<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Customers';
 
// Table's primary key
$primaryKey = "customer_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
       array( 'db' => '`c`.`logo`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
           if (isset($d) && strcmp($d, '') != 0) {
               return '<img class="center-canvas" style="width:auto;height:25px;max-width:50px" src="//' . HTML_PATH . '/cop/media/customersLogos/' . $d . '"></td>';
           } else {
               return '<img class="img-rounded img-responsive center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/customerdefault.jpg" width="25" height="25"></td>';
           }
       },
            'field' => 'logo' ),
     array( 'db' => '`c`.`customer_code`',       'dt' =>  'code', 'field' =>'customer_code' ),
       array( 'db' => '`c`.`customer_company_name`',       'dt' => 'name', 'field' => 'customer_company_name' ),
     array( 'db' => '`c`.`mobile`',       'dt' => 'phone' , 'field' => 'mobile' ),
        array( 'db' => '`c`.`balance`',       'dt' => 'balance',  'formatter' => function( $d, $row ) {
            return number_format($d,2);},
            'field' => 'balance' ),
    array( 'db' => '`c`.`customer_id`', 'dt' => 'address', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $address="";
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city FROM CustomerAddress WHERE customer_id='$d'");
        $stm->execute();
        $stm->bind_result($addressLine1,$addressLine2,$postCode,$city);

        while ($stm->fetch()) {
            $address="$addressLine1 $addressLine2  $postCode $city";

        }
        $stm->close();



        return $address;},
        'field' => 'customer_id' ),
    array( 'db' => '`c`.`customer_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");

        $stm = $db->prepare("SELECT type_of_business FROM Customers WHERE customer_id='$d'");
        $stm->execute();
        $stm->bind_result($typeOfBusiness);

        while ($stm->fetch()) {


        }
        $stm->close();





        return '<form target="_blank" style="display:inline;" id="'.$d.'" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_customer.php" method="post">
           		<input type="hidden" name="customer_id" value="'.$d.'">
			<input  type="submit" class="btn btn-success" value="View" style="margin-top:5px;width:60px;height:25px;padding-top:2px;">

			</form>';},
        'field' => 'customer_id' ),

    array( 'db' => '`c`.`customer_id`', 'dt' => 'schedules', 'formatter' => function( $d, $row ) {



        global $username,$password,$database;
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $salesPersonID = trim($_GET['salesperson_id']);
        $scheduleSelect = "<select name='select_$d' id='select_$d' class='js-example-basic-single dt-select2' style='width: 100%;' multiple='multiple' onchange='changeSchedules($d,$salesPersonID)'>";

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT DISTINCT(Schedules.schedule_id), name FROM Schedules INNER JOIN Schedule_Salesperson ON (Schedule_Salesperson.schedule_id = Schedules.schedule_id) WHERE Schedule_Salesperson.salesperson_id ='$salesPersonID' ");
        $stm->execute();
        $stm->bind_result($scheduleID, $scheduleName);
        while ($stm->fetch()) {
            $scheduleSelect .= "<option value='$scheduleID'>$scheduleName</option>";
        }
        $stm->close();

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT DISTINCT(Schedules.schedule_id), name FROM Schedules INNER JOIN Schedule_Salesperson ON (Schedule_Salesperson.schedule_id = Schedules.schedule_id) INNER JOIN Schedule_Customer ON (Schedule_Customer.schedule_id=Schedules.schedule_id) WHERE Schedule_Salesperson.salesperson_id ='$salesPersonID' AND Schedule_Customer.customer_id IN ('$d')");
        $stm->execute();
        $stm->bind_result($scheduleID, $scheduleName);
        while ($stm->fetch()) {
            $scheduleSelect .= "<option value='$scheduleID' selected>$scheduleName</option>";
        }
        $stm->close();


        $scheduleSelect .="</select>";
//        $scheduleSelect .="<input type='text' val='' id='salesperson_for_$d' name='salesperson_for_$d'>";
//        $scheduleSelect .="<input type='text' val='' id='customer_$d' name='customer_$d'>";
        $scheduleSelect .="<input type='hidden' val='' id='schedules_for_$d' name='schedules_for_$d'>";


        return $scheduleSelect;},
        'field' => 'customer_id' )
);


$db2= new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$stm2 = $db2->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Customers'");
$stm2->execute();
$stm2->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm2->fetch()) {

    include(ROOT . "concc/dbhelpers/dbhelper.php");

    $db3= new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db3->set_charset("utf8");
    $stm3 = $db3->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm3->execute();
    $stm3->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm3->fetch()) {


        $column = array( 'db' => '`c`.`customer_id`','customerForm'=>$customFormID,'customField'=>$customFieldID, 'dt' => $customFieldID, 'field' => 'customer_id' );





        $formatter = function( $d, $row)use($customFormID,$customFieldID) {

            return getLastValueOfCustomForm($customFormID, $customFieldID, "Customers", $d);
        };

        $column['formatter'] = $formatter;

        array_push($columns,$column);
    }


}
$stm2->close();


// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Customers` AS `c`";
$where='';
if(isset($_GET['group_id']))
{
    $groupID=$_GET['group_id'];
    $where=" `c`.customer_id IN(SELECT customer_id AS customer_id FROM Customer_CustomersGroup WHERE group_id IN ('$groupID'))";
}
//$where ="`a`.`primary_address`='yes'";
require(ROOT . 'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>