<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$waybillID = trim($_POST['waybillID']);
$waybillCode=trim($_POST['waybillCode']);
$companyID = $_SESSION['companyID'];
$customerID= trim($_POST['customerID']);
$deliveryAddress= trim($_POST['deliveryAddress']);
$billingAddress= trim($_POST['billingAddress']);
$currencyID = trim($_POST['currencyID']);
$waybillDate= trim($_POST['waybillDate']);
$paymentMethod= trim($_POST['paymentMethod']);
$salespersonSearch= trim($_POST['salespersonSearch']);
$warehouseSearch= trim($_POST['warehouseSearch']);
$subtotal= trim($_POST['subtotal']);
$discount= trim($_POST['discount']);
$vatTotal= trim($_POST['vatTotal']);
$grandTotal= trim($_POST['grandTotal']);
$details= trim($_POST['details']);

$status="Placed";

$waybillItems = array();
$waybillItems = json_decode($_POST['waybillItems'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($waybillDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $waybillDate);
        $waybillDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    lockDocumentSingleTransaction($waybillID, "Waybills", $db);

    $stmt = $db->prepare("SELECT status FROM Waybills WHERE waybill_id='$waybillID'");
    $stmt->execute();
    $stmt->bind_result($prevStatus);
    while ($stmt->fetch()) {if(strcmp($prevStatus,'')!=0){$status=$prevStatus;}}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Waybills WHERE waybill_id=?");
    $stmt->bind_param('i', $waybillID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);

    $statement = "DELETE FROM Waybills WHERE waybill_id=$waybillID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Waybills (waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,waybill_address_id,delivery_address_id,waybill_date,details,global_discount_percentage,status,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissdsi', $waybillID, $waybillCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $waybillDate, $details, $globalDiscountPercentage, $status, $currencyID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();


    $waybillItemsForSockArray = getStockUpdateLinesOfDocument($db, 3, $waybillID);

    foreach ($waybillItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 3, $waybillID, $waybillCode, 'Edit Waybill (Remove)', 0, null, null, 0, null);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
        if(!$insertStockStatementResult){throw new Exception();}

    }

    $waybillConnectedItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 3, $waybillID,2);

    foreach ($waybillConnectedItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 3, $waybillID, $waybillCode, 'Order Waybill (Remove)', 2, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $linkedForReservedItems = array();
        $stmt = $db->prepare("SELECT order_item_id,qty_delivered FROM Order_Item WHERE order_id=? AND item_id=?");
        $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
        $stmt->execute();
        $stmt->bind_result($linkedOrderItemID,$linkedForReserved);
        while ($stmt->fetch()) {

            if($linkedForReserved <= $itemObject->fromActionQty){
                $reverseFromActionQty = $linkedForReserved;
                $itemObject->fromActionQty -= $reverseFromActionQty;
            } else {
                $reverseFromActionQty = $itemObject->fromActionQty;
                $itemObject->fromActionQty = 0;
            }

            $lineReservation = new stdClass();
            $lineReservation->lineID = $linkedOrderItemID;
            $lineReservation->reserved = $reverseFromActionQty;

            array_push($linkedForReservedItems,$lineReservation);

        }
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        foreach ($linkedForReservedItems as $lineReservation){

            $reverseFromActionQty=-$lineReservation->reserved;

            $stmt = $db->prepare("UPDATE Order_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE order_item_id = ?");
            $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }

    $stmt = $db->prepare("DELETE FROM Waybill_Item WHERE waybill_id=?");
    $stmt->bind_param('i', $waybillID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);

    $statement = "DELETE FROM Waybill_Item WHERE waybill_id=$waybillID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $lineTotals         = 0;
    $lineDiscountTotals = 0;
    $itemsCounter       = 0;

    if (count($waybillItems) == 0) {throw new Exception();}

    foreach ($waybillItems as $waybillItem) {

        $itemID = $waybillItem['itemID'];

        if ($itemID > 0) {

            $itemsCounter++;

            $itemNotes      = $waybillItem['Notes'];
            $qty            = $waybillItem['Qty'];
            $unitPrice      = $waybillItem['UP'];
            $lineDiscount   = $waybillItem['LD'];
            $priceType      = $waybillItem['PC'];
            $globalDiscount = $waybillItem['globalDiscount'];
            $vatTotal       = $waybillItem['vatLine'];
            $vatCode        = $waybillItem['VAT'];

            $subunits = getSubUnits($itemID, $db);
            $vatID    = getVatID($vatCode, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += floatval($unitPrice) * $qty / $subunits;
            $lineDiscountTotals += floatval($lineDiscount);
            $batchNumber = '0';

            $waybillItemID = getNextKeySingleTransaction("Waybill_Item", "waybill_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Waybill_Item (waybill_item_id,waybill_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $waybillItemID, $waybillID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes,$batchNumber);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) { throw new Exception();}
            $stmt->close();


            $available = -$qty;
            $delivered =  $qty;

            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, $available, 0, $delivered, 0, 0, 0, "0000-00-00", 3, $waybillID, $waybillCode, 'Edit Waybill (Add)', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}



            $custTable = new CustomTable('Waybill_Item', $waybillItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($waybillItem, $code->tableCode, $db);
            }

        }

    }

    $stockWaybillItems = array();
    $stmt = $db->prepare("SELECT item_id,batch_number,warehouse_id,SUM(qty) FROM Waybill_Item WHERE waybill_id=? GROUP BY item_id,batch_number,warehouse_id");
    $stmt->bind_param('i', $waybillID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($itemID,$batchNumber,$warehouseID,$qty);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = "$warehouseID";
        $object->itemID = $itemID;
        $object->batchNumber = $batchNumber;
        $object->available = $qty;
        $object->reserved = $qty;
        $object->delivered = $qty;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = 0;
        $object->fromActionQty = 0;
        $object->fromActionID = 0;
        $object->fromActionCode = '';
        $object->fromActionField = '';

        array_push($stockWaybillItems,$object);
    }
    $stmt->close();

    $orderedItemObjects = array();
    $stmt = $db->prepare("SELECT order_item_id,Order_Item.order_id,order_code,delivery_method,item_id,qty,qty_delivered,qty_invoiced FROM Order_Waybill,Orders,Order_Item WHERE Order_Waybill.order_id=Order_Item.order_id AND Orders.order_id=Order_Waybill.order_id AND Order_Waybill.waybill_id=?");
    $stmt->bind_param('i', $waybillID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($orderItemID,$orderID,$orderCode,$warehouseID,$itemID,$qty,$qtyDelivered,$qtyInvoiced);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = "$warehouseID";
        $object->itemID = $itemID;
        $object->batchNumber = "0";
        $object->available = $qty - $qtyDelivered - $qtyInvoiced;
        $object->reserved = 0;
        $object->delivered = $qtyDelivered;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = $qtyInvoiced;
        $object->fromActionQty = 0;
        $object->fromActionID = $orderID;
        $object->fromActionCode = $orderCode;
        $object->fromActionField = 'qty_invoiced';
        $object->fromActionLineID = $orderItemID;


        array_push($orderedItemObjects,$object);
    }
    $stmt->close();


    foreach ($orderedItemObjects as $orderedItemObject) {

        foreach ($stockWaybillItems as $stockWaybillItem) {

            if(strcmp($orderedItemObject->itemID,$stockWaybillItem->itemID)==0
                && strcmp($orderedItemObject->warehouseID,$stockWaybillItem->warehouseID)==0
                && strcmp($orderedItemObject->batchNumber,$stockWaybillItem->batchNumber)==0)
            {

                if($orderedItemObject->available <= $stockWaybillItem->delivered){
                    $reserved  = $orderedItemObject->available;
                    $objectReserved  = $stockWaybillItem->delivered - $orderedItemObject->available;
                } else {
                    $reserved  = $stockWaybillItem->delivered;
                    $objectReserved  = 0;
                }

                $stockWaybillItem->delivered = $objectReserved;
                $delivered = $reserved;
                $fromActionQty = $reserved;
                $reserved = -$reserved;

                $stmt = $db->prepare("UPDATE Order_Item SET qty_delivered = qty_delivered+? WHERE order_item_id = ?");
                $stmt->bind_param('di', $delivered, $orderedItemObject->fromActionLineID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception();}
                $stmt->close();

                $insertStockStatementResult = insertStockRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, $reserved, 0, 0, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, $reserved, 0, 0, 0, 0, "0000-00-00", 3, $waybillID, $waybillCode, 'Order Waybill', 2, $orderedItemObject->fromActionID, $orderedItemObject->fromActionCode, $fromActionQty, "qty_delivered");
                if(!$insertStockUpdateStatementResult){throw new Exception();}
            }

        }

    }


    $discount += $lineDiscountTotals;

    $stmt = $db->prepare("UPDATE  Waybills SET subtotal =? ,discount_amount=? WHERE waybill_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $waybillID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {
        throw new Exception();
    }
    $stmt->close();

    $custTable = new CustomTable('Waybills', $waybillID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$waybillID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Waybills',$waybillID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}


	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

?>