<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (empty($_POST['customerId']) || empty($_POST['subcustomerId']) || empty($_POST['type']) || empty($_POST['editSubcustomerId']) || empty($_POST['editCustomerId']) ) {
    echo "emptyFields";
    exit;
}

//ids before change
$editSubcustomerId = trim($_POST['editSubcustomerId']);
$editCustomerId = trim($_POST['editCustomerId']);
$editType = trim($_POST['editType']);

$customerId = trim($_POST['customerId']);
$subcustomerId = trim($_POST['subcustomerId']);
$type = trim($_POST['type']);
$position = trim($_POST['position']);
$notes = trim($_POST['notes']);

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($customerId == $subcustomerId) {
    echo "selfReference";
    exit;
}

$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomers 
                      WHERE customer_id = ? AND subcustomer_id = ? AND type = ? 
                      AND NOT (customer_id = ? AND subcustomer_id = ? AND type = ?)");
$stmt->bind_param('iisiis', $customerId, $subcustomerId, $type, $editCustomerId, $editSubcustomerId, $editType);
$stmt->execute();
$stmt->bind_result($existingCount);
$stmt->fetch();
$stmt->close();

if($existingCount > 0) {
    echo "existingRelation";
    exit;
}

// Check for circular relationship
$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomers 
                      WHERE customer_id = ? AND subcustomer_id = ? 
                      AND NOT (customer_id = ? AND subcustomer_id = ? AND type = ?)");
$stmt->bind_param('iiiis', $subcustomerId, $customerId, $editCustomerId, $editSubcustomerId, $editType);
$stmt->execute();
$stmt->bind_result($circularCount);
$stmt->fetch();
$stmt->close();

if($circularCount > 0) {
    echo "circularReference";
    exit;
}


$stmt = $db->prepare("UPDATE SubCustomers 
                      SET customer_id = ?, subcustomer_id = ?, position = ?, notes = ? 
                      WHERE customer_id = ? AND subcustomer_id = ? AND type = ?");
$stmt->bind_param("iiisiis", $customerId,$subcustomerId,$position, $notes, $editCustomerId, $editSubcustomerId, $editType);

if ($stmt->execute()) {
    echo "success";
} else {
    echo "error";
}

$stmt->close();
