<?php
require_once("../backend/dbinfo.php");
include_once("../backend/platform/phpexcel/vendor/autoload.php");

// ------ FILE CONFIGURATION START --------

$inputFile  = "testing.txt";
$outputFile = "Items2.txt";

$inputDirectory = "./b2bAdmin/microprojects/";
$outputDirectory= "./b2bAdmin/microprojects/";

$inputDelimiter      = ";";
$outputDelimiter     = "|";

$startingRow   = 0;
$endingRow     = 0;
$ColumnArray   = array(0,1,2,6,5,0,1,2,6,5,0,1,2,6,5,1);

convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray);

// ------ FILE CONFIGURATION END ---------


function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow,$ColumnArray)
{
    $inputFileDirectory  = $inputDirectory.$inputFile;
    $outputFileDirectory = $outputDirectory.$outputFile;

    $fileExt = substr( $inputFile, ( $pos = strpos( $inputFile, '.' ) ) === false ? 0 : $pos + 1 );

    if(strcmp($fileExt,'xlsx') == 0) {
        XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory);
    }else{
        TXTInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$inputDelimiter,$outputDelimiter,$outputFileDirectory);
    }
}

function XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory)
{
    $file = fopen($outputFileDirectory, "w");
    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
    $objReader->setReadDataOnly(true);

    $objPHPExcel = $objReader->load($inputFileDirectory);
    $sheet = $objPHPExcel->getSheet(0);
    $highestRow = $sheet->getHighestRow();
    $highestColumn = $sheet->getHighestColumn();
    $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);

    if($endingRow == 0){
        $endingRow = $highestRow;
    }

//  Loop through each row of the worksheet in turn
    for ($row = $startingRow; $row <= $endingRow; $row++) {

        //  Read a row of data into an array
        $rowData  = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
        $position = 0;
        $temp     = $startingRow;
        $data     = array();

        foreach ($rowData[0] as $field){
            if($temp != $row){
                fwrite($file,"\n");
                $temp = $row;
                $position = 0;
                $data = array();
            }

            array_push($data,$field);

            if($position == $colNumber-1){
                foreach($ColumnArray as $col){
                    fwrite($file, $data[$col]);
                    fwrite($file, $outputDelimiter);
                }
            }
            $position++;
        }

    }
    fclose($file);
}

function TXTInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$inputDelimiter,$outputDelimiter,$outputFileDirectory)
{
    $file        = fopen($outputFileDirectory, "w");
    $txt_file    = file_get_contents($inputFileDirectory);
    $rows        = explode("\n", $txt_file);

    array_shift($rows);

    foreach($rows as $row => $fields)
    {
        $row_data = explode($inputDelimiter, $fields);
        $data     = array();

        if($row >= $startingRow) {
            if($row <= $endingRow || $endingRow == 0) {
                foreach ($row_data as $field) {
                    array_push($data, $field);
                }

                foreach ($ColumnArray as $col) {
                    fwrite($file, $data[$col]);
                    fwrite($file, $outputDelimiter);
                }
                fwrite($file, "\n");
            }
        }
    }
    fclose($file);
}


?>