<?php
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");

$companyID     = $_SESSION['companyID'];
$notes         = trim($_POST['notes']);
$customerID    = trim($_POST['customerID']);
$visitDate     = trim($_POST['visitDate']);
$salesperson   = trim($_POST['salesperson']);
$serviceCallID = trim($_POST['serviceCallID']);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
     printf("Connect failed: %s\n", mysqli_connect_error());
     exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $visitID   = getNextKeySingleTransaction('Visits', 'visit_id', $db);
    $visitCode = getNextCodeSingleTransaction("Visits", "visit_code", "V", "CLOUD", $db);

    if (strcmp($visitCode, '') == 0) {
        $stmt = $db->prepare("SELECT display_prefix FROM Devices WHERE activation_code='CLOUD' LIMIT 1");
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->bind_result($prefix);
        while ($stmt->fetch()) {$visitCode = "V" . $prefix . "10000";}
        $stmt->close();
    }

    $stmt = $db->prepare("INSERT INTO Visits (visit_id, visit_code, customer_id, company_id, salesperson_id, notes, visit_date, timestamp) VALUES(?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isiiiss', $visitID, $visitCode, $customerID, $companyID, $salesperson, $notes, $visitDate);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    if ($serviceCallID > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status = 0;
        $timezone = 2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "New Visit Issued";
        $documentType = "Visits";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salesperson, $status, $date, $replyTypeID, $details, $visitID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $db->commit(true);

    echo "$visitID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Visits',$visitID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}

function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}



?>