<?php
include_once("../../../../param.php");

$groupId = trim($_POST['groupId']);
$subgroupId = trim($_POST['subgroupId']);
$userId = $_SESSION['user_id'];

if(empty($groupId) || empty($subgroupId)){
    echo "emptyFields";
    exit;
}

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if($groupId == $subgroupId) {
    echo "selfReference";
    exit;
}

$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomerGroups WHERE group_id = ? AND subgroup_id = ?");
$stmt->bind_param('ii', $subgroupId, $groupId);
$stmt->execute();
$stmt->bind_result($circularCount);
$stmt->fetch();
$stmt->close();

if($circularCount > 0) {
    echo "circularReference";
    exit;
}

$stmt = $db->prepare("SELECT COUNT(*) FROM SubCustomerGroups WHERE group_id = ? AND subgroup_id = ?");
$stmt->bind_param('ii', $groupId, $subgroupId);
$stmt->execute();
$stmt->bind_result($existingCount);
$stmt->fetch();
$stmt->close();

if($existingCount > 0) {
    echo "existingRelation";
    exit;
}

$stmt = $db->prepare("INSERT INTO SubCustomerGroups (group_id, subgroup_id, timestamp) VALUES (?, ?, NOW())");
$stmt->bind_param('ii', $groupId, $subgroupId);
$success = $stmt->execute();
$stmt->close();

if($success) {
    echo "success";
} else {
    echo "error";
}
?>