<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once('../../param.php');
require_once("../dbaccess/dbhelper.php");
include_once('../dbaccess/emailOrder.php');


$orderID = $paymentOrderID = $transactionID = '';
$vivaResponseCode = $vivaReasonCode = 0;
$vivaReasonDescr = "Payment Failed";


if(isset($_SESSION['VIVAORDER']) && strcmp($_SESSION['VIVAORDER'],'')!=0){
    $orderID = $_SESSION['VIVAORDER'];
    $_SESSION['VIVAORDER'] = '';
}
if(isset($_GET['s']) && strcmp($_GET['s'],'')!=0){
    $paymentOrderID = $_GET['s'];
    $vivaResponseCode=1;
    $vivaReasonDescr = "Payment Failed";
}
if(isset($_GET['t']) && strcmp($_GET['t'],'')!=0){
    $transactionID = $_GET['t'];
    $vivaReasonCode=1;
    $vivaReasonDescr = "";
}

if(isset($_GET['eventId']) && strcmp($_GET['eventId'],'')!=0 && $_GET['eventId'] > 0){
    $vivaResponseCode = 0;
    $vivaReasonDescr  = "Payment Failed";
}

if (isset($orderID) && isset($paymentOrderID) && strcmp($orderID,'')!=0 && strcmp($paymentOrderID,'')!=0) {
    //Parameters returned from viva

    $vivaOrderCode = $orderID;
    $vivaPaddedCardNo = ' ';
    $customerID=$_SESSION['customerID'];


    $status = "Payment Failed";
    if ($vivaResponseCode == 1 && $vivaReasonCode == 1) {
        $vivaAuthNo = "$transactionID";
        $status = "Placed";
        $paymentComplete = true;
    } else {
        if(strcmp($vivaReasonDescr,'')!=0) {$status = "VIVA Wallet ".$vivaReasonDescr;}
        $paymentComplete = false;
    }

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    if(isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0){
        $customerID = $_SESSION['customerID'];
    } else {
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT anonymous_checkout,anonymous_checkout_customer_id FROM B2B_Configuration");
        $stm->execute();
        $stm->bind_result($anonymousCheckoutCheck, $anonymousCheckoutCustomerID);
        while ($stm->fetch()) {
            if (strcmp($anonymousCheckoutCheck, "yes") == 0) {
                $customerID = $anonymousCheckoutCustomerID;
            }
        }
        $stm->close();
    }


    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
    $stmt->bind_param('ssi',$status, $vivaOrderCode,$customerID);
    $stmt->execute();
    $stmt->close();

    if($paymentComplete) {

        $payedStatus = "Placed";
        $db->set_charset("utf8");
        $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
        $stmt->bind_param('ssi',$payedStatus, $vivaOrderCode,$customerID);
        $stmt->execute();
        $stmt->close();

        $companyID = 0;
        $salespersonID = $_SESSION['userID'];
        $invoiceID = 0;
        $receiptAddress = 0;
        $amount = 0;
        $cashDiscount = 0;
        $bank = 'VIVA Wallet';
        $branch = " ";
        $chequeNumber = "$vivaAuthNo";
        $chequeDate = date('Y-m-d');


        $receiptDate = date('Y-m-d');
        $paymentMethod ="VIVA Wallet";
        $notes = "For Online Order $vivaOrderCode";
        $receiptStatus = "Confirmed";

        $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_code=? AND customer_id=?");
        $stm-> bind_param('si', $vivaOrderCode,$customerID);
        $stm-> execute();
        $stm-> bind_result($orderID,$receiptAddress,$amount);
        while ($stm->fetch()) {}
        $stm->close();

        $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($defaultSalesPerson);
        while ($stm->fetch()) {
            if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                $salespersonID = $defaultSalesPerson;
            } else {
                $salespersonID = 0;
            }
        }
        $stm->close();

        if($amount > 0) {

            $receiptID   = getNextKey("Receipts","receipt_id");
            $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
            $stmt->execute();
//        echo $stmt->error;
            $stmt->close();
            setNextReceiptCode("CLOUD");

//        echo "INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES($receiptID, '$receiptCode', $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, '$paymentMethod', $cashDiscount, '$bank', '$branch', '$chequeNumber', '$chequeDate', '$receiptDate', '$notes','$receiptStatus')<br>";


            $detailsTra="Online Payment Receipt $receiptCode";
            $sign = -1;
            $payment -= $cashDiscount;
            $transactionID = getNextKey("Transactions", "transaction_id");
            $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
            $stmt->execute();
            $stmt->close();

            updateCustomerBalance($customerID, $amount);
        }
        sendEmail($orderID, $receiptID);
        $pFlag = 1;
    } else {
        $pFlag = 0;
    }
    header("Location: //".HTML_PATH."/cop/b2b/viewsingleorder.php?p=$pFlag&Order=$vivaOrderCode");

} else {
    header("Location: //".HTML_PATH."/cop/b2b/checkout.php?p=1");

}


function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}





?>