<?php

include_once("../param.php");
require_once("./dbaccess/dbhelper.php");
require_once("./assets/mobiledetect/Mobile_Detect.php");

$isMobile = false;
$detect = new Mobile_Detect;

if (isset($_GET['currency']) && $_GET['currency'] > 0) {
    $_SESSION['currency'] = $_GET['currency'];
}
if (isset($_SESSION['currency'])) {
    $sessionCurrencyID = $_SESSION['currency'];
}

if ( $detect->isMobile() ) {$isMobile = true;}
if(isset($_SESSION['orderID'])) {
    $orderID = $_SESSION['orderID'];
}
$customerID=$_SESSION['customerID'];
$displayGreeting = '';

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if($sessionCurrencyID > 0 && isset($_SESSION['customerID']) && isset($_SESSION['orderID'])){
    $stm2 = $db->prepare("UPDATE Online_Orders SET currency_id=? WHERE customer_id=? AND order_id=?");
    $stm2-> bind_param('iii',$sessionCurrencyID,$customerID,$orderID);
    $stm2-> execute();
    $stm2->close();
}

$allowAnonymousOrder = false;
$includeVatOnPrice = false;
$showCustomerLogo = false;
$showCurrencies = false;
$addItemByUnits = true;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme,theme,anonymous_order,show_prices_with_vat,show_customer_logo,multi_currency,order_qty_by_subunits FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($cssTheme,$themeColor,$anonymousOrder,$showPricesIncludingVAT,$showCustomerLogoSetting,$multiCurrency,$orderQtyBySubunits);
while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    $themeColor = strtolower($themeColor);

    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0){
        $includeVatOnPrice = true;
    }
    if(strcmp($showCustomerLogoSetting,"yes")==0){
        $showCustomerLogo = true;
    }
    if(strcmp($multiCurrency,"yes")==0){
        $showCurrencies = true;
    }
    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

}
$stm->close();


$logoLinkHeader = $logoLink;
if($showCustomerLogo) {
    if (isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0) {

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT logo FROM Customers WHERE customer_id='". $_SESSION['customerID']."' AND customer_id > 0 LIMIT 1");
        $stm->execute();
        $stm->bind_result($customerLogo);
        while ($stm->fetch()) {
            if(strcmp($customerLogo,'')!=0 && file_exists('../media/customersLogos/'.$customerLogo)){
                $logoLinkHeader = '../media/customersLogos/'.$customerLogo;
            }
        }
        $stm->close();

    }
}

if(isset($_SESSION['orderID'])) {
    $currencyRate = getPriceRate();
    $count = 0;
    $itemCounter = 0;
    $subtotal = 0;
    $netTotalLabel = $langu['column_total_label'];
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT qty,unit_price,Items.vat_id,Online_Order_Item.item_id FROM Online_Order_Item,Items WHERE  Online_Order_Item.item_id=Items.item_id AND order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($ordQty,  $ordLineUnitPrice,$ordVatID,$ordItemID);
    while ($stm->fetch()) {

        if($addItemByUnits) {
            $ordQty = $ordQty / floatval(getSubUnits($ordItemID));
            $subtotalLine = $ordLineUnitPrice*$ordQty;
        } else {
            $subtotalLine = $ordLineUnitPrice*$ordQty / floatval(getSubUnits($ordItemID));
        }

        $count += $ordQty;
        $itemCounter++;

        if($includeVatOnPrice) {
            $vatPercentage = getVatPercentage($ordVatID);
            $subtotal += $subtotalLine + $subtotalLine * ($vatPercentage / 100);
        } else {
            $subtotal += $subtotalLine;
        }
    }
    $stm->close();
}

if(strcmp($showPrices,'no')==0 || (isset($_SESSION['showPrices']) && $_SESSION['showPrices']==false) || $showPrices==false){
    $showPrices = false;
    $showCurrencies = false;
} else {
    $showPrices = true;
}

if (!(!isset($_SESSION['customerID'])||$_SESSION['customerID']==0)) {

    global $username, $password, $database;

    $checkoutLabel = $langu['checkout_label'];
    $greeting = $langu['greeting'];

    $userId =  $_SESSION['userID'];
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT username,first_name FROM B2B_User WHERE b2b_user_id='$userId'");
    $stm-> execute();
    $stm-> bind_result($userName,$fname);
    while ($stm->fetch()) {
        if(strcmp(trim($fname),'')!=0){$userName=$fname;}
        $displayGreeting = "<label class='hidden-xs' style='padding-top: 13px;color: white;font-weight: bolder'>$greeting $userName</label>";
    }
    $stm-> close();



}

$textColor = "white";
if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}
$themeColorGradient = " background: -moz-linear-gradient(bottom,  $themeColor  0%, white 10%, whitesmoke 60%);
                        background: -webkit-gradient(linear, left top, left bottom, from($themeColor), to(white));
                        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#cfddac', endColorstr='#ffffff');
                        background: linear-gradient(to bottom, $themeColor  0%, white 10%, whitesmoke 60%);";

$db->set_charset("utf8");
$stm = $db->prepare("SELECT facebook_link,instagram_link,twitter_link FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($facebookLink,$instagramLink,$twitterLink);
while ($stm->fetch()) {}
$stm-> close();
?>

<div class="header-wrapper" style="padding-top:0px;padding-bottom:0px;margin-left: 0px;margin-right: 20px;width: 100%;margin-bottom: 0px;background-color: <?php echo $themeColor;?>;border: 7px solid <?php echo $themeColor;?>">
    <div class="header-theme container" style="width: 100%;height: 45px;padding: 0px;">
        <div class="col-xs-1 col-sm-1  hidden-md  hidden-lg  pull-left" style="margin: 0px;padding: 0px;">
            <a href='#' class='menu-toggle btn btn-theme-transparent pull-left' style="border-color: transparent;color: <?php echo $textColor;?>; font-weight: bolder;margin-left: 0px;padding-left: 4px;padding-right: 4px;border-radius: 30%"><i class='fa fa-bars'></i></a>
<!--            <a href="index.php"><img class="pull-right" style="display: block;margin-top:5px;margin-left: 0px;margin-right: auto;max-height:30px;" src="--><?php //echo $logoLinkHeader ?><!--" alt="Coprime"/></a>-->
        </div>
        <div class="col-sm-11 col-xs-11 col-md-12 col-lg-12 pull-right">
            <?php //echo $displayGreeting ;?>

            <nav class='navigation closed clearfix pull-left'>
                <a href='#' class='menu-toggle-close btn' id="sidemenuclosebutton"><i class='fa fa-times'></i></a>
                <div class="hidden-sm hidden-xs hidden-md pull-left">
                <a href="index.php"><img class="pull-left " style="display: block;margin-top:3px;margin-left: -11px;margin-right: auto;max-height:40px;" src="<?php echo $logoLinkHeader ?>" alt="Coprime"/></a>
                </div>
                <ul class='nav <?php if(!$isMobile){echo "sf-menu";}?>' style="height: 45px;color: <?php echo $textColor?>;line-height: 1.92;text-align: left;padding-top:0px !important;" id="navUl">
                    <?php

                    $db = new mysqli('localhost', $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }
                    $db->set_charset("utf8");
                    $stm = $db->prepare("SELECT page_id,page_name_display,page_name_display_gr,page_name_code,menu_position,show_if_logged_in,show_if_logged_out,function_to_call FROM B2B_Pages WHERE active='yes' ORDER BY menu_position");
                    $stm->execute();
                    $stm->bind_result($pageID,$pageName,$pageGreekName,$pagePhp,$position,$showIfLoggedIn,$showIfLoggedOut,$functionToCall);

                    while ($stm->fetch()) {

                        if($position==1)
                        {
                            $class ="class='active '";
                        } else {
                            $class ="class=''";
                        }


                        if(strcmp($_SESSION['lang'],'el')==0)
                        {
                            $value = $langu['pages'][$pageName];

                            if(isset($value))
                            {
                                $pageName = $langu['pages'][$pageName];
                            }
                            if(strcmp($pageGreekName,'')!=0){
                                $pageName = $pageGreekName;
                            }
                        }


                        if((strcmp($showIfLoggedOut,'yes')==0&& $_SESSION['customerID']==0)||(strcmp($showIfLoggedIn,'yes')==0&& $_SESSION['customerID']!=0)) {

                            $msg="";
                            if(strcmp($functionToCall,"")!=0)
                            {
                                $msg="(".call_user_func($functionToCall).")";
                            }

                            if($pageID == 2 || $pageID == 3 || $pageID >= 100){
                                if(isset($len) && substr($pagePhp, 0, $len) === "http")
                                {
                                    echo "  <li><a $class target='_blank' href='$pagePhp' style='height: 50px;vertical-align: middle;color: $textColor;padding-top: 8px;'>$pageName$msg</a></li>";
                                }
                                else
                                {
                                    echo "  <li><a $class href='$pagePhp' style='height: 50px;color: $textColor;vertical-align: middle;padding-top: 8px;'>$pageName$msg</a></li>";
                                }
                            } else {
                                if(isset($len) && substr($pagePhp, 0, $len) === "http")
                                {
                                    $dropDownPages .= "  <li><a  target='_blank' href='$pagePhp' style='vertical-align: middle;color: $textColor;padding-top: 8px;'>$pageName$msg</a></li>";
                                }
                                else
                                {
                                    $dropDownPages .= "  <li><a  href='$pagePhp' style='color: $textColor;vertical-align: middle;padding-top: 8px;'>$pageName$msg</a></li>";
                                }
                            }



                        }
                    }
                    $stm->close();

                    if(strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || strpos($_SERVER['REQUEST_URI'] , '.php') === false){
                        echo "<style>   

                                #navUl{
                                height: auto !important;
                                }                     
                                /*VERTICAL MENU*/
                                #categoriesContainerMobile {
                                  position:relative !important;
                                }
                                
                                /* ALL UL */
                                #categoriesContainerMobile  ul{
                                  list-style: none !important;
                                }
                                /* ALL LI */
                                #categoriesContainerMobile  li{
                                  position:relative !important;
                                }
                                /* ALL A */
                                #categoriesContainerMobile  a{
                                  display:block !important;
                                  color:#eee !important;
                                  text-decoration:none !important;
                                  padding:10px 15px !important;
                                  transition:0.02s !important;
                                }
           
                                
                                /* INNER UL HIDE */
                                #categoriesContainerMobile  ul ul{
                                  padding-left:20px !important;
                                  transition: max-height 0.02s ease-out !important;
                                  max-height:0 !important;
                                  overflow:hidden !important;
                                }
//                                /* INNER UL SHOW */
//                                #categoriesContainerMobile  li:hover > ul{
//                                  max-height:500px !important;
//                                  transition: max-height 0.25s ease-in !important;
//                                }
                                /* INNER UL HIDE */
                                #categoriesContainerMobile  ul{
                                  padding-left:20px !important;
                                  transition: max-height 0.02s ease-out !important;
                                  max-height:0 !important;
                                  overflow:hidden !important;
                                }
                                /* INNER UL SHOW */
                                #categoriesContainerMobile:hover > ul{
                                  max-height:35000px !important;
                                  transition: max-height 0.25s ease-in !important;
                                }
                                #categoriesContainerMobile a:hover{
                                  color: $themeColor !important;
                                }
                                </style>";

                        echo "<script>
                                        function viewCategoryMobile(element,active){
                                            if(active > 0){
                                                $(element).parent().find('ul').attr('style', 'max-height:5000px !important;transition: max-height 0.25s ease-in !important;');
                                                $(element).parent().find('ul').find('li').find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                                $(element).parent().find('ul').find('li').find('a').attr('onclick','viewCategoryMobile(this,1);');
                                                $(element).attr('onclick','viewCategoryMobile(this,0);');
                                            } else {
                                                $(element).parent().find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                                $(element).attr('onclick','viewCategoryMobile(this,1);');  
                                            }
                                            
                                        }  
                                        
                                  </script>";

                        echo "<li style='border-top: 2px solid gray;border-bottom: 2px solid gray;padding-top: 10px;padding-bottom: 10px;' class='hidden-lg hidden-md' id='categoriesContainerMobile'><a>". $langu['categories_label'] ."</a></li>";

                    }


                    ?>
                </ul>
            </nav>

                        <ul  style="display:inline-block;margin-bottom: 0px;margin-top: 0px;">
                            <?php
                            if(strcmp($facebookLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$facebookLink' class='btn btn-theme-transparent' style='padding-top: 8px;margin-right: 1px;border: 0px;border-radius: 50%'>&nbsp;<i class='fa fa-facebook' style='color: $textColor'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($instagramLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$instagramLink' class='btn btn-theme-transparent' style='padding-top: 8px;margin-right: 1px;border: 0px;border-radius: 50%'>&nbsp;<i class='fa fa-instagram' style='color: $textColor'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($twitterLink,'')!=0) {
                                echo "<li style='display:inline-block'><a target='_blank' href='$twitterLink'  class='btn btn-theme-transparent' style='padding-top: 8px;border: 0px;border-radius: 50%'><i class='fa fa-twitter' style='color: $textColor'></i></a></li>";
                            }
                            ?>
                        </ul>
                        <?php
                        $showLanguages = $_SESSION['show_language_selection'];
                        $lang = $_SESSION['lang'];
                        if(isset($_SESSION['langname'])) {
                            $langName = $_SESSION['langname'];
                        }
                        if($showLanguages) {
                            if($isMobile) {
                                echo "<select id='languageSelect' class='btn-theme-transparent pull-left' onchange='setLanguage()' style='width:54px;display:inline-block;height:33px;margin-left: -15px;color: $textColor;border: 4px solid transparent;margin-top: 3px;margin-right: 15px;border-radius: 30%;'>";
                            } else {
                                echo "<select id='languageSelect' class='btn-theme-transparent pull-left' onchange='setLanguage()' style='width:80px;display:inline-block;height:33px;margin-left: 5px;color: $textColor;border: 4px solid transparent;margin-top: 4px;margin-right: 8px;'>";
                            }
                            if (strcmp($lang, 'en') == 0) {
                                echo "<option value='en'><strong>English</strong></option>";
                                echo "<option value='el'><strong>Greek</strong></option>";
                            } else {
                                echo "<option value='el'><strong>Greek</strong></option>";
                                echo "<option value='en'><strong>English</strong></option>";
                            }
                            echo "</select>";
                        }

                        ?>


                        <?php

                        if(!$isMobile && strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || !$isMobile && strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || !$isMobile && strpos($_SERVER['REQUEST_URI'] , '.php') === false) {
                            echo '

                            <div class="widget-search widget-searchbox " style="margin-top: 1px;position: absolute;z-index: 100 !important;background-color: whitesmoke !important;width: 50%; border-radius: 4px !important;">
                                <input id = "searchButton" name = "searchButton" class="form-control widget_searchbox_input deletable  " type = "search" placeholder = "' . $langu['searchbox_hint'] . '" style="border-radius: 4px !important;">
                                <div id = "suggesstion-box" ></div >
                                <button style = "display:none;position:absolute;right:60px;" class="widget-close" id = "searchButtonIconClose" ><i class="fa fa-times" ></i ></button >
                                <button id = "searchButtonIcon" ><i class="fa fa-search" ></i ></button >
                            </div >

                        ';
                        }

                        if($isMobile) {
                            echo '<div class="widget-search widget-searchbox hidden-md hidden-lg" style="border-color:transparent;margin-top: 0px;position: absolute;z-index: 1 !important;width: 150px; border-radius: 4px !important;"><a href="index.php" ><img class="pull-right " style="display: block;margin-top:0px;margin-left: -11px;margin-right: auto;max-height:40px;" src="'.$logoLinkHeader.'" alt="Coprime"/></a></div>';
                        }

                        ?>

                        <?php

                        if (!(!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) || $allowAnonymousOrder) {

                            global $username, $password, $database;

                            $userId =  $_SESSION['userID'];
                            $db = new mysqli('localhost',$username,$password,$database);
                            if (mysqli_connect_errno()) {
                                printf("Connect failed: %s\n", mysqli_connect_error());
                                exit();
                            }
                            $db->set_charset("utf8");

                            $stm = $db->prepare("SELECT username,first_name FROM B2B_User WHERE b2b_user_id='$userId'");
                            $stm-> execute();
                            $stm-> bind_result($userName,$fname);

                            while ($stm->fetch()) {
                                if(strcmp(trim($fname),'')!=0){$userName=$fname;}
                            }
                            $stm-> close();

                            $checkoutLabel = $langu['checkout_label'];
                            $displaySubTotal = number_format(floatval($subtotal),2);

                            $greeting = $langu['greeting'];


                            $show = true;

                            $stm = $db->prepare("SELECT category_id, count(category_id) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userId'");
                            $stm->execute();
                            $stm->bind_result($categoryID, $counter);
                            while ($stm->fetch()) {
                            }
                            $stm->close();

                            if($counter == 1 && $categoryID == 2){$show = false;}
                            else if($counter == 1 && $categoryID == 14){$show = false;$_GET['category_id']=$categoryID;}

                            $_SESSION['show'] = $show;
                            $itemsLabel = $langu['item'];
                            $qtyLabel = $langu['qty'];
                            $netTotalLabel = $langu['net_total'];
                            if(true) {
                                if($isMobile){
                                    $headerCartStyle='margin-right: -12px;width:40%;margin-top: 3px;';
                                }else{
                                    $headerCartStyle='margin-top: -8px;';
                                }

                                if((int)$itemCounter > 0){
                                    $boubleBgColor  = 'firebrick';
                                    $boubleColor    = 'white';
                                } else {
                                    $boubleBgColor  = $boubleColor = 'transparent';
                                }
                                echo "

         <!-- Header shopping cart -->

            <div class='header-cart  pull-right' style='$headerCartStyle'>      
                <div class='cart-wrapper pull-right' style=''>
                  <label style='display:block;font-size: 7px;' class='hidden-xs'>&nbsp;</label>
                    <a href='#'  class='btn btn-theme-transparent  pull-right' onclick='openCart()' data-toggle='modal' data-target='#popup-cart' style='padding-left:0px;padding-right:0px;border-radius: 14px !important;border-color: transparent;'>&nbsp; <i class='fa fa-shopping-cart' style='font-size:20px;color: $textColor'></i><span class='dot' style='vertical-align: middle;margin-bottom:-12px;margin-left:-5px;margin-top:-38px;height: 18px;width: 18px;background-color: $boubleBgColor;border-radius: 50%;display:inline-block;color: $boubleColor;font-size: 11px;font-weight:bold;text-align: center;padding: 1px;overflow: hidden' id='modalCartButtonNumber'>$itemCounter</span><span class='hidden-xs hidden' id='modalCartButtonText' style='color: $textColor'> $itemCounter $itemsLabel - $qtyLabel $count";
                                if ($showPrices) {
                                    echo " $netTotalLabel: $displaySubTotal";
                                }
                                echo "</span> <i class='fa fa-angle-down hidden'></i></a>
                    <!-- Mobile menu toggle button -->
                    <!--<a href='accountinformation.php'  class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;border-radius: 14px !important;border-color: transparent;'><i class='fa fa-user' style='font-size:20px;color: $textColor'></i>&nbsp;</a>-->
                    <div class='dropdownPages pull-right' >
                      <button class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;border-radius: 14px !important;border-color: transparent;'><i class='fa fa-user' style='font-size:20px;color: $textColor'></i></button>
                      <div class='dropdownPages-content' style='position: absolute;right: -60px;top: 40px;text-align: left;border: 1px solid black;'>
                      <ul style='margin-bottom: 0px;width: 180px;'>
                        $dropDownPages
                        </ul>
                      </div>
                    </div>";
                                if($showCurrencies) {

                                    $currencySelection = '';
                                    $db->set_charset("utf8");
                                    $stm = $db->prepare("SELECT currency_code,currency_sign,currency_id FROM Display_Currency ORDER BY default_currency DESC ");
                                    $stm->execute();
                                    $stm->bind_result($currencySelectionOptionCode, $currencySelectionOptionSign, $currencySelectionOptionID);
                                    while ($stm->fetch()) {
                                        if ($sessionCurrencyID == $currencySelectionOptionID) {
                                            $currencySelection .= "<option value='$currencySelectionOptionID' selected>$currencySelectionOptionSign</option>";
                                        } else {
                                            $currencySelection .= "<option value='$currencySelectionOptionID'>$currencySelectionOptionSign</option>";
                                        }
                                    }
                                    $stm->close();

                                    if (strcmp($currencySelection, '') != 0) {
                                        echo "<div class='dropdownPages pull-right' ><select id='currencySelect' class='btn-theme-transparent pull-right text-center' onchange='setCurrency()' style='width:40px;height:37px;font-size:20px;margin-top:1px;margin-left: 5px;margin-right:-5px;border-radius: 14px !important;border-color: transparent;color: $textColor;appearance: none;'>$currencySelection</select></div>";
                                    }
                                } else {
                                    if(isset($_SESSION['currency'])){
                                        unset($_SESSION['currency']);
                                    }
                                }
                    echo "
                    <style>
                        /* The container <div> - needed to position the dropdown content */
                        .dropdownPages {
                          position: relative;
                          display: inline-block;
                        }
                        
                        /* Dropdown Content (Hidden by Default) */
                        .dropdownPages-content {
                          display: none;
                          position: absolute;
                          background-color: $themeColor;
                          min-width: 160px;
                          box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
                          z-index: 1000;
                        }
                        
                        /* Links inside the dropdown */
                        .dropdownPages-content a {
                          color: black;
                          padding: 12px 16px;
                          text-decoration: none;
                          display: block;
                        }
                        
                        /* Change color of dropdown links on hover */
                        .dropdownPages-content a:hover {
                            background-color: black;
                            color: $themeColor;
                            }
                        
                        /* Show the dropdown menu on hover */
                        .dropdownPages:hover .dropdownPages-content {display: block;}
                        
                        /* Change the background color of the dropdown button when the dropdown content is shown */
                        .dropdownPages:hover .dropbtn {background-color: #3e8e41;}
                    </style>
                </div>
            </div>

        ";
                            }
                        } else {
                            echo "<div class='dropdownPages pull-right' >
                      <button class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;border-radius: 14px !important;border-color: transparent;'><i class='fa fa-user' style='font-size:20px;color: $textColor'></i></button>
                      <div class='dropdownPages-content' style='position: absolute;right: -60px;top: 40px;text-align: left;border: 1px solid black;'>
                      <ul style='margin-bottom: 0px;width: 180px;'>
                        $dropDownPages
                        </ul>
                      </div>
                    </div>";
                            if($showCurrencies) {

                                $currencySelection = '';
                                $db->set_charset("utf8");
                                $stm = $db->prepare("SELECT currency_code,currency_sign,currency_id FROM Display_Currency ORDER BY default_currency DESC ");
                                $stm->execute();
                                $stm->bind_result($currencySelectionOptionCode, $currencySelectionOptionSign, $currencySelectionOptionID);
                                while ($stm->fetch()) {
                                    if ($sessionCurrencyID == $currencySelectionOptionID) {
                                        $currencySelection .= "<option value='$currencySelectionOptionID' selected>$currencySelectionOptionSign</option>";
                                    } else {
                                        $currencySelection .= "<option value='$currencySelectionOptionID'>$currencySelectionOptionSign</option>";
                                    }
                                }
                                $stm->close();

                                if (strcmp($currencySelection, '') != 0) {
                                    echo "<div class='dropdownPages pull-right' ><select id='currencySelect' class='btn-theme-transparent pull-right text-center' onchange='setCurrency()' style='width:40px;height:37px;font-size:20px;margin-top:1px;margin-left: 5px;margin-right:-5px;border-radius: 14px !important;border-color: transparent;color: $textColor;appearance: none;'>$currencySelection</select></div>";
                                }
                            } else {
                                if(isset($_SESSION['currency'])){
                                    unset($_SESSION['currency']);
                                }
                            }

                    echo "
                    <style>
                        /* The container <div> - needed to position the dropdown content */
                        .dropdownPages {
                          position: relative;
                          display: inline-block;
                        }
                        
                        /* Dropdown Content (Hidden by Default) */
                        .dropdownPages-content {
                          display: none;
                          position: absolute;
                          background-color: $themeColor;
                          min-width: 160px;
                          box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
                          z-index: 1000;
                        }
                        
                        /* Links inside the dropdown */
                        .dropdownPages-content a {
                          color: black;
                          padding: 12px 16px;
                          text-decoration: none;
                          display: block;
                        }
                        
                        /* Change color of dropdown links on hover */
                        .dropdownPages-content a:hover {
                            background-color: black;
                            color: $themeColor;
                            }
                        
                        /* Show the dropdown menu on hover */
                        .dropdownPages:hover .dropdownPages-content {display: block;}
                        
                        /* Change the background color of the dropdown button when the dropdown content is shown */
                        .dropdownPages:hover .dropbtn {background-color: #3e8e41;}
                    </style>";
                        }
                        ?>





        </div>
        <div class="col-sm-12 col-xs-12 hidden-md  hidden-lg" style="padding-right: 0px;padding-left: 0px;">
            <?php

            $urlFile = explode('?',basename($_SERVER['REQUEST_URI']))[0];
            if((strcmp($urlFile,'index.php')==0 || strcmp($urlFile,'b2b')==0 || strpos($urlFile , '.php') === false) && $isMobile )
            {
                if($allowAnonymousOrder || $customerID !=0){$allowOrderWidth = 'width: 100%;';}else{$allowOrderWidth = 'width: 100%;';}
                echo '        
                            <div class="widget-search widget-searchbox" style="margin-top: 12px;display: inline-block;'.$allowOrderWidth.'margin-bottom: 15px;z-index: 10;position:relative;">
                                <input id = "searchButton" name = "searchButton" class="form-control widget_searchbox_input deletable " type="search" placeholder = "'. $langu['searchbox_hint'] .'" >
                            <div id = "suggesstion-box" style="width: 100% !important;" ></div >
                            <button style = "display:none;position:absolute;right:60px;color: black;" class="widget-close" id = "searchButtonIconClose" ><i class="fa fa-times" ></i ></button >
                            <button id = "searchButtonIcon" ><i class="fa fa-search" ></i ></button >
                            </div >
                        ';


            }


            ?>
        </div>
    </div>
    <div class="container" style="width: 100%;padding: 0px;margin:0px;border:0px;display: none;">
        <div class='navigation-wrapper  closed clearfix hidden-xs hidden-sm' style="width: 100%;padding-bottom: 2px;border: 0px solid transparent;<?php echo $themeColorGradient; ?> ;">

        <!-- Logo -->
        <div class="col-sm-12 col-xs-12 col-md-3 col-lg-3">
            <a href="index.php"><img class="pull-left" style="display: block;margin-top:5px;margin-left: 0px;margin-right: auto;max-height:60px;" src="<?php echo $logoLinkHeader ?>" alt="Coprime"/></a>
        </div>




<!--        <div class="col-sm-12 col-xs-12 col-md-5 col-lg-5" >-->
<!--            --><?php
//            $urlFile = explode('?',basename($_SERVER['REQUEST_URI']))[0];
//            if((strcmp($urlFile,'index.php')==0 || strcmp($urlFile,'b2b')==0) && !$isMobile)
//            {
//                echo ' <center>
//                            <div class="widget-search widget-searchbox" style="margin-top: 12px;position: absolute;left: 72px;z-index: 10000 !important;background-color: whitesmoke !important;">
//                                <input id = "searchButton" name = "searchButton" class="form-control widget_searchbox_input deletable  " type = "search" placeholder = "'. $langu['searchbox_hint'] .'" >
//                            <div id = "suggesstion-box" ></div >
//                            <button style = "display:none;position:absolute;right:60px;" class="widget-close" id = "searchButtonIconClose" ><i class="fa fa-times" ></i ></button >
//                            <button id = "searchButtonIcon" ><i class="fa fa-search" ></i ></button >
//                            </div >
//
//                        </center>';
//
//
//            }
//
//
//            ?>
<!--        </div>-->






        <style>
            @media (max-width: 600px) {
                .header-cart {
                    width:70%;
                }
            }
        </style>

        <script>

            function setLanguage()
            {
                var language = $('#languageSelect').val();

                var currenthref = window.location.href;
                var newhref = '';

                if(currenthref.indexOf('?lang=') > -1)
                {
                    newhref = window.location.href.split('?lang=')[0];
                }
                else if(currenthref.indexOf('lang=') > -1)
                {
                    newhref = window.location.href.split('lang=')[0];
                }
                else {
                    newhref = window.location.href;
                }

                if (newhref.substring(newhref.length-1) == "&")
                {
                    newhref = newhref.substring(0, newhref.length-1);
                }

                if(newhref.indexOf('?') > -1)
                {
                    window.location.href=newhref + "&lang=" + language;
                }
                else
                {
                    window.location.href=newhref + "?lang=" + language;
                }

            }
            function setCurrency()
            {
                var currency = $('#currencySelect').val();

                var currenthref = window.location.href;
                var newhref = '';

                if(currenthref.indexOf('?currency=') > -1)
                {
                    newhref = window.location.href.split('?currency=')[0];
                }
                else if(currenthref.indexOf('currency=') > -1)
                {
                    newhref = window.location.href.split('currency=')[0];
                }
                else {
                    newhref = window.location.href;
                }

                if (newhref.substring(newhref.length-1) == "&")
                {
                    newhref = newhref.substring(0, newhref.length-1);
                }

                if(newhref.indexOf('?') > -1)
                {
                    window.location.href=newhref + "&currency=" + currency;
                }
                else
                {
                    window.location.href=newhref + "?currency=" + currency;
                }

            }

        </script>
        </div>
    </div>
</div>
