<?php
session_start();
include_once("../param.php");
require_once("./assets/mobiledetect/Mobile_Detect.php");

$detect = new Mobile_Detect;
$isMobile = false;
if ( $detect->isMobile() ) {
    $isMobile = true;
}

//$_SESSION['customerID'] ='10000';
//$_SESSION['orderID'] = '10000';
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

$companyID = $_SESSION['companyID'];
$orderID=$_SESSION['orderID'];
$customerID = $_SESSION['customerID'];



$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$showPrices=true;
$stm = $db->prepare("SELECT primary_language,show_prices,css_theme FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$cssTheme);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 && $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();

include_once("headerImports.php");

?>

<body id="home" class="wide">
    <!-- PRELOADER -->
    <div id="preloader">
        <div id="preloader-status">
            <div class="spinner">
                <div class="rect1"></div>
                <div class="rect2"></div>
                <div class="rect3"></div>
                <div class="rect4"></div>
                <div class="rect5"></div>
            </div>
            <div id="preloader-title">Loading</div>
        </div>
    </div>
    <!-- /PRELOADER -->

    <!-- WRAPPER -->
    <div class="wrapper">

        <!-- Popup: Shopping cart items -->
        <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog">
                <div id='cartItems' class="container">

                </div>
            </div>
        </div>

        <!-- /Popup: Shopping cart items -->

        <!-- HEADER -->
            <?php
            $topmenu = "topMenu$cssTheme.php";

            if(strcmp($topmenu,"topMenu2.php")==0){
                echo '<header class="header fixed" style="border: 0px;">';
            } else {
                echo '<header class="header fixed" >';
            }

            include_once("$topmenu");
            if(strcmp($topmenu,"topMenu.php")==0) {
                include_once("navigationMenu.php");
            }
            ?>
        </header>
        <!-- /HEADER -->

        <!-- CONTENT AREA -->
        <div class="content-area">
            <section class="page-section">
                <div class=" container" >
                    <div class="row">
                            <!--start main contain of page-->

                            <!--start sidebar-->
                            <?php

                            include_once("navigationAccountMenu.php");
                            ?>
                            <!--end sidebar-->

                            <div class="col-md-9 col-md-9 col-sm-8">
                                <div class="information-title"><?php echo $langu['account_order_history_title'] ?></div>
                                <div class="details-wrap">                                    
                                    <div class="details-box orders">
                                        <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" <?php if($isMobile) {echo "style='font-size:12px;'";}?> >

                                            <thead style="background-color:ghostwhite;color: black">
                                            <tr>
                                                <th ><?php echo $langu['account_view_order_code'] ?></th>
                                                <th ><?php echo $langu['account_view_order_date'] ?></th>
                                                <?php
                                                if(!$isMobile) {
                                                    echo '<th >'. $langu['account_view_order_delivery_date'] .'</th>';
                                                    echo '<th >'. $langu['account_order_status'] .'</th>';
                                                }
                                                if ($showPrices) {
                                                    $grandTotalString = $langu['account_order_grand_total'];
                                                    echo "<th >$grandTotalString</th>";
                                                }
                                                ?>

                                                <th ><?php echo $langu['account_order_action_title'] ?></th>
                                            </tr>
                                            </thead>
                                        </table>

                                        <div>
                                            <a href="accountinformation.php" class="btn btn-theme"><?php echo $langu['account_order_history_back_to_account_button'] ?> </a>
                                        </div>
                                    </div>
                                </div>                                
                            </div>
                            <!--end main contain of page-->                           
                        </div>
                    </div>
                </section>
            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">

                <div class="footer-meta" >
                    <div class="container">
                        <div class="row">

                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <link href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" rel="stylesheet">

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/owl-carousel2/owl.carousel.min.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

<!--        <script src="assets/plugins/datatables/jquery.dataTables.min.js"></script>-->
<!--        <script src="assets/plugins/datatables/dataTables.colVis.min.js"></script>-->
<!--        <script src="assets/plugins/datatables/dataTables.tableTools.min.js"></script>-->
<!--        <script src="assets/plugins/datatables/dataTables.bootstrap.min.js"></script>-->
<!--        <script src="assets/plugins/datatable-responsive/datatables.responsive.min.js"></script>-->

        <script src="//cdn.datatables.net/1.10.12/js/jquery.dataTables.min.js"></script>


        <script type="text/javascript">

            $(document).ready(function() {

                 $('#datatable_fixed_column').DataTable({
                    "bInfo" : false,
                    "autoWidth" : true,
                    "processing": false,
                    "serverSide": true,
                    "ajax": "./dbaccess/getAllOrders.php",
                    "columns": [
                        { "data": "code" },
                        { "data": "date" },
                        <?php
                        if(!$isMobile) {
                            echo "{ \"data\": \"ddate\" },";
                            echo "{ \"data\": \"status\" },";
                        }
                        if ($showPrices) {
                            echo "{ \"data\": \"grand\" },";
                        }
                        ?>

                        { "data": "form" }
                    ],
                    "deferRender": true,
                    "order": [[ 1, "desc" ],[ 0, "desc" ]]
                });
            })

        </script>

        <script>

            // Fixed menu toggle
            $('.menu-toggle').on('click', function () {
                if (navigation.hasClass('opened')) {
                    navigation.removeClass('opened').addClass('closed');
                } else {
                    navigation.removeClass('closed').addClass('opened');
                }
            });
            $('.menu-toggle-close').on('click', function () {
                if (navigation.hasClass('opened')) {
                    navigation.removeClass('opened').addClass('closed');
                } else {
                    navigation.removeClass('closed').addClass('opened');
                }
            });
        </script>

       <style>
           #datatable_fixed_column_filter
           {
               margin-bottom:10px;
           }
       </style>

    </body>
</html>