<?php
session_start();

include_once("../../param.php");
require_once("dbhelper.php");
include('../langs/'.$_SESSION['lang'].'.php');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$addItemByUnits = true;
$stm = $db->prepare("SELECT theme,show_prices_with_vat,order_qty_by_subunits FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($themeColor,$showPricesIncludingVAT,$orderQtyBySubunits);
while ($stm->fetch()) {
    if(strcmp($themeColor,'')==0){$themeColor='#6796d3';}

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm->close();

$textColor="white";
$themeColor = strtolower($themeColor);
if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0){
    $themeColor = "firebrick";
} else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0) {
    $themeColor = "goldenrod";
} else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
    $themeColor = "#1d4f9c";
} else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
    $themeColor = "#1d4f9c";
}  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
    $themeColor = "#000080";
} else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
    $themeColor = "black";
}
else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
    $themeColor = "yellow";
    $textColor = "black";
} else {
    if(strpos($themeColor,'#')===false) {
        $themeColor = str_replace('darkdark','dark',"dark$themeColor");
    }
}

$customerID = intval($_SESSION['customerID']);
$itemID = intval($_POST['itemID']);
$currencySign = getCurrencySign();

//get order history limit
$stm = $db->prepare("SELECT product_history_limit,product_history_source FROM B2B_Page_Catalogue LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($historyLimit, $productHistorySource);
while ($stm->fetch()) {
}
$stm->close();

if(strcmp($productHistorySource,"orders")==0 || strcmp($productHistorySource,"")==0 ) {
    $inOrder = false;

    $lastOrdersHistory = "<table style='width:100%; border-collapse:collapse; font-family: Arial, sans-serif;margin:0px;' class='table table-striped'>
                           <thead style='background-color:$themeColor; color:$textColor; border: solid 1px $themeColor;'>
                              <tr>
                                  <th style='width:20%;padding:8px; text-align:left;'>" . $langu['order_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['account_view_date'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['column_price_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['column_quantity_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:right;'>" . $langu['column_total_label'] . "</th>
                              </tr>
                           </thead>  
                           <tbody style=''>";


    $stm = $db->prepare("SELECT order_code,order_date,qty,unit_price,Order_Item.vat_amount 
                            FROM Orders,Order_Item 
                            WHERE Orders.order_id=Order_Item.order_id 
                            AND item_id='$itemID' 
                            AND customer_id='$customerID' 
                            AND NOT Orders.status='Canceled'
                            AND online_order_id > 0
                            ORDER BY order_date DESC 
                            LIMIT $historyLimit");

    $stm->execute();
    $stm->bind_result($orderCodeInfo, $orderDateInfo, $qtyInfo, $unitPriceInfo, $vatAmountInfo);
    while ($stm->fetch()) {
        $inOrder = true;
        if ($orderDateInfo == '0000-00-00') {
            $orderDateInfo = '';
        } else {
            $orderDateInfo = date_format(date_create_from_format('Y-m-d', $orderDateInfo), 'd-m-Y');
        }

        if (strcmp($showPricesIncludingVAT, 'yes') == 0) {
            $unitPriceInfo = $unitPriceInfo + $vatAmountInfo;
        }

        if ($addItemByUnits) {
            $qtyInfo = $qtyInfo / floatval(getSubUnits($itemID));
            $totalInfo = $unitPriceInfo * $qtyInfo;
        } else {
            $totalInfo = $unitPriceInfo * $qty / floatval(getSubUnits($itemID));
        }


        $lastOrdersHistory .= "<tr style='border-bottom: 1px solid #ccc;'>
                              <td style='padding:8px; text-align:left; word-break:break-word;'>$orderCodeInfo</td>
                              <td style='padding:8px; text-align:center;'>$orderDateInfo</td>
                              <td style='padding:8px; text-align:center;'>" . $currencySign . number_format($unitPriceInfo, 2) . "</td>
                              <td style='padding:8px; text-align:center;'>$qtyInfo</td>
                              <td style='padding:8px; text-align:right;'>" . $currencySign . number_format($totalInfo, 2) . "</td>
                           </tr>";
    }

    $stm->close();

    $lastOrdersHistory .= "</tbody></table>";

    if ($inOrder == false) {
        $lastOrdersHistory = "<center><h3>" . $langu['no_orders_label'] . "</h3></center>";
    }

    $response = array(
        'header' => $langu['product_order_history_title'],
        'body' => $lastOrdersHistory
    );
    echo json_encode($response);
}
else if(strcmp($productHistorySource,"invoices")==0){

    $inInvoice = false;

    $lastHistory = "<table style='width:100%; border-collapse:collapse; font-family: Arial, sans-serif;margin:0px;' class='table table-striped'>
                           <thead style='background-color:$themeColor; color:$textColor; border: solid 1px $themeColor;'>
                              <tr>
                                  <th style='width:20%;padding:8px; text-align:left;'>" . $langu['invoice_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['account_view_date'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['column_price_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:center;'>" . $langu['column_quantity_label'] . "</th>
                                  <th style='width:20%;padding:8px; text-align:right;'>" . $langu['column_total_label'] . "</th>
                              </tr>
                           </thead>  
                           <tbody style=''>";



    $stm = $db->prepare("SELECT invoice_code,invoice_date,qty,unit_price,Invoice_Item.vat_amount 
                            FROM Invoices INNER JOIN Invoice_Item ON Invoices.invoice_id = Invoice_Item.invoice_id 
                            LEFT JOIN Orders AS o ON o.order_id = Invoices.order_id
                            WHERE item_id='$itemID' 
                            AND Invoices.customer_id='$customerID' 
                            AND NOT Invoices.status='Canceled'
                            AND o.online_order_id > 0
                            ORDER BY invoice_date DESC 
                            LIMIT $historyLimit");
    $stm->execute();
    $stm->bind_result($codeInfo, $dateInfo, $qtyInfo, $unitPriceInfo, $vatAmountInfo);
    while ($stm->fetch()) {
        $inInvoice = true;
        if ($dateInfo == '0000-00-00') {
            $dateInfo = '';
        } else {
            $dateInfo = date_format(date_create_from_format('Y-m-d', $dateInfo), 'd-m-Y');
        }

        if (strcmp($showPricesIncludingVAT, 'yes') == 0) {
            $unitPriceInfo = $unitPriceInfo + $vatAmountInfo;
        }

        if ($addItemByUnits) {
            $qtyInfo = $qtyInfo / floatval(getSubUnits($itemID));
            $totalInfo = $unitPriceInfo * $qtyInfo;
        } else {
            $totalInfo = $unitPriceInfo * $qty / floatval(getSubUnits($itemID));
        }


        $lastHistory .= "<tr style='border-bottom: 1px solid #ccc;'>
                              <td style='padding:8px; text-align:left; word-break:break-word;'>$codeInfo</td>
                              <td style='padding:8px; text-align:center;'>$dateInfo</td>
                              <td style='padding:8px; text-align:center;'>" . $currencySign . number_format($unitPriceInfo, 2) . "</td>
                              <td style='padding:8px; text-align:center;'>$qtyInfo</td>
                              <td style='padding:8px; text-align:right;'>" . $currencySign . number_format($totalInfo, 2) . "</td>
                           </tr>";
    }

    $stm->close();

    $lastHistory .= "</tbody></table>";

    if (!$inInvoice) {
        $lastHistory = "<center><h3>" . $langu['no_invoice_label'] . "</h3></center>";
    }

    $response = array(
        'header' => $langu['product_invoice_history_title'].$itemID,
        'body' => $lastHistory
    );
    echo json_encode($response);

}

else if(strcmp($productHistorySource,"erp_last_prices")==0){

    $inERP = false;

    $lastHistory = "<table style='width:100%; border-collapse:collapse; font-family: Arial, sans-serif;margin:0px;' class='table table-striped'>
                           <thead style='background-color:$themeColor; color:$textColor; border: solid 1px $themeColor;'>
                              <tr>
                                  <th style='width:25%;padding:8px; text-align:left;'>" . $langu['invoice_label'] . "</th>
                                  <th style='width:25%;padding:8px; text-align:center;'>" . $langu['account_view_date'] . "</th>
                                  <th style='width:25%;padding:8px; text-align:center;'>" . $langu['column_price_label'] . "</th>
                                  <th style='width:25%;padding:8px; text-align:center;'>" . $langu['column_quantity_label'] . "</th>
                              </tr>
                           </thead>  
                           <tbody style=''>";



    $stm = $db->prepare("SELECT invoice_code,invoice_date,qty,price
                            FROM ERP_Last_Prices 
                            WHERE item_id='$itemID' 
                            AND customer_id='$customerID' 
                            ORDER BY invoice_date DESC 
                            LIMIT $historyLimit");
    $stm->execute();
    $stm->bind_result($codeInfo, $dateInfo, $qtyInfo, $unitPriceInfo);
    while ($stm->fetch()) {
        $inERP = true;
        if ($dateInfo == '0000-00-00') {
            $dateInfo = '';
        } else {
            $dateInfo = date_format(date_create_from_format('Y-m-d', $dateInfo), 'd-m-Y');
        }

        if ($addItemByUnits) {
            $qtyInfo = $qtyInfo / floatval(getSubUnits($itemID));
          //  $totalInfo = $unitPriceInfo * $qtyInfo;
        } else {
           // $totalInfo = $unitPriceInfo * $qty / floatval(getSubUnits($itemID));
        }


        $lastHistory .= "<tr style='border-bottom: 1px solid #ccc;'>
                              <td style='padding:8px; text-align:left; word-break:break-word;'>$codeInfo</td>
                              <td style='padding:8px; text-align:center;'>$dateInfo</td>
                              <td style='padding:8px; text-align:center;'>" . $currencySign . number_format($unitPriceInfo, 2) . "</td>
                              <td style='padding:8px; text-align:center;'>$qtyInfo</td>
                           </tr>";
    }

    $stm->close();

    $lastHistory .= "</tbody></table>";

    if (!$inERP) {
        $lastHistory = "<center><h3>".$langu['no_data_label'] ."</h3></center>";
    }

    $response = array(
        'header' => $langu['product_last_price_history_title'],
        'body' => $lastHistory
    );
    echo json_encode($response);

}
?>