<?php
session_start();
include_once("../../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$waybillID = trim($_GET['waybillID']);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

// DB table to use
$table = 'Waybills';

// Table's primary key
$primaryKey = "waybill_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`w`.`qty`', 'dt' => 'hours', 'formatter' => function( $d, $row ) {

        $shownTimeHr  = floor($d/60);
        $shownTimeMin = round(($d/60-$shownTimeHr)*60);
        if($shownTimeMin < 10 ) {$shownTimeMin = "0".$shownTimeMin;}
        $qty = $shownTimeHr.':'.$shownTimeMin;

       return $qty;
    }, 'field' => 'qty' ),

    array( 'db' => '`w`.`warehouse_id`', 'dt' => 'project', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT project_name FROM Projects WHERE project_id = $d ");
        $stm-> execute();
        $stm-> bind_result($projects);
        while ($stm->fetch()) {}
        $stm-> close();
        return $projects;
    }, 'field' => 'warehouse_id' ),

    array( 'db' => '`w`.`item_id`', 'dt' => 'activity', 'formatter' => function( $d, $row ) {

        global $db;

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT name FROM Items WHERE item_id = $d ");
        $stm-> execute();
        $stm-> bind_result($projects);
        while ($stm->fetch()) {}
        $stm-> close();
        return $projects;
    }, 'field' => 'item_id' ),


    array( 'db' => '`w`.`date_from`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));
        },'field' => 'date_from' ),

    array( 'db' => '`w`.`date_from`', 'dt' => 'from' , 'formatter' => function( $d, $row ) {
        return date('H:i',strtotime($d));
        },'field' => 'date_from' ),

    array( 'db' => '`w`.`date_to`', 'dt' => 'to' , 'formatter' => function( $d, $row ) {
        return date('H:i',strtotime($d));
        },'field' => 'date_to' ),



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$customerID =$_SESSION['customerID'];
$salesPersonID = $_SESSION['userID'];
$joinQuery = "FROM `Waybill_Item` AS `w` ";
$where = "`w`.`waybill_id`='$waybillID'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );

     ?>

