<?php

include_once("../../param.php");
require("dbhelper.php");

global  $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
printf("Connect failed: %s\n", mysqli_connect_error());
exit();
}
$db->set_charset("utf8");

$loggedInUserID = intval($_SESSION['userID']);
$loggedInCustomerID = intval($_SESSION['customerID']);

if(isset($loggedInUserID) && $loggedInUserID > 0 && isset($loggedInCustomerID) && $loggedInCustomerID > 0){
    $loggedin = true;
} else {
    $loggedin = false;
}

if (!$loggedin) {
    http_response_code(401);
    exit;
}



$customerID = $_SESSION['customerID'];
$query = "SELECT sc.service_call_id, sc.service_call_code ,sc.schedule_start_date ,sc.schedule_end_date, sc.date,sc.due_date,sc.topic ,sc.details, scs.status_id, scs.status_code,scs.status_name,scs.status_color, sct.type_id,sct.type_code,sct.type_name,sct.color
            FROM Service_Call AS sc 
            LEFT JOIN SC_Status AS scs ON sc.status_id = scs.status_id
            LEFT JOIN SC_Types AS sct ON sct.type_id = sc.type_id
            WHERE sc.customer_id = ?";

$stm = $db->prepare($query);
$stm->bind_param('i', $customerID);
$stm->execute();
$stm->bind_result($serviceID,$serviceCode, $scheduleStartDate, $scheduleEndDate,$serviceDate,$serviceDueDate, $topic,$details, $statusID, $statusCode, $statusName, $statusColor, $typeID, $typeCode, $typeName, $typeColor);

$serviceCalls = array();
while ($stm->fetch()) {
    $serviceCall = new  stdClass();

    $serviceCall = new stdClass();
    $serviceCall->serviceCallID = $serviceID;
    $serviceCall->serviceCallCode = $serviceCode;

    $serviceCall->scStatus = new stdClass();
    $serviceCall->scStatus->statusID = $statusID;
    $serviceCall->scStatus->statusCode = $statusCode;
    $serviceCall->scStatus->name = $statusName;
    $serviceCall->scStatus->color = $statusColor;

    $serviceCall->topic = $topic;
    $serviceCall->date = $serviceDate;

    $serviceCall->scType = new stdClass();
    $serviceCall->scType->typeID = $typeID;
    $serviceCall->scType->typeCode = $typeCode;
    $serviceCall->scType->name = $typeName;
    $serviceCall->scType->color = $typeColor;

    $serviceCall->details = $details;
    $serviceCall->dueDate = $serviceDueDate;
    $serviceCall->scheduleStart = $scheduleStartDate;
    $serviceCall->scheduleEnd = $scheduleEndDate;


    array_push($serviceCalls, $serviceCall);

}
$stm->close();
echo json_encode($serviceCalls);




?>