<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

$userID = intval($_SESSION['userID']);
$customerID = intval($_SESSION['customerID']);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT customer_id FROM B2B_User WHERE b2b_user_id=? AND customer_id=? LIMIT 1");
$stm->bind_param('ii',$userID,$customerID);
$stm->execute();
$stm->bind_result($checkCustomerID);
while($stm->fetch()) {}
$stm->close();
$checkCustomerID = intval($checkCustomerID);

$stm = $db->prepare("SELECT anonymous_checkout_customer_id FROM B2B_Configuration LIMIT 1");
$stm->execute();
$stm->bind_result($anonymousCustomerID);
while($stm->fetch()) {}
$stm->close();
$anonymousCustomerID = intval($anonymousCustomerID);

if($checkCustomerID!=$customerID){$customerID=0;}
if($anonymousCustomerID==$customerID){$customerID=0;}

$arrayCustomerAddresses = array();

if ($customerID>0){
    $stm = $db->prepare("SELECT customer_address_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,primary_address FROM CustomerAddress WHERE customer_id=? AND NOT primary_address = 'deleted' ORDER BY customer_address_id DESC");
    $stm->bind_param('i',$customerID);
    $stm-> execute();
    $stm-> bind_result($customer_address_id,$country,$city,$address_line_1,$address_line_2,$postcode,$region,$lat,$lng,$primary_address);
    while ($stm->fetch()) {
        $objAddresses = new stdClass();
        $objAddresses->customer_address_id = $customer_address_id;
        $objAddresses->country = $country;
        $objAddresses->city =$city;
        $objAddresses->address_line_1 = $address_line_1;
        $objAddresses->address_line_2 = $address_line_2;
        $objAddresses->postcode = $postcode;
        $objAddresses->region =$region;
        $objAddresses->lat =$lat;
        $objAddresses->lng =$lng;
        $objAddresses->primary_address =$primary_address;
        array_push($arrayCustomerAddresses,$objAddresses);
    }
    $stm-> close();
}

if(isset($userID) && $userID > 0 && isset($customerID) && $customerID > 0){
    $loggedin = 'true';
} else {
    $loggedin = 'false';
}

$object = new stdClass();
$object->customerAddresses = $arrayCustomerAddresses;
$object->loggedin = $loggedin;
echo json_encode($object);






?>
