<?php 
// In the field 'password' of Table 'B2C_Payment_Methods' for SIX use the structure: '{username}:{password}'

include_once('../../param.php');

$orderCode = trim($_GET['oid']);
$customerID = $_SESSION['customerID'];
$userID=$_SESSION['userID'];

if(isset($orderCode) && strcmp($orderCode,'')!=0) {
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT customer_code,customer_company_name,balance FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName,$balance);
    while ($stm->fetch()){}
    $stm->close();

    $stm = $db->prepare("SELECT company_name FROM B2B_Configuration LIMIT 1");
    $stm->execute();
    $stm->bind_result($contactCompanyName);
    while ($stm->fetch()) {}
    $stm->close();
   
    $stm = $db->prepare("SELECT username,email,first_name,last_name,B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($userName, $email,$firstName,$lastName,$isB2CUser);
    while ($stm->fetch()) {}
    $stm->close();
    
    $stm = $db->prepare("SELECT merchant_id,password,currency_iso_code,acquirer_id,post_url FROM B2C_Payment_Methods WHERE payment_method_code = 'SIX'");
    $stm->execute();
    $stm->bind_result($sixCustomerID, $SIXpassword, $SIXcurrency, $terminalID, $postURL);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT order_id,order_code,order_date,subtotal,vat_amount,grand_total,details,order_address_id,status,delivery_method FROM Orders WHERE order_code='$orderCode'");
    $stm->execute();
    $stm->bind_result($orderID,$orderCode, $orderDate, $subtotal, $vatAmount, $grandTotal, $details, $orderAddressID, $orderStatus, $deliveryMethod);
    while ($stm->fetch()) {}
    $stm->close();

    $SIXcurrency = getCurrencyCodeFromISO($SIXcurrency);
    $api_url = $postURL."Payment/v1/PaymentPage/Initialize";
    $amount = round($grandTotal*100);
    
    $payload = array(
        'RequestHeader' => array(
        'SpecVersion' => "1.7",
        'CustomerId' => "$sixCustomerID",
        'RequestId' => "$orderCode-$orderID",
        'RetryIndicator'=> 0
        ),
        'TerminalId' => "$terminalID",
        'Payment' => array(
        'Amount' => array(
        'Value' => "$amount",
        'CurrencyCode' =>"$SIXcurrency"
        ),
        'OrderId' => "$orderCode",
        'Description' => "$orderCode"
        ),
        'ReturnUrls' => array(
        'Success' => "https://".HTML_PATH."/cop/b2b/six/success.php",
        'Fail' => "https://".HTML_PATH."/cop/b2b/six/fail.php"
        )
    );
    
   
    $curl = curl_init($api_url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER,array("Content-type: application/json","Accept: application/json; charset=utf-8"));
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
    curl_setopt($curl, CURLOPT_USERPWD, $SIXpassword);
    $jsonResponse = curl_exec($curl);
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    if ($status != 200) {
        $body = json_decode(curl_multi_getcontent($curl), true);
        $response = array(
            "status" => $status . " <|> " . curl_error($curl),
            "body" => $body
        );
    } else {
        $body = json_decode($jsonResponse, true);
        $response = array(
        "status" => $status,
        "body" => $body
        );
    }
    curl_close($curl);
    $urlPay = $response['body']['RedirectUrl'];
    $token = $response['body']['Token'];
        
    
    //to token xrisimopoihte sta file success kai fail gia na dume to transaction
    session_start();
    $_SESSION["TOKENSIX"] = $token;
    $_SESSION["ORDERSIXID"] = $orderID;
    
    if (isset($urlPay)){
        header('Location: ' . $urlPay);
    }else{
        header("Location: //".HTML_PATH."/cop/b2b/viewsingleorder.php?p=-1&methodLabel=SIX&Order=$orderCode");
    }
}

function getCurrencyCodeFromISO($isoCode){

    $array = array('EUR'=>'978','AFN'=>'971','ALL'=>'8','DZD'=>'12','AOA'=>'973','ARS'=>'32','AMD'=>'51','AWG'=>'533','AZN'=>'944','BSD'=>'44',
                    'BHD'=>'48','BDT'=>'50','BBD'=>'52','BYN'=>'933','BZD'=>'84','BMD'=>'60','BTN'=>'64','BOB'=>'68','BOV'=>'984','BAM'=>'977',
                    'BWP'=>'72','BRL'=>'986','BND'=>'96','BGN'=>'975','BIF'=>'108','CVE'=>'132','KHR'=>'116','CAD'=>'124','KYD'=>'136','CLF'=>'990',
                    'CLP'=>'152','CNY'=>'156','COP'=>'170','COU'=>'970','KMF'=>'174','CDF'=>'976','CRC'=>'188','HRK'=>'191','CUC'=>'931','CUP'=>'192',
                    'CZK'=>'203','DJF'=>'262','DOP'=>'214','EGP'=>'818','SVC'=>'222','ERN'=>'232','ETB'=>'230','FKP'=>'238','FJD'=>'242','XAF'=>'950',
                    'GMD'=>'270','GEL'=>'981','GHS'=>'936','GIP'=>'292','DKK'=>'208','GTQ'=>'320','GNF'=>'324','GYD'=>'328','HTG'=>'332','HNL'=>'340',
                    'HKD'=>'344','HUF'=>'348','ISK'=>'352','INR'=>'356','IDR'=>'360','XDR'=>'960','IRR'=>'364','IQD'=>'368','ILS'=>'376','JMD'=>'388',
                    'JPY'=>'392','JOD'=>'400','KZT'=>'398','KES'=>'404','KPW'=>'408','KRW'=>'410','KWD'=>'414','KGS'=>'417','LAK'=>'418','LBP'=>'422',
                    'LSL'=>'426','LRD'=>'430','LYD'=>'434','MOP'=>'446','MGA'=>'969','MWK'=>'454','MYR'=>'458','MVR'=>'462','MRU'=>'929','MUR'=>'480',
                    'XUA'=>'965','MXN'=>'484','MXV'=>'979','MDL'=>'498','MNT'=>'496','MZN'=>'943','MMK'=>'104','NAD'=>'516','NPR'=>'524','NIO'=>'558',
                    'NGN'=>'566','OMR'=>'512','PKR'=>'586','PAB'=>'590','PGK'=>'598','PYG'=>'600','PEN'=>'604','PHP'=>'608','PLN'=>'985','QAR'=>'634',
                    'MKD'=>'807','RON'=>'946','RUB'=>'643','RWF'=>'646','SHP'=>'654','XCD'=>'951','WST'=>'882','STN'=>'930','SAR'=>'682','RSD'=>'941',
                    'SCR'=>'690','SLL'=>'694','SGD'=>'702','ANG'=>'532','XSU'=>'994','SBD'=>'90','SOS'=>'706','ZAR'=>'710','SSP'=>'728','LKR'=>'144',
                    'SDG'=>'938','SRD'=>'968','NOK'=>'578','SZL'=>'748','SEK'=>'752','CHE'=>'947','CHF'=>'756','CHW'=>'948','SYP'=>'760','TWD'=>'901',
                    'TJS'=>'972','TZS'=>'834','THB'=>'764','XOF'=>'952','NZD'=>'554','TOP'=>'776','TTD'=>'780','TND'=>'788','TRY'=>'949','TMT'=>'934',
                    'AUD'=>'36','UGX'=>'800','UAH'=>'980','AED'=>'784','GBP'=>'826','USN'=>'997','UYI'=>'940','UYU'=>'858','UZS'=>'860','VUV'=>'548',
                    'VEF'=>'937','VED'=>'926','VND'=>'704','USD'=>'840','XPF'=>'953','MAD'=>'504','YER'=>'886','ZMW'=>'967','ZWL'=>'932');
    $result = array_search ((int)$isoCode, $array);
    return "$result";
}
?>
