<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");

$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$userID=$_SESSION['userID'];

global $username, $password, $database;
$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT android_id,device_id FROM Devices WHERE activation_code='CLOUD' ");
$stm-> execute();
$stm-> bind_result($androidID,$deviceID);
while ($stm->fetch()) {}
$stm->close();

$stm = $db->prepare("SELECT checkout_cart_api_call_url FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($postURL);
while ($stm->fetch()) {}
$stm->close();

$itemObjects = array();
$stm = $db->prepare("SELECT Online_Order_Item.item_id,qty FROM Online_Order_Item WHERE Online_Order_Item.order_id='$orderID' AND NOT master_item = 'no'");
$stm-> execute();
$stm-> bind_result($itemID,$qty);
while ($stm->fetch()) {
    array_push($itemObjects,"{\"id\": $itemID, \"qty\":$qty}");
}
$stm->close();

$postObject = new stdClass();
$postObject->androidID = $androidID;
$postObject->deviceID = $deviceID;
$postObject->customer = $customerID;
$postObject->date = date('Y-m-d');
$postObject->items = "[".implode(',',$itemObjects)."]";

$testFile = fopen('testAPICall.txt','w');
fwrite($testFile,"$postURL\nType:POST\n");
fwrite($testFile,json_encode($postObject)."\n");

$ch = curl_init();
curl_setopt_array($ch, array(
    CURLOPT_URL => $postURL,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $postObject,
));
$response = curl_exec($ch);
$response = json_decode($response);
curl_close($ch);

fwrite($testFile,json_encode($response)."\n");
fclose($testFile);

if(count($response->data) > 0){
    clearCart($orderID);
}

foreach($response->data as $item){

    if(strcmp($item->fromPostData,'true')==0){$item->fromPostData = 'yes';}
    else if(strcmp($item->fromPostData,'false')==0){$item->fromPostData = 'no';}

    $stmt = $db->prepare("INSERT INTO Online_Order_Item (order_id,item_id,qty,unit_price,line_discount,line_discount_percentage, vat_amount,vat_id,master_item, timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('iiddsssss', $orderID, $item->itemID, $item->Qty, $item->unitPrice, $item->lineDiscountAmount, $item->lineDiscountPercent, $item->vatAmount, $item->vatID, $item->fromPostData);
    $stmt->execute();
    $stmt->close();

}

?>