<?php
include ('./FirebasePushNotification.php');
include ('../../concc/dbinfo.php');
session_start();

$deviceID = trim($_POST['deviceID']);
$androidID = trim($_POST['androidID']);

if(strcmp($deviceID,'') !=0){
    $hasDeviceID=true;
} else {
    $hasDeviceID=false;
    echo " No Device ID Given.";
}

if(strcmp($androidID,'')!=0){
    $hasAndroidID=true;
} else {
    $hasAndroidID=false;
    echo " No Android ID Given.";
}

if($hasDeviceID && $hasAndroidID) {
    resetDevice($deviceID,$androidID);
}



function resetDevice($deviceID,$androidID){

    echo ' Reset Device..';
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    try {
        $db->begin_transaction();

        $stm1 = $db->prepare("SELECT display_prefix,activation_code,gcm_id FROM Devices WHERE device_id=? AND android_id=? LIMIT 1");
        $stm1->bind_param('is',$deviceID,$androidID);
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->bind_result($deviceDisplayPrefix,$deviceActivationCode,$deviceToken);
        while ($stm1->fetch()) {}
        $stm1->close();

        if(strcmp($deviceToken,'')!=0) {

            $push = new FirebasePushNotification($db);
            $push->senderID($_SESSION['adminID']);
            $push->selectDeviceByID('Devices','device_id',$deviceID);
            $push->notificationType('resetDevice');
            $push->send();

            echo ' Coprime app on Device Locked..';
        }

        $stm1 = $db->prepare("SELECT MAX(device_id)+1,MAX(cast(prefix as unsigned))+1 FROM Devices");
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->bind_result($nextDeviceID,$nextDevicePrefix);
        while ($stm1->fetch()) {}
        $stm1->close();

        $stm1 = $db->prepare("INSERT INTO Disabled_Devices(device_id, gcm_id, activation_code, android_id, prefix, display_prefix, activation_date, status, last_update_from, sales_person_id, expiry_date, app_version, android_version, begin_tender_number, begin_waybill_number, begin_order_number, begin_invoice_number, begin_receipt_number, begin_return_number, begin_warehouse_transaction_number, begin_customer_stock_taking_number, begin_service_call_number, begin_z_number, begin_opportunity_number, coprime_version)
                                    SELECT device_id, gcm_id, activation_code, android_id, prefix, display_prefix, activation_date, status, last_update_from, sales_person_id, expiry_date, app_version, android_version, begin_tender_number, begin_waybill_number, begin_order_number, begin_invoice_number, begin_receipt_number, begin_return_number, begin_warehouse_transaction_number, begin_customer_stock_taking_number, begin_service_call_number, begin_z_number, begin_opportunity_number, coprime_version
                                    FROM Devices
                                    WHERE device_id=? ");
        $stm1->bind_param('i',$deviceID);
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->close();

        $stm1 = $db->prepare("UPDATE Devices SET activation_code=CONCAT(activation_code,'-Disabled'), display_prefix=CONCAT(display_prefix,'-Disabled'),status='disabled' WHERE device_id=? ");
        $stm1->bind_param('i',$deviceID);
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->close();

        $stm1 = $db->prepare("INSERT INTO Devices(device_id, gcm_id, activation_code, android_id, prefix, display_prefix, activation_date, status, last_update_from, sales_person_id, expiry_date, app_version, android_version, begin_tender_number, begin_waybill_number, begin_order_number, begin_invoice_number, begin_receipt_number, begin_return_number, begin_warehouse_transaction_number, begin_customer_stock_taking_number, begin_service_call_number, begin_z_number, begin_opportunity_number, coprime_version)
                                    SELECT ?,'', ?, '', ?, ?, '0000-00-00', '', '0000-00-00', 0, expiry_date, '', '', begin_tender_number, begin_waybill_number, begin_order_number, begin_invoice_number, begin_receipt_number, begin_return_number, begin_warehouse_transaction_number, begin_customer_stock_taking_number, begin_service_call_number, begin_z_number, begin_opportunity_number, coprime_version
                                    FROM Devices WHERE device_id=? LIMIT 1");
        $stm1->bind_param('isisi',$nextDeviceID,$deviceActivationCode,$nextDevicePrefix,$deviceDisplayPrefix,$deviceID);
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->close();

        $stm1 = $db->prepare("DELETE FROM Devices WHERE device_id=? ");
        $stm1->bind_param('i',$deviceID);
        $stm1->execute();
        if(strcmp($stm1->error,"")!=0) {throw new Exception();}
        $stm1->close();

        $db->commit(true);

        echo ' Completed.';

    } catch (Exception  $e) {

        $db->rollback();
        echo ' error '.$e.' Line '.$e->getLine();
    }
    $db->close();
}


?>