<?php
class FirebasePushNotification
{
    private $url = 'https://fcm.googleapis.com/fcm/send';
    private $authorizationKey = '';
    private $deviceToken;
    private $deviceID;
    private $recipientID;
    private $senderID;
    private $senderName;
    private $recipientName;
    private $dataType;
    private $dataCompany;
    private $appType;
    private $title;
    private $body;
    private $data = array();
    private $isForB2BApp = false;

    public  $db;
    public  $result;


    public function __construct($db){$this->db = $db;}

    public function getDataType(){return $this->dataType;}
    public function getDataCompanyCode(){return $this->dataCompany;}
    public function getUrl(){return $this->url;}
    public function getAuthorizationKey(){return $this->authorizationKey;}
    public function getDeviceToken(){return $this->deviceToken;}
    public function getDeviceID(){return $this->deviceID;}
    public function getTitle(){return $this->title;}
    public function getBody(){return $this->body;}
    public function getData(){return $this->data;}

    public function changeUrl($url){$this->url = $url;}
    public function changeAuthorizationKey($authorizationKey){$this->authorizationKey = $authorizationKey;}

    public function title($title){$this->title = $title;}
    public function body($body){$this->body = $body;}
    public function extraData($data){$this->data = $data;}
    public function notificationType($type){$this->dataType = $type;}
    public function dataCompanyCode($code){$this->dataCompany = $code;}
    public function senderID($id){
        $senderName = 'Coprime Cloud';
        if($id > 0) {
            $db = $this->db;
            $name='';
            $stm1 = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id = '$id' LIMIT 1");
            $stm1->execute();
            $stm1->bind_result($name);
            while ($stm1->fetch()) {
                if(strcmp($name,'')!=0){$senderName = $name;}
            }
            $stm1->close();
        } else {
            $id = 0;
        }
        $this->senderID   = $id;
        $this->senderName = $senderName;
    }

    public function selectDeviceByID($table,$tableID,$deviceID){
        $db = $this->db;

        switch ($table){
            case 'Devices_Pop':
                $this->appType = 'pur';
                $this->authorizationKey = "AAAALm8N8Uo:APA91bHSIQWA2rzeY1aKrGXlA6t14Fx_loHu9tsFLd4qCzJNm2ibgwuegq8MCmDRG9v_MKvGf9RkpUR0AFDsH-riToFBUEOPswbDCpjkWkoevpaJurOCH0F8La8wHSfw3zENAc6NirrY";
                break;
            default:
                $this->appType = 'sal';
                $this->authorizationKey = "AAAApYbhGsk:APA91bHqChNK3KXK_3qeE7yGcU9a7zAAZnlWQWXRouVT8RX0Gk_tH4fGE6iDvwERvaqI04O8C3Y79NF4v6VE71i_6fb7fDkFDD9buxFOR4_T9cizCiqJNI-WovsECw6lvFwJuFbZmDf9";
                break;
        }

        $deviceToken   = '';
        $recipientName = '';
        $companyCode   = '';
        $recipientID   = 0;

        $this->deviceID = $deviceID;

        $stm1 = $db->prepare("SELECT company_code FROM Companies ORDER BY company_id ASC LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($companyCode);
        while ($stm1->fetch()) {$this->dataCompany=$companyCode;}
        $stm1->close();

        $stm1 = $db->prepare("SELECT gcm_id,sales_person_id FROM $table WHERE $tableID = $deviceID LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($deviceToken,$recipientID);
        while ($stm1->fetch()) {
            $this->deviceToken=$deviceToken;
            $this->recipientID=$recipientID;
        }
        $stm1->close();

        if($recipientID > 0){
            $stm1 = $db->prepare("SELECT CONCAT(salesperson_code,' - ',first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id = '$recipientID' LIMIT 1");
            $stm1->execute();
            $stm1->bind_result($recipientName);
            while ($stm1->fetch()) {
                $this->recipientName=$recipientName;
            }
            $stm1->close();
        }

    }

    public function selectDeviceForB2BApp($orderID,$deviceToken,$appType='B2B'){

        $recipientName = trim($appType.' App User');
        $authorizeKey  = '';
        $companyCode   = '';
        $recipientID   = 0;
        $deviceID      = 0;

        $db = $this->db;

        $stm1 = $db->prepare("SELECT b2b_app_firebase_authorization_key FROM B2B_Configuration LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($authorizeKey);
        while ($stm1->fetch()) {}
        $stm1->close();

        $stm1 = $db->prepare("SELECT company_code FROM Companies ORDER BY company_id ASC LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($companyCode);
        while ($stm1->fetch()) {$this->dataCompany=$companyCode;}
        $stm1->close();

        $this->deviceToken = "$deviceToken";
        $this->authorizationKey = "$authorizeKey";
        $this->recipientName="$recipientName";
        $this->appType = "$appType";
        $this->recipientID = intval($recipientID);
        $this->deviceID = intval($deviceID);
        $this->data['orderID']  = $orderID;
        $this->isForB2BApp = true;


    }

    public function logMessage()
    {

        $db = $this->db;
        $deviceID = (int)$this->deviceID;
        $senderID = (int)$this->senderID;
        $recipientID = (int)$this->recipientID;
        $recipientName = "$this->recipientName";
        $companyCode = "$this->dataCompany";
        $title = "$this->title";
        $body = "$this->body";
        $silent = 'no';
        $senderName = "$this->senderName";

        if (strcmp($this->title, '') == 0 || strcmp($this->body, '') == 0) {
            $silent = 'yes';
        }

        $stm1 = $db->prepare("INSERT INTO Firebase_Notifications (device_id, sender_id, sender_name, recipient_id, recipient_name, company_code, notification_type, title, body, silent, coprime_app, date_sent, timestamp)
                                      VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())");
        $stm1->bind_param('sssssssssss', $deviceID, $senderID, $senderName, $recipientID, $recipientName, $companyCode, $this->dataType, $title, $body, $silent, $this->appType);
        $stm1->execute();
        $logID = $stm1->insert_id;
        $stm1->close();

        return $logID;

    }

    public function insertFirebaseMessageID($coprimeLogID,$firebaseLogID){
        $firebaseLogID = "".$firebaseLogID;
        $db = $this->db;
        $stm1 = $db->prepare("UPDATE Firebase_Notifications SET firebase_message_id=? WHERE id=?");
        $stm1->bind_param('si', $firebaseLogID,$coprimeLogID);
        $stm1->execute();
        $stm1->close();
    }

    public function updateFirebaseNotificationLog($coprimeLogID,$data){

        if(!empty($data) && $coprimeLogID > 0) {

            $fieldsArray = array();

            foreach ($data as $field => $value) {
                array_push($fieldsArray, "$field='$value'");
            }

            $fieldsImp = implode(', ', $fieldsArray);

            $db = $this->db;
            $stm1 = $db->prepare("UPDATE Firebase_Notifications SET $fieldsImp WHERE id=?");
            $stm1->bind_param('i', $coprimeLogID);
            $stm1->execute();
            $stm1->close();
        }
    }

    public function legacy_send()
    {
        $result = '';
        if (strcmp("$this->deviceToken", '') != 0 && strcmp("$this->authorizationKey", '') != 0) {

            $coprimeLogID = $this->logMessage();
            $this->data['log_id']  = $coprimeLogID;
            $this->data['type']    = $this->dataType;
            $this->data['company'] = $this->dataCompany;

            if (strcmp($this->title, '') != 0) {
                $this->data['title'] = $this->title;
            }

            if (strcmp($this->title, '') != 0) {
                $this->data['body'] = $this->body;
            }

            if($this->isForB2BApp){
                $data = [
                    "priority" => "high",
                    "data" => $this->data,
                    "notification" => $this->data,
                    "to" => "$this->deviceToken"
                ];
            } else {
                $data = [
                    "priority" => "high",
                    "data" => $this->data,
                    "to" => "$this->deviceToken"
                ];
            }


            $headers = array();
            $headers[] = 'Content-Type: application/json';
            $headers[] = 'Authorization: key=' . $this->authorizationKey;

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $this->url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $result = curl_exec($ch);
            curl_close($ch);

            $this->result = $result;
            $resultObject = json_decode($result);

            $this->insertFirebaseMessageID($coprimeLogID,$resultObject->results[0]->message_id);

        }
        return $result;
    }

    public function send()
    {
        $result = '';
        if (strcmp("$this->deviceToken", '') != 0 && strcmp("$this->appType", '') != 0) {

            $baseDirectory = __DIR__;

            include_once($baseDirectory.'/httpV1Client/vendor/autoload.php');

            $coprimeLogID = $this->logMessage();
            $this->data['log_id']  = $coprimeLogID;
            $this->data['type']    = $this->dataType;
            $this->data['company'] = $this->dataCompany;

            if (strcmp($this->title, '') != 0) {
                $this->data['title'] = $this->title;
            }

            if (strcmp($this->title, '') != 0) {
                $this->data['body'] = $this->body;
            }

            foreach($this->data as $key => $value){
                $this->data["$key"] = "$value";
            }

            switch ($this->appType){
                case 'pur':
                    $jsonFile = $baseDirectory.'/coprime_firebase_account_purchasing.json';
                    break;
                case 'sal':
                    $jsonFile = $baseDirectory.'/coprime_firebase_account_sales.json';
                    break;
                case 'B2B':
                    $jsonFile = $baseDirectory.'/coprime_firebase_account_b2b.json';
                    break;
                default:
                    $jsonFile = '';
            }

            if(strcmp($jsonFile,'')!=0 && file_exists($jsonFile)){

                $client = new phpFCMv1\Client("$jsonFile");
                $recipient = new phpFCMv1\Recipient();
                $notification = new phpFCMv1\Notification();
                $config = new phpFCMv1\Config();

                if (strcmp($this->title, '') != 0 && strcmp($this->body, '') != 0) {
                    $payload = array('data' => $this->data, 'notification' => array('title' => "$this->title", 'body' => "$this->body"));
                } else {
                    $payload = array('data' => $this->data);
                }

                $recipient->setSingleRecipient("$this->deviceToken");
                $notification->setPayload($payload);
                $config->setPriority(phpFCMv1\Config::PRIORITY_HIGH);
                $client->build($recipient, $notification, null, $config);
                $result = $client->fire();

                if($result == 1){
                    $result = "$this->dataType Message sent";
                }

                $this->insertFirebaseMessageID($coprimeLogID,$result);

            } else {

                $result = "$this->appType Json file not found";
                $this->insertFirebaseMessageID($coprimeLogID,$result);

            }


        }
        return $result;
    }
}


?>