<?php
// List of events

session_start();
include_once("../../../../param.php");
require(ROOT."concc/dbhelpers/dbhelper.php");

$where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND (SC_Types.type_name LIKE 'Project%' OR SC_Types.type_name LIKE 'Task%') AND NOT status_id=3";



if(isset($_GET['typeSelect']))
{
    $types=$_GET['typeSelect'];

    if(strcmp($types,"")!=0)
    {
        $where=$where." AND SC_Types.type_id IN($types)";
    }
}


if(isset($_GET['userSelect']))
{
    $users=$_GET['userSelect'];

    if(strcmp($users,"")!=0)
    {
        $where=$where." AND Service_Call.assign_to IN($users)";
    }
}


if(isset($_GET['prioritySelect']))
{
    $priorities=$_GET['prioritySelect'];

    if(strcmp($priorities,"")!=0)
    {
        $where=$where." AND Service_Call.priority_id IN($priorities)";
    }
}


if(isset($_GET['statusSelect']))
{
    $statuses=$_GET['statusSelect'];

    if(strcmp($statuses,"")!=0)
    {
        $where=$where." AND Service_Call.status_id IN($statuses)";
    }
}

$objects = array();

// Query that retrieves events
$request = "SELECT service_call_id,service_call_code,topic,schedule_start_date,schedule_end_date,customer_company_name,type_name,priority_id,progress,parent_id FROM Service_Call,Customers,SC_Types $where ORDER BY service_call_id";


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare($request);
$stmt->execute();
$stmt->bind_result($serviceCallID,$serviceCallCode,$serviceCallTitle,$serviceCallDate,$serviceCallDateDue,$customerName,$type,$priorityID,$progress,$parentID);
while ($stmt->fetch()) {
    $serviceCallTitle=str_replace("'","",$serviceCallTitle);
    $serviceCallTitle=str_replace("\"","",$serviceCallTitle);
    $customerName=str_replace("'","",$customerName);
    $customerName=str_replace("\"","",$customerName);
    $object = "";



    $duration=10;
    if(strcmp($serviceCallDateDue,'0000-00-00')!=0)
    {
        $duration=dateDifference($serviceCallDate,$serviceCallDateDue);
    }

    $object->id = $serviceCallID;
    $object->text = $serviceCallTitle;
    $object->start_date = $serviceCallDate;
    $object->duration = $duration;
    $object->progress = $progress;

    $object->open = true;
    if($parentID>0)
    {
        $object->parent = $parentID;
    }

    if($parentID==0)
    {
        $object->priority = 1;
        $object->project = 1;

    }
    else{
        $object->priority = 0;
        $object->color = '#4682b4';
    }


    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDateDue);
    $secondDate = $myDateTime->format('Y-m-d');

//    if (strcmp($firstDate,$secondDate)!=0) {
//
//        $object->allDay=true;
//
//    }



//    if($priorityID == 1)
//    {
//        $object->color = "#b22222";
//    }
//    else  if($priorityID == 2)
//    {
//        $object->color = "#CC8E53";
//    }
//    else  if($priorityID == 3)
//    {
//        $object->color = "#4682B4";
//    }
//    else  if($priorityID == 4)
//    {
//        $object->color = "#008080";
//    }



    array_push($objects,$object);

}

$stmt->close();


$model->data=$objects;
$model->liks=array();
// sending the encoded result to success page
echo json_encode($model);


function dateDifference($earlier,$later)
{
    $earlier = new DateTime($earlier);
    $later = new DateTime($later);

    $diff = $later->diff($earlier)->format("%a");
    return $diff;
}
?>
