<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class SubCustomerGroupsPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Sub Customer Groups');
            $this->SetMenuLabel('Sub Customer Groups');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`SubCustomerGroups`');
            $this->dataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new IntegerField('subgroup_id', true, true),
                    new DateTimeField('date_added', true),
                    new IntegerField('position', true),
                    new IntegerField('user_id', true),
                    new StringField('type', true),
                    new StringField('notes', true),
                    new DateTimeField('timestamp', true)
                )
            );
            $this->dataset->AddLookupField('group_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'group_id_CONCAT(group_code, \' - \',name)', 'group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'group_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
            $this->dataset->AddLookupField('subgroup_id', '(SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups)', new IntegerField('group_id'), new StringField('CONCAT(group_code, \' - \',name)', false, false, false, false, 'subgroup_id_CONCAT(group_code, \' - \',name)', 'subgroup_id_CONCAT(group_code, \' - \',name)_customerGroupSearch'), 'subgroup_id_CONCAT(group_code, \' - \',name)_customerGroupSearch');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group'),
                new FilterColumn($this->dataset, 'subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group'),
                new FilterColumn($this->dataset, 'date_added', 'date_added', 'Date Added'),
                new FilterColumn($this->dataset, 'position', 'position', 'Position'),
                new FilterColumn($this->dataset, 'user_id', 'user_id', 'User Id'),
                new FilterColumn($this->dataset, 'type', 'type', 'Type'),
                new FilterColumn($this->dataset, 'notes', 'notes', 'Notes'),
                new FilterColumn($this->dataset, 'timestamp', 'timestamp', 'Timestamp')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['group_id'])
                ->addColumn($columns['subgroup_id']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('group_id')
                ->setOptionsFor('subgroup_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('group_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_SubCustomerGroups_group_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('group_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_SubCustomerGroups_group_id_search');
            
            $filterBuilder->addColumn(
                $columns['group_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new DynamicCombobox('subgroup_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_SubCustomerGroups_subgroup_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('subgroup_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_SubCustomerGroups_subgroup_id_search');
            
            $filterBuilder->addColumn(
                $columns['subgroup_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for group_id field
            //
            $editor = new DynamicCombobox('group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Group', 'group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'edit_SubCustomerGroups_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for subgroup_id field
            //
            $editor = new DynamicCombobox('subgroup_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Sub Group', 'subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'edit_SubCustomerGroups_subgroup_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for group_id field
            //
            $editor = new DynamicCombobox('group_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Group', 'group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'insert_SubCustomerGroups_group_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for subgroup_id field
            //
            $editor = new DynamicCombobox('subgroup_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Sub Group', 'subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'insert_SubCustomerGroups_subgroup_id_search', $editor, $this->dataset, $lookupDataset, 'group_id', 'CONCAT(group_code, \' - \',name)', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('group_id', 'group_id_CONCAT(group_code, \' - \',name)', 'Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for CONCAT(group_code, ' - ',name) field
            //
            $column = new TextViewColumn('subgroup_id', 'subgroup_id_CONCAT(group_code, \' - \',name)', 'Sub Group', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(false);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_SubCustomerGroups_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_SubCustomerGroups_subgroup_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_SubCustomerGroups_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_SubCustomerGroups_subgroup_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_SubCustomerGroups_group_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $selectQuery = 'SELECT group_id, CONCAT(group_code, \' - \',name) FROM CustomerGroups';
            $insertQuery = array();
            $updateQuery = array();
            $deleteQuery = array();
            $lookupDataset = new QueryDataset(
              MySqlIConnectionFactory::getInstance(), 
              GetConnectionOptions(),
              $selectQuery, $insertQuery, $updateQuery, $deleteQuery, 'customerGroupSearch');
            $lookupDataset->addFields(
                array(
                    new IntegerField('group_id', true, true),
                    new StringField('CONCAT(group_code, \' - \',name)')
                )
            );
            $lookupDataset->setOrderByField('CONCAT(group_code, \' - \',name)', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_SubCustomerGroups_subgroup_id_search', 'group_id', 'CONCAT(group_code, \' - \',name)', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new SubCustomerGroupsPage("SubCustomerGroups", "SubCustomerGroups.php", GetCurrentUserPermissionsForPage("SubCustomerGroups"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("SubCustomerGroups"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
