<?php
function importReceipts($client,$today)
{

    echo "<br><b>---RECEIPTS---</b><br>";

    $skip = '';
    $filterNext = '';
    $hasMore = true;
    $isFirst = true;

    if(strcmp($today,'')!=0){
        $filterSelect= '$filter=DocDate ge '."'$today'";
    } else {
        $filterSelect= '';
    }

    $filterSelect = str_replace(' ','%20',$filterSelect);

    while($hasMore){

        if($isFirst){$isFirst=false;}else{$filterSelect='';}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1];}

        $result = $client->requestData('IncomingPayments'.$filterNext,$filterSelect,true);

        $skip     = $result[1];
        $receipts = $result[0];

        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}

        foreach($receipts AS $receipt){
            $receipt = (object)$receipt;

            $sapCustomerCode = "$receipt->CardCode";
            $sapCustomerName = "$receipt->CardName";
            $sapCustomerAddress = str_replace("\r",", ","$invoice->Address");

            if(strcmp("$sapCustomerCode","")==0){
                $sapCustomerCode = "GenericCustomer";
                $sapCustomerName = "Generic Customer";
                $sapCustomerAddress = " ";
            }

            echo "<br>---------------- SAP Receipt $receipt->DocNum ($receipt->DocEntry) -------------------";


            $customerID = intval(getCustomerID($sapCustomerCode));

            if($customerID == 0){
                $customer_code="$sapCustomerCode";
                $customer_company_name="$sapCustomerName";
                $customer_report_name="";
                $logo="";
                $registration_code="";
                $mobile="";
                $website="";
                $email="";
                $description="";
                $type_of_business="Credit";
                $tic_code="";
                $vat_code="";
                $credit_limit=0;
                $address_code_eurosoft="";
                $customer_type="Credit";
                $balance=0;
//                echo "<br>INSERT CUSTOMER $customer_code - $customer_company_name<br>";
//                $customerID = intval(insertCustomer($customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance));
            }

            $coprimeCodeNumber = intval($receipt->DocEntry);

            $document = new stdClass();
            $document->CoprimeType = 'Receipt';
            $document->CoprimePrefix = '';
            $document->receiptCode = $document->CoprimePrefix.$coprimeCodeNumber;
            $document->receiptDate = explode('T',$receipt->DocDate)[0];
            $document->receiptDueDate = explode('T',$receipt->DueDate)[0];

            $document->customerID = $customerID;
            $document->customerCode = $sapCustomerCode;
            $document->customerName = $sapCustomerName;
            $document->customerAddress = $sapCustomerAddress;
            $document->salespersonID = intval(getSalespersonID("$document->SalesPersonCode"));
            $document->details = trim(rtrim(trim("$receipt->DocNum - $receipt->Remarks"),'-'));
            $document->cancelled = rtrim(strtolower($receipt->Cancelled),'t');

            $document->cashAmount = floatval($receipt->CashSum);
            $document->cashDate = explode('T',$receipt->DueDate)[0];
            $document->cashReference = "$receipt->Remarks";

            $document->bankTransferAmount = floatval($receipt->TransferSum);
            $document->bankTransferDate = explode('T',$receipt->TransferDate)[0];
            $document->bankTransferReference = "$receipt->TransferReference";

            $document->checksAmount = 0;
            $document->payments = array();
            $document->status = '';

            if(strcmp($document->cancelled,"yes")==0){
                $document->status = 'Canceled';
            }

            foreach($receipt->PaymentChecks as $paymentCheck){
                $paymentCheck = (object)$paymentCheck;

                $paymentObject = new stdClass();
                $paymentObject->amount = floatval($paymentCheck->CheckSum);
                $paymentObject->paymentMethod = "Cheque";
                $paymentObject->cashDiscount = 0;
                $paymentObject->bank = getBankNameByCode("$paymentCheck->BankCode");
                $paymentObject->branch = "$paymentCheck->Branch";
                $paymentObject->chequeNumber = "$paymentCheck->CheckNumber";
                $paymentObject->chequeDate = "$paymentCheck->DueDate";
                $paymentObject->notes = "$paymentCheck->Remarks";
                array_push($document->payments,$paymentObject);

                $document->checksAmount += $paymentObject->amount;

            }

            if($document->bankTransferAmount > 0){
                $paymentObject = new stdClass();
                $paymentObject->amount = $document->bankTransferAmount;
                $paymentObject->paymentMethod = "Bank Transfer";
                $paymentObject->cashDiscount = 0;
                $paymentObject->bank =  getBankNameByCode("$document->BankCode");
                $paymentObject->branch = "$document->Branch";
                $paymentObject->chequeNumber = "";
                $paymentObject->chequeDate = "$document->bankTransferDate";
                $paymentObject->notes = "$document->Remarks";
                array_push($document->payments,$paymentObject);
            }

            if($document->cashAmount > 0){
                $paymentObject = new stdClass();
                $paymentObject->amount = $document->cashAmount;
                $paymentObject->paymentMethod = "Cash";
                $paymentObject->cashDiscount = 0;
                $paymentObject->bank = getBankNameByCode("$document->BankCode");;
                $paymentObject->branch = "$document->Branch";
                $paymentObject->chequeNumber = "";
                $paymentObject->chequeDate = "$document->cashDate";
                $paymentObject->notes = "$document->Remarks";
                array_push($document->payments,$paymentObject);
            }

            $objectActionHash = sha1(json_encode($document));

            $receiptCode = "$document->receiptCode";
            $customerID = intval($customerID);
            $companyID = 0;
            $salespersonID = 0;
            $orderID = 0;
            $invoiceID = 0;
            $addressID = 0;
            $amount = floatval($document->cashAmount + $document->checksAmount + $document->bankTransferAmount);
            $paymentMethod = "";
            $cashDiscount = 0;
            $bank = "";
            $branch = "";
            $chequeNumber = "";
            $chequeDate = $document->receiptDueDate;
            $receiptDate = $document->receiptDate;
            $printCount = 0;
            $notes = "$document->details";
            $receiptItems = $document->payments;
            $actionHash = "$objectActionHash";
            $status = "$document->status";

            if(count($document->payments) == 1){
                $payment = $document->payments[0];
                $paymentMethod = "$payment->paymentMethod";
                $bank = "$payment->bank";
                $branch = "$payment->branch";
                $chequeNumber = "$payment->chequeNumber";
                $chequeDate = $payment->chequeDate;

                $document->payments = array();
                $receiptItems = array();
            } else if(count($document->payments) > 1){
                $paymentMethod = 'Multiple';
            } else {
                echo " NO PAYMENTS";
                continue;
            }

            echo "<br>$paymentMethod : $amount ($bank $branch, $chequeNumber) $chequeDate";
            if(count($receiptItems) > 1){
                foreach($receiptItems as $receiptItem){
                    echo "<br> -- $receiptItem->paymentMethod : $receiptItem->amount ($receiptItem->bank $receiptItem->branch, $receiptItem->chequeNumber) $receiptItem->chequeDate ";
                }
            }

            if(!receiptExists($receiptCode)){
                if(strcmp("$receipt->Reference2","")!=0 && receiptExists("$receipt->Reference2")){
                    $receiptCode = "$receipt->Reference2";
                    echo "<br>------------ Coprime Receipt $receiptCode ----------------<br>";
                    continue;
                } else if(strcmp("$receipt->Reference1","")!=0 && receiptExists("$receipt->Reference1")){
                    $receiptCode = "$receipt->Reference1";
                    echo "<br>------------ Coprime Receipt $receiptCode ----------------<br>";
                    continue;
                } else if(strcmp("$receipt->CounterReference","")!=0 && receiptExists("$receipt->CounterReference")){
                    $receiptCode = "$receipt->CounterReference";
                    echo "<br>------------ Coprime Receipt $receiptCode ----------------<br>";
                    continue;
                }
            }

            if(receiptExists($receiptCode)){

                $receiptID = updateReceiptSingleTransaction($receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$printCount,$notes,$status,$actionHash,$receiptItems);
                if($receiptID == -1){
                    echo "<br> ------------- $receiptCode No Change -------------<br>";
                } else {
                    echo "<br> ------------- Updated Receipt $receiptCode: $receiptID -------------<br>";
                }

            } else {
                $receiptID = insertReceiptSingleTransaction($receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$printCount,$notes,$status,$actionHash,$receiptItems);
                echo "<br> ------------- Inserted Receipt $receiptCode: $receiptID -------------<br>";

            }


        }


    }
    echo "<br><b>---RECEIPTS/---</b><br>";

   
}

?>