<?php
function importInvoices($client,$today)
{

    echo "<br><b>---INVOICES---</b><br>";

    $skip = '';
    $filterNext = '';
    $hasMore = true;
    $isFirst = true;

    if(strcmp($today,'')!=0){
        $filterSelect= '$filter=UpdateDate ge '."'$today'";
    } else {
        $filterSelect= '';
    }

    $filterSelect = str_replace(' ','%20',$filterSelect);

    while($hasMore){

        if($isFirst){$isFirst=false;}else{$filterSelect='';}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1];}

        $result = $client->requestData('Invoices'.$filterNext,$filterSelect,true);

        $skip     = $result[1];
        $invoices = $result[0];

        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}

        foreach($invoices AS $invoice){
            $invoice = (object)$invoice;

            $invoiceIdNumber = "$invoice->DocEntry";
            $sapCustomerCode = "$invoice->CardCode";
            $sapCustomerName = "$invoice->CardName";
            $sapCustomerAddress = str_replace("\r",", ","$invoice->Address");

            if(strcmp("$sapCustomerCode","")==0){
                $sapCustomerCode = "GenericCustomer";
                $sapCustomerName = "Generic Customer";
                $sapCustomerAddress = " ";
            }

            $invoicesArray = array();
            $invoiceItems = array();

            $subtotals = 0;
            $discountTotals = 0;
            $vatTotals = 0;

            echo "<br>---------------- SAP Invoice $invoice->DocNum ($invoice->DocEntry) -------------------";

            foreach($invoice->DocumentLines AS $invoiceLine){
                $invoiceLine = (object)$invoiceLine;

                $warehouseID = getWarehouseID("$invoiceLine->WarehouseCode");
                $itemID = getItemID($invoiceLine->ItemCode);
                $qty = floatval($invoiceLine->Quantity);

                if(intval($itemID) == 0){
                    $itemID = importInvoiceItemFromSAP($client,$invoiceLine->ItemCode);
                }

                $vatID = getVatItemID($itemID);
                $vatPercent = getVatPercent($vatID);

                $lineDiscount = floatval($invoiceLine->UnitPrice) - floatval($invoiceLine->Price);
                $lineDiscount *= $qty;

                $lineTotal = floatval($invoiceLine->UnitPrice)*floatval($invoiceLine->Quantity);
                $vatTotal = ($lineTotal-$lineDiscount)*$vatPercent/100;

                $subtotals += $lineTotal;
                $discountTotals += $lineDiscount;
                $vatTotals += $vatTotal;

                $invoiceItem = new stdClass();
                $invoiceItem->itemID = $itemID;
                $invoiceItem->qty = $qty;
                $invoiceItem->unitPrice = $invoiceLine->UnitPrice;
                $invoiceItem->lineDiscount = $lineDiscount;
                $invoiceItem->globalDiscount = 0;
                $invoiceItem->vatTotal = $vatTotal;
                $invoiceItem->priceTypeID = 10000;
                $invoiceItem->vatID = $vatID;
                $invoiceItem->warehouseID = $warehouseID;
                $invoiceItem->batchNumber=0;
                $invoiceItem->serialNumber='';
                $invoiceItem->lineDiscountPercent = $invoiceLine->DiscountPercent;
                $invoiceItem->itemNotes = $invoiceLine->ItemDescription.' |CostingCode| '.$invoiceLine->CostingCode.' |AccountCode| '.$invoiceLine->AccountCode.' |DocEntry| '.$invoice->DocEntry.' |LineNum| '.$invoiceLine->LineNum;

                echo "<br> LineNum $invoiceLine->LineNum - Item($itemID): $invoiceLine->ItemCode - $invoiceLine->ItemDescription | UnitPrice: $invoiceLine->UnitPrice | FinalPrice: $invoiceLine->Price | DiscountPercent: $invoiceLine->DiscountPercent | Quantity: $qty  ";

                array_push($invoiceItems,$invoiceItem);


            }


            if(count($invoicesArray) > 1){
                $sapCustomerCode = "MultiCustomer";
                $sapCustomerName = "Multiple Customers";
                $sapCustomerAddress = "";
            }


            $customerID = intval(getCustomerID($sapCustomerCode));

            if($customerID == 0){

                $customer_code="$sapCustomerCode";
                $customer_company_name="$sapCustomerName";
                $customer_report_name="";
                $logo="";
                $registration_code="";
                $mobile="";
                $website="";
                $email="";
                $description="";
                $type_of_business="Credit";
                $tic_code="";
                $vat_code="";
                $credit_limit=0;
                $address_code_eurosoft="";
                $customer_type="Credit";
                $balance=0;
                echo "<br>INSERT CUSTOMER $customer_code - $customer_company_name<br>";
                $customerID = intval(insertCustomer($customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance));
            }

            $coprimeCodeNumber = 10000 + intval($invoice->DocEntry);

            $invoiceBillingAddress = $invoice->AddressExtension['BillToStreet'];
            $invoiceDeliveryAddress = $invoice->AddressExtension['ShipToStreet'];

//            if(strcmp("$invoiceBillingAddress","")==0 && strcmp("$invoiceDeliveryAddress","")!=0){$invoiceBillingAddress = $invoiceDeliveryAddress;}
//            if(strcmp("$invoiceDeliveryAddress","")==0 && strcmp("$invoiceBillingAddress","")!=0){$invoiceDeliveryAddress = $invoiceBillingAddress;}

            $document = new stdClass();
            $document->CoprimeType = 'Invoice';
            $document->CoprimePrefix = '';
            $document->invoiceCode = $document->CoprimePrefix.$coprimeCodeNumber;
            $document->invoiceDate = explode('T',$invoice->DocDate)[0];
            $document->invoiceDueDate = explode('T',$invoice->DocDueDate)[0];
            $document->customerID = $customerID;
            $document->customerCode = $sapCustomerCode;
            $document->customerName = $sapCustomerName;
            $document->customerAddress = $sapCustomerAddress;
            $document->billingAddressID = getAddressIdFromStreet($customerID, "$invoiceBillingAddress");
            $document->deliveryAddressID = getAddressIdFromStreet($customerID, "$invoiceDeliveryAddress");
            $document->salespersonID = intval(getSalespersonID("$document->SalesPersonCode"));
            $document->details = trim(rtrim(trim("$invoice->DocNum - $invoice->Comments"),'-'));
            $document->lines = $invoiceItems;
            $document->status = 'Not Paid';
            $document->invoiceType = 'Credit';
            $document->vatIE = 'i';


            if(strcmp("$invoice->DocumentStatus","bost_Open")!=0){
                $document->status = str_replace('bost_','',$invoice->DocumentStatus);
            }


            $objectActionHash = sha1(json_encode($document));

            $paymentMethod = 0;
            $invoiceCode = $document->invoiceCode;
            $companyID = 0;
            $salespersonID = $document->salespersonID;
            $subtotal = floatval($subtotals);
            $vatTotal = floatval($vatTotals);
            $discount = floatval($discountTotals);
            $grandTotal = $subtotal+$vatTotal-$discount;
            $globalDiscountPercentage = 0;
            $billingAddress = intval($document->billingAddressID);
            $deliveryAddress = intval($document->deliveryAddressID);
            $invoiceDate = "$document->invoiceDate";
            $dueDate = "$document->invoiceDueDate";
            $details = $document->details;
            $status = $document->status;
            $tenderID = intval($invoiceIdNumber);
            $orderID = 0;
            $currencyID = 0;
            $actionHash = "$objectActionHash";
            $invoiceType = "$document->invoiceType";
            $vatIE = "$document->vatIE";


            if(!invoiceExists($invoiceCode)){
                if(strcmp("$invoice->Reference2","")!=0 && invoiceExists("$invoice->Reference2")){
                    $invoiceCode = "$invoice->Reference2";
                    echo "<br>--------- Coprime Invoice $invoiceCode -------------<br>";
                    continue;
                } else if(strcmp("$invoice->NumAtCard","")!=0 && invoiceExists("$invoice->NumAtCard")){
                    $invoiceCode = "$invoice->NumAtCard";
                    echo "<br>--------- Coprime Invoice $invoiceCode -------------<br>";
                    continue;
                }
            }

            if(invoiceExists($invoiceCode)){

                if(invoiceHasWaybill($invoiceCode)){
                    echo "<br> ------------- $invoiceCode LOCKED (Has Waybill) -------------<br>";
                } else {
                    $invoiceID = updateInvoiceSingleTransaction($invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$globalDiscountPercentage,$status,$tenderID,$orderID,$vatIE,$invoiceType,$currencyID,$actionHash,$invoiceItems);
                    if($invoiceID == -1){
                        echo "<br> ------------- $invoiceCode No Change -------------<br>";
                    } else {
                        echo "<br> ------------- Updated Invoice $invoiceCode: $invoiceID -------------<br>";
                    }
                }

            } else {
                if(count($invoiceItems) > 0){
                    $invoiceID = insertInvoiceSingleTransaction($invoiceCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$invoiceDate,$dueDate,$details,$globalDiscountPercentage,$status,$tenderID,$orderID,$vatIE,$invoiceType,$currencyID,$actionHash,$invoiceItems);
                    echo "<br> ------------- Inserted Invoice $invoiceCode: $invoiceID -------------<br>";
                } else {
                    echo "<br> ------------- $invoiceCode No Items -------------<br>";
                }
            }


        }


    }
    echo "<br><b>---INVOICES/---</b><br>";

   
}

function importInvoiceItemFromSAP($client,$sapCode){

    $itemFilter = '$filter=ItemCode eq '."'$sapCode'";
    $itemFilter = str_replace(' ','%20',$itemFilter);
    $item = $client->requestData('Items',$itemFilter);
    $item = (object)$item[0][0];

    echo "<br><b>ADD Item---</b>";
    echo $item->ItemCode;
    echo " [ItemCode] ";
    echo $item->ItemName;
    echo " [ItemName] ";
    echo $item->UpdateDate;
    echo " [UpdateDate] ";

    $vatCode      = $item->SalesVATGroup;
    $categoryCode = $item->ItemsGroupCode;
    $isSalesItem  = $item->SalesItem;
    $itemType     = $item->ItemType;

    $itemCode       = $item->ItemCode;
    $itemSKU        = "".str_replace('-','',$itemCode);
    $companyID      = 0;
    $vatID          = getVatID($vatCode);
    $subunits       = 1;
    $salesUnits     = $item->SalesUnit;
    $manufacturerID = 0;
    $itemName       = $item->ItemName;
    $shortDesc      = $item->ForeignName;
    $longDesc       = "";
    $thumbnailURL   = "";
    $reorderLevel   = 0;
    $targetQty      = 0;
    $bundled        = " ";
    $maxStock       = 0;
    $minStock       = 0;
    $packing        = $item->SalesPackagingUnit;
    $stockControl   = "yes";
    $sellable       = trim(strtolower($item->SalesItem),'t');
    $weight         = $item->SalesUnitWeight;
    $cbm            = 0;
    $status         = 0;
    $inactive       = trim(strtolower($item->Frozen),'t');
    $defaultBarcode = $item->BarCode;

    if(strcmp($inactive,'yes')==0){$status = 'inactive';}


    if(strcmp($salesUnits,'')==0){$salesUnits = 'EACH';}
    if(strcmp($vatID,'')==0){$vatID = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($packing,'')==0){$packing = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($itemSKU,'')==0){$itemSKU = " ";}
    if(is_null($shortDesc)){$shortDesc = "";}
    if(strcmp($item->ManageSerialNumbers,"tYes")==0)
    {
        $manufacturerID=-400;
    }

    if(itemExits($itemCode)){
        $itemID = updateItem($itemCode,$vatID,$subunits,$salesUnits,$itemName,$shortDesc,$longDesc,$weight,$status,$packing);
        echo " -> updateItem $itemCode  : ID $itemID STATUS: $status, WEIGHT: $weight, Packing: $packing";

    } else {
        $itemID = insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
        echo " -> insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status)";
    }



    if(strcmp($item->U_Category1,'')!=0)
    {
        $categoryLevel = $item->U_Category1;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category2,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category3,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if($itemID > 0){
        if(categoryExists($categoryCode)){
            $categoryID = getCategoryID($categoryCode);
            if($categoryID >0){
                if(itemExistsInCategory($itemID, $categoryID)){
                    // echo "<b>Item Category---</b> Item $itemCode exists in Category $categoryCode<br>";
                } else {
                    insertItemToCategory($itemID,$categoryID);
                    // echo "<b>Item Category---</b> insertItemToCategory $categoryCode<br>";
                }
            }
        }
    }

    foreach($item->ItemPrices as $itemPrice){
        $itemPrice = (object)$itemPrice;

        $priceTypeCode = $itemPrice->PriceList;
        $price         = $itemPrice->Price;

        if(strcmp($priceTypeCode,'')!=0){
            if(strcmp($price,'')==0){$price=0;}
            $priceTypeID = getPriceTypeID($priceTypeCode);
            if($priceTypeID > 0){

                $prevPrice = getPrice($priceTypeID,$itemID);
                if($price !== $prevPrice){
                    insertPrices($itemID,$priceTypeID,$price);
                }
                updateSpecialPrices($itemID,$priceTypeID,$price);

            }
        }
    }
    foreach($item->ItemWarehouseInfoCollection as $itemStock){
        $itemStock = (object)$itemStock;

        $warehouseCode = $itemStock->WarehouseCode;
        $available = $itemStock->InStock;
        $reserved = $itemStock->Committed;
        $onOrder = $itemStock->Ordered;
        $locked=$itemStock->Locked;

        if(strcmp(trim($itemStock->U_BinLoc),'')!=0){
            updateItemLongDescription($itemID,"$itemStock->U_BinLoc");
        }

        $delivered = 0;

        if(strcmp($warehouseCode,'')!=0){
            $warehouseID = getWarehouseID($warehouseCode);
            $batchnumber = "0";

            if(strcmp($locked,"tYES")==0){
                $batchnumber = "0";
                $available=-10000;
            }

            if($warehouseID > 0){
                //  insertStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered);
            }
        }
    }

    $uomGroupID = $item->UoMGroupEntry;
    foreach($item->ItemUnitOfMeasurementCollection as $uom){
        $uom = (object)$uom;
        $uomID = $uom->UoMEntry;
        $multiplier = getUOMMultiplier($uomGroupID,$uomID);
        if(!UOMItemExists($itemID,$uomID,$multiplier)){
            insertUOMItem($itemID,$uomID,$position=1,$multiplier);
            // echo " -> insertUOMItem($itemID,$uomID,$position,$multiplier);";
        }
    }

    return $itemID;
}
?>