<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('../../concc/dbinfo.php');
require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');
include_once("exportFunctions.php");

//$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
//$client->startConnection();
$dateFilter='';

$stockTakingIDsPost = $_POST['stockTakingIDs'];
if(!empty($stockTakingIDsPost)){
//    exportStockTakings($client,$today,$stockTakingIDsPost);
    exportStockTakingsBuObjects($client,$stockTakingIDsPost);
} else {
    echo "<center>Something went wrong. Please try again. $stockTakingIDsPost</center>";
}

function exportStockTakingsBuObjects($client,$stockTakingIDsPost)
{
    global $username;
    global $password;
    global $database;

    $stockTakingIDsPost = implode(',',$stockTakingIDsPost);

    $db11 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stockTakingWarehouseObjects = array();

    $db11->set_charset("utf8");
    $stm11 = $db11->prepare("SELECT Stock_Taking.stock_taking_id,Stock_Taking.stock_taking_code, Items.item_code,Warehouses.warehouse_code,Stock_Taking_Item.qty,batch_number,serialnumber FROM Stock_Taking,Stock_Taking_Item,Warehouses,Items WHERE Warehouses.warehouse_id=Stock_Taking.warehouse_id AND Items.item_id=Stock_Taking_Item.item_id AND Stock_Taking.stock_taking_id=Stock_Taking_Item.stock_taking_id AND Stock_Taking.stock_taking_id NOT IN (SELECT id FROM Documents_Status WHERE type='13') AND Stock_Taking.stock_taking_id IN ($stockTakingIDsPost) ORDER BY Warehouses.warehouse_code ASC,Items.item_code ASC");
    $stm11-> execute();
    $stm11-> bind_result($stockTakingID,$stockTakingCode,$itemCode,$whCode,$qty,$batchNumber, $expiryDate);
    while ($stm11->fetch()) {

        $batchNumberBinLocationExplode = explode(';BIN;',$batchNumber);
        $batchNumber = $batchNumberBinLocationExplode[0];
        $binLocation = $batchNumberBinLocationExplode[1];

        if(strcmp("$batchNumber","0")==0){$batchNumber = "";}
        if(strcmp("$binLocation","0")==0){$binLocation = "";}

        $existingStockTakingWarehouseObject = new stdClass();
        $existingStockTakingWarehouseObject->warehouseCode = "$whCode";
        $existingStockTakingWarehouseObject->stockTakings = array($stockTakingID => $stockTakingCode);
        $existingStockTakingWarehouseObject->stockTakingItemObjects = array();

        $existingStockTakingItemObject = new stdClass();
        $existingStockTakingItemObject->itemCode = "$itemCode";
        $existingStockTakingItemObject->qty = $qty;
        $existingStockTakingItemObject->batchNumberObjects = array();
        $existingStockTakingItemObject->binLocationObjects = array();

        $existingBatchNumberObject = new stdClass();
        $existingBatchNumberObject->batchNumber = $batchNumber;
        $existingBatchNumberObject->expiryDate = $expiryDate;
        $existingBatchNumberObject->qty = $qty;

        $existingBinLocationObject = new stdClass();
        $existingBinLocationObject->binLocation = $binLocation;
        $existingBinLocationObject->qty = $qty;

        $stockTakingObjectExists = false;
        $stockTakingItemObjectExists = false;
        $batchNumberObjectExists = false;
        $binLocationObjectExists = false;

        foreach($stockTakingWarehouseObjects as $stockTakingWarehouseObject){
            if(strcmp($stockTakingWarehouseObject->warehouseCode,$whCode)==0){

                $stockTakingObjectExists = true;
                $existingStockTakingWarehouseObject = $stockTakingWarehouseObject;

                foreach ($stockTakingWarehouseObject->stockTakingItemObjects as $stockTakingItemObject){
                    if(strcmp($stockTakingItemObject->itemCode,$itemCode)==0){

                        $stockTakingItemObjectExists = true;
                        $existingStockTakingItemObject = $stockTakingItemObject;
                        $existingStockTakingItemObject->qty += $qty;

                        foreach ($stockTakingItemObject->batchNumberObjects as $batchNumberObject){
                            if(strcmp($batchNumberObject->batchNumber,$batchNumber)==0){
                                $batchNumberObjectExists = true;
                                $existingBatchNumberObject = $batchNumberObject;
                                $existingBatchNumberObject->qty += $qty;
                                break;
                            }
                        }

                        foreach ($stockTakingItemObject->binLocationObjects as $binLocationObject){
                            if(strcmp($binLocationObject->binLocation,$binLocation)==0){
                                $binLocationObjectExists = true;
                                $existingBinLocationObject = $binLocationObject;
                                $existingBinLocationObject->qty += $qty;
                                break;
                            }
                        }

                        break;

                    }
                }

                break;

            }
        }

        if(!in_array($stockTakingID,$existingStockTakingWarehouseObject->stockTakingIDs)){
            $existingStockTakingWarehouseObject->stockTakings[$stockTakingID] = "$stockTakingCode";
        }

        if(!$binLocationObjectExists && strcmp("$binLocation","")!=0){
            array_push($existingStockTakingItemObject->binLocationObjects,$existingBinLocationObject);
        }

        if(!$batchNumberObjectExists && strcmp("$batchNumber","")!=0){
            array_push($existingStockTakingItemObject->batchNumberObjects,$existingBatchNumberObject);
        }

        if(!$stockTakingItemObjectExists && strcmp("$itemCode","")!=0){
            array_push($existingStockTakingWarehouseObject->stockTakingItemObjects,$existingStockTakingItemObject);
        }

        if(!$stockTakingObjectExists && strcmp("$whCode","")!=0){
            array_push($stockTakingWarehouseObjects,$existingStockTakingWarehouseObject);
        }


    }
    $stm11->close();

//    echo "<pre>".json_encode($stockTakingWarehouseObjects, JSON_PRETTY_PRINT)."</pre>";

    foreach($stockTakingWarehouseObjects as $stockTakingWarehouseObject){
        $postData   = array();
        $stockTakes = new stdClass();
        $stockTakes->InventoryCountingLines = array();
        $LineNumber = 0;

        foreach ($stockTakingWarehouseObject->stockTakingItemObjects as $stockTakingItemObject){

            $uomCode = getUomCode($stockTakingItemObject->itemCode);

            $LineNumber++;
            $stockTake = new stdClass();
            $stockTake->LineNumber = $LineNumber;
            $stockTake->ItemCode = "$stockTakingItemObject->itemCode";
            $stockTake->WarehouseCode = "$stockTakingWarehouseObject->warehouseCode";
            $stockTake->UoMCode = "$uomCode";
            $stockTake->CountedQuantity = stockTakingItemObject->qty;
            $stockTake->InventoryCountingSerialNumbers = array();
            $stockTake->InventoryCountingBatchNumbers = array();
            $stockTake->Counted = "tYES";
            //$stockTake->BinEntry = getBinLocationAbsEntry("".$binLocationsArray[$itemCode]);

            foreach ($stockTakingItemObject->batchNumberObjects as $batchNumberObject){
                $InventoryCountingBatchNumber = new stdClass();
                $InventoryCountingBatchNumber->BatchNumber= $batchNumberObject->batchNumber;
                $InventoryCountingBatchNumber->ExpiryDate= $batchNumberObject->expiryDate;
                $InventoryCountingBatchNumber->Quantity = $batchNumberObject->qty;
                $InventoryCountingBatchNumber->BaseLineNumber = $LineNumber;
                array_push($stockTake->InventoryCountingBatchNumbers,$InventoryCountingBatchNumber);
            }

            if(strcmp($uomCode,'Manual')==0){
                $stockTake->UoMCountedQuantity = null;
                $stockTake->InventoryCountingLineUoMs = array();
            } else {
                $InventoryCountingLineUoMs = new stdClass();
                $InventoryCountingLineUoMs->LineNumber = $LineNumber;
                $InventoryCountingLineUoMs->ChildNumber = 1;
                $InventoryCountingLineUoMs->UoMCountedQuantity = "$stockTakingItemObject->qty";
                $InventoryCountingLineUoMs->UoMCode = "$uomCode";
                $stockTake->UoMCountedQuantity = "$stockTakingItemObject->qty";
                $stockTake->InventoryCountingLineUoMs = array($InventoryCountingLineUoMs);
            }

            array_push($stockTakes->InventoryCountingLines,$stockTake);

        }


        if(!empty($stockTakes)){
            echo "<pre>".json_encode($stockTakes, JSON_PRETTY_PRINT)."</pre>";
            $result = $client->postData("InventoryCountings",$stockTakes);
            // echo "<pre><br>";var_dump($result);echo "</pre><br>";
            if($result["error"]["code"] < 0 ){break;}
        }

        $status = 1;
        $type = 13;
        $reason = "OK";

        $status = $result["error"]["code"];
        $reason = $result["error"]["message"]["value"];

        if(strcmp($status,'')==0 && strcmp($result["DocNum"],'')!=0){
            $status = 1;
            $reason = "OK ".$result["DocNum"];

        } else if(strcmp($status,'')==0){
                $status = -1;
                $reason = "ERP No answer.";
        }


        echo "<table style='width:100%;'>";
        echo "<tr><td style='padding: 5px;'><b> # </td><td style='padding: 5px;'><b> Stock Taking Code </td><td style='padding: 5px;'><b> Status </td><td style='padding: 5px;'><b> Reason </td></tr>";

        foreach($stockTakingWarehouseObject->stockTakings as $stockTakingID => $stockTakingCode){
            insertDocumentStatuses($stockTakingID,$type,$status,$reason);
            echo "<tr><td style='padding: 5px;'><img class=\"custom-rounded-image invoice center-canvas\" src=\"../../../../backend/themes/smartadmin/img/stockadjustmenticon.png\" width=\"30\" height=\"30\" ></td><td style='padding: 5px;'> $stockTakingCode </td><td style='padding: 5px;'> $status</td><td style='padding: 5px;'>$reason</td></tr>";
        }
        echo "";

    }

}


function exportStockTakings($client,$today,$stockTakingIDsPost)
{   
    global $username;
    global $password;
    global $database;
    
    $stockTakingIDsPost = implode(',',$stockTakingIDsPost);


    $db11 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
 	$stockTakings = array();
 	$stockTakingIDs = array();
 	$stockTakingCodes = array();
 	$binLocationsArray = array();
	$db11->set_charset("utf8");
	$stm11 = $db11->prepare("SELECT Stock_Taking.stock_taking_id,Stock_Taking.stock_taking_code, Items.item_code,Warehouses.warehouse_code,Stock_Taking_Item.qty,batch_number FROM Stock_Taking,Stock_Taking_Item,Warehouses,Items WHERE Warehouses.warehouse_id=Stock_Taking.warehouse_id AND Items.item_id=Stock_Taking_Item.item_id AND Stock_Taking.stock_taking_id=Stock_Taking_Item.stock_taking_id AND Stock_Taking.stock_taking_id NOT IN (SELECT id FROM Documents_Status WHERE type='13') AND Stock_Taking.stock_taking_id IN ($stockTakingIDsPost) ORDER BY Warehouses.warehouse_code ASC,Items.item_code ASC");
	$stm11-> execute();
	$stm11-> bind_result($stockTakingID,$stockTakingCode,$itemCode,$whCode,$qty,$batchNumberBinLocation);
	while ($stm11->fetch()) {
    $stockTakings[$whCode][$itemCode] += $qty;
    array_push($stockTakingIDs,$stockTakingID);
    $stockTakingCodes[$stockTakingID] = $stockTakingCode;
    
    $batchNumberBinLocationExplode = explode(';BIN;',$batchNumberBinLocation);
    $batchNumber = $batchNumberBinLocationExplode[0];
    $binLocation = $batchNumberBinLocationExplode[1];
    
    if(strcmp("$binLocation","0")!=0 && strcmp("$binLocation","")!=0){
        $binLocationsArray[$itemCode] = $binLocation;   
    }
        
	}
	$stm11->close();
	
	$stockTakingIDs = array_unique($stockTakingIDs);
	$stockTakingCodes = array_unique($stockTakingCodes);
	
    $postData = array();
	
	
	
	foreach($stockTakings as $warehouseCode => $item){
	    
        $lineCounter = 0;
        $stockTakes = '';
    // 	$stockTakes->BranchID = getBranchID($warehouseCode);
    	$stockTakes->InventoryCountingLines = array();
    	
	    foreach($item as $itemCode => $counted){
	       $lineCounter++;
	       $uomCode = getUomCode($itemCode);
	       
	       
	       
	       $stockTake = '';
	       $stockTake->LineNumber = $lineCounter;
	       $stockTake->ItemCode = "$itemCode";
	       $stockTake->WarehouseCode = "$warehouseCode";
	       //$stockTake->Counted = "tYES";
	       $stockTake->UoMCode = $uomCode;
	       $stockTake->CountedQuantity = $counted;
	       $stockTake->InventoryCountingSerialNumbers = array();
	       $stockTake->InventoryCountingBatchNumbers = array();
	       $stockTake->BinEntry = getBinLocationAbsEntry("".$binLocationsArray[$itemCode]);
	       
	       
	       if(strcmp($uomCode,'Manual')==0){
	           $stockTake->UoMCountedQuantity = null;
	           $stockTake->InventoryCountingLineUoMs = array();
	       } else {
	           
	           $InventoryCountingLineUoMs ='';
	           $InventoryCountingLineUoMs->LineNumber=$lineCounter;
	           $InventoryCountingLineUoMs->ChildNumber=1;
	           $InventoryCountingLineUoMs->UoMCountedQuantity=$counted;
	           $InventoryCountingLineUoMs->UoMCode="$uomCode";
	           $stockTake->UoMCountedQuantity = $counted;
	           $stockTake->InventoryCountingLineUoMs = array($InventoryCountingLineUoMs);
	           
	       }
	       
	       
	       
	       
	       
	       
           array_push($stockTakes->InventoryCountingLines,$stockTake);
           array_push($postData,$stockTakes);
	        
	    }
	    
	    if(!empty($stockTakes)){
	       // echo "<pre>";
        //     var_dump(json_encode($stockTakes));
        //     echo "</pre>";
            $result = $client->postData("InventoryCountings",$stockTakes);
            // echo "<pre><br>";
            // var_dump($result);
            // echo "</pre><br>";
            if($result["error"]["code"] < 0 ){break;}
	    } else {
	        
	    }
	    
	}
    	
	


    // echo "<pre><br>";
    // var_dump($result);
    // echo "</pre><br>";
    
    $status = 1;
    $type = 13;
    $reason = "OK";
        
    $status = $result["error"]["code"];
    $reason = $result["error"]["message"]["value"];

    if(strcmp($status,'')==0 && strcmp($result["DocNum"],'')!=0){
        $status = 1;
        $reason = "OK ".$result["DocNum"];

    } else {
        if(strcmp($status,'')==0){
            $status = -1;
            $reason = "ERP No answer.";
        }
    }


    echo "<table style='width:100%;'>";
    echo "<tr><td style='padding: 5px;'><b> # </td><td style='padding: 5px;'><b> Stock Taking Code </td><td style='padding: 5px;'><b> Status </td><td style='padding: 5px;'><b> Reason </td></tr>";

	foreach($stockTakingIDs as $stockTakingID){
	    insertDocumentStatuses($stockTakingID,$type,$status,$reason);
        // sendFailErrorEmail('Stock_Taking',$code,$id,$status,$reason,$to='');
	    $stockTakingCode = $stockTakingCodes[$stockTakingID];
	    echo "<tr><td style='padding: 5px;'><img class=\"custom-rounded-image invoice center-canvas\" src=\"../../../../backend/themes/smartadmin/img/stockadjustmenticon.png\" width=\"30\" height=\"30\" ></td><td style='padding: 5px;'> $stockTakingCode </td><td style='padding: 5px;'> $status</td><td style='padding: 5px;'>$reason</td></tr>";
	}
	echo "";


	


}

function getUomCode($itemCode){
    
    global $username;
    global $password;
    global $database;
    $db12 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
 	$z="Manual";
 	$db12->set_charset("utf8");
	$stm12 = $db12->prepare("SELECT UOMs.description FROM Items,UOM_Item,UOMs WHERE Items.item_id=UOM_Item.item_id AND UOM_Item.uom_id=UOMs.uom_id AND Items.item_code='$itemCode' ORDER BY multiplier ASC LIMIT 1");
	$stm12-> execute();
	$stm12-> bind_result($description);
	while ($stm12->fetch()) {
	    
	    $codeName = explode('-',$description);
	    $code = trim($codeName[0]);
	    $name = trim($codeName[1]);
	    if(strcmp($code,'')!=0){$z=$code;}
	    
	}
	$stm12->close();
	return $z;
}

function getBranchID($warehouseCode){
    
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      
    $companyID=1;
	$stm1 = $db1->prepare("SELECT company_id FROM Warehouses WHERE warehouse_code ='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($id);
	while ($stm1->fetch()) {
		if($id > 0){
		  $companyID = $id;
		}
	}
	$stm1->close();
    
    $stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id ='$companyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if(strcmp($companyCode,'GDL')==0){$companyCode=1;}
     
    return $companyCode;
	
}


?>