<?php

function exportCustomers($client,$dateFilter)
{   
    global $username;
    global $password;
    global $database;

    echo "<br><b>---CUSTOMERS---</b><br>";

    $db11 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db11->set_charset("utf8");
	$stm11 = $db11->prepare("SELECT customer_id,customer_code,customer_company_name,mobile,website,email,description,customer_type FROM Customers WHERE type_of_business='Lead' AND timestamp>='2025-01-01' ");
	$stm11-> execute();
	$stm11-> bind_result($customerID,$customerCode,$customerName,$customerMobile,$customerWebsite,$customerEmail,$customerDescription,$customerType);
	while ($stm11->fetch()) {
	    
	    echo "<br>$customerCode - ";
	    
	    $customerAddresses = getCustomerAddressesForExport($customerID);
	    
	    $primaryAddress = $customerAddresses[0];

        $postData = new stdClass();
        $postData->CardCode = $customerCode;
        $postData->CardName = $customerName;
        $postData->CardType = 'cCustomer';
        $postData->Address  = trim($primaryAddress->addressLine1.' '.$primaryAddress->addressLine2);
        $postData->ZipCode  = $primaryAddress->postCode;
        $postData->Phone1   = $customerMobile;
        $postData->Phone2   = $primaryAddress->landline;
        $postData->Fax      = $primaryAddress->fax;
        $postData->Notes    = $customerDescription;
        $postData->EmailAddress = $customerEmail;

//        if (strpos($customerCode, 'CB') !== false) {$sapSeries = '82';}
//        else if (strpos($customerCode, 'CC') !== false) {$sapSeries = '83';}
//        else if (strpos($customerCode, 'CD') !== false) {$sapSeries = '84';}
//        else {$sapSeries = 0;}
//
//        $postData->Series = $sapSeries;
//
//        echo "Series:".$sapSeries;

        
        $postData->BPAddresses = array();
        foreach($customerAddresses as $customerAddress){
            $postDataAddress = new stdClass();
            $postDataAddress->AddressName = 'Bill to';
            $postDataAddress->Street      = trim($customerAddress->addressLine1.' '.$customerAddress->addressLine2);
            $postDataAddress->ZipCode     = $customerAddress->postCode;
            $postDataAddress->City        = $customerAddress->city;
            $postDataAddress->County      = $customerAddress->region;
            $postDataAddress->Country     = $customerAddress->country;
            array_push($postData->BPAddresses,$postDataAddress);
        }


        echo "<pre>";
        var_dump($postData);
        echo "</pre>";
        
        $result = $client->postData("BusinessPartners",$postData);
       
        echo "<pre>";
        var_dump($result);
        echo "</pre><br>";
        
        if(isset($result['CardCode']) && strcmp($result['CardCode'],'')!=0){
            updateCustomerStatusForExport($customerID,$result['CardCode'],$result['SalesPersonCode']);
        }
        
        
	}
	$stm11->close();
	

    echo "<b>---CUSTOMERS/---</b><br>";

}

function updateCustomerStatusForExport($customerID,$customerCode,$typeOfBusiness){

    global $username, $password, $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stmt1 = $db1->prepare("UPDATE Customers SET customer_code=?,type_of_business=? WHERE customer_id=?");
	$stmt1->bind_param('ssi',$customerCode,$typeOfBusiness,$customerID);
 	$stmt1->execute(); 	
 	$stmt1->close();

    return $stmt1->error;

}

function getCustomerAddressesForExport($customerID){

    global $username;
    global $password;
    global $database;
    
    $addressesArray = array();

    $db11 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db11->set_charset("utf8");
	$stm11 = $db11->prepare("SELECT country,city,address_line_1,address_line_2,postcode,region,pobox,landline,fax FROM CustomerAddress WHERE customer_id='$customerID' ORDER BY primary_address DESC");
	$stm11-> execute();
	$stm11-> bind_result($country,$city,$addressLine1,$addressLine2,$postCode,$region,$pobox,$landline,$fax);
	while ($stm11->fetch()) {
	    
	    $address = new stdClass();
	    $address->country = $country;
	    $address->city = $city;
	    $address->addressLine1 = $addressLine1;
	    $address->addressLine2 = $addressLine2;
	    $address->postCode = $postCode;
	    $address->region = $region;
	    $address->pobox = $pobox;
	    $address->landline = $landline;
	    $address->fax = $fax;
	    array_push($addressesArray,$address);
	    
	}
	$stm11->close();
	
	return $addressesArray;
    
}


?>