<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once("../param.php");

$exportData = getExportData();
$jsonExport = json_encode($exportData);
$fileExport = fileExport($exportData);

echo "<pre>";
var_dump($exportData);



function fileExport($salespersons){
    $file = fopen("./custom/routeExport.txt", "w");
    $statement_TRIP_PARAMETERS = '';
    foreach ($salespersons as $salesperson){

        //------- TRIP_PARAMETERS --------//

        $ROUTE_KEY     = $salesperson->route_id; // Documents Statuses export ID
        $R_LOC_ID      = $salesperson->group_id; // anonymous group ID on Sales Persons
        $PERSON_ID     = $salesperson->code;
        $S_PERSON_ID   = $salesperson->code;
        $SALES_DATE    = $salesperson->sales_date;
        $T_EQUIP_ID    = $salesperson->mobile;
        $NEXT_INV_NBR  = $salesperson->next_invoice_number;
        $NEXT_ORD_NBR  = $salesperson->next_order_number;
        $NEXT_PAY_NBR  = $salesperson->next_receipt_number;
        $NEXT_LOAD_NBR = $salesperson->next_load_number;
        $RouteStartDateTime = $salesperson->first_visit_date_time;
        $RouteEndDateTime   = $salesperson->last_visit_date_time;
        $RouteStartOdometer = $salesperson->odometer_start;
        $RouteEndOdometer   = $salesperson->odometer_end;
        $POSTED_FL = 'N';

        $statement_TRIP_PARAMETERS = "INSERT INTO TRIP_PARAMETERS ";
//        $statement_TRIP_PARAMETERS .= "( ROUTE_KEY , R_LOC_ID , PERSON_ID , SALES_DATE , T_EQUIP_ID , NEXT_INV_NBR , NEXT_ORD_NBR , NEXT_PAY_NBR , NEXT_LOAD_NBR , RouteStartDateTime , RouteEndDateTime , RouteStartOdometer , RouteEndOdometer)";
        $statement_TRIP_PARAMETERS .= "( ROUTE_KEY , R_LOC_ID , PERSON_ID , SALES_DATE , T_EQUIP_ID , RouteStartDateTime , RouteEndDateTime , RouteStartOdometer , RouteEndOdometer , POSTED_FL)";
        $statement_TRIP_PARAMETERS .= " VALUES ";
//        $statement_TRIP_PARAMETERS .= "( $ROUTE_KEY , $R_LOC_ID , $PERSON_ID , $SALES_DATE , $T_EQUIP_ID , $NEXT_INV_NBR , $NEXT_ORD_NBR , $NEXT_PAY_NBR , $NEXT_LOAD_NBR , $RouteStartDateTime , $RouteEndDateTime , $RouteStartOdometer , $RouteEndOdometer)";
        $statement_TRIP_PARAMETERS .= "( $ROUTE_KEY , $R_LOC_ID , $PERSON_ID , $SALES_DATE , $T_EQUIP_ID , $RouteStartDateTime , $RouteEndDateTime , $RouteStartOdometer , $RouteEndOdometer , $POSTED_FL)";
        $statement_TRIP_PARAMETERS .= ";\n";

        fwrite($file, $statement_TRIP_PARAMETERS);

        //------- TRIP_PARAMETERS/ --------//

        //------- TRANS_HDR & TRANS_DTL--------//

        foreach ($salesperson->orders as $order){

            $TRANS_TYPE = 1; // 1 For Order
            $TRANS_ID   = $order->code;
            $TRANSACTION_TYPE = 15; // 15 For SALES
            $LOCATION_ID = $order->customer->vatCode;
            $R_LOC_ID    = $order->customer->registration;
            $TRANS_DT    = $order->orderDate;
            $DELIVERY_DT = $order->deliveryDate;
            $CUSTOMER_ID = $order->customer->code;
            $CHILD_CUSTOMER_ID = '';
            $TRIP_NO = 1;
            $REMARK  = $order->details;
            $DIST_ID = '';
            $SYS_NET_AM = $order->grandTotal;
            $DOCUMENT_NO = $order->code;
            $PAYMENT_TYPE = '';


            foreach ($order->lines as $orderItem){

                $ITEM_ID = $orderItem->code;
                $QTY = $orderItem->qty;
                $Price = $orderItem->unitPrice;
                $NET_AM = $orderItem->lineTotal;

                $statement_TRANS_DTL  = "INSERT INTO TRANS_DTL ";
                $statement_TRANS_DTL .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , ITEM_ID , LOCATION_ID , TRANSACTION_TYPE , QTY , Price , NET_AM )";
                $statement_TRANS_DTL .= " VALUES ";
                $statement_TRANS_DTL .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $ITEM_ID , $LOCATION_ID , $TRANSACTION_TYPE , $QTY , $Price , $NET_AM )";
                $statement_TRANS_DTL .= ";\n";
                fwrite($file, $statement_TRANS_DTL);


            }
            $statement_TRANS_HDR  = "INSERT INTO TRANS_HDR ";
            $statement_TRANS_HDR .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , LOCATION_ID , R_LOC_ID , PERSON_ID , TRANS_DT , DELIVERY_DT , CUSTOMER_ID , CHILD_CUSTOMER_ID , TRIP_NO , REMARK , DIST_ID , SYS_NET_AM , PAYMENT_TYPE , POSTED_FL )";
            $statement_TRANS_HDR .= " VALUES ";
            $statement_TRANS_HDR .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $LOCATION_ID , $R_LOC_ID , $PERSON_ID , $TRANS_DT , $DELIVERY_DT , $CUSTOMER_ID , $CHILD_CUSTOMER_ID , $TRIP_NO , $REMARK , $DIST_ID , $SYS_NET_AM , $PAYMENT_TYPE , $POSTED_FL )";
            $statement_TRANS_HDR .= ";\n";
            fwrite($file, $statement_TRANS_HDR);

            insertDocumentsStatusesRecord($order->id,2,-1,'Sent - Awaiting ERP Confirmation',$salesperson->route_id);

        }

        foreach ($salesperson->invoices as $invoice){

            $TRANS_TYPE = 2; // 2 For Invoice
            $TRANS_ID   = $invoice->code;
            $TRANSACTION_TYPE = 15; // 15 For SALES
            $LOCATION_ID = $invoice->customer->vatCode;
            $R_LOC_ID    = $invoice->customer->registration;
            $TRANS_DT    = $invoice->invoiceDate;
            $DELIVERY_DT = '';
            $CUSTOMER_ID = $invoice->customer->code;
            $CHILD_CUSTOMER_ID = '';
            $TRIP_NO = 1;
            $REMARK  = $invoice->details;
            $DIST_ID = '';
            $SYS_NET_AM = $invoice->grandTotal;
            $DOCUMENT_NO = $invoice->code;
            $PAYMENT_TYPE = '';
            $POSTED_FL = 'N';

            foreach ($invoice->lines as $invoiceItem){

                $ITEM_ID = $invoiceItem->code;
                $QTY = $invoiceItem->qty;
                $Price = $invoiceItem->unitPrice;
                $NET_AM = $invoiceItem->lineTotal;

                $statement_TRANS_DTL  = "INSERT INTO TRANS_DTL ";
                $statement_TRANS_DTL .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , ITEM_ID , LOCATION_ID , TRANSACTION_TYPE , QTY , Price , NET_AM )";
                $statement_TRANS_DTL .= " VALUES ";
                $statement_TRANS_DTL .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $ITEM_ID , $LOCATION_ID , $TRANSACTION_TYPE , $QTY , $Price , $NET_AM )";
                $statement_TRANS_DTL .= ";\n";
                fwrite($file, $statement_TRANS_DTL);


            }
            $statement_TRANS_HDR  = "INSERT INTO TRANS_HDR ";
            $statement_TRANS_HDR .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , LOCATION_ID , R_LOC_ID , PERSON_ID , TRANS_DT , DELIVERY_DT , CUSTOMER_ID , CHILD_CUSTOMER_ID , TRIP_NO , REMARK , DIST_ID , SYS_NET_AM , PAYMENT_TYPE , POSTED_FL )";
            $statement_TRANS_HDR .= " VALUES ";
            $statement_TRANS_HDR .= "( $ROUTE_KEY , $TRANS_TYPE , $LOCATION_ID , $R_LOC_ID , $PERSON_ID , $TRANS_DT , $DELIVERY_DT , $CUSTOMER_ID , $CHILD_CUSTOMER_ID , $TRIP_NO , $REMARK , $DIST_ID , $SYS_NET_AM , $PAYMENT_TYPE , $POSTED_FL )";
            $statement_TRANS_HDR .= ";\n";
            fwrite($file, $statement_TRANS_HDR);

            insertDocumentsStatusesRecord($invoice->id,5,-1,'Sent - Awaiting ERP Confirmation',$salesperson->route_id);

        }

        foreach ($salesperson->loadRequests as $loadRequest){

            $LOAD_TYPE_ID = 1;
            $TRANS_ID      = $loadRequest->code;
            $LOCATION_ID  = $loadRequest->customer->vatCode;
            $R_LOC_ID     = $loadRequest->customer->registration;
            $LDSHT_NR_ID  = '';  // 1 = unload , 2 = load
            $LOAD_SEQ_NR  = '';  // ???
            $ROAD_SEQ_ID  = '';  // ???
            $ROUTE_DT     = $loadRequest->date;
            $LOAD_TM      = $loadRequest->date; // ???
            $END_ODOMETER_QTY = 0; // ???
            $H_PERSON_ID1  = ''; // ???
            $REFERENCE_NR = ''; // ???
            $DIST_ID = ''; // ???
            $POSTED_FL = 'N';

            foreach ($loadRequest->lines as $loadRequestItem){

                $ITEM_ID = $loadRequestItem->code;
                $LOAD_QTY = $loadRequestItem->qty;

                $statement_TRANS_DTL  = "INSERT INTO LOAD_DTL ";
                $statement_TRANS_DTL .= "( ROUTE_KEY , TRANS_ID , ITEM_ID , LOAD_QTY )";
                $statement_TRANS_DTL .= " VALUES ";
                $statement_TRANS_DTL .= "( $ROUTE_KEY , $TRANS_ID , $ITEM_ID , $LOAD_QTY )";
                $statement_TRANS_DTL .= ";\n";
                fwrite($file, $statement_TRANS_DTL);


            }
            $statement_TRANS_HDR  = "INSERT INTO LOAD_HDR ";
            $statement_TRANS_HDR .= "( ROUTE_KEY , TRANS_ID , LOAD_TYPE_ID , LDSHT_NR_ID , LOCATION_ID , LOAD_SEQ_NR , R_LOC_ID , PERSON_ID , SALES_DATE , LOAD_TM , H_PERSON_ID1 , REFERENCE_NR , T_EQUIP_ID , DIST_ID , POSTED_FL )";
            $statement_TRANS_HDR .= " VALUES ";
            $statement_TRANS_HDR .= "( $ROUTE_KEY , $TRANS_ID , $LOAD_TYPE_ID , $LDSHT_NR_ID , $LOCATION_ID , $LOAD_SEQ_NR , $R_LOC_ID , $PERSON_ID , $SALES_DATE , $LOAD_TM , $H_PERSON_ID1 , $REFERENCE_NR , $T_EQUIP_ID , $DIST_ID , $POSTED_FL )";
            $statement_TRANS_HDR .= ";\n";
            fwrite($file, $statement_TRANS_HDR);

            insertDocumentsStatusesRecord($loadRequest->id,7,-1,'Sent - Awaiting ERP Confirmation',$salesperson->route_id);

        }


            foreach ($salesperson->receipts as $receipt) {

                $TRANS_TYPE = 3; // 2 For Receipts
                $TRANS_ID = $receipt->code;
                $LOCATION_ID = $receipt->customer->vatCode;
                $R_LOC_ID = $receipt->customer->registration;
                $TRANS_DT = $receipt->receiptDate;
                $DELIVERY_DT = '';
                $CUSTOMER_ID = $receipt->customer->code;
                $CHILD_CUSTOMER_ID = '';
                $TRIP_NO = 1;
                $REMARK = $receipt->details;
                $DIST_ID = '';
                $SYS_NET_AM = $receipt->grandTotal;
                $DOCUMENT_NO = $receipt->code;
                $POSTED_FL = 'N';

                $method = $receipt->method;
                if (strcmp($method, 'Cash') == 0) {$PAYMENT_TYPE = 23;}
                else if (strcmp($method, 'Cheque') == 0) {$PAYMENT_TYPE = 15;}

                foreach ($receipt->paymentMethods as $paymentMethod) {

                    $method = $paymentMethod->method;
                    if (strcmp($method, 'Cash') == 0) {$PAYMENT_TYPE = 23;}
                    else if (strcmp($method, 'Cheque') == 0) {$PAYMENT_TYPE = 15;}

//                    foreach ($paymentMethod->lines as $line) {
//
//                        if (strcmp($method, 'Cash') == 0) {
//
//                            $PAYMENT_TYPE = 23;
//                            $DENOMINATION_ID = 0;
//                            $DENOMINATION_QTY = 0;
//                            $DENOMINATION_AM = $line->amount;
//                            $statement_CASH_DETAILS = "INSERT INTO CASH_DETAILS ";
//                            $statement_CASH_DETAILS .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , PAYMENT_TYPE , DENOMINATION_ID , DENOMINATION_QTY , DENOMINATION_AM )";
//                            $statement_CASH_DETAILS .= " VALUES ";
//                            $statement_CASH_DETAILS .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $PAYMENT_TYPE , $DENOMINATION_ID , $DENOMINATION_QTY , $DENOMINATION_AM )";
//                            $statement_CASH_DETAILS .= ";\n";
//                            fwrite($file, $statement_CASH_DETAILS);
//
//                        } else if (strcmp($method, 'Cheque') == 0) {
//
//                            $PAYMENT_TYPE = 15;
//                            $CHK_NR_ID = $line->cheque_number;
//                            $CHECK_DT = $line->cheque_date;
//                            $CHECK_AM = $line->amount;
//                            $BANK_ID = $line->bankCode;
//                            $statement_CHEQUE_DETAILS = "INSERT INTO CHEQUE_DETAILS ";
//                            $statement_CHEQUE_DETAILS .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , PAYMENT_TYPE , CHK_NR_ID , CHECK_DT , CHECK_AM , BANK_ID )";
//                            $statement_CHEQUE_DETAILS .= " VALUES ";
//                            $statement_CHEQUE_DETAILS .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $PAYMENT_TYPE , $CHK_NR_ID , $CHECK_DT , $CHECK_AM , $BANK_ID )";
//                            $statement_CHEQUE_DETAILS .= ";\n";
//                            fwrite($file, $statement_CHEQUE_DETAILS);
//
//                        }
//                    }
                }


                $statement_TRANS_HDR = "INSERT INTO TRANS_HDR ";
                $statement_TRANS_HDR .= "( ROUTE_KEY , TRANS_TYPE , TRANS_ID , LOCATION_ID , R_LOC_ID , PERSON_ID , TRANS_DT , DELIVERY_DT , CUSTOMER_ID , CHILD_CUSTOMER_ID , TRIP_NO , REMARK , DIST_ID , SYS_NET_AM , PAYMENT_TYPE , POSTED_FL )";
                $statement_TRANS_HDR .= " VALUES ";
                $statement_TRANS_HDR .= "( $ROUTE_KEY , $TRANS_TYPE , $TRANS_ID , $LOCATION_ID , $R_LOC_ID , $PERSON_ID , $TRANS_DT , $DELIVERY_DT , $CUSTOMER_ID , $CHILD_CUSTOMER_ID , $TRIP_NO , $REMARK , $DIST_ID , $SYS_NET_AM , $PAYMENT_TYPE , $POSTED_FL )";
                $statement_TRANS_HDR .= ";\n";
                fwrite($file, $statement_TRANS_HDR);

                insertDocumentsStatusesRecord($receipt->id,6,-1,'Sent - Awaiting ERP Confirmation',$salesperson->route_id);

            }
        }







    fclose($file);

    return true;

}

function getExportData()
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $routeID = getRouteID();
    $salespersons = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT salesperson_id, salesperson_code,first_name,last_name,anonymous_group_id,mobile FROM SalesPersons WHERE 1=1");
    $stm->execute();
    $stm->bind_result($salespersonID, $salespersonCode, $firstName, $lastName, $anonymous_group_id, $mobile);
    while ($stm->fetch()) {

        $salesperson = new stdClass();

        $salesperson->sales_date = date('Y-m-d');
        $salesperson->next_invoice_number = getNextKey("Invoices","invoice_code","begin_invoice_number", $salespersonID);
        $salesperson->next_order_number = getNextKey("Orders","order_code", "begin_order_number", $salespersonID);
        $salesperson->next_receipt_number = getNextKey("Receipts","receipt_code", "begin_receipt_number", $salespersonID);
        $salesperson->next_load_number = getNextKey("Warehouse_Transactions", "warehouse_transaction_code", "begin_warehouse_transaction_number", $salespersonID);
        $salesperson->first_visit_date_time = getVisitDateTime($salespersonID,date('Y-m-d'),'first');
        $salesperson->last_visit_date_time = getVisitDateTime($salespersonID,date('Y-m-d'),'last');
        $salesperson->odometer_start = 0;
        $salesperson->odometer_end = 0;

        $salesperson->id = $salespersonID;
        $salesperson->code = $salespersonCode;
        $salesperson->firstName = $firstName;
        $salesperson->lastName = $lastName;
        $salesperson->group_id = $anonymous_group_id;
        $salesperson->mobile = $mobile;

        $orders = getOrders($salespersonID);
        $noOfOrders = count($orders);
        $salesperson->noOfOrders = $noOfOrders;
        $salesperson->orders = $orders;

        $invoices = getInvoices($salespersonID);
        $noOfInvoices = count($invoices);
        $salesperson->noOfInvoices = $noOfInvoices;
        $salesperson->invoices = $invoices;

        $receipts = getReceipts($salespersonID);
        $noOfReceipts = count($receipts);
        $salesperson->noOfReceipts = $noOfReceipts;
        $salesperson->receipts = $receipts;

        $loadRequests = getLoadRequests($salespersonID);
        $noOfLoadRequests = count($loadRequests);
        $salesperson->noOfloadRequests = $noOfLoadRequests;
        $salesperson->loadRequests = $loadRequests;

        if($noOfOrders > 0 || $noOfInvoices > 0 || $noOfReceipts > 0 || $noOfLoadRequests > 0){
            $routeID++;
            $salesperson->route_id = $routeID;
            array_push($salespersons, $salesperson);
        }


    }
    $stm->close();

    return $salespersons;
}

function getOrders($salespersonID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $orders = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT order_id,order_code,customer_id,order_date,subtotal,discount_amount,vat_amount,grand_total,delivery_date,details FROM Orders WHERE NOT status = 'Canceled' AND salesperson_id = '$salespersonID' AND order_id NOT IN (SELECT id FROM Documents_Status WHERE type='2') AND order_date >='2021-04-01'");
    $stm2->execute();
    $stm2->bind_result($orderID, $orderCode,$customerID,$orderDate,$subtotal,$discount,$vat,$total,$deliveryDate,$details);
    while ($stm2->fetch()) {

        $lines = getOrderLines($orderID);
        $noOfLines = count($lines);

        $order = new stdClass();
        $order->id=$orderID;
        $order->code=$orderCode;
        $order->orderDate=$orderDate;
        $order->deliveryDate=$deliveryDate;
        $order->details=$details;
        $order->subtotal=$subtotal;
        $order->discount=$discount;
        $order->vat=$vat;
        $order->grandTotal=$total;
        $order->customer= getCustomer($customerID);
        $order->noOfLines= $noOfLines;
        $order->lines= $lines;
        array_push($orders,$order);

    }
    $stm2->close();

    return $orders;
}

function getInvoices($salespersonID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $orders = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT invoice_id,invoice_code,customer_id,invoice_date,subtotal,discount_amount,vat_amount,grand_total,invoice_type,details FROM Invoices WHERE NOT status = 'Canceled' AND salesperson_id = '$salespersonID' AND invoice_id NOT IN (SELECT id FROM Documents_Status WHERE type='5') AND invoice_date >='2021-04-01'");
    $stm2->execute();
    $stm2->bind_result($orderID, $orderCode,$customerID,$orderDate,$subtotal,$discount,$vat,$total,$type,$details);
    while ($stm2->fetch()) {

        $lines = getInvoiceLines($orderID);
        $noOfLines = count($lines);

        $order = new stdClass();
        $order->id=$orderID;
        $order->code=$orderCode;
        $order->invoiceDate=$orderDate;
        $order->type=$type;
        $order->details=$details;
        $order->subtotal=$subtotal;
        $order->discount=$discount;
        $order->vat=$vat;
        $order->grandTotal=$total;
        $order->customer= getCustomer($customerID);
        $order->noOfLines= $noOfLines;
        $order->lines= $lines;
        array_push($orders,$order);

    }
    $stm2->close();

    return $orders;
}

function getReceipts($salespersonID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $orders = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT receipt_id,receipt_code,customer_id,receipt_date,payment_method,amount,cash_discount,notes,status FROM Receipts WHERE NOT status = 'Canceled' AND salesperson_id = '$salespersonID' AND receipt_id NOT IN (SELECT id FROM Documents_Status WHERE type='6') AND receipt_date >='2021-04-01'");
    $stm2->execute();
    $stm2->bind_result($orderID, $orderCode,$customerID,$orderDate,$method,$amount,$cashDiscount,$notes,$status);
    while ($stm2->fetch()) {

        $lines = getReceiptLines($orderID);
        $noOfLines = count($lines);

        $order = new stdClass();
        $order->id=$orderID;
        $order->code=$orderCode;
        $order->receiptDate=$orderDate;
        $order->method=$method;
        $order->notes=$notes;
        $order->amount=$amount;
        $order->cashDiscount=$cashDiscount;
        $order->status=$status;
        $order->customer= getCustomer($customerID);
        $order->noOfPaymentMethods= $noOfLines;
        $order->paymentMethods= $lines;

        array_push($orders,$order);

    }
    $stm2->close();

    return $orders;
}

function getLoadRequests($salespersonID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $orders = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,transaction_date,details FROM Warehouse_Transactions WHERE salesperson_id = '$salespersonID' AND warehouse_transaction_id NOT IN (SELECT id FROM Documents_Status WHERE type='7') AND transaction_date >='2021-04-01' AND type='Load Request' ");
    $stm2->execute();
    $stm2->bind_result($orderID, $orderCode,$whFrom,$whTo,$orderDate,$details);
    while ($stm2->fetch()) {

        $lines = getLoadRequestLines($orderID);
        $noOfLines = count($lines);

        $order = new stdClass();
        $order->id=$orderID;
        $order->code=$orderCode;
        $order->date=$orderDate;
        $order->details=$details;
        $order->whFrom=getWarehouse($whFrom);
        $order->whTo=getWarehouse($whTo);
        $order->noOfLines= $noOfLines;
        $order->lines= $lines;
        array_push($orders,$order);

    }
    $stm2->close();

    return $orders;
}

function getCustomer($customerID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    ;
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT customer_code,customer_company_name,registration_code,vat_code FROM Customers WHERE customer_id='$customerID' LIMIT 1 ");
    $stm2->execute();
    $stm2->bind_result($code, $name,$registration,$vatCode);
    while ($stm2->fetch()) {}
    $stm2->close();

    $customer = new stdClass();
    $customer->id=$customerID;
    $customer->code=$code;
    $customer->name=$name;
    $customer->registration=$registration;
    $customer->vatCode=$vatCode;

    // FOR ANDREA CHARALAMBOUS -> REGISTRATION CODE is the ROUTE of CUSTOMER !!!!!!!!!!!

    return $customer;
}

function getItemCode($itemID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    ;
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT item_code FROM Items WHERE item_id='$itemID' LIMIT 1 ");
    $stm2->execute();
    $stm2->bind_result($code);
    while ($stm2->fetch()) {}
    $stm2->close();


    return $code;
}

function getWarehouse($whID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }


    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT warehouse_id,warehouse_code,name FROM Warehouses WHERE warehouse_id='$whID' LIMIT 1 ");
    $stm2->execute();
    $stm2->bind_result($id,$code,$name);
    while ($stm2->fetch()) {}
    $stm2->close();

    $warehouse = new stdClass();
    $warehouse->id=$id;
    $warehouse->code=$code;
    $warehouse->name=$name;


    return $warehouse;
}

function getOrderLines($orderID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $lines = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT item_id,qty,unit_price,line_discount,vat_amount,description,global_discount FROM Order_Item WHERE order_id='$orderID'");
    $stm2->execute();
    $stm2->bind_result($itemID,$qty,$unitPrice,$lineDiscount,$vatAmount,$description,$globalDiscount);
    while ($stm2->fetch()) {

        $line = new stdClass();
        $line->id=$itemID;
        $line->code= getItemCode($itemID);
        $line->description= $description;
        $line->qty= $qty;
        $line->unitPrice= $unitPrice;
        $line->lineDiscount= $lineDiscount;
        $line->lineTotal = $unitPrice*$qty - $lineDiscount - $globalDiscount;
        $line->vatAmount= $vatAmount;

        array_push($lines,$line);

    }
    $stm2->close();

    return $lines;
}

function getInvoiceLines($invoiceID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $lines = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT item_id,qty,unit_price,line_discount,vat_amount,description,global_discount FROM Invoice_Item WHERE invoice_id='$invoiceID'");
    $stm2->execute();
    $stm2->bind_result($itemID,$qty,$unitPrice,$lineDiscount,$vatAmount,$description,$globalDiscount);
    while ($stm2->fetch()) {

        $line = new stdClass();
        $line->id=$itemID;
        $line->code= getItemCode($itemID);
        $line->description= $description;
        $line->qty= $qty;
        $line->unitPrice= $unitPrice;
        $line->lineDiscount= $lineDiscount;
        $line->lineTotal = $unitPrice*$qty - $lineDiscount - $globalDiscount;
        $line->vatAmount= $vatAmount;

        array_push($lines,$line);

    }
    $stm2->close();

    return $lines;
}

function getReceiptLines($receiptID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $methods = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT DISTINCT(payment_method) FROM Receipt_Item WHERE receipt_id='$receiptID'");
    $stm2->execute();
    $stm2->bind_result($payment_method);
    while ($stm2->fetch()) {array_push($methods,$payment_method);}
    $stm2->close();

    $lines = array();
    foreach ($methods as $paymentMethod) {

        $methodLines = array();
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT amount,cash_discount,bank,branch,cheque_number,cheque_date,notes FROM Receipt_Item WHERE receipt_id='$receiptID' AND payment_method = '$paymentMethod'");
        $stm2->execute();
        $stm2->bind_result($amount, $cash_discount, $bank, $branch, $cheque_number, $cheque_date, $notes);
        while ($stm2->fetch()) {

            $bankCode = getBankCode($bank);

            $line = new stdClass();
            $line->amount = $amount;
            $line->cash_discount = $cash_discount;
            $line->bankName = $bank;
            $line->bankCode = $bankCode;
            $line->branch = $branch;
            $line->cheque_number = $cheque_number;
            $line->cheque_date = $cheque_date;
            $line->notes = $notes;

            array_push($methodLines, $line);

        }
        $stm2->close();

        $method =new stdClass();
        $noOfLines = count($methodLines);
        $method->method = $paymentMethod;
        $method->noOfLines = $noOfLines;
        $method->lines = $methodLines;
        array_push($lines,$method);
    }


    return $lines;
}

function getLoadRequestLines($requestID){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $lines = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT item_id,batch_number,qty FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id='$requestID'");
    $stm2->execute();
    $stm2->bind_result($itemID,$batchNumber,$qty);
    while ($stm2->fetch()) {

        $line = new stdClass();
        $line->id=$itemID;
        $line->code= getItemCode($itemID);
        $line->batchNumber= $batchNumber;
        $line->qty= $qty;

        array_push($lines,$line);

    }
    $stm2->close();

    return $lines;
}

function getRouteID(){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $exportID = 0;
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT export_id FROM Documents_Status ORDER BY export_id DESC LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($exportID);
    while ($stm2->fetch()) {}
    $stm2->close();

    return $exportID;
}

function getNextKey($tableName,$codeName,$beginNumberColumn,$salespersonID)
{
    global $username, $password, $database;
    $z=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");


    $stm1 = $db1->prepare("SELECT display_prefix,$beginNumberColumn FROM Devices WHERE sales_person_id='$salespersonID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($prefix,$beginNumber);
    while ($stm1->fetch()) {}
    $stm1->close();

    $stm1 = $db1->prepare("SELECT $codeName FROM $tableName WHERE salesperson_id ='$salespersonID' ORDER BY $codeName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextCode);
    while ($stm1->fetch()) {}
    $stm1->close();

    $z = str_replace($prefix,'',$nextCode);
    if($z > 0){
        $z+=1;
    } else {
        $z = $beginNumber;
    }


    return $prefix.$z;


}

function getVisitDateTime($salespersonID,$date,$filter){

    $z= date('Y-m-d')." 00:00:00";
    if(strcmp($filter,'first')==0){
        $sorting = "ASC";
    } else {
        $sorting = "DESC";
    }

    global $username, $password, $database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");


    $stm1 = $db1->prepare("SELECT visit_date FROM Visits WHERE salesperson_id='$salespersonID' AND visit_date>='$date 00:00:00' ORDER BY visit_date $sorting LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($result);
    while ($stm1->fetch()) {
        if(strcmp($result,'')!=0 && strcmp($result,'0000-00-00 00-00-00')!=0){
            $z = $result;
        }
    }
    $stm1->close();

    return $z;
}

function getBankCode($name){
    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $z = '';
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT code FROM Banks WHERE name='$name'");
    $stm2->execute();
    $stm2->bind_result($code);
    while ($stm2->fetch()) {
        $z = $code;
    }
    $stm2->close();

    return $z;
}

function insertDocumentsStatusesRecord($documentID,$type,$status,$reason,$exportID){

    global $username,$password,$database;
    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stmt = $db2->prepare("INSERT INTO Documents_Status (id, type, status, reason,export_id, timestamp) VALUES (?,?,?,?,?, NOW())");
    $stmt->bind_param('iiisi',$documentID,$type,$status,$reason,$exportID);
    $stmt->execute();
    $stmt->close();
}

?>