<?php
class Concopius
{
    private $dbUsername;
    private $dbPassword;
    private $dbLocalhost;
    private $dbName;
    private $prefix = 9900;
    private $charset = 'utf8';
    private $connectionUrl;
    private $companyID;
    private $companyTIC;
    private $companyVAT;
    private $vatArray;
    private $db;


    public function __construct($dbLocalhost, $dbUsername, $dbPassword,$dbName)
    {
        $this->dbUsername = $dbUsername;
        $this->dbPassword = $dbPassword;
        $this->dbLocalhost = $dbLocalhost;
        $this->dbName = $dbName;

    }

    public function setCompanyInfo($companyID){
        $companyInfo = (object)$this->query("SELECT * FROM Companies WHERE company_id='$companyID' LIMIT 1")[0];
        $this->companyID = $companyID;
        $this->companyTIC = $companyInfo->tic_code;
        $this->companyVAT = $companyInfo->vat_code;
    }

    public function dbConnectionStart(){
        $this->db = new mysqli($this->dbLocalhost,$this->dbUsername,$this->dbPassword,$this->dbName);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
        $this->db->begin_transaction();
    }

    public function dbConnectionEnd(){
        $this->db->commit(true);
    }

    private function query($query){
        $stmt = $this->db->prepare("$query");
        $stmt-> execute();
        $result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        return $result;
    }

    public function invoiceObjectByID($invoiceID){

        $object      = (object)$this->query("SELECT * FROM Invoices INNER JOIN Customers ON (Invoices.customer_id=Customers.customer_id) WHERE Invoices.invoice_id='$invoiceID' LIMIT 1")[0];
        $lines       = $this->query("SELECT * FROM Invoice_Item INNER JOIN Items ON (Invoice_Item.item_id=Items.item_id) LEFT JOIN Vats ON (Vats.vat_id=Invoice_Item.vat_id) WHERE Invoice_Item.invoice_id='$invoiceID'");

        $lineObjects = array();

        foreach ($lines as $line){
            array_push($lineObjects,(object)$line);
        }

        $object->lines = $lineObjects;

        return $object;
    }

    public function jiniusInvoiceByCopObject($invoiceObject)
    {

        $globalDiscount = 0;

        if(strcmp($invoiceObject->due_date,'0000-00-00')==0){$invoiceObject->due_date = $invoiceObject->invoice_date;}

        $result = new stdClass();
        $result->kind = 'Invoice';
        $result->documentNumber = $invoiceObject->invoice_code;
        $result->issueDate = $invoiceObject->invoice_date;
        $result->modificationDate = $invoiceObject->invoice_date;
        $result->dueDate = $invoiceObject->due_date;
        $result->description = $invoiceObject->details;
        $result->issuerVatNumber = $this->companyVAT;
        $result->issuerCompanyRegistrationNumber = $this->companyTIC;
//        $result->recipientVatNumber = $invoiceObject->vat_code;
//        $result->recipientCompanyRegistrationNumber = $invoiceObject->tic_code;
        $result->recipientVatNumber = '33884411C';
        $result->recipientCompanyRegistrationNumber = 'CY33884411';
        $result->lineItems = array();


        foreach ($invoiceObject->lines as $invoiceItem){
            $invoiceItemObject = (object)$invoiceItem;
            if($invoiceItemObject->unit_price == 0){continue;}

//            $globalDiscount -= $invoiceItemObject->global_discount;
            $lineDiscount = round($invoiceItemObject->line_discount + $invoiceItemObject->global_discount,12);
            $lineDiscountPercentageCalculation = round($lineDiscount / ($invoiceItemObject->unit_price * $invoiceItemObject->qty) * 100,4);
            $invoiceItemObject->qty /= $invoiceItemObject->subunits;

            $resultLine = new stdClass();
            $resultLine->code = preg_replace("/[^A-Za-z0-9-]/", '',$invoiceItemObject->item_code);
            $resultLine->description = $invoiceItemObject->name;
            $resultLine->quantity = $invoiceItemObject->qty;
            if($invoiceItemObject->subunits > 1){
                $resultLine->unit = 'Boxes';
            } else {
                $resultLine->unit = 'Pieces';
            }
            $resultLine->price = $invoiceItemObject->unit_price;
            $resultLine->discountPercentage = $lineDiscountPercentageCalculation;
            $resultLine->taxPercentage = $this->jiniusVatIDs((int)$invoiceItemObject->percentage);
            $resultLine->discount = $lineDiscount;
            $resultLine->lineTotal = round(($invoiceItemObject->unit_price * $invoiceItemObject->qty) - $lineDiscount + $invoiceItemObject->vat_amount,3);
            $resultLine->taxAmount = $invoiceItemObject->vat_amount;
            array_push($result->lineItems,$resultLine );
        }

//        if($globalDiscount < 0){
//            $resultLine = new stdClass();
//            $resultLine->code = 'DISC';
//            $resultLine->description = 'Discount';
//            $resultLine->quantity = '1';
//            $resultLine->unit = 'Pieces';
//            $resultLine->price = $globalDiscount;
//            $resultLine->discountPercentage = 0;
//            $resultLine->taxPercentage = 4;
//            $resultLine->discount = 0;
//            $resultLine->lineTotal = $globalDiscount;
//            $resultLine->taxAmount = $globalDiscount*0.19;
//            array_push($result->lineItems,$resultLine );
//        }

        $result->net = $invoiceObject->subtotal - $invoiceObject->discount_amount;
        $result->vatAmount = $invoiceObject->vat_amount;
        $result->totalAmount = $invoiceObject->grand_total;
        $result->discount = $invoiceObject->discount_amount;
        $result->initial = $invoiceObject->subtotal;

        return $result;

    }

//    public function jiniusInvoiceObjectByID($invoiceID)
//    {
//        $invoiceObject = (object)$this->query("SELECT * FROM Invoices INNER JOIN Customers ON (Invoices.customer_id=Customers.customer_id) WHERE Invoices.invoice_id='$invoiceID' LIMIT 1")[0];
//        $invoiceObject->lines  = $this->query("SELECT * FROM Invoice_Item INNER JOIN Items ON (Invoice_Item.item_id=Items.item_id) LEFT JOIN Vats ON (Vats.vat_id=Invoice_Item.vat_id) WHERE Invoice_Item.invoice_id='$invoiceID'");
//
//        $globalDiscount = 0;
//
//        if(strcmp($invoiceObject->due_date,'0000-00-00')==0){$invoiceObject->due_date = $invoiceObject->invoice_date;}
//
//        $result = new stdClass();
//        $result->kind = 'Invoice';
//        $result->documentNumber = $invoiceObject->invoice_code;
//        $result->issueDate = $invoiceObject->invoice_date;
//        $result->modificationDate = $invoiceObject->invoice_date;
//        $result->dueDate = $invoiceObject->due_date;
//        $result->description = $invoiceObject->details;
//        $result->issuerVatNumber = $this->companyVAT;
//        $result->issuerCompanyRegistrationNumber = $this->companyTIC;
////        $result->recipientVatNumber = $invoiceObject->vat_code;
////        $result->recipientCompanyRegistrationNumber = $invoiceObject->tic_code;
//        $result->recipientVatNumber = '33884411C';
//        $result->recipientCompanyRegistrationNumber = 'CY33884411';
//        $result->lineItems = array();
//
//
//        foreach ($invoiceObject->lines as $invoiceItem){
//            $invoiceItemObject = (object)$invoiceItem;
//            if($invoiceItemObject->unit_price == 0){continue;}
//
////            $globalDiscount -= $invoiceItemObject->global_discount;
//            $lineDiscount = round($invoiceItemObject->line_discount + $invoiceItemObject->global_discount,12);
//            $lineDiscountPercentageCalculation = round($lineDiscount / ($invoiceItemObject->unit_price * $invoiceItemObject->qty) * 100,4);
//            $invoiceItemObject->qty /= $invoiceItemObject->subunits;
//
//            $resultLine = new stdClass();
//            $resultLine->code = preg_replace("/[^A-Za-z0-9-]/", '',$invoiceItemObject->item_code);
//            $resultLine->description = $invoiceItemObject->name;
//            $resultLine->quantity = $invoiceItemObject->qty;
//            $resultLine->unit = 'Pieces';
//            $resultLine->price = $invoiceItemObject->unit_price;
//            $resultLine->discountPercentage = $lineDiscountPercentageCalculation;
//            $resultLine->taxPercentage = $this->jiniusVatIDs((int)$invoiceItemObject->percentage);
//            $resultLine->discount = $lineDiscount;
//            $resultLine->lineTotal = round(($invoiceItemObject->unit_price * $invoiceItemObject->qty) - $lineDiscount + $invoiceItemObject->vat_amount,2);
//            $resultLine->taxAmount = $invoiceItemObject->vat_amount;
//            array_push($result->lineItems,$resultLine );
//        }
//
////        if($globalDiscount < 0){
////            $resultLine = new stdClass();
////            $resultLine->code = 'DISC';
////            $resultLine->description = 'Discount';
////            $resultLine->quantity = '1';
////            $resultLine->unit = 'Pieces';
////            $resultLine->price = $globalDiscount;
////            $resultLine->discountPercentage = 0;
////            $resultLine->taxPercentage = 4;
////            $resultLine->discount = 0;
////            $resultLine->lineTotal = $globalDiscount;
////            $resultLine->taxAmount = $globalDiscount*0.19;
////            array_push($result->lineItems,$resultLine );
////        }
//
//        $result->net = $invoiceObject->subtotal - $invoiceObject->discount_amount;
//        $result->vatAmount = $invoiceObject->vat_amount;
//        $result->totalAmount = $invoiceObject->grand_total;
//        $result->discount = $invoiceObject->discount_amount;
//        $result->initial = $invoiceObject->subtotal;
//
//        return $result;
//
//    }

    public function curlPostRequest($json){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://concopius.com/connector/request.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_HTTPHEADER, array('Content-Type: application/json'),
            CURLOPT_POSTFIELDS => array('json'=>$json),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return $response;
    }

    private function jiniusVatIDs($percent)
    {
        switch($percent){
            case '0':
                $vatID = 0;
                break;
            case '5':
                $vatID = 2;
                break;
            case '9':
                $vatID = 3;
                break;
            case '19':
                $vatID = 4;
                break;
            default:
                $vatID = 4;
        }

        return $vatID;
    }

    private function vatVerbalPercent($number)
    {
        list($integer, $fraction) = explode(".", (string) $number);

        $output = "";

        if ($integer{0} == "-")
        {
            $output = "negative ";
            $integer    = ltrim($integer, "-");
        }
        else if ($integer{0} == "+")
        {
            $output = "positive ";
            $integer    = ltrim($integer, "+");
        }

        if ($integer{0} == "0")
        {
            $output .= "zero";
        }
        else
        {
            $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
            $group   = rtrim(chunk_split($integer, 3, " "), " ");
            $groups  = explode(" ", $group);

            $groups2 = array();
            foreach ($groups as $g)
            {
                $groups2[] = $this->convertThreeDigit($g{0}, $g{1}, $g{2});
            }

            for ($z = 0; $z < count($groups2); $z++)
            {
                if ($groups2[$z] != "")
                {
                    $output .= $groups2[$z] . $this->convertGroup(11 - $z) . (
                        $z < 11
                        && !array_search('', array_slice($groups2, $z + 1, -1))
                        && $groups2[11] != ''
                        && $groups[11]{0} == '0'
                            ? " and "
                            : ", "
                        );
                }
            }

            $output = rtrim($output, ", ");
        }

        if ($fraction > 0)
        {
            $output .= " point";
            for ($i = 0; $i < strlen($fraction); $i++)
            {
                $output .= " " . $this->convertDigit($fraction{$i});
            }
        }

        return ucfirst(trim($output)).'Percent';
    }

    private function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

    private function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= $this->convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= $this->convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= $this->convertDigit($digit3);
    }

    return $buffer;
}

    private function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = $this->convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

    private function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}


}