<?php

class Woocommerce{
    private $url;
    private $consumerKey;
    private $consumerSecret;



    function setURL($url){$this->url = $url;}
    function setConsumerKey($consumerKey){$this->consumerKey = $consumerKey;}
    function setConsumerSecret($consumerSecret){$this->consumerSecret = $consumerSecret;}



    function getURL(){return $this->url;}
    function gwtConsumerKey(){return $this->consumerKey;}
    function getConsumerSecret(){return $this->consumerSecret;}


    function __construct($baseUrl,$consumerKey,$consumerSecret){
        $this->setURL($baseUrl);
        $this->setConsumerKey($consumerKey);
        $this->setConsumerSecret($consumerSecret);
    }

    function requestData($action,$filterData=''){
        if (strcmp($filterData,'')!=0){
            $filterData = '/'.$filterData;
        }else{
            $filterData = '';
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL =>  'https://'.$this->url.'/wp-json/wc/v3/'.$action.$filterData,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '. base64_encode($this->consumerKey . ":" . $this->consumerSecret)
            ),
        ));
        $response = curl_exec($curl);
        return $response;
    }
    function postData($action,$data){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL =>  'https://'.$this->url.'/wp-json/wc/v3/'.$action,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '. base64_encode($this->consumerKey . ":" . $this->consumerSecret),
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        return $response;
    }
    function putData($action,$data,$filterData){
        if (strcmp($filterData,'')!=0){
            $filterData = '/'.$filterData;
        }else{
            return 'error';
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL =>  'https://'.$this->url.'/wp-json/wc/v3/'.$action.$filterData,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_POSTFIELDS =>json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '. base64_encode($this->consumerKey . ":" . $this->consumerSecret),
                'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        return $response;
    }

}

?>