<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Warehouse.php');
require_once('../../../backend/core/model/WarehouseTransaction.php');
require_once('../../../backend/core/model/WarehouseTransactionItem.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/DocumentStatus.php');


function outboundWarehouseTransactions($db, $client)
{
    $warehouseTransactions = $db->getDocumentForExports("Transfers", true, "AND warehouse_transaction_id = 20081 LIMIT 1 ");

    foreach ($warehouseTransactions as $warehouseTransaction){

        $data = new stdClass();
        $data->CURDATE = $warehouseTransaction->transactionDate ;
        $data->WARHSNAME = $db->getWarehouseObjectByID($warehouseTransaction->warehouseIdFrom)->warehouseCode ;
        $data->TOWARHSNAME = $db->getWarehouseObjectByID($warehouseTransaction->warehouseIdTo)->warehouseCode ;
        $data->BOOKNUM = $warehouseTransaction->warehouseTransactionCode ;
        $data->DETAILS = $warehouseTransaction->details ;
        $data->TRANSORDER_T_SUBFORM = array();

        foreach($warehouseTransaction->warehouseTransactionItems as $warehouseTransactionItem){
            $itemObject = $db->getItemObjectByID($warehouseTransactionItem->itemID);
            $dataItem = new stdClass();
            $dataItem->PARTNAME = $itemObject->itemCode;
            $dataItem->PDES = $itemObject->name;
            $dataItem->SERIALNAME = $warehouseTransactionItem->batchNumber;
            $dataItem->QUANT = (float)$warehouseTransactionItem->qty;

            array_push($data->TRANSORDER_T_SUBFORM,$dataItem);
        }


        $dataResponse = $client->sendPostData("DOCUMENTS_T",json_encode($data));


        $erpDocumentCode = $dataResponse->DOCNO;

        if(strcmp($erpDocumentCode,'')!=0){
            $erpErrorStatus  = 1;
            $erpErrorMessage = "OK";
        } else {
            $erpErrorStatus  = -1;
            $erpErrorMessage = json_encode($dataResponse);
        }

        $documentStatus = new DocumentStatus(
            $id         = $warehouseTransaction->warehouseTransactionID,
            $table      = $db->getDocumentStatusTypeByTable("Transfers"),
            $status     = $erpErrorStatus,
            $reason     = $erpErrorMessage,
            $exportID   = 0,
            $exportCode = $erpDocumentCode
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
        $client->complete();
    }


}



?>
