<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Return.php');
require_once('../../../backend/core/model/ReturnItem.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/DocumentStatus.php');


function outboundReturns($db, $client)
{
    $returns = $db->getDocumentForExports("Returns", true, "AND return_id > 0 LIMIT 1 ");

    foreach ($returns as $return){

        $data = new stdClass();
        $data->BOOKNUM      = $return->returnCode;
        $data->CUSTNAME     = $db->getCustomerObjectByID($return->customerID)->customerCode;
        $data->CURDATE      = $return->returnDate;
        $data->ORDERITEMS_SUBFORM   = array();

        foreach ($return->returnItems as $returnLine) {

            $item = $db->getItemObjectByID($returnLine->itemID);

            $dataItem = new stdClass();
            $dataItem->PARTNAME = $item->itemCode;
            $dataItem->TQUANT   = -(float)$returnLine->qty;
            $dataItem->DUEDATE  = $returnLine->returnDate;
            $dataItem->SERIALNAME =  $returnLine->batchNumber;
            array_push($data->ORDERITEMS_SUBFORM,$dataItem);
        }

        $dataResponse = $client->sendPostData("ORDERS",json_encode($data));


        $erpDocumentCode = $dataResponse->ORDNAME;

        if(strcmp($erpDocumentCode,'')!=0){
            $erpErrorStatus = 1;
            $erpErrorMessage = "OK";
        } else {
            $erpErrorStatus = -1;
            $erpErrorMessage = json_encode($dataResponse);
        }

        $documentStatus = new DocumentStatus(
            $id         = $return->returnID,
            $table      = $db->getDocumentStatusTypeByTable("Returns"),
            $status     = $erpErrorStatus,
            $reason     = $erpErrorMessage,
            $exportID   = 0,
            $exportCode = $erpDocumentCode
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
        $client->complete();
    }



}



?>
