<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');


require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/CustomerAddress.php');
require_once('../../../backend/core/model/CustomerGroup.php');


function outboundCustomers($db, $client)
{
    $customers = $db->getMultipleCustomerObjectsByFilter('type_of_business','Lead');

    foreach ($customers as $customer) {
        $address = $db->getAddressObjectByCustomerID($customer->customerID);
        $customerGroups = $db->getCustomerGroupObjectsByCustomerID($customer->customerID);

        $salespersonCode = '';
        foreach ($customerGroups as $customerGroup){
            if(strcmp($customerGroup->description,'AGENTCODE')==0){
                $salespersonCode = $customerGroup->groupCode;
            }
        }
        if(strcmp(trim($customer->vatCode),'')==0){
            $taxCode = 'S-CY';
        } else {
            $taxCode = $customer->vatCode;
        }

        $taxCode = 'S-CY';

        $data = new stdClass();
        $data->DEXT_COPRIMENUM = "$customer->customerCode";
        $data->AGENTCODE = "$salespersonCode";
        $data->CUSTDES  = "$customer->companyName";
        $data->BRANCHNAME   = "$address->city";
        $data->TAXCODE      = "$taxCode";

        $data->PHONE     = "$address->landline";
        $data->FAX       = "$address->fax";
        $data->EMAIL     = "$customer->email";
        $data->COUNTRYNAME   = "$address->country";

        $data->ZIP  = "$address->postcode";
        $data->ADDRESS   = "$address->city";
        $data->ADDRESS2  = "$address->addressLine1";
        $data->ADDRESS3  = "$address->addressLine2";
        $data->GPSX      = "$address->lat";
        $data->GPSY      = "$address->lng";

        $data->PAYCODE    = "";
        $data->BRANCHNAME = "";
        $data->SPEC1      = "";
        $data->SPEC2      = "";
        $data->SPEC3      = "";

        $dataResponse = $client->sendPostData("CUSTOMERS",json_encode($data));

        if(strcmp(trim($dataResponse->CUSTNAME),'')!=0) {
            $customer->customerCode = "$dataResponse->CUSTNAME";
            $customer->typeOfBusiness = 'LeadERP';
            $client->log($db->updateCustomerByObjectID($customer, $excludeUpdateColumns = array(), $deleteRecordsNotSent = array()), 'CUSTOMERS');

        }
        $client->complete();
    }



}



?>
