<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);



getStatementAPI($_POST['customerCode'],$_POST['dateFrom'],$_POST['dateTo'],$_POST['username'],$_POST['password'],$_POST['type']);

function getStatementAPI($customerCode,$dateFrom,$dateTo,$conAuthUsername,$conAuthPassword,$conAuthType)
{

    ob_start();
    require_once('../../ConnectionAuth.php');
    require_once('../../../concc/dbinfo.php');
    require_once('../../InterfaceLogger.php');
    require_once('../../InterfaceSettingsHandler.php');
    require_once('../../../backend/core/model/Database.php');
    require_once('../../../backend/core/model/Customer.php');

    require_once('../BasicAuthClient.php');

    $_GET['username'] = $conAuthUsername;
    $_GET['password'] = $conAuthPassword;
    $_GET['type']     = $conAuthType;

    $auth = new ConnectionAuth($_GET, $_POST);
    $db = $auth->connect(basename(__DIR__));
    $cData = $auth->getErpConnectionData('PRIORITY_REST_API');
    $cLog = $auth->getConnectionLog();

    $client = new BasicAuthClient($cData, $cLog);

    if (!$db) {
        return;
    }
    if (!$cData) {
        return;
    }

    $explodeDateFrom = explode('-',$dateFrom);
    $explodeDateTo   = explode('-',$dateTo);

    $yearFrom  = $explodeDateFrom[0];
    $monthFrom = $explodeDateFrom[1];

    $yearTo  = $explodeDateTo[0];
    $monthTo = $explodeDateTo[1];

    $statement = new stdClass();
    $statement->ACCNAME = $customerCode;
    $statement->FROMPRD = (int)$monthFrom;
    $statement->FROMGLNAME = "$yearFrom";
    $statement->TOPRD = (int)$monthTo;
    $statement->TOGLNAME = "$yearTo";


    $dataPost = $client->sendPostData("DEXT_CUSTSTMT", json_encode($statement));


    $urlFilters = 'DEXT_CUSTSTMT?$filter=ACCNAME eq \'' . $statement->ACCNAME .
        '\' and FROMPRD eq ' . $statement->FROMPRD .
        ' and FROMGLNAME eq \'' . $statement->FROMGLNAME .
        '\' and TOPRD eq ' . $statement->TOPRD .
        ' and TOGLNAME eq \'' . $statement->TOGLNAME . '\'';

    $urlFilters = str_replace(' ', '%20', $urlFilters);

    $dataResponse = $client->requestData($urlFilters,false)->value[0];
    $client->complete();

    ob_end_clean();
    echo base64_decode(explode('data:application/pdf;base64,', $dataResponse->STMT_EXTFILENAME)[1]);

}
?>