<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Tender.php');
require_once('../../../backend/core/model/TenderItem.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/DocumentStatus.php');

function inboundTenders($db, $client)
{
    $filter = '?$filter=STATDES ne \'Draft\'';
    $filter.= '&$expand=CPROFITEMS_SUBFORM';
    $filter.= '&$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData("CPROF".$filter);

    foreach ($response->value as $data) {

        if($db->checkExist('Documents_Status',array('type'=>$db->getDocumentStatusTypeByTable('Tenders'),'export_code'=>$data->CPROFNUM)))  {

            $existingID   = $db->getData()->id;
            $existingCode = $db->getTenderObjectByID($existingID,false)->tenderCode;
            $client->log(array('Documents_Status'=>"[".date('Y-m-d H:i:s')."] Tender Exists (Coprime Tender Code: $existingCode ).\n"));
            continue;

        }



        $customerID    = $db->getCustomerObjectByCode("$data->CUSTNAME")->customerID;
        $discountPrice = (float)$data->QPRICE - (float)$data->DISPRICE;

        $tender = new Tender(
            $tenderID           = "",
            $tenderCode         = "$data->CPROFNUM",
            $companyID          = "1",
            $salesPersonID      = "0",
            $customerID         = "$customerID",
            $tenderDate         = "$data->PDATE",
            $validUntil         = "$data->EXPIRYDATE",
            $name               = "",
            $addressLine1       = "",
            $addressLine2       = "",
            $city               = "",
            $country            = "",
            $region             = "",
            $subTotal           = "$data->QPRICE",
            $grandTotal         = "$data->TOTPRICE",
            $vatAmount          = "$data->VAT",
            $discountAmount     = "$discountPrice",
            $status             = "$data->STATDES",
            $vatIorE            = "",
            $printCount         = "0",
            $details            = "$data->BYPROFNUM",
            $currencyID         = "0",
            $deliveryMethod     = "",
            $globalDiscPercent  = "$data->PERCENT",
            $currentVersion     = "",
            $editedBy           = "0",
            $actionHash         = "",
            $actionTime         = "",
            $tenderItems        = array()
        );

        foreach ($data->CPROFITEMS_SUBFORM as $dataItem) {

            $item = $db->getItemObjectByCode("$dataItem->PARTNAME");

            $vatID             = $item->vatID;
            $itemID            = $item->itemID;
            $itemSubunits      = $item->subunits;
            $vatPrice          = (float)$dataItem->TOTPRICE - (float)$dataItem->QPRICE;
            $lineDiscountPrice = (float)$dataItem->TQUANT * ((float)$dataItem->PRICE - (float)$dataItem->PERCENTPRICE);
            $unitPrice         = (float)$dataItem->PRICE * $itemSubunits;

            $discountPrice += $lineDiscountPrice;

            $tender->addTenderItem(
                new TenderItem(
                    $tenderItemID    = "",
                    $tenderID        = "",
                    $itemID          = "$itemID",
                    $qty             = "$dataItem->TQUANT",
                    $unitPrice       = "$unitPrice",
                    $lineDiscount    = "$lineDiscountPrice",
                    $globalDiscount  = "",
                    $lineDiscPercent = "$dataItem->PERCENT",
                    $vatAmount       = "$vatPrice",
                    $priceTypeID     = "0",
                    $vatID           = "$vatID",
                    $description     = "$dataItem->PDES",
                    $promotionID     = "",
                    $promotionNumber = "",
                    $masterItem      = ""
                )
            );
        }
        $tender->setDiscountAmount($discountPrice);
        $tender->setSubTotal((float)$data->QPRICE + $discountPrice);
        $tender->setActionHash($db->hashObject($tender));
        $tender->setActionTime(date('Y-m-d H:i:s'));


        $excludeUpdateColumns=array(
            'Tenders' => array('action_time')
        );

        $deleteRecordsNotSent=array(

        );

        $client->log($db->insertUpdateTenderByObject($tender,$excludeUpdateColumns,$deleteRecordsNotSent));

        $documentStatus = new DocumentStatus(
            $id         = $db->getTenderObjectByCode($data->CPROFNUM,false)->tenderID,
            $table      = $db->getDocumentStatusTypeByTable("Tenders"),
            $status     = 100,
            $reason     = 'Imported From ERP',
            $exportID   = 100,
            $exportCode = $data->CPROFNUM
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
    }
    $client->complete();
}

/**
 * custom Functions
 */



?>