<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Receipt.php');
require_once('../../../backend/core/model/ReceiptItem.php');
require_once('../../../backend/core/model/DocumentStatus.php');

function inboundReceipts($db, $client)
{

    $filter = '?$filter=STATDES eq \'Final\' and BOOKNUM eq \'\'';
    $filter.= '&$expand=TPAYMENT_SUBFORM';
    $filter.= '&$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('TINVOICES'.$filter);

    foreach ($response->value as $data) {

        if($db->checkExist('Documents_Status',array('type'=>$db->getDocumentStatusTypeByTable('Receipts'),'export_code'=>$data->IVNUM)))  {

            $existingID   = $db->getData()->id;
            $existingCode = $db->getReceiptObjectByID($existingID,false)->receiptCode;
            $client->log(array('Documents_Status'=>"[".date('Y-m-d H:i:s')."] Receipt Exists (Coprime Receipt Code: $existingCode ).\n"));
            continue;

        }

        $customerID    = $db->getCustomerObjectByCode("$data->CUSTNAME")->customerID;
        $salespersonID = $db->getSalesPersonIDByCode("$data->AGENTCODE");


        if(count($data->TPAYMENT_SUBFORM) >= 1){
            $paymentMethod = 'Cheque';
            foreach ($data->TPAYMENT_SUBFORM as $payment) {
                $bank = $payment->BANKNAME;
                $branch = $payment->BRANCH;
                $chequeNumber = $payment->CARDNUM;
                $chequeDate = explode('T',$payment->PAYDATE)[0];
            }

        }  else {
            $bank = '';
            $branch = '';
            $chequeNumber = '';
            $chequeDate = '';
            $paymentMethod = 'Cash';
        }

        $receipt = new Receipt(
            $receiptID          = "",
            $receiptCode        = "$data->IVNUM",
            $customerID         = "$customerID",
            $companyID          = "1",
            $salespersonID      = "$salespersonID",
            $orderID            = "0",
            $invoiceID          = "0",
            $addressID          = "0",
            $amount             = "$data->TOTPRICE",
            $paymentMethod      = "$paymentMethod",
            $cashDiscount       = "0",
            $bank               = "$bank",
            $branch             = "$branch",
            $chequeNumber       = "$chequeNumber",
            $chequeDate         = "$chequeDate",
            $receiptDate        = "$data->IVDATE",
            $notes              = "$data->DETAILS",
            $status             = "$data->STATDES",
            $actionHash         = "",
            $actionTime         = "",
            $receiptItems      = array()
        );




        $receipt->setActionHash($db->hashObject($receipt));
        $receipt->setActionTime(date('Y-m-d H:i:s'));


        $excludeUpdateColumns=array(
            'Receipts' => array('action_time')
        );

        $deleteRecordsNotSent=array(

        );

        $db->displayObject($receipt);
        $client->log($db->insertUpdateReceiptByObject($receipt,$excludeUpdateColumns,$deleteRecordsNotSent));

        $documentStatus = new DocumentStatus(
            $id         = $db->getReceiptObjectByCode($data->IVNUM,false)->receiptID,
            $table      = $db->getDocumentStatusTypeByTable("Receipts"),
            $status     = 100,
            $reason     = 'Imported From ERP',
            $exportID   = 100,
            $exportCode = $data->IVNUM
        );

        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
    }
    $client->complete();
}

/**
 * custom Functions
 */



?>