<?php
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/CustomerAddress.php');
require_once('../../../backend/core/model/CustomerGroup.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/Schedule.php');
require_once('../../../backend/core/model/ScheduleCustomer.php');
require_once('../../../backend/core/model/ContactPerson.php');


function inboundCustomers($db,$client)
{

    $filter = '?$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('CUSTOMERS'.$filter);

    foreach ($response->value as $data){

        $typeOfBusinessValue = 'Credit';
        if(strcmp($data->STATDES,'Inactive')==0){$typeOfBusinessValue=$data->STATDES;}


        $customer = new Customer(
            $customerID          = "",
            $customerCode        = "$data->CUSTNAME",
            $companyName         = "$data->CUSTDES",
            $reportName          = "$data->CUSTDESLONG",
            $logo                = "",
            $registrationCode    = "",
            $mobile              = "$data->PHONE",
            $website             = "",
            $email               = "$data->EMAIL",
            $description         = "$data->PAYDES",
            $typeOfBusiness      = "$typeOfBusinessValue",
            $ticCode             = "",
            $vatCode             = "$data->TAXCODE",
            $creditLimit         = "$data->MAX_CREDIT",
            $typeOfCustomer      = "Credit",
            $balance             = "",
            $addressCodeEurosoft = "$data->BUSINESSTYPE"
        );


        $customer->addCustomerAddress(
            new CustomerAddress(
                $addressID      = "",
                $addressCode    = "$data->CUSTNAME",
                $customerID     = "",
                $country        = "$data->COUNTRYNAME",
                $city           = "$data->STATEA",
                $addressLine1   = "$data->ADDRESS",
                $addressLine2   = "",
                $postcode       = "$data->ZIP",
                $region         = "$data->STATENAME",
                $lat            = "$data->GPSX",
                $lng            = "$data->GPSY",
                $pobox          = "",
                $landline       = "$data->PHONE",
                $fax            = "$data->FAX",
                $primaryAddress = "yes"
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->AGENTCODE)),
                $name        = "$data->AGENTCODE",
                $description = "AGENTCODE",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->BUSINESSTYPE)),
                $name        = "$data->BUSINESSTYPE",
                $description = "BUSINESSTYPE",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC1)),
                $name        = "$data->SPEC1",
                $description = "SPEC1",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC2)),
                $name        = "$data->SPEC2",
                $description = "LEVEL1",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC3)),
                $name        = "$data->SPEC3",
                $description = "SPEC3",
                $creationDate = date('Y-m-d')
            )
        );

        $customer->addCustomerGroup(
            new CustomerGroup(
                $groupID     = "",
                $groupCode   = "".str_replace(' ','_',strtoupper($data->SPEC4)),
                $name        = "$data->SPEC4",
                $description = "SPEC4",
                $creationDate = date('Y-m-d')
            )
        );

        $excludeUpdateColumns = array(
            'Customers'       => array('balance'),
            'CustomerAddress' => array('lat','lng'),
            'CustomerGroups'  => array()
        );


        $deleteRecordsNotSent = array(
            'CustomerAddress' => true,
            'CustomerGroups'  => true
        );

        $client->log($db->insertUpdateCustomerByObject($customer,$excludeUpdateColumns,$deleteRecordsNotSent),'CUSTOMERS');


        $paymentType = new PaymentType(
            $paymentTypeID   = "",
            $paymentTypeCode = "$data->PAYCODE",
            $name            = "$data->PAYDES"
        );

        $client->log($db->insertUpdatePaymentTypeByObject($paymentType,$excludeUpdateColumns=array(),$deleteRecordsNotSent=array()),'PAYMENT TYPES');


        $contactPersonsResponse = $client->requestData("CUSTOMERS('$data->CUSTNAME')/CUSTPERSONNEL_SUBFORM",false);

        foreach ($contactPersonsResponse->value as $contactPersonData) {
            $contactPerson = new ContactPerson(
                $id         = "",
                $firstName  = "$contactPersonData->FIRSTNAME",
                $lastName   = "$contactPersonData->LASTNAME",
                $position   = "$contactPersonData->TITLEDES",
                $landline   = "$contactPersonData->PHONENUM",
                $mobile     = "$contactPersonData->CELLPHONE",
                $fax        = "$contactPersonData->FAX",
                $email      = "$contactPersonData->EMAIL",
                $notes      = "$contactPersonData->STATDES",
                $customerID = "" . $db->getCustomerObjectByCode("$data->CUSTNAME")->customerID
            );

            $client->log($db->insertUpdateContactPersonByObject($contactPerson, $excludeUpdateColumns = array(), $deleteRecordsNotSent = array()), 'CONTACT PERSONS');

        }

        $data = inboundCustomersAfterDbInsertBeforeNextCustomerLoop($data,$customer);


    }

    $client->complete();
}

/**
 * custom Functions
 */

function inboundCustomersAfterDbInsertBeforeNextCustomerLoop($data,$customer){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

?>