<?php
class BasicAuthClient{

    private $ipRest;
    private $portRest;
    private $usernameRest;
    private $passwordRest;
    private $response;

    private $daysBack;
    private $log;
    private $erpImportID;
    private $erpImportLog;
    private $erpErrorEmail;
    private $db;

    public function getErpErrorEmail()
    {
        return $this->erpErrorEmail;
    }

    public function getDaysBack()
    {
        return $this->daysBack;
    }


    public function setDaysBack($daysBack)
    {
        $this->daysBack = $daysBack;
        return $this;
    }

    public function getDateFilter()
    {
        $daysBack = (int)$this->daysBack;
        if($daysBack > 0){
            $dateFilter = date('Y-m-d',strtotime(date('Y-m-d') . "-$daysBack days"));
        } else {
            $dateFilter = date('Y-m-d');
        }

        return $dateFilter;
    }

    public function __construct($cData,$cLog)
    {
        InterfaceLogger::start();
        if($cData !== false) {
            $this->ipRest = $cData->erp_host;
            $this->portRest = $cData->erp_port;
            $this->usernameRest = $cData->erp_username;
            $this->passwordRest = $cData->erp_identifier;
            $this->erpImportID = $cData->erp_import_id;
            $this->daysBack = $cData->daysBack;
            $this->erpErrorEmail = $cData->erp_error_mail;
            $this->db = $cData->db;
        } else {
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","connection","ERP Connection");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","analytic","ERP Connection");
        }
    }


    function requestData($url,$NewErpImportLog = true){

        try {

            $portDelimiter = '';
            $logUrl = explode('?',$url)[0];
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Request: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Request: $this->ipRest:$this->portRest/$url\n","analytic","$logUrl");

            if($NewErpImportLog) {
                $this->erpImportLog = new ErpImport("$logUrl", "", '', '0', '0', '0', "", "", "", "");
                $this->db->resetAffectedRecords();
                $this->erpImportLog->start($this->db, "$this->log", "$this->erpImportID");
            }

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest . '/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json",
                    "authorization: Basic " . base64_encode($this->usernameRest . ":" . $this->passwordRest),
                    "cache-control: no-cache",
                    "content-type: application/json",
                    'Content-Length: 0'
                ),
            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$logUrl)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$logUrl");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$logUrl");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function sendPostData($url,$json){
        try {
            $portDelimiter = '';
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Send Data: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("$this->log","analytic","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Data Json: $json\n","analytic","$url");

            $this->erpImportLog = new ErpImport( "$url", "", '','0','0','0',"","", "", "");
            $this->db->resetAffectedRecords();
            $this->erpImportLog->start($this->db,"$this->log","$this->erpImportID");

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest . '/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json",
                    "authorization: Basic " . base64_encode($this->usernameRest . ":" . $this->passwordRest),
                    "cache-control: no-cache",
                    "content-type: application/json"
                )

            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$url)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$url");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function sendPatchData($url,$json){
        try {
            $portDelimiter = '';
            if(strcmp(trim($this->portRest),"")!=0){$portDelimiter = ":";}
            $this->log = "[".date('Y-m-d H:i:s')."] Send (Patch) Data: ".$this->ipRest.$portDelimiter.$this->portRest."/$url\n";
            InterfaceLogger::log("$this->log","analytic","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Data Json: $json\n","analytic","$url");

            $this->erpImportLog = new ErpImport( "$url", "", '','0','0','0',"","", "", "");
            $this->db->resetAffectedRecords();
            $this->erpImportLog->start($this->db,"$this->log","$this->erpImportID");

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $this->ipRest . '/' . $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PATCH',
                CURLOPT_POSTFIELDS => $json,
                CURLOPT_HTTPHEADER => array(
                    "accept: application/json",
                    "authorization: Basic " . base64_encode($this->usernameRest . ":" . $this->passwordRest),
                    "cache-control: no-cache",
                    "content-type: application/json"
                )

            ));
            $response = curl_exec($ch);
            curl_close($ch);
            $this->response = $response;
            $this->log .= "[".str_replace('/','_',$url)."] [".date('Y-m-d H:i:s')."] Response: ".substr(trim(preg_replace('/\s\s+/', ' ', $response)),0,150)." \n";
            InterfaceLogger::log($this->log,"connection","$url");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Response: $response\n","analytic","$url");
            return json_decode($response);

        } catch(Exception $e) {
            $this->response = $e;
            $this->log .= "[$url]"." [".date('Y-m-d H:i:s')."] Exception: $e\n";
            InterfaceLogger::log($this->log,"summary","$url");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return $e;

        }

    }

    function log($response,$alterURL=''){
        foreach($response as $url => $text) {
            if(strcmp(trim($alterURL),'')!=0){$url = $alterURL;}
            $url = strtoupper($url);
            InterfaceLogger::log($text, "summary", "$url");
            InterfaceLogger::log($text, "analytic", "$url");
//            $this->erpImportLog->update($this->db,"$text");

        }
        $this->erpImportLog->updateRecordsAffected($this->db,$this->db->affectedRecords,$this->db->deletedRecords,$this->db->deleteStatementRecords);
    }

    function textLog($text){
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "summary", "TEXT LOG");
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "analytic", "TEXT LOG");
    }

    function complete(){
        $this->erpImportLog->end($this->db);
        $this->db->resetAffectedRecords();
    }


}