<?php
require_once('../../../backend/core/model/CustomerGroup.php');


function inboundCustomerGroups(Database $db, AuthTokenClient $client)
{
    $filters = array('Company' => $client->getCompanyCode());
    $filters = json_encode($filters);

    $response = $client->requestData('AccountGroups',$filters);

    foreach ($response->AccountGroups as $data) {


        $customerGroup = new CustomerGroup(
            $groupID = "",
            $groupCode = "$data->Head"."$data->Code",
            $name = "$data->Description",
            $description = "$data->Head",
            $creationDate = ""
        );

        $excludeUpdateColumns = array(
            'Customer_Groups' => array('creation_date')
        );


        $deleteRecordsNotSent = array();

        $client->log($db->insertUpdateCustomerGroupByObject($customerGroup, $excludeUpdateColumns, $deleteRecordsNotSent));


    }
    $client->complete();
}

?>