<?php
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Category.php');

function inboundCategories($db,$client){

    $filters = array('Company' => $client->getCompanyCode());
    $filters = json_encode($filters);

    $response = $client->requestData('Levels',$filters);

    $response = inboundCategoriesAfterRequestDataBeforeEnteringForeach($response);

    foreach ($response->invLevelList as $data){

        $data = inboundCategoriesAfterForeachLoopBeforeCategoryObjectCreation($data);

        $category = new Category(
            $categoryID         = "",
            $categoryCode       = "$data->Head"."$data->Code",
            $categoryName       = "$data->Description",
            $description        = "$data->Head",
            $creationDate       = date('Y-m-d'),
            $allowSubcategories = "yes",
            $allowItems         = "yes",
            $level              = "1",
            $customOrder        = "0"
        );

        $excludeUpdateColumns=array('Categories'=>array('creation_date','custom_order'));

        $deleteRecordsNotSent=array();

        $category = inboundCategoriesAfterObjectCreationBeforeDbInsert($data,$category);

        $client->log($db->insertUpdateCategoryByObject($category,$excludeUpdateColumns,$deleteRecordsNotSent),'CATEGORY');



    }

    $client->complete();
}

/**
 * custom Functions
 */

function inboundCategoriesAfterRequestDataBeforeEnteringForeach($response){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $response;
}

function inboundCategoriesAfterForeachLoopBeforeCategoryObjectCreation($data){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $data;
}

function inboundCategoriesAfterObjectCreationBeforeDbInsert($data,$category){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $category;
}

?>