CREATE TABLE `ZB_Custom_Screen_Fields` ( `custom_screen_field_id` BIGINT NOT NULL , `custom_screen_id` BIGINT NOT NULL , `field_type` VARCHAR(100) NOT NULL , `default_values` TEXT NOT NULL , `from_query` TEXT NOT NULL , `display_name` VARCHAR(100) NOT NULL , `input_value` VARCHAR(100) NOT NULL , `on_click_function` VARCHAR(200) NOT NULL , `on_change_function` VARCHAR(200) NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`custom_screen_field_id`)) ENGINE = InnoDB;
ALTER TABLE `ZB_Custom_Screen_Fields` CHANGE `default_values` `default_values` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
ALTER TABLE `ZB_Custom_Screen_Fields` ADD `field` VARCHAR(100) NOT NULL DEFAULT '' AFTER `custom_screen_id`;
ALTER TABLE `ZB_Custom_Screens` ADD `menu_item_definition_id` BIGINT NOT NULL DEFAULT '0' AFTER `custom_javascript`;
ALTER TABLE `ZB_Custom_Screens` CHANGE `field_type` `field_type` TEXT CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;
ALTER TABLE `Cloud_Configuration` ADD `stock_control_on_documents` VARCHAR(5) NULL DEFAULT 'yes' AFTER `force_desktop_view`;
CREATE TABLE `ZB_Custom_Screen_Controllers` ( `custom_screen_controller_id` BIGINT NOT NULL , `custom_screen_id` BIGINT NOT NULL , `controller_name` VARCHAR(300) NOT NULL , `file_name` VARCHAR(300) NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`custom_screen_controller_id`)) ENGINE = InnoDB;
CREATE TABLE `Filters` ( `filter_id` BIGINT NOT NULL , `filter_code` VARCHAR(100) NOT NULL , `name` VARCHAR(200) NOT NULL , `description` TEXT NOT NULL , `position` INT NOT NULL , `type` VARCHAR(50) NOT NULL , `class` VARCHAR(200) NOT NULL , `css` VARCHAR(200) NOT NULL , `active` VARCHAR(10) NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`filter_id`)) ENGINE = InnoDB;
ALTER TABLE `Filters` CHANGE `description` `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
ALTER TABLE `Filters` CHANGE `name` `name` VARCHAR(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
CREATE TABLE `Filter_Options` ( `filter_option_id` BIGINT NOT NULL , `filter_id` BIGINT NOT NULL , `option_name` VARCHAR(100) NOT NULL , `description` TEXT NOT NULL , `position` INT NOT NULL , `active` VARCHAR(10) NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`filter_option_id`)) ENGINE = InnoDB;
ALTER TABLE `Filter_Options` CHANGE `option_name` `option_name` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
ALTER TABLE `Filter_Options` CHANGE `description` `description` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
CREATE TABLE `Filter_Category` ( `filter_id` BIGINT NOT NULL , `category_id` BIGINT NOT NULL , `position` INT NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`filter_id`, `category_id`)) ENGINE = InnoDB;
CREATE TABLE `Filter_Item` ( `filter_item_id` BIGINT NOT NULL , `item_id` BIGINT NOT NULL , `filter_id` BIGINT(20) NOT NULL , `filter_option_id` INT NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`filter_item_id`)) ENGINE = InnoDB;
ALTER TABLE `Filter_Item` DROP PRIMARY KEY;
ALTER TABLE `Filter_Item` DROP `filter_item_id`;
ALTER TABLE `Filter_Item` ADD PRIMARY KEY( `item_id`, `filter_id`, `filter_option_id`);
CREATE TABLE `Delivery_Cost` ( `min_value` DOUBLE NOT NULL , `delivery_price` DOUBLE NOT NULL , `notes` TEXT NOT NULL , `timestamp` TIMESTAMP on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP , PRIMARY KEY (`min_value`)) ENGINE = InnoDB;
ALTER TABLE `Delivery_Cost` ADD `item_id` BIGINT NOT NULL AFTER `delivery_price`;
CREATE TABLE `Documents_Status_Per_File` (`id` bigint(20) NOT NULL,`type` int(11) NOT NULL COMMENT '0 = Tender 1 = Order',`status` int(11) NOT NULL,`reason` text NOT NULL,`export_id` bigint(20) NOT NULL DEFAULT '0',`export_code` varchar(30) DEFAULT '',`timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8;
ALTER TABLE `Documents_Status_Per_File` ADD PRIMARY KEY (`id`,`type`);
ALTER TABLE `B2B_Configuration` ADD `use_billing_address` VARCHAR(5) NOT NULL DEFAULT 'no' AFTER `categories_display_type`;