<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 11:09
 */
require_once(ROOT . "backend/core/model/Supplier.php");
require_once(ROOT . "backend/core/model/SupplierItems.php");
require_once(ROOT . "backend/core/model/CustomerAddress.php");
//include_once("../../../param.php");

class DBSupplier {

    public $db;

    static private $instance;

    public function __construct()
    {
        $this->db = new mysqli(localhost,username,password,database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
    }

    static public function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new DBSupplier();
        }
        return self::$instance;
    }

    public function getSupplerByID($customerID)
    {
        $customer=null;
        $stm = $this->db->prepare("SELECT customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance,$timestamp);
        while ($stm->fetch()) {
            $customer = new Supplier($customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance);


        }
        $stm-> close();
        return $customer;
    }

    public function getSupplierAddress($customerID)
    {
        $customerAddresses= array();

        $stm =$this->db->prepare("SELECT supplier_address_id,address_code,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp FROM SupplierAddress WHERE supplier_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($customerAddressID,$addressCode,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress,$timestamp);
        while ($stm->fetch()) {

            $customerAddress= new CustomerAddress($customerAddressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress);
            array_push($customerAddresses,$customerAddress);


        }
        $stm-> close();
        return $customerAddresses;
    }

    public function getSupplierItems($customerID)
    {
        $contractPrices= array();
        $stm = $this->db->prepare("SELECT supplier_id,item_id,price,lead_time,timestamp FROM Item_Supplier WHERE supplier_id ='$customerID'");
        $stm-> execute();
        $stm-> bind_result($customerID,$itemID,$price,$leadTime,$timestamp);
        while ($stm->fetch()) {

            $contractPrice = new SupplierItems($customerID,$itemID,$price,$leadTime);
            array_push($contractPrices,$contractPrice);
        }
        $stm-> close();

        return $contractPrices;
    }
    public function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
    {

        $value="";
        $stm = $this->db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($value);
        while ($stm->fetch()) {


        }
        $stm-> close();

        return $value;
    }


}