<?php

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 11/02/2016
 * Time: 11:09
 */
include(ROOT . "backend/core/model/Item.php");
include(ROOT . "backend/core/model/Price.php");
//include_once("../../../param.php");

class DBItem {

    public $db;

    static private $instance;

    public function __construct()
    {
        $this->db = new mysqli(localhost,username,password,database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $this->db->set_charset("utf8");
    }

    static public function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new DBItem();
        }
        return self::$instance;
    }

    public function getItemByID($itemID)
    {
        $item=null;
        $stm = $this->db->prepare("SELECT item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp FROM Items WHERE item_id='$itemID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($itemCode,$itemSku,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$name,$shortDescription,$longDescription,$thumb,$reorderLevel,$targetQTY,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status,$timestamp);
        while ($stm->fetch()) {

            $item = new Item($itemID,$itemCode,$itemSku,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$name,$shortDescription,$longDescription,$thumb,$reorderLevel,$targetQTY,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);


        }
        $stm-> close();
        return $item;
    }


    public function getBarcodesOFItem($itemID)
    {
        $barcodes= array();

        $stm =$this->db->prepare("SELECT barcode FROM Item_Barcode WHERE item_id ='$itemID'");
        $stm-> execute();
        $stm-> bind_result($barcode);
        while ($stm->fetch()) {

             array_push($barcodes,$barcode);


        }
        $stm-> close();
        return $barcodes;
    }

    public function getBarcodesOFItemWithDefaultFlag($itemID)
    {
        $barcodes= array();

        $stm =$this->db->prepare("SELECT barcode,default_barcode FROM Item_Barcode WHERE item_id ='$itemID' ORDER BY default_barcode DESC");
        $stm-> execute();
        $stm-> bind_result($barcodeCode, $defaultBarcode);
        while ($stm->fetch()) {

            $barcode = new stdClass();
            $barcode->barcode = $barcodeCode;
            $barcode->default = $defaultBarcode;


            array_push($barcodes,$barcode);


        }
        $stm-> close();
        return $barcodes;
    }


    public function getCategories($itemID)
    {
        $categories= array();
        $stm = $this->db->prepare("SELECT category_id FROM Category_Item WHERE item_id ='$itemID'");
        $stm-> execute();
        $stm-> bind_result($categoryID);
        while ($stm->fetch()) {


            array_push($categories,$categoryID);
        }
        $stm-> close();

        return $categories;
    }

    public function getCategoriesNewDB($itemID)
    {
        global $username, $password, $database;
        $categories= array();
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm = $db2->prepare("SELECT category_id FROM Category_Item WHERE item_id ='$itemID'");
        $stm-> execute();
        $stm-> bind_result($categoryID);
        while ($stm->fetch()) {


            array_push($categories,$categoryID);
        }
        $stm-> close();

        return $categories;
    }
    function getVatPercentageOfItem($itemID)
    {
        global $username, $password, $database;
        $z = 0;
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm = $db2->prepare("SELECT percentage FROM Items,Vats WHERE item_id='$itemID' AND Items.vat_id=Vats.vat_id LIMIT 1");
        $stm->execute();
        $stm->bind_result($per);

        while ($stm->fetch()) {
            $z = $per;
        }
        $stm->close();

        return $z;
    }

    function getDefaultPrice($itemID,$customerID)
    {
        global $username, $password, $database;
        $prices = array();
        $today = date("Y-m-d");
        $stm1 =  $this->db->prepare("SELECT price FROM ContractPrices WHERE item_id= '$itemID' AND customer_id='$customerID' AND valid_from<='$today' AND valid_until>='$today' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {

            $priceObject = new Price("98","C","Contract Price","$price",false);
             array_push($prices,$priceObject);



        }
        $stm1->close();

        $stm1 =  $this->db->prepare("SELECT price_group_definition_id FROM Price_Group_Customer WHERE customer_id='$customerID'");
        $stm1-> execute();
        $stm1-> bind_result($priceGroupDefinitionID);
        while ($stm1->fetch()) {

            $categories = array();
            $categories = $this->getCategoriesNewDB($itemID);

            foreach($categories as $category)
            {
                $db2 = new mysqli(localhost,$username,$password,$database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db2->set_charset("greek");
                $stm = $db2->prepare("SELECT discount_percent,price_type_id,price_group_code,name FROM Price_Group_Rules,Price_Group_Definitions WHERE Price_Group_Rules.price_group_definition_id='$priceGroupDefinitionID' AND Price_Group_Rules.price_group_definition_id =Price_Group_Definitions.price_group_definition_id AND category_id='$category'");
                $stm-> execute();
                $stm-> bind_result($discountPercent,$priceTypeID,$priceGroupCode,$priceGroupName);
                while ($stm->fetch()) {



                    $price = $this->getPriceFromPriceType($itemID,$priceTypeID) - $this->getPriceFromPriceType($itemID,$priceTypeID)*$discountPercent/100;

                    $priceObject = new Price("99",$priceGroupCode,$priceGroupName,"$price",false);
                    array_push($prices,$priceObject);

                }
                $stm->close();

            }
        }
        $stm1->close();



        $stm1 = $this->db->prepare("SELECT price_group_definition_id FROM Price_Group_Customer_Group WHERE customer_group_id IN(SELECT group_id AS customer_group_id FROM Customer_CustomersGroup WHERE customer_id='$customerID')");
        $stm1-> execute();
        $stm1-> bind_result($priceGroupDefinitionID);
        while ($stm1->fetch()) {

            $categories = array();
            $categories = $this->getCategoriesNewDB($itemID);

            foreach($categories as $category)
            {
                $db2 = new mysqli(localhost,$username,$password,$database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db2->set_charset("greek");
                $stm = $db2->prepare("SELECT discount_percent,price_type_id,price_group_code,name FROM Price_Group_Rules,Price_Group_Definitions WHERE Price_Group_Rules.price_group_definition_id='$priceGroupDefinitionID' AND Price_Group_Rules.price_group_definition_id =Price_Group_Definitions.price_group_definition_id AND category_id='$category'");
                $stm-> execute();
                $stm-> bind_result($discountPercent,$priceTypeID,$priceGroupCode,$priceGroupName);
                while ($stm->fetch()) {



                    $price = $this->getPriceFromPriceType($itemID,$priceTypeID) - $this->getPriceFromPriceType($itemID,$priceTypeID)*$discountPercent/100;

                    $priceObject = new Price("99",$priceGroupCode,$priceGroupName,"$price",false);
                    array_push($prices,$priceObject);

                }
                $stm->close();

            }
        }
        $stm1->close();


        $stm1 = $this->db->prepare("SELECT Customer_Pricelist.pricetype_id,price_code,name FROM Customer_Pricelist,PriceTypes WHERE Customer_Pricelist.pricetype_id=PriceTypes.pricetype_id AND customer_id ='$customerID' AND NOT Customer_Pricelist.allow_discount='onlydisc'");
        $stm1-> execute();
        $stm1-> bind_result($priceTypeID,$priceCode,$name);
        while ($stm1->fetch()) {

            $price = $this->getPriceFromPriceType($itemID,$priceTypeID);
            $incVat = $this->getPriceVatInc($itemID,$priceTypeID);

            $incVatBool=false;
            if(strcmp($incVat,"yes")==0)
            {
                $incVatBool=true;
            }
            if($incVatBool)
            {
                $itemVat = $this->getVatPercentageOfItem($itemID);
                $price=$price/(1+$itemVat/100);
            }
            $priceObject = new Price($priceTypeID,$priceCode,$name,"$price",$incVatBool);
            array_push($prices,$priceObject);


        }
        $stm1->close();


        $where='';
        if(isset($_SESSION['Allow_PriceTypes']) && strcmp($_SESSION['Allow_PriceTypes'],'')!=0){
            $where .= " AND PriceTypes.pricetype_id IN (".$_SESSION['Allow_PriceTypes'].")";
        }
        $stm1 =  $this->db->prepare("SELECT price,Prices.pricetype_id,price_code,name,Prices.inc_vat FROM Prices,PriceTypes WHERE item_id= '$itemID' AND Prices.pricetype_id=PriceTypes.pricetype_id $where ORDER BY default_type DESC");
        $stm1-> execute();
        $stm1-> bind_result($price,$priceTypeID,$priceCode,$name,$incVat);
        while ($stm1->fetch()) {
            $incVatBool=false;
            if(strcmp($incVat,"yes")==0)
            {
                $incVatBool=true;
            }
            if($incVatBool)
            {
                $itemVat = $this->getVatPercentageOfItem($itemID);
                $price=$price/(1+$itemVat/100);
            }
            $priceObject = new Price($priceTypeID,$priceCode,$name,"$price",$incVatBool);
            array_push($prices,$priceObject);




        }
        $stm1->close();


        return $prices;
    }

    function getDefaultPurchasePrice($itemID,$customerID)
    {
        global $username, $password, $database;
        $prices = array();
        $stm1 =  $this->db->prepare("SELECT price FROM Item_Supplier WHERE item_id= '$itemID' AND supplier_id='$customerID' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {

            $priceObject = new Price("98","C","Contract Price","$price",false);
            array_push($prices,$priceObject);

        }
        $stm1->close();


        $where='';
        if(isset($_SESSION['Allow_PriceTypes']) && strcmp($_SESSION['Allow_PriceTypes'],'')!=0){
            $where .= " AND PriceTypes.pricetype_id IN (".$_SESSION['Allow_PriceTypes'].")";
        }
        $stm1 =  $this->db->prepare("SELECT price,Prices.pricetype_id,price_code,name,Prices.inc_vat FROM Prices,PriceTypes WHERE item_id= '$itemID' AND Prices.pricetype_id=PriceTypes.pricetype_id $where ORDER BY default_type DESC");
        $stm1-> execute();
        $stm1-> bind_result($price,$priceTypeID,$priceCode,$name,$incVat);
        while ($stm1->fetch()) {
            $incVatBool=false;
            if(strcmp($incVat,"yes")==0)
            {
                $incVatBool=true;
            }
            if($incVatBool)
            {
                $itemVat = $this->getVatPercentageOfItem($itemID);
                $price=$price/(1+$itemVat/100);
            }
            $priceObject = new Price($priceTypeID,$priceCode,$name,"$price",$incVatBool);
            array_push($prices,$priceObject);




        }
        $stm1->close();


        return $prices;
    }


    function getPriceFromPriceType($itemID,$priceTypeID)
    {
        global $username, $password, $database;
        $z = 0;
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm = $db2->prepare("SELECT price FROM Prices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($price);

        while ($stm->fetch()) {
            $z = $price;
        }
        $stm->close();

        return $z;
    }

    function getPriceVatInc($itemID,$priceTypeID)
    {
        global $username, $password, $database;
        $z = 0;
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("greek");
        $stm = $db2->prepare("SELECT inc_vat FROM Prices WHERE item_id='$itemID' AND pricetype_id='$priceTypeID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($incVat);

        while ($stm->fetch()) {
            $z = $incVat;
        }
        $stm->close();

        return $z;
    }




}