<?php
class DatabaseHelper
{

    private $database;
    private $username;
    private $password;
    private $localHost;


    public function __construct($database,$username,$password,$localHost)
    {
        $this->database;
        $this->username;
        $this->password;
        $this->localHost;
    }



}

function getNextKey($tableName, $idName)
{
    global $username, $password, $database, $prefix;
    $z = 0;
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("greek");

    if (isset($_SESSION['prefix']) && $_SESSION['prefix'] > 0) {
        $prefix = $_SESSION['prefix'];
    } else {
        $prefix=1000;
    }


    $likeVar = $prefix . "%";
    $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID, 4, strlen($nextID));
        $z += 1;


    }
    $stm1->close();


    return $prefix . $z;


}

function getNextInvoiceCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_invoice_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'I' . $beginOrderNumber;
    return $beginOrderNumber;
}

function getNextPurchaseInvoiceCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_purchase_invoice_number,display_prefix FROM Devices_Pop WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'PI' . $beginOrderNumber;
    return $beginOrderNumber;
}

function setNextPurchaseInvoiceCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices_Pop SET begin_purchase_invoice_number=begin_purchase_invoice_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function getNextWTCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_warehouse_transaction_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'WT' . $beginOrderNumber;
    return $beginOrderNumber;
}

function getNextOrderCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_order_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'O' . $beginOrderNumber;
    return $beginOrderNumber;

}

function getNextPurchaseOrderCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_purchase_order_number,display_prefix FROM Devices_Pop WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'PO' . $beginOrderNumber;
    return $beginOrderNumber;

}

function getNextPickCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_pick_number,display_prefix FROM Devices_Pop WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'P' . $beginOrderNumber;
    return $beginOrderNumber;

}

function getNextReturnCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_return_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;

    }
    $stm1->close();
    $beginOrderNumber = 'N' . $beginOrderNumber;
    return $beginOrderNumber;
}

function getNextReceiptCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_receipt_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'R' . $beginOrderNumber;
    return $beginOrderNumber;
}

function getNextWaybillCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_waybill_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;

    }
    $stm1->close();
    $beginOrderNumber = 'W' . $beginOrderNumber;
    return $beginOrderNumber;

}

function getNextServiceCallCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_service_call_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginOrderNumber;
}

function getNextOpportunityCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_opportunity_number FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $beginOrderNumber;
}

function setNextInvoiceCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_invoice_number=begin_invoice_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextWaybillCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_waybill_number=begin_waybill_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextWTCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_warehouse_transaction_number=begin_warehouse_transaction_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextReturnCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_return_number=begin_return_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextReceiptCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_receipt_number=begin_receipt_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextOrderCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_order_number=begin_order_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function setNextPurchaseOrderCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices_Pop SET begin_purchase_order_number=begin_purchase_order_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function setNextPickingCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices_Pop SET begin_pick_number=begin_pick_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();
}

function setNextServiceCallCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_service_call_number=begin_service_call_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function setNextOpportunityCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_opportunity_number=begin_opportunity_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function getNextCustomerCode()
{
    global $username, $password, $database;
    $customerCode = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_code_suffix,customer_code_format FROM Cloud_Configuration");
    $stm1->execute();
    $stm1->bind_result($customerCodeSuffix, $customerCodeFormat);
    while ($stm1->fetch()) {
        $customerCodeSuffix .= "$customerCodeFormat";
    }
    $stm1->close();
    $customerCode = $customerCodeSuffix . '1';
    $stm1 = $db1->prepare("SELECT customer_code FROM Customers WHERE customer_code like'$customerCodeSuffix%' ORDER BY customer_code DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($nextCustomerCode);
    while ($stm1->fetch()) {
        $customerCode = str_replace($customerCodeSuffix, "", $nextCustomerCode);
        $customerCode = $customerCode + 1;
        $customerCode = $customerCodeSuffix . $customerCode;
    }
    $stm1->close();

    return $customerCode;

}

function getNextItemCode()
{
    global $username, $password, $database;
    $itemCode = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT item_code_suffix,item_code_format FROM Cloud_Configuration");
    $stm1->execute();
    $stm1->bind_result($itemCodeSuffix, $itemCodeFormat);
    while ($stm1->fetch()) {

    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT item_code FROM Items WHERE item_code like'$itemCodeSuffix%' ORDER BY item_code DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($itemCode);
    while ($stm1->fetch()) {
        $itemCode = str_replace($itemCodeSuffix, "", $itemCode);
        $itemCode = $itemCode + 1;
        $itemCode = $itemCodeSuffix . $itemCode;
    }
    $stm1->close();

    return $itemCode;

}

function getNextSupplierCode()
{
    global $username, $password, $database;
    $customerCode = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT supplier_code_suffix,supplier_code_format FROM Cloud_Configuration");
    $stm1->execute();
    $stm1->bind_result($customerCodeSuffix, $customerCodeFormat);
    while ($stm1->fetch()) {

    }
    $stm1->close();

    $stm1 = $db1->prepare("SELECT customer_code FROM Suppliers WHERE customer_code like'$customerCodeSuffix%' ORDER BY customer_code DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($customerCode);
    while ($stm1->fetch()) {
        $customerCode = str_replace($customerCodeSuffix, "", $customerCode);
        $customerCode = $customerCode + 1;
        $customerCode = $customerCodeSuffix . $customerCode;
    }
    $stm1->close();

    return $customerCode;

}

function getLastValueOfCustomForm($customFormID, $customFieldID, $tableName, $tableID)
{

    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $value = "";
    $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($value);
    while ($stm->fetch()) {


    }
    $stm->close();

    return $value;
}

function getCustomerCode($customerID)
{
    global $username, $password, $database;

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT customer_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($customerCode);
    while ($stm1->fetch()) {

    }
    $stm1->close();
    return $customerCode;


}

function lockDocument($documentID, $documentType)
{

    global $username, $password, $database;


    if (!containsLock($documentID, $documentType)) {

        $db = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");


        $stmt = $db->prepare("INSERT INTO ZD_Lock_Document (document_id,document_type,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('is', $documentID, $documentType);
        $stmt->execute();
        $stmt->close();
    }
}

function containsLock($documentID, $documentType)
{
    global $username, $password, $database;
    $contains = false;

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(*) FROM ZD_Lock_Document WHERE document_id='$documentID' AND document_type='$documentType'");
    $stm1->execute();
    $stm1->bind_result($counter);
    while ($stm1->fetch()) {
        if ($counter > 0) {
            $contains = true;
        }

    }
    $stm1->close();
    return $contains;
}

function recordSCChange($serviceCallID, $salespersonID, $details, $replyType)
{

    global $username, $password, $database;
    date_default_timezone_set('Europe/Athens');

    $dateNow = date('Y-m-d H:i:s');

    $serviceCallReplyID = getNextKey("Service_Call_Reply", "service_call_reply_id");
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,date,details,reply_type_id) VALUES(?,?,?,?,?,?)");
    $stmt->bind_param('iiissi', $serviceCallReplyID, $serviceCallID, $salespersonID, $dateNow, $details, $replyType);
    $stmt->execute();
    $stmt->close();


}

function sendMessage($fromID, $toID, $message)
{
    global $username, $password, $database;
    date_default_timezone_set('Europe/Athens');

    $dateNow = date('Y-m-d H:i:s');
    $fromUserName = getUserName($fromID);
    $toUserName = getUserName($toID);
    $type = "text";
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stmt = $db->prepare("INSERT INTO messages (from_id,to_id,from_uname,to_uname,message_content,message_date,message_type) VALUES(?,?,?,?,?,?,?)");
    $stmt->bind_param('iisssss', $fromID, $toID, $fromUserName, $toUserName, $message, $dateNow, $type);
    $stmt->execute();
    $stmt->close();

}

function getUserName($id)
{
    global $username, $password, $database;


    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT username FROM Admin WHERE id='$id' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($u);
    while ($stm1->fetch()) {


    }
    $stm1->close();
    return $u;
}


function createNotification($salesperonID, $createdByID, $text, $linkedTable, $linkedTableID)
{
    global $username, $password, $database;
    date_default_timezone_set('Europe/Athens');

    $dateNow = date('Y-m-d H:i:s');

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $notificationID = getNextKey("Notifications", "notification_id");


    $isRead = $isSeen = "no";
    $userID = $_SESSION['adminID'];
    $insert = true;

    if (isset($userID) && $userID > 0) {
        if ($salesperonID == $userID) {
            $insert = false;
        }
    }
    if ($insert) {
        $stmt = $db->prepare("INSERT INTO Notifications (notification_id,salesperson_id,created_time,created_by_id,title,is_read,is_seen,linked_table,linked_table_id) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iisissssi', $notificationID, $salesperonID, $dateNow, $createdByID, $text, $isRead, $isSeen, $linkedTable, $linkedTableID);
        $stmt->execute();
        $stmt->close();
    }
}

function getSalespersonName($salespersonID)
{
    global $username, $password, $database;
    $itemCode = "";
    $db2 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("UTF8");

    $stm2 = $db2->prepare("SELECT CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($itemCode);
    while ($stm2->fetch()) {


    }
    $stm2->close();
    return $itemCode;
}

function hasQuotationCategory()
{
    global $username, $password, $database;
    $result = false;
    $db2 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("greek");

    $stm2 = $db2->prepare("SELECT COUNT(*) FROM Categories WHERE description='quotation' LIMIT 1");
    $stm2->execute();
    $stm2->bind_result($counter);
    while ($stm2->fetch()) {

        if ($counter > 0) {
            $result = true;
        }
    }
    $stm2->close();
    return $result;
}

function get_time_difference_php($created_time)
{
    date_default_timezone_set('Europe/Athens');//Change as per your default time
    $str = strtotime($created_time);
    $today = strtotime(date('Y-m-d H:i:s'));

    // It returns the time difference in Seconds...
    $time_differnce = $today - $str;

    // To Calculate the time difference in Years...
    $years = 60 * 60 * 24 * 365;

    // To Calculate the time difference in Months...
    $months = 60 * 60 * 24 * 30;

    // To Calculate the time difference in Days...
    $days = 60 * 60 * 24;

    // To Calculate the time difference in Hours...
    $hours = 60 * 60;

    // To Calculate the time difference in Minutes...
    $minutes = 60;

    if (intval($time_differnce / $years) > 1) {
        return intval($time_differnce / $years) . " years ago";
    } else if (intval($time_differnce / $years) > 0) {
        return intval($time_differnce / $years) . " year ago";
    } else if (intval($time_differnce / $months) > 1) {
        return intval($time_differnce / $months) . " months ago";
    } else if (intval(($time_differnce / $months)) > 0) {
        return intval(($time_differnce / $months)) . " month ago";
    } else if (intval(($time_differnce / $days)) > 1) {
        return intval(($time_differnce / $days)) . " days ago";
    } else if (intval(($time_differnce / $days)) > 0) {
        return intval(($time_differnce / $days)) . " day ago";
    } else if (intval(($time_differnce / $hours)) > 1) {
        return intval(($time_differnce / $hours)) . " hours ago";
    } else if (intval(($time_differnce / $hours)) > 0) {
        return intval(($time_differnce / $hours)) . " hour ago";
    } else if (intval(($time_differnce / $minutes)) > 1) {
        return intval(($time_differnce / $minutes)) . " minutes ago";
    } else if (intval(($time_differnce / $minutes)) > 0) {
        return intval(($time_differnce / $minutes)) . " minute ago";
    } else if (intval(($time_differnce)) > 1) {
        return intval(($time_differnce)) . " seconds ago";
    } else {
        return "few seconds ago";
    }
}


function convertOrderToInvoice($orderID)
{
    global $username, $password, $database;

    $db2 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stmt = $db2->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,tender_id,subtotal,grand_total,vat_amount,vat_i_or_e,discount_amount,order_address_id,delivery_address_id,print_count,order_date,delivery_date,details,status,currency_id,global_discount_percentage, delivery_method,timestamp FROM Orders WHERE order_id='$orderID'");
    $stmt->execute();
    $stmt->bind_result($orderID, $orderCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $tenderID, $subtotal, $grandTotal, $vatTotal, $vatIorE, $discount, $orderAddressID, $deliveryAdressID, $printCount, $orderDATE, $dueDate, $details, $status, $currencyID, $globalDiscountPercentage, $warehouseID, $timestamp);
    while ($stmt->fetch()) {
    }
    $stmt->close();
    echo "Got Order -> $orderID<br>";
    if ($orderID > 0) {
        $orderItems = array();
        $stmt = $db2->prepare("SELECT order_item_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description FROM Order_Item WHERE order_id='$orderID'");
        $stmt->execute();
        $stmt->bind_result($orderItemID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountSelectedPercentage, $vatAmount, $priceType, $vatID, $itemNotes);
        while ($stmt->fetch()) {
            $orderItem = '';
            $orderItem->orderID = $orderID;
            $orderItem->orderItemID = $orderItemID;
            $orderItem->itemID = $itemID;
            $orderItem->qty = $qty;
            $orderItem->unitPrice = $unitPrice;
            $orderItem->lineDiscount = $lineDiscount;
            $orderItem->globalDiscount = $globalDiscount;
            $orderItem->lineDiscountSelectedPercentage = $lineDiscountSelectedPercentage;
            $orderItem->vatAmount = $vatAmount;
            $orderItem->priceType = $priceType;
            $orderItem->vatID = $vatID;
            $orderItem->itemNotes = $itemNotes;
            array_push($orderItems, $orderItem);
            echo "Got Item -> $orderItemID<br>";
        }
        $stmt->close();


        $invoiceCode = getNextInvoiceCode('CLOUD');
        $invoiceID = getNextKey('Invoices', 'invoice_id');
        lockDocument($invoiceID, "Invoices");
        $invoiceDate = date('Y-m-d');
        $invoiceType = "Credit";
        $warehouseID = 0;
        $commit = false;
        $db2->autocommit(FALSE);

        $stmt = $db2->prepare("INSERT INTO Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status,order_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isiiiiddddiissssdsi', $invoiceID, $invoiceCode, $companyID, $customerID, $salespersonID, $paymentTypeID, $subtotal, $grandTotal, $vatTotal, $discount, $orderAddressID, $deliveryAdressID, $invoiceDate, $dueDate, $details, $invoiceType, $globalDiscountPercentage, $status, $orderID);
        if ($stmt->execute()) {
            $commit = true;
            echo "Invoice ID -> $invoiceID<br>";
        } else {
            $commit = false;
            echo "Invoices - " . $stmt->error;
        }

        if ($commit) {
            foreach ($orderItems as $orderItem) {

                $orderID = $orderItem->orderID;
                $orderItemID = $orderItem->orderItemID;
                $itemID = $orderItem->itemID;
                $qty = $orderItem->qty;
                $unitPrice = $orderItem->unitPrice;
                $lineDiscount = $orderItem->lineDiscount;
                $globalDiscount = $orderItem->globalDiscount;
                $lineDiscountSelectedPercentage = $orderItem->lineDiscountSelectedPercentage;
                $vatAmount = $orderItem->vatAmount;
                $priceType = $orderItem->priceType;
                $vatID = $orderItem->vatID;
                $itemNotes = $orderItem->itemNotes;
                $batchNumber = '0';

                $stmt = $db2->prepare("INSERT INTO Invoice_Item (invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('iisidddddiids', $invoiceID, $itemID, $batchNumber, $warehouseID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes);
                if ($stmt->execute()) {
                    $commit = true;
                } else {
                    $commit = false;
                    echo "Invoice_Item - " . $stmt->error;
                    break;
                }
//            $batchNumber = '0';
//            $available = -$qty;
//            $stmt = $db2->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available) VALUES(?,?,?,?) ON DUPLICATE KEY UPDATE available=available+?");
//            $stmt->bind_param('iisdd', $warehouseID, $itemID, $batchNumber, $available, $available);
//            if($stmt->execute()){
//               $commit=true;
//            } else {
//               $commit=false;
//               echo $stmt->error;
//            }

                if (isset($orderID) && $orderID > 0 && isset($orderItemID) && $orderItemID > 0) {

                    $stmt = $db2->prepare("UPDATE Order_Item SET qty_invoiced=qty_invoiced+? WHERE order_item_id=?");
                    $stmt->bind_param('di', $qty, $orderItemID);
                    if ($stmt->execute()) {
                        $commit = true;
                    } else {
                        $commit = false;
                        echo "Order_Item - " . $stmt->error;
                        break;
                    }
                }
                $stmt = $db2->prepare("INSERT INTO Order_Invoice (order_id,invoice_id,timestamp) VALUES (?,?,NOW())");
                $stmt->bind_param('ii', $orderID, $invoiceID);
                if ($stmt->execute()) {
                    $commit = true;
                } else {
                    $commit = false;
                    echo "Order_Invoice - " . $stmt->error;
                    break;
                }
            }
        }
        if ($commit) {
            $db2->commit();
            setNextInvoiceCode('CLOUD');
        }
        $stmt->close();
        echo "<br><br>";
    }
}

function getNextZCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_z_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'Z' . $beginOrderNumber;
    return $beginOrderNumber;

}

function setNextZCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_z_number=begin_z_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

// -------------------- CUSTOMER FUNCTIONS --------------------------//

function insertOrUpdateCustomer($overWriteEmptyValues, $customerCode, $customerCompanyName, $customerReportName, $logo, $registrationCode, $mobile, $website, $email, $description, $typeOfBusiness, $ticCode, $vatCode, $creditLimit, $addressCodeEurosoft, $customerType, $balance)
{

    $error = '';
    $isNew = false;

    if (strcmp($customerCode, '') != 0) {

        $customerID = getTableKey('Customers', 'customer_id', 'customer_code', "$customerCode");

        if ($customerID == 0) {
            $customerID = getNextKey("Customers", "customer_id");
            $isNew = true;
        }

        if ($customerID > 0) {
            $customersArray = array('customer_id' => "$customerID",
                'customer_code' => "$customerCode",
                'customer_company_name' => "$customerCompanyName",
                'customer_report_name' => "$customerReportName",
                'logo' => "$logo",
                'registration_code' => "$registrationCode",
                'mobile' => "$mobile",
                'website' => "$website",
                'email' => "$email",
                'description' => "$description",
                'type_of_business' => "$typeOfBusiness",
                'tic_code' => "$ticCode",
                'vat_code' => "$vatCode",
                'credit_limit' => "$creditLimit",
                'address_code_eurosoft' => "$addressCodeEurosoft",
                'customer_type' => "$customerType",
                'balance' => "$balance",
                'timestamp' => 'NOW()'
            );

            $error .= " Customer : $customerCode ";

            if ($isNew) {
                $error .= " Insert ";
            } else {
                $error .= " Update ";
                if ($overWriteEmptyValues) {
                    $error .= " (Include Empty Values) ";
                }
            }

            // Building & Executing Query
            $error .= InsertOrUpdateDynamicQuery('Customers', 'customer_id', $customersArray, $overWriteEmptyValues);


        } else {
            // Error Creating ID
            $error .= " ERROR: Error Creating ID ";
        }

    } else {
        // Empty Code
        $error .= " ERROR: Empty Customer Code ";
    }

    return $error;

}

function insertOrUpdateCustomerAddress($overWriteEmptyValues, $addressCode, $customerID, $country, $city, $addressLine1, $addressLine2, $postCode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress)
{

    $error = '';
    $isNew = false;

    if (strcmp($addressCode, '') != 0) {

        $addressID = getTableKey('CustomerAddress', 'customer_address_id', 'address_code', "$addressCode");

        if ($addressID == 0) {
            $addressID = getNextKey("CustomerAddress", "customer_address_id");
            $isNew = true;
        }

        if ($addressID > 0) {
            $addressesArray = array('customer_address_id' => "$addressID",
                'address_code' => "$addressCode",
                'customer_id' => "$customerID",
                'country' => "$country",
                'city' => "$city",
                'address_line_1' => "$addressLine1",
                'address_line_2' => "$addressLine2",
                'postcode' => "$postCode",
                'region' => "$region",
                'lat' => "$lat",
                'lng' => "$lng",
                'pobox' => "$pobox",
                'landline' => "$landline",
                'fax' => "$fax",
                'primary_address' => "$primaryAddress",
                'timestamp' => 'NOW()'
            );

            $error .= " Customer Address : $addressCode ";

            if ($isNew) {
                $error .= " Insert ";
            } else {
                $error .= " Update ";
                if ($overWriteEmptyValues) {
                    $error .= " (Include Empty Values) ";
                }
            }

            // Building & Executing Query
            $error .= InsertOrUpdateDynamicQuery('CustomerAddress', 'customer_address_id', $addressesArray, $overWriteEmptyValues);


        } else {
            // Error Creating ID
            $error .= " ERROR: Error Creating ID ";
        }

    } else {
        // Empty Code
        $error .= " ERROR: Empty Address Code ";
    }

    return $error;

}

function insertOrUpdateCustomerGroup($overWriteEmptyValues, $groupCode, $groupName, $groupDescription)
{

    $error = '';
    $isNew = false;

    if (strcmp($groupCode, '') != 0) {

        $groupID = getTableKey('CustomerGroups', 'group_id', 'group_code', "$groupCode");

        if ($groupID == 0) {
            $groupID = getNextKey("CustomerGroups", "group_id");
            $isNew = true;
        }

        if ($groupID > 0) {
            $addressesArray = array('group_id' => "$groupID",
                'group_code' => "$groupCode",
                'name' => "$groupName",
                'description' => "$groupDescription",
                'creation_date' => "cop_false",
                'timestamp' => 'NOW()'
            );

            $error .= " Customer Group : $groupCode ";

            if ($isNew) {
                $error .= " Insert ";
                $addressesArray['creation_date'] = 'NOW()';
            } else {
                $error .= " Update ";
                if ($overWriteEmptyValues) {
                    $error .= " (Include Empty Values) ";
                }
            }

            // Building & Executing Query
            $error .= InsertOrUpdateDynamicQuery('CustomerGroups', 'group_id', $addressesArray, $overWriteEmptyValues);


        } else {
            // Error Creating ID
            $error .= " ERROR: Error Creating ID ";
        }

    } else {
        // Empty Code
        $error .= " ERROR: Empty Group Code ";
    }

    return $error;

}

function insertCustomerToGroupByID($customerID, $groupID, $insertedBy = 0)
{
    if ($customerID > 0 && $groupID > 0) {
        global $username, $password, $database;
        $error = '';
        $db99 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db99->set_charset("utf8");

        $z = 0;
        $stmt99 = $db99->prepare("SELECT COUNT(*) FROM Customer_CustomersGroup WHERE group_id='$groupID' AND customer_id='$customerID'");
        $stmt99->execute();
        $stmt99->bind_result($counter);
        while ($stmt99->fetch()) {
            if ($counter > 0) {
                $z = $counter;
            }
        }
        $error .= $stmt99->error;
        $stmt99->close();

        if ($z == 0) {
            if (strcmp($insertedBy, '') == 0) {
                $insertedBy = 0;
            }
            $stmt99 = $db99->prepare("INSERT INTO Customer_CustomersGroup (group_id,customer_id,added_date,salesperson_id,timestamp) VALUES (?,?,NOW(),?,NOW())");
            $stmt99->bind_param('iii', $groupID, $customerID, $insertedBy);
            $stmt99->execute();
            $error .= $stmt99->error;
            $stmt99->close();

            if (strcmp($error, '') == 0) {
                $error = "Complete";
            } else {
                $error = "ERROR: " . $error;
            }
        } else {
            $error = "[EXISTS]  Complete.";
        }

        return "Customer ($customerID) Into Group ($groupID) $error";
    } else {
        return "Customer ($customerID) Into Group ($groupID) ERROR: Empty ID";
    }
}

function setCustomerPrimaryAddress($customerID, $customerAddressID)
{

    if ($customerID > 0 && $customerAddressID > 0) {
        global $username, $password, $database;
        $error = '';
        $db99 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db99->set_charset("utf8");

        $stmt99 = $db99->prepare("UPDATE CustomerAddress SET primary_address='' WHERE customer_id='$customerID'");
        $stmt99->execute();
        $error .= $stmt99->error;
        $stmt99->close();

        $stmt99 = $db99->prepare("UPDATE CustomerAddress SET primary_address='yes' WHERE customer_id='$customerID' AND customer_address_id='$customerAddressID'");
        $stmt99->execute();
        $error .= $stmt99->error;
        $stmt99->close();

        if (strcmp($error, '') == 0) {
            $error = "Complete";
        } else {
            $error = "ERROR: " . $error;
        }

        return "Customer Address ($customerAddressID) Set As Primary For Customer ($customerID) $error";
    } else {
        return "Customer Address ($customerAddressID) Set As Primary For Customer ($customerID) ERROR: Empty ID";
    }
}

function getCustomerAddressesByCustomerID($customerID)
{
    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    $DBCustomer = new DBCustomer();
    return $DBCustomer->getCustomerAddress($customerID);
}

function removeCustomerAddressByID($customerAddressID)
{
    global $username, $password, $database;
    $error = '';
    $db9 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM CustomerAddress WHERE customer_address_id=?");
    $stmt9->bind_param('i', $customerAddressID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM CustomerAddress WHERE customer_address_id='$customerAddressID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    if (strcmp($error, '') == 0) {
        $error = "Complete";
    } else {
        $error = "ERROR: " . $error;
    }
    return "Remove Address ($customerAddressID) " . $error;

}

function removeCustomerGroupByID($customerGroupID)
{
    global $username, $password, $database;
    $error = '';
    $db9 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM Customer_CustomersGroup WHERE group_id=?");
    $stmt9->bind_param('i', $customerGroupID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM Customer_CustomersGroup WHERE group_id='$customerGroupID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();


    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM CustomerGroup_Salesperson WHERE group_id=?");
    $stmt9->bind_param('i', $customerGroupID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM CustomerGroup_Salesperson WHERE group_id='$customerGroupID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();


    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM CustomerGroup_Pricelist WHERE group_id=?");
    $stmt9->bind_param('i', $customerGroupID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM CustomerGroup_Pricelist WHERE group_id='$customerGroupID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();


    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM Allow_CustomerGroups WHERE group_id=?");
    $stmt9->bind_param('i', $customerGroupID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM Allow_CustomerGroups WHERE group_id='$customerGroupID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();


    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM CustomerGroups WHERE group_id=?");
    $stmt9->bind_param('i', $customerGroupID);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM CustomerGroups WHERE group_id='$customerGroupID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $error .= $stmt9->error;
    $stmt9->close();


    if (strcmp($error, '') == 0) {
        $error = "Complete";
    } else {
        $error = "ERROR: " . $error;
    }
    return "Remove Group ($customerGroupID) " . $error;

}

// -------------------- CUSTOMER FUNCTIONS/ -------------------------//
//
// -------------------- TENDER FUNCTIONS --------------------------//

function getNextTenderCode($activationCode)
{
    global $username, $password, $database;
    $beginOrderNumber = "";

    $db1 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT begin_tender_number,display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($beginOrderNumber, $preFix);
    while ($stm1->fetch()) {
        $beginOrderNumber = $preFix . $beginOrderNumber;
    }
    $stm1->close();
    $beginOrderNumber = 'T' . $beginOrderNumber;
    return $beginOrderNumber;

}

function setNextTenderCode($activationCode)
{
    global $username, $password, $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Devices SET begin_tender_number=begin_tender_number+1 WHERE activation_code='$activationCode'");
    $stmt->execute();
    $stmt->close();


}

function getTenderByID($tenderID, $analytical = false)
{

    require_once(ROOT . 'backend/core/model/Tender.php');
    require_once(ROOT . "concc/dbhelpers/classes/DBCustomer.php");
    require_once(ROOT . "concc/dbhelpers/classes/DBSalesperson.php");

    $DBSalesperson = new DBSalesperson();
    $DBCustomer = new DBCustomer();
    $tender = null;

    global $username, $password, $database;
    $db9 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db9->set_charset("UTF8");
    $stm9 = $db9->prepare("SELECT tender_id, tender_code, company_id, salesperson_id, customer_id, tender_date, valid_until, name, address_line_1, address_line_2, city, country, region, subtotal, grand_total, vat_amount, discount_amount, status, vat_i_e, print_count, details, currency_id, delivery_method, global_discount_percentage, current_version, edited_by, timestamp FROM Tenders WHERE tender_id='$tenderID'");
    $stm9->execute();
    $stm9->bind_result($tender_id, $tender_code, $company_id, $salesperson_id, $customer_id, $tender_date, $valid_until, $name, $address_line_1, $address_line_2, $city, $country, $region, $subtotal, $grand_total, $vat_amount, $discount_amount, $status, $vat_i_e, $print_count, $details, $currency_id, $delivery_method, $global_discount_percentage, $current_version, $edited_by, $timestamp);
    while ($stm9->fetch()) {
        if ($analytical) {
            $tender = new Tender($tender_id, $tender_code, $company_id, $DBSalesperson->getSalesPersonBasicInfo($DBSalesperson->getSalespersonByID($salesperson_id)), $DBCustomer->getCustomerByID($customer_id), $tender_date, $valid_until, $name, $address_line_1, $address_line_2, $city, $country, $region, $subtotal, $grand_total, $vat_amount, $discount_amount, $status, $vat_i_e, $print_count, $details, $currency_id, $delivery_method, $global_discount_percentage, $timestamp);
        } else {
            $tender = new Tender($tender_id, $tender_code, $company_id, $salesperson_id, $customer_id, $tender_date, $valid_until, $name, $address_line_1, $address_line_2, $city, $country, $region, $subtotal, $grand_total, $vat_amount, $discount_amount, $status, $vat_i_e, $print_count, $details, $currency_id, $delivery_method, $global_discount_percentage, $timestamp);
        }
        $tenderItems = getTenderItemsByTenderID($tender_id, $analytical);
        $tender->setNumberOfItems(count($tenderItems));
        $tender->setTenderItems($tenderItems);
    }
    $stm9->close();

    return $tender;

}

function getTenderItemsByTenderID($tenderID, $analytical = false)
{

    require_once(ROOT . 'backend/core/model/TenderItem.php');
    require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
    require_once(ROOT . "concc/dbhelpers/classes/DBVat.php");
    require_once(ROOT . "concc/dbhelpers/classes/DBPriceType.php");

    $DBitem = new DBItem();
    $DBVat = new DBVat();
    $DBPriceType = new DBPriceType();

    global $username, $password, $database;
    $db9 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $tenderItems = array();
    $db9->set_charset("UTF8");
    $stm9 = $db9->prepare("SELECT tender_item_id,item_id,qty,unit_price,vat_amount,pricetype_id,vat_id,line_discount,global_discount,line_discount_percentage FROM Tender_Item  WHERE tender_id ='$tenderID'");
    $stm9->execute();
    $stm9->bind_result($tenderItemID, $itemID, $qty, $unitPrice, $vatAmount, $pricetypeID, $vatID, $lineDiscount, $globalDiscount, $lineDiscountPercentage);
    while ($stm9->fetch()) {
        if ($analytical) {
            $tenderItem = new TenderItem($DBitem->getItemByID($itemID), $qty, $unitPrice, $vatAmount, $DBVat->getVatByID($vatID), $lineDiscount, $globalDiscount, $lineDiscountPercentage);
            $tenderItem->setPriceType($DBPriceType->getPriceTypeByID($pricetypeID));
        } else {
            $tenderItem = new TenderItem($itemID, $qty, $unitPrice, $vatAmount, $vatID, $lineDiscount, $globalDiscount, $lineDiscountPercentage);
            $tenderItem->setPriceType($pricetypeID);
        }
        $tenderItem->setTenderItemID($tenderItemID);
        $tenderItem->setTenderID($tenderID);
        array_push($tenderItems, $tenderItem);
    }
    $stm9->close();

    return $tenderItems;
}

function buildTenderItemArray($itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $priceTypeID, $vatID, $description, $promotionID, $promotionNumber, $masterItem)
{
    $tenderItemArray = array('tender_item_id' => "",
        'tender_id' => "",
        'item_id' => "$itemID",
        'qty' => "$qty",
        'unit_price' => "$unitPrice",
        'line_discount' => "$lineDiscount",
        'global_discount' => "$globalDiscount",
        'line_discount_percentage' => "$lineDiscountPercentage",
        'vat_amount' => "$vatAmount",
        'pricetype_id' => "$priceTypeID",
        'vat_id' => "$vatID",
        'description' => "$description",
        'promotion_id' => "$promotionID",
        'promotion_number' => "$promotionNumber",
        'master_item' => "$masterItem",
        'timestamp' => "NOW()"
    );
    return $tenderItemArray;
}

function insertOrUpdateTender($overWriteEmptyValues, $tenderItems, $tenderCode, $companyID, $salespersonID, $customerID, $tenderDate, $validUntil, $name, $addressLine1, $addressLine2, $city, $country, $region, $subtotal, $grandTotal, $vatAmount, $discountAmount, $status, $vatIE, $printCount, $details, $currencyID, $deliveryMethod, $globalDiscountPercentage, $currentVersion = '0', $editedBy = '0')
{

    $error = '';
    $isNew = false;

    if (strcmp($tenderCode, '') != 0) {

        $tenderID = getTableKey('Tenders', 'tender_id', 'tender_code', "$tenderCode");

        if ($tenderID == 0) {
            $tenderID = getNextKey("Tenders", "tender_id");
            $isNew = true;
        }

        if ($tenderID > 0) {

            $tenderArray = array('tender_id' => "$tenderID",
                'tender_code' => "$tenderCode",
                'company_id' => "$companyID",
                'salesperson_id' => "$salespersonID",
                'customer_id' => "$customerID",
                'tender_date' => "$tenderDate",
                'valid_until' => "$validUntil",
                'name' => "$name",
                'address_line_1' => "$addressLine1",
                'address_line_2' => "$addressLine2",
                'city' => "$city",
                'country' => "$country",
                'region' => "$region",
                'subtotal' => "$subtotal",
                'grand_total' => "$grandTotal",
                'vat_amount' => "$vatAmount",
                'discount_amount' => "$discountAmount",
                'status' => "$status",
                'vat_i_e' => "$vatIE",
                'print_count' => "$printCount",
                'details' => "$details",
                'currency_id' => "$currencyID",
                'delivery_method' => "$deliveryMethod",
                'global_discount_percentage' => "$globalDiscountPercentage",
                'current_version' => "$currentVersion",
                'edited_by' => "$editedBy",
                'timestamp' => "NOW()",
            );

            $error .= " Tender : $tenderCode [";


            deleteTenderItemsByTenderID($tenderID);
            $itemCounter = 0;
            foreach ($tenderItems as $tenderItem) {
                $itemCounter++;
                $tenderItemID = getNextKey("Tender_Item", "tender_item_id");
                $tenderItem['tender_item_id'] = $tenderItemID;
                $tenderItem['tender_id'] = $tenderID;
                $error .= " Item $itemCounter ";
                $error .= InsertOrUpdateDynamicQuery('Tender_Item', 'tender_item_id', $tenderItem, $overWriteEmptyValues);
            }
            $error .= "] ";
            if ($isNew) {
                $error .= " Insert ";
            } else {
                $error .= " Update ";
                if ($overWriteEmptyValues) {
                    $error .= " (Include Empty Values) ";
                }
            }

            // Building & Executing Query
            $error .= InsertOrUpdateDynamicQuery('Tenders', 'tender_id', $tenderArray, $overWriteEmptyValues);


        } else {
            // Error Creating ID
            $error .= " ERROR: Error Creating ID ";
        }
    } else {
        // Empty Code
        $error .= " ERROR: Empty Tender Code ";
    }
    return $error;
}

function deleteTenderItemsByTenderID($tenderID)
{
    global $username, $password, $database;

    $db9 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("DELETE FROM Tender_Item WHERE tender_id=?");
    $stmt9->bind_param('i', $tenderID);
    $stmt9->execute();
    $stmt9->close();

    $deleteID = getNextKey("Deletes", "delete_id");
    $statement = "DELETE FROM Tender_Item WHERE tender_id='$tenderID'";
    $stmt9 = $db9->prepare("INSERT INTO Deletes (delete_id,statement,timestamp) VALUES(?,?,NOW())");
    $stmt9->bind_param('is', $deleteID, $statement);
    $stmt9->execute();
    $stmt9->close();
}

// -------------------- TENDER FUNCTIONS/ -------------------------//


function InsertOrUpdateDynamicQuery($tableName, $tableIDField, $importArray, $overwrite = true)
{

    $updateFieldValues = '';
    $updateFilterValue = '';
    $insertFields = '';
    $insertValues = '';
    $error = 'Complete.';
    $tableIDValue = $importArray[$tableIDField];

    foreach ($importArray as $field => $val) {
        if (strcmp('cop_false', $val) != 0) {
            $val = str_replace('"', "'", $val);
            $insertFields .= "$field,";

            if (strcmp($val, 'NOW()') == 0) {

                $insertValues .= "$val,";
                $updateFieldValues .= "$field=$val,";

            } else if (strcmp($field, $tableIDField) == 0) {
                $insertValues .= "\"$val\",";
                $updateFilterValue .= "$field=\"$val\"";

            } else {

                $insertValues .= "\"$val\",";
                if ($overwrite || strcmp($val, '') != 0) {
                    $updateFieldValues .= "$field=\"$val\",";
                }

            }
        }

    }

    $insertFields = trim($insertFields, ',');
    $insertValues = trim($insertValues, ',');
    $updateFieldValues = trim($updateFieldValues, ',');
    $updateFilterValue = trim($updateFilterValue, ',');

    if ($tableIDValue > 0) {
        $query = "INSERT INTO $tableName ($insertFields) VALUES ($insertValues) ON DUPLICATE KEY UPDATE $updateFieldValues ";
    }
    global $username, $password, $database;
    $db99 = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db99->set_charset("utf8");
    $stmt = $db99->prepare($query);
    $stmt->execute();
    if (strcmp($stmt->error, '') != 0) {
        $error = " ERROR: $stmt->error ";
    }
    $stmt->close();

    return $error;
}

function getTableKey($tableName, $idName, $filterColumnName, $filterValue)
{

    $z = 0;

    global $username, $password, $database;
    $db9 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $stm1 = $db9->prepare("SELECT $idName FROM $tableName WHERE $filterColumnName = '$filterValue' ORDER BY $idName DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($key);
    while ($stm1->fetch()) {
        if (strcmp($key, '') != 0) {
            $z = $key;
        }
    }
    $stm1->close();

    return $z;
}

?>