<?php

////-----------DEVICE PARAMS-----------------
//$_POST['displayPrefix'] = 'TQ';
//$_POST['companyCode'] = 'COP';
//$_POST['androidID'] = '47ca02cdb41a2014';
//$_POST['deviceID'] = '30';
//$_POST['salespersonID'] = '30';
//$_POST['url'] = $_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
////------------------------------------------
//

$curURL = $_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
$appURL = $_POST['url'];
$appURL = str_replace('https://','',$appURL);
$appURL = str_replace('http://' ,'',$appURL);

if(strcmp($appURL,$curURL)!=0){

    exit();

} else if(isset($_POST['androidID']) && isset($_POST['deviceID']) && strcmp($_POST['androidID'],'')!=0 && strcmp($_POST['deviceID'],'')!=0 ){

    include_once("../../../../concc/dbinfo.php");

    $androidID = trim($_POST['androidID']);
    $deviceID = trim($_POST['deviceID']);
    $companyCode = trim($_POST['companyCode']);
    $displayPrefix = trim($_POST['displayPrefix']);
    $databasePrefix = trim($_POST['databasePrefix']);
    $activationCode = trim($_POST['activationCode']);

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $devicesCount = 0;
    $db->set_charset("utf8");

    try {
        $db->begin_transaction();

        $stm = $db->prepare("SELECT count(company_id) FROM Companies WHERE company_code = '$companyCode' LIMIT 1");
        $stm->execute();
        $stm->bind_result($companiesCount);
        while ($stm->fetch()) {}
        if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
        $stm->close();

        if ($companiesCount > 0) {

            $stm = $db->prepare("SELECT count(device_id) FROM Devices WHERE display_prefix = '$displayPrefix' AND android_id = '$androidID' AND device_id = '$deviceID'");
            $stm->execute();
            $stm->bind_result($devicesCount);
            while ($stm->fetch()) {}
            if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
            $stm->close();

            if ($devicesCount == 0) {
                $stm = $db->prepare("SELECT count(device_pop_id) FROM Devices_Pop WHERE display_prefix = '$displayPrefix' AND android_id = '$androidID' AND device_pop_id = '$deviceID'");
                $stm->execute();
                $stm->bind_result($devicesCount);
                while ($stm->fetch()) {}
                if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
                $stm->close();
            }

            if ($devicesCount > 0) {

                if (isset($_POST['orders']) && isset($_POST['salespersonID']) && strcmp($_POST['orders'], '') != 0 && strcmp($_POST['salespersonID'], '') != 0) {

                    $salespersonID = trim($_POST['salespersonID']);
                    $type = trim($_POST['type']);
                    $orders = json_decode($_POST['orders']);

                    foreach ($orders as $orderID) {
                        switch ($type){
                            case 'lock':
                                if(pickOrderIsLocked($db, $orderID)) {
                                    $order = getPickOrderDetails($db, $orderID);
                                    throw new Exception("Order $order->code is Locked by $order->person",true);
                                }

                                // change status to Locked -> salesperson
                                // add pick on order / salesperson
                                // add to new table single_pick_order
                                // add to new table lock_order_log

                                if(!pickOrderIsLockedBySalesperson($db, $orderID,$salespersonID)){
                                    $order = getPickOrderDetails($db, $orderID);
                                    throw new Exception("Order $order->code is Locked by $order->person",true);
                                }
                                break;
                            case 'check':
                                if(pickOrderIsLockedBySalesperson($db, $orderID,$salespersonID)) {
                                    $result = new stdClass();
                                    $result->status = 'success';
                                    $result->reason = 'You Locked this Order';
                                    $result->locked = true;
                                    echo json_encode($result);
                                } else {
                                    $result = new stdClass();
                                    $result->status = 'success';
                                    $result->reason = 'Order is Available';
                                    $result->locked = false;
                                    echo json_encode($result);
                                }
                                break;
                        }


                    }

                }
            }
        }

        $db->commit(true);

    } catch (Exception  $e) {
        $result = new stdClass();
        $result->status = 'failed';
        $result->reason = $e->getMessage();
        $result->locked = $e->getCode();
        echo json_encode($result);
        $db->rollback();
    }
}

function getPickOrderDetails($db, $orderID){

    $orderCode = '';
    $salespersonName = '';
    $salespersonID = 0;

    $stm = $db->prepare("SELECT order_code,salesperson_id FROM Orders WHERE order_id=?");
    $stm->bind_param('i',  $orderID);
    $stm->execute();
    $stm->bind_result($orderCode,$salespersonID);
    while ($stm->fetch()) {}
    if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
    $stm->close();

    $stm = $db->prepare("SELECT CONCAT(first_name,' ',last_name) FROM SalesPersons WHERE salesperson_id=?");
    $stm->bind_param('i',  $salespersonID);
    $stm->execute();
    $stm->bind_result($salespersonName);
    while ($stm->fetch()) {}
    if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
    $stm->close();

    $result = new stdClass();
    $result->code = $orderCode;
    $result->person = $salespersonName;

    return $result;

}

function pickOrderIsLocked($db, $orderID){

    $count = 0;

    $stm = $db->prepare("SELECT count(order_id) FROM Pick_Order_Single_Lock WHERE order_id=?");
    $stm->bind_param('i',  $orderID);
    $stm->execute();
    $stm->bind_result($count);
    while ($stm->fetch()) {}
    if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
    $stm->close();

    if($count > 0){
        return true;
    } else {
        return false;
    }
}

function pickOrderIsLockedBySalesperson($db, $orderID,$salespersonID){

    $count = 0;

    $stm = $db->prepare("SELECT count(order_id) FROM Pick_Order_Single_Lock WHERE order_id=? AND salesperson_id=?");
    $stm->bind_param('ii',  $orderID,$salespersonID);
    $stm->execute();
    $stm->bind_result($count);
    while ($stm->fetch()) {}
    if(strcmp($stm->error,"")!=0) {throw new Exception($stm->error,true);}
    $stm->close();

    if($count > 0){
        return true;
    } else {
        return false;
    }
}

?>