<?php
include_once("../../../../param.php");

$scheduleID = trim(''.$_GET['scheduleID']);
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}




?>

<div class="container" id="main" role="main" style="width: 88%">

    <div class="row" style="margin-left:10px;margin-top:10px;">
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;" id="currentDateText">
                <i class="fa-fw fa fa-map-marker"></i>
                <b>POD Map</b>
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: left;" id="currentSchedule">
                <i class="fa-fw fa fa-users"></i>
                Select Sales Person:
                <select class="form-control" style="width: 250px;display: inline-block" id="salespersonSelect">
                    <?php
                        $db->set_charset("UTF8");
                        $stm = $db->prepare("SELECT CONCAT(salesperson_code,' - ', first_name,' ',last_name), salesperson_id FROM SalesPersons WHERE landline='van'");
                        $stm-> execute();
                        $stm-> bind_result($salespersonName,$salespersonID);
                        while ($stm->fetch()) {
                            echo "<option value='$salespersonID'>$salespersonName</option>";
                        }
                        $stm-> close();
                    ?>
                </select>
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: left;" id="currentSchedule">
                <i class="fa-fw fa fa-calendar"></i>
                Select Date:
                <input type="date" class="form-control" style="width: 250px;display: inline-block" value="<?php echo date('Y-m-d')?>" id="dateSelect">
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">

        </div>

    </div>

    <!-- MAIN CONTENT -->

    <div  id="noCordinatesContainer" class="pull-right" style="float: right;background: whitesmoke;width: 19%; height: 100%;">
        <span style=" text-align: center;font-size: 16px;"><b>Not Registered Locations</b></span>
        <div  id="noCordinates" style="float: right;background: whitesmoke;width: 100%; height: 100%; margin-top: 10px;"></div>
    </div>
    <div class="map" id="map_coprime" ></div>

</div>

<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs">
</script>

<style>

    html { height: 100% }
    body { height: 100%; margin: 0px; padding: 0px }
    .container { width: 85%; height: 86% }
    #nav { z-index: 100; position: absolute;
        margin: 10px 0px 0px 200px; background-color: #fff;
        border: 1px #000 Solid; padding: 5px; }
    .map { width: 81%; height: 100% }
</style>


<script type="text/javascript">

    var copMap;
    var markers=[];

    var customerMarkers = [];

    var showCustomers = false;
    var showLines = true;

    var currentMarkerPosition = 0;
    var flightPath;
    var latlngs = [];

    function initMap()
    {
        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
        updateMarkers();
    }

    function updateMarkers()
    {
        currentMarkerPosition = 0;

        var salesperson = $('#salespersonSelect').val();
        var date = $('#dateSelect').val();

        if(flightPath != null) {
            flightPath.setMap(null);
        }
        if(latlngs != null)
        {
            latlngs = [];
        }


        $.ajax({
            type:"POST",
            dataType: "json",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/waybillPOD/controllers/getPODMapMarkersFullScreen.php',
            data: {'salesperson': salesperson,'date': date},
            success: function(data) {

                var bounds = new google.maps.LatLngBounds();

                var counter = 0;

                for (var i = 0; i < markers.length; i++) {
                    markers[i].setMap(null);
                }
                var nomarkers = '';
                $.each(data, function(index,value)
                {

                    if(value.mark === undefined){
                        counter = counter +1;
                    }
                    else{
                        nomarkers = nomarkers.concat(value.mark,'<br />');
                    }


                    if(value.lat > 0 && value.lng > 0){
                        var marker = new google.maps.Marker({
                            position: new google.maps.LatLng(value.lat, value.lng),
                            map: copMap,
                            title: value.name,
                            label: value.label
                        });

                        markers[index] = marker;
                        latlngs[index] = marker.position;

                        bounds.extend(markers[index].position);
                    }
                    $('#noCordinates').html(nomarkers);
                });

                copMap.fitBounds(bounds);

                if(showLines) {
                    flightPath = new google.maps.Polyline({
                        path: latlngs,
                        geodesic: true,
                        strokeColor: '#FF0000',
                        strokeOpacity: 1.0,
                        strokeWeight: 2
                    });
                    flightPath.setMap(copMap);
                }
            }
        });
    }

    function toggleLines()
    {
        if(showLines)
        {
            showLines = false;
            if(flightPath != null) {
                flightPath.setMap(null);
            }
        }
        else
        {
            showLines = true;

            flightPath = new google.maps.Polyline({
                path: latlngs,
                geodesic: true,
                strokeColor: '#FF0000',
                strokeOpacity: 1.0,
                strokeWeight: 2
            });
            flightPath.setMap(copMap);
        }
    }

    function toggleCustomers()
    {
        var salespersonID = $('#salespersonSelect').val();

        if(showCustomers)
        {
            showCustomers = false;

            for(i=0; i<customerMarkers.length; i++){
                customerMarkers[i].setMap(null);
            }
        }
        else
        {
            showCustomers = true;

            $.ajax({
                type:"POST",
                dataType: "json",
                url: '//<?php echo HTML_PATH ?>/cop/backend/core/controllers/get/getCustomersPositionForRouteMap.php',
                data: {salespersonID: salespersonID},
                success: function(data) {

                    for (var i = 0; i < customerMarkers.length; i++) {
                        customerMarkers[i].setMap(null);
                    }

                    $.each(data, function(index,value)
                    {
                        var marker = new google.maps.Marker({
                            position: new google.maps.LatLng(value.lat,value.lng),
                            map: copMap,
                            title: value.label
                        });

                        marker.setIcon('http://maps.google.com/mapfiles/ms/icons/blue-dot.png');
                        marker.setTitle(value.label);
                        customerMarkers[index] = marker;

                    });
                }
            });

        }
    }

    function previousMarker()
    {
        try {

            if(currentMarkerPosition > 0) {
                currentMarkerPosition = currentMarkerPosition - 1;
                var currentMarker = markers[currentMarkerPosition];
                if (currentMarker != null) {
                    currentMarker.setIcon('http://mt.googleapis.com/vt/icon/name=icons/spotlight/spotlight-poi.png');
                }
            }
            //currentMarker.setLabel((currentMarkerPosition+1).toString());
        }
        catch (err){}

    }

    function nextMarker()
    {
        try {
            if(currentMarkerPosition < markers.length)
            {
                var currentMarker = markers[currentMarkerPosition];
                if (currentMarker != null) {

                    currentMarker.setIcon('http://maps.google.com/mapfiles/ms/icons/green.png');
                    currentMarker.setLabel((currentMarkerPosition + 1).toString());
                    currentMarkerPosition = currentMarkerPosition + 1;
                }
            }
        }
        catch (err){}
    }

    $(document).ready(function() {

        pageSetUp();

        initMap();

        $('#dateSelect').change(function(){
            updateMarkers();
        });
        $('#salespersonSelect').change(function(){
            updateMarkers();
        })

    })

</script>

