<?php


$archiveOldVersion = trim($_POST['stepOne']);
$extractNewVersion = trim($_POST['StepTwo']);
$moveOldDataToNew  = trim($_POST['StepThree']);
$updateDbTables    = trim($_POST['StepFour']);
$removeOldVersion  = trim($_POST['StepFive']);
$getErrorFile      = trim($_POST['errorLog']);

if($getErrorFile > 0){
    $txt_file = file_get_contents('UPDATE_PROCESS_ERROR.COP');
    $rows     = str_replace("\n","<br>:: ", $txt_file);
    echo $rows;
    return $rows;
}

$errorFile = fopen('UPDATE_PROCESS_ERROR.COP','w');

$result = 0;

if($archiveOldVersion > 0){
    $result = archiveOldVersion($errorFile);
}

if($extractNewVersion > 0){
    $result = extractNewVersion($errorFile);
}

if($moveOldDataToNew > 0){
    $result = moveOldDataToNew($errorFile);
}

if($updateDbTables > 0){
    $result = updateDBTables($errorFile);
}

if($removeOldVersion > 0){
    $result = removeOldVersion($errorFile);
}

fclose($errorFile);

echo $result;


function archiveOldVersion($errorFile){

    if(!appSync($errorFile,'stop')){return 0;}

    if(file_exists('./cop')){

        if(!file_exists('./cop_archive')){
            mkdir("cop_archive");
        } else {
            clear_archive();
        }

        $filePrefix  = date('Ymd_Hi');
        $copFileName = $filePrefix."_cop_archive.zip";
        $sqlFileName = $filePrefix."_db_archive.sql";

        if(zipData('./cop', './cop_archive/'.$copFileName)) {
            fwrite($errorFile,"\narchives: $copFileName Created.");
            $result = archiveDB($errorFile,$sqlFileName);
        } else {
            fwrite($errorFile,"\nZIP Data: ".error_get_last()['message']);
            $result = 0;
        }

    } else {
        fwrite($errorFile,"\nCOP Dir: ".error_get_last()['message']);
        $result = 0;
    }

    return $result;

}

function extractNewVersion($errorFile){
    foreach (glob("./cop_*.zip") as $filename) {
        if (preg_match('#[0-9]#',$filename)){
            $newVersionFile = $filename;
        }
    }

    if(file_exists($newVersionFile)) {
        if (file_exists('./cop_update')){
            if(removeDir('cop_update')) {
                mkdir("cop_update");
            }
        } else {
            mkdir("cop_update");
        }
        if (file_exists('./cop_new')) {
            if(removeDir('cop_new')) {
                mkdir("cop_new");
            }
        } else {
            mkdir("cop_new");
        }

        $zip = new ZipArchive;
        $res = $zip->open($newVersionFile);
        if ($res === TRUE) {
            $zip->extractTo('cop_update/');
            $zip->close();
            $result = 1;
        } else {$result = 0;}

        if (file_exists('./cop_update/cop') && $result = 1){
            if(rename("./cop_update/cop","./cop_new")){
                if(rename("./cop_new","./cop_update")){
                    $result = 1;
                } else {$result = 0;}
            } else {$result = 0;}
        }

    } else {$result = 0;}

    return $result;

}

function moveOldDataToNew($errorFile){


    if(!transferParams()){fwrite($errorFile,"\ntransferParams - ERROR: ".error_get_last()['message']);return 0;}

    if(!recurse_copy($errorFile,'./cop_update/b2b'                             ,'./cop_update/b2b_new')){return 0;}
    if(!recurse_copy($errorFile,'./cop_update/connections'                     ,'./cop_update/connections_new')){return 0;}
    if(!recurse_copy($errorFile,'./cop_update/appConnectionPur'                ,'./cop_update/appConnectionPur_new')){return 0;}
    if(!recurse_copy($errorFile,'./cop_update/appConnection'                   ,'./cop_update/appConnection_new')){return 0;}
    if(!recurse_copy($errorFile,'./cop_update/libs/calendarnew'                ,'./cop_update/libs/calendarnew_new')){return 0;}
    if(!recurse_copy($errorFile,'./cop_update/libs/reportico/projects/reports' ,'./cop_update/libs/reportico/projects/reports_new')){return 0;}

    if(!recurse_empty($errorFile,'./cop_update/media'          ,false)){return 0;}
    if(!recurse_empty($errorFile,'./cop_update/custom'         ,true )){return 0;}
    if(!recurse_empty($errorFile,'./cop_update/b2b_new/custom' ,true )){return 0;}

    if(!recurse_copy($errorFile,'./cop/appConnection_STOPPED'          ,'./cop_update/appConnection')){return 0;}
    if(!recurse_copy($errorFile,'./cop/appConnectionPur_STOPPED'       ,'./cop_update/appConnectionPur')){return 0;}
    if(!recurse_copy($errorFile,'./cop/connections'                    ,'./cop_update/connections')){return 0;}
    if(!recurse_copy($errorFile,'./cop/b2b'                            ,'./cop_update/b2b')){return 0;}
    if(!recurse_copy($errorFile,'./cop/b2b/custom'                     ,'./cop_update/b2b_new/custom')){return 0;}
    if(!recurse_copy($errorFile,'./cop/custom'                         ,'./cop_update/custom')){return 0;}
    if(!recurse_copy($errorFile,'./cop/interface'                      ,'./cop_update/interface')){return 0;}
    if(!recurse_copy($errorFile,'./cop/logs'                           ,'./cop_update/logs')){return 0;}
    if(!recurse_copy($errorFile,'./cop/media'                          ,'./cop_update/media')){return 0;}
    if(!recurse_copy($errorFile,'./cop/libs/calendarnew'               ,'./cop_update/libs/calendarnew')){return 0;}
    if(!recurse_copy($errorFile,'./cop/libs/reportico/projects/reports','./cop_update/libs/reportico/projects/reports')){return 0;}

    if(!copy('./cop/concc/dbinfo.php'    ,'./cop_update/concc/dbinfo.php')){fwrite($errorFile,"\nrecurse_copy: /cop/concc/dbinfo.php -> /cop_update/concc/dbinfo.php - ERROR: ".error_get_last()['message']);return 0;}
    if(!copy('./cop/concc/dbinfo_b2b.php','./cop_update/concc/dbinfo_b2b.php')){fwrite($errorFile,"\nrecurse_copy: /cop/concc/dbinfo_b2b.php -> /cop_update/concc/dbinfo_b2b.php - ERROR: ".error_get_last()['message']);return 0;}
    if(!copy('./cop/.htaccess'           ,'./cop_update/.htaccess')){fwrite($errorFile,"\ncopy: /cop/.htaccess -> /cop_update/.htaccess - ERROR: ".error_get_last()['message']);return 0;}

    chmod('/cop_update/media/pdfs', 0700);
    chmod('/cop_update/media/actionAttachments', 0700);

    $themes = array_filter(glob('cop/backend/themes/*'), 'is_dir');
    foreach ($themes as $theme){
        $theme = basename($theme);
        if(strcmp($theme,'smartadmin')!=0) {
            if(!recurse_copy($errorFile,"./cop/backend/themes/$theme","./cop_update/backend/themes/$theme")){return 0;}
        }
    }

    return 1;
}

function updateDBTables($errorFile){

    $result = 1;
    $errorResult = '';

    if(file_exists('./cop_update/concc/dbinfo.php')) {
        include_once('./cop_update/concc/dbinfo.php');
        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

    } else { return 0; }

    $db->set_charset("utf8");

    try {
        $db->begin_transaction();

        $hasErrors = false;
        $dbChanges = getDbVersions();
        $executions = explode('<br>', $dbChanges);

        foreach ($executions as $execution) {
            $existQuery = get_string_between($execution, "FIRST{", "}");
            $alterQuery = get_string_between($execution, "THEN{", "}");
            if (strcmp($existQuery, '') != 0 && !$db->query($existQuery)) {
                $alter = true;
            } else {
                $alter = false;
            }

            if ($alter) {
                if (!$db->query($alterQuery)) {
                    if(strcmp($db->error,'Multiple primary key defined')==0){
                        if (!$db->query(implode('DROP PRIMARY KEY, ADD PRIMARY KEY',explode('ADD PRIMARY KEY',$alterQuery)))) {
                            fwrite($errorFile, "\nQuery: " . trim(str_replace("\n", "", $alterQuery)) . "\nError: " . $db->error . "\n-------------------------------------------------");
                            $hasErrors = true;
                        } else {
                            $result++;
                        }
                    } else {
                        fwrite($errorFile, "\nQuery: " . trim(str_replace("\n", "", $alterQuery)) . "\nError: " . $db->error . "\n-------------------------------------------------");
                        $hasErrors = true;
                    }
                } else {
                    $result++;
                }
            }
        }

        if($hasErrors) {
            $db->rollback();
            $result = 0;
        } else {
            $db->commit(true);
        }
    } catch (Exception  $e) {
        $result = 'Error: '.$e;
        $db->rollback();
    }

    return $result;
}

function removeOldVersion($errorFile){

    if(!rename(realpath(dirname(__FILE__)).'/cop',realpath(dirname(__FILE__)).'/cop_old')){return 0;}
    if(!rename(realpath(dirname(__FILE__)).'/cop_update',realpath(dirname(__FILE__)).'/cop')){return 0;}
    $result = removeDir('cop_old');

    if($result === true){

        foreach (glob("./cop_*.zip") as $filename) {
            if (preg_match('#[0-9]#',$filename)){
                $newVersionFile = $filename;
            }
        }
        unlink('./update.php');
        unlink('./updateStep2.php');
        unlink('./updateHelper.php');
        unlink('./UPDATE_PROCESS_ERROR.COP');
        if(unlink($newVersionFile)){return 1;} else {return "Update Successful.<br> Update Zip Archive Not Deleted.";}
    } else {
        return $result;
    }

}


function appSync($errorFile,$function){
    $result = true;
    switch ($function){
        case 'stop':
            if(file_exists(realpath(dirname(__FILE__)).'/cop/appConnection')) {
                if (!rename(realpath(dirname(__FILE__)) . '/cop/appConnection', realpath(dirname(__FILE__)) . '/cop/appConnection_STOPPED')) {
                    $result = false;
                    fwrite($errorFile,"\nApp Sync Stop: ".error_get_last()['message']);
                }
            }
            if(file_exists(realpath(dirname(__FILE__)).'/cop/appConnectionPur')) {
                if (!rename(realpath(dirname(__FILE__)) . '/cop/appConnectionPur', realpath(dirname(__FILE__)) . '/cop/appConnectionPur_STOPPED')) {
                    $result = false;
                    fwrite($errorFile,"\nApp Sync Stop: ".error_get_last()['message']);
                }
            }
            break;
        case 'start':
            if(file_exists(realpath(dirname(__FILE__)).'/cop/appConnection_STOPPED')) {
                if (!rename(realpath(dirname(__FILE__)) . '/cop/appConnection_STOPPED', realpath(dirname(__FILE__)) . '/cop/appConnection')) {
                    $result = false;
                    fwrite($errorFile,"\nApp Sync Start: ".error_get_last()['message']);
                }
            }
            if(file_exists(realpath(dirname(__FILE__)).'/cop/appConnectionPur_STOPPED')) {
                if (!rename(realpath(dirname(__FILE__)) . '/cop/appConnectionPur_STOPPED', realpath(dirname(__FILE__)) . '/cop/appConnectionPur')) {
                    $result = false;
                    fwrite($errorFile,"\nApp Sync Start: ".error_get_last()['message']);
                }
            }
            break;
        default:
            $result = false;
            fwrite($errorFile,"\nApp Sync: No function Added - appSync([start/stop]);");

    }

    return $result;
}

function getDbVersions(){
    $dir = './cop_update/concc/dbversions';
    $result = '';
    $lines  = '';
    $fileExists=true;
    $createTable=false;
    $major=5;
    $minor=2;
    while($fileExists){
        $validation = '';
        $file = "$dir/$major.$minor.sql";

        if(file_exists($file)) {

            $result .= "<u>VERSION $major.$minor:</u></br>" ;
//            $result .= "<br/><p style='padding-left: 10px;margin-top: 10px;font-size: 15px;'>";
            foreach(file("$file") as $line) {

                if (strpos($line, 'ALTER TABLE') !== false) {
                    if (strpos($line, 'ADD') !== false) {
                        if (strpos($line, 'INDEX') !== false) {
                            $line = str_replace('ADD INDEX(','ADD INDEX (',$line);
                            $DbTable  = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD INDEX (', ')');
                            if(strpos($DbColumn, ',') === false){
                                $validation = "SHOW INDEX FROM $DbTable WHERE Key_name='$DbColumn'";
                            }
                            $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else if (strpos($line, 'PRIMARY') !== false) {
                            $line = str_replace('ADD PRIMARY KEY(', 'ADD PRIMARY KEY (', $line);
                            $DbTable = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD PRIMARY KEY (', ')');
                            $DbTable = str_replace('DROP PRIMARY KEY,','',$DbTable);
                            if (strpos($DbColumn, ',') !== false) {
                                $validation = "SELECT $DbColumn FROM $DbTable LIMIT 1;";
                            } else {
                                $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            }
                            $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else if (strpos($line, 'UNIQUE') !== false) {
                            $line = str_replace('ADD UNIQUE(', 'ADD UNIQUE (', $line);
                            $DbTable = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD UNIQUE (', ')');
                            if (strpos($DbColumn, ',') !== false) {
                                $validation = "SELECT $DbColumn FROM $DbTable LIMIT 1;";
                            } else {
                                $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            }
                            $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                        } else {
                            $DbTable  = get_string_between($line, 'ALTER TABLE', 'ADD');
                            $DbColumn = get_string_between($line, 'ADD ', ' ');
                            $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                            $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                        }
                    } else if (strpos($line, 'CHANGE') !== false){
                        $DbTable  = get_string_between($line, 'ALTER TABLE', 'CHANGE');
                        $DbColumn = get_string_between($line, 'CHANGE ', ' ');
                        $validation = "SELECT COUNT($DbColumn) FROM $DbTable LIMIT 1;";
                        $result.= "FIRST{{$validation}}THEN{{$line}}<br>";
                    }

                } else if(strpos($line, 'CREATE TABLE') !== false){
                    $DbTable  = get_string_between($line, 'CREATE TABLE ', ' (');
                    $validation = "SELECT 1 FROM $DbTable LIMIT 1;";
                    if(strpos($line, ';') !== false){
                        $createTable = false;
                        $result .= "FIRST{{$validation}}THEN{{$line}}<br>";
                    } else {
                        $createTable = true;
                        $lines = "FIRST{{$validation}}THEN{{$line}";
                    }

                } else if($createTable && strpos($line, ';') !== false){
                    $lines .= $line;
                    $result.= "{$lines}}<br>";
                } else {
                    $lines .= $line;
                }
            }

            $minor++;
        } else {
            $major++;
            $minor=0;
            if(!file_exists("$dir/$major.$minor.sql")) {
                $minor++;
                if(!file_exists("$dir/$major.$minor.sql")) {
                    $fileExists = false;
                }
            }
        }
    }
    return $result;
}

function transferParams(){
    $paramsOld = file("./cop/param.php");
    if($paramsOld){
        $definitions = array();
        foreach ($paramsOld as $definition) {
            $define = get_string_between($definition, 'define(', ');');
            if(strcmp($define,'')!=0){
                $line   = $define;
                $define = explode(',',$define);
                $definitions[$define[0]] = $line;
            }
        }
    } else {return false;}

    $paramsOld       = file_get_contents("./cop/param.php");
    $oldCustFunction = get_string_between($paramsOld, 'function customFunction', 'function');
    $oldMultyDbInfos = get_string_between($paramsOld, '$dbInfo = dbInfoDirectory(', ');');

    $paramsNew = file("./cop_update/param.php");
    if($paramsNew){
        $paramChanges = file_get_contents("./cop_update/param.php");
        foreach ($paramsNew as $definition) {
            $define = get_string_between($definition, 'define(', ');');
            if(strcmp($define,'')!=0){
                $newline = $define;
                $define = explode(',',$define);
                if(strcmp($define[0],'"VERSION"')!=0 && strcmp($define[0],'"VERSION_NUMBER"')!=0) {
                    if (str_replace($newline, $definitions[$define[0]],  $paramChanges)){
                        $paramChanges = str_replace($newline, $definitions[$define[0]],  $paramChanges);
                    } else {
                        return false;
                    }
                }
            }
        }
        file_put_contents("./cop_update/param.php", $paramChanges);
    } else {return false;}

    $paramsNew       = file_get_contents("./cop_update/param.php");
    $newCustFunction = get_string_between($paramsNew, 'function customFunction', 'function');
    $newMultyDbInfos = get_string_between($paramsNew, '$dbInfo = dbInfoDirectory(', ');');

    if(strcmp($oldCustFunction,'')!=0){
        $paramChanges = file_get_contents("./cop_update/param.php");
        if(str_replace($newCustFunction, $oldCustFunction, $paramChanges)){
            $paramChanges = str_replace($newCustFunction, $oldCustFunction, $paramChanges);
        } else {return false;}
        file_put_contents("./cop_update/param.php", $paramChanges);
    }

    if(strcmp($oldMultyDbInfos,'')!=0){
        $paramChanges = file_get_contents("./cop_update/param.php");
        if(str_replace($newMultyDbInfos, $oldMultyDbInfos, $paramChanges)){
            $paramChanges = str_replace($newMultyDbInfos, $oldMultyDbInfos, $paramChanges);
        } else {return false;}
        file_put_contents("./cop_update/param.php", $paramChanges);
    }
    return true;
}

function archiveDB($errorFile,$archiveFile){

    if(file_exists('./cop/concc/dbinfo.php')) {

        include_once('./cop/concc/dbinfo.php');
        $db = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            fwrite($errorFile,"\nConnect failed: ".mysqli_connect_error());
            return 0;
        }
        $db->set_charset("utf8");

        $tables = array();
        $result = mysqli_query($db, "SHOW TABLES");
        while ($row = mysqli_fetch_row($result)) {
            $tables[] = $row[0];
        }
        $handle = fopen('./cop_archive/' .$archiveFile, 'w');
        foreach ($tables as $table) {
            $result = mysqli_query($db, "SELECT * FROM " . $table);
            $num_fields = mysqli_num_fields($result);
            fwrite($handle, 'DROP TABLE ' . $table . ';');
            $row2 = mysqli_fetch_row(mysqli_query($db, 'SHOW CREATE TABLE ' . $table));
            fwrite($handle, "\n\n" . $row2[1] . ";\n\n");
            for ($i = 0; $i < $num_fields; $i++) {
                while ($row = mysqli_fetch_row($result)) {
                    fwrite($handle, 'INSERT INTO ' . $table . ' VALUES(');
                    for ($j = 0; $j < $num_fields; $j++) {
                        $row[$j] = addslashes($row[$j]);
                        if (isset($row[$j])) {
                            fwrite($handle, '"' . $row[$j] . '"');
                        } else {
                            fwrite($handle, '""');
                        }
                        if ($j < $num_fields - 1) {
                            fwrite($handle, ',');
                        }
                    }
                    fwrite($handle, ");\n");
                }
            }
            fwrite($handle, "\n\n\n");
        }
        fclose($handle);

        $db->close();


        fwrite($errorFile,"\narchives: $archiveFile Created.");


        $return = 1;
    } else {
        $return = 0;
    }

    return $return;

}

function recurse_empty($errorFile,$src,$removeSubFolders)
{

    $dir = opendir($src);
    $result = true;
    while(false !== ( $file = readdir($dir)) && $result == true) {
        if (( $file != '.' ) && ( $file != '..' )) {
            if ( is_dir($src . '/' . $file) ) {
                if($removeSubFolders){
                    if(recurse_empty($errorFile,$src . '/' . $file,$removeSubFolders)) {
                        $result = rmdir($src . '/' . $file);
                    }
                } else {
                    $result = recurse_empty($errorFile,$src . '/' . $file,$removeSubFolders);
                }
            } else if (is_file($src . '/' . $file)) {
                $result = unlink($src . '/' . $file);
            }
        }
    }
    closedir($dir);

    if(!$result){
        fwrite($errorFile,"\nempty: $src - ERROR: ".error_get_last()['message']);
    }
    return $result;
}

function recurse_copy($errorFile, $src,$dst) {

    if(!file_exists($src)) {mkdir($src);}
    if(!file_exists($dst)) {mkdir($dst);}

    $dir = opendir($src);
    $result = true;
    while(false !== ( $file = readdir($dir)) && $result == true) {
        if (( $file != '.' ) && ( $file != '..' )) {
            if ( is_dir($src . '/' . $file) ) {
                if(!is_dir($dst . '/' . $file)){mkdir($dst . '/' . $file);}
                $result = recurse_copy($errorFile,$src . '/' . $file,$dst . '/' . $file);
            } else {
                $result = copy($src . '/' . $file,$dst . '/' . $file);
            }
        }
    }
    closedir($dir);

    if(!$result){
        fwrite($errorFile,"\nrecurse_copy: $src -> $dst - ERROR: ".error_get_last()['message']);
    }

    return $result;
}

function get_string_between($string, $start, $end){
    $string = ' ' . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) return '';
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}

function zipData($source, $destination) {
    $rootPath = realpath($source);

// Initialize archive object
    $zip = new ZipArchive();
    $zip->open($destination, ZipArchive::CREATE | ZipArchive::OVERWRITE);

// Create recursive directory iterator
    /** @var SplFileInfo[] $files */
    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($rootPath),
        RecursiveIteratorIterator::LEAVES_ONLY
    );

    foreach ($files as $name => $file)
    {
        // Skip directories (they would be added automatically)
        if (!$file->isDir())
        {
            // Get real and relative path for current file
            $filePath = $file->getRealPath();
            $relativePath = substr($filePath, strlen($rootPath) + 1);

            // Add current file to archive
            if(strpos($filePath, 'media/') == false){
                $zip->addFile($filePath, $relativePath);
            }
        }
    }

// Zip archive will be created only after closing object
    return $zip->close();
}

function removeDir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (is_dir($dir."/".$object) && !is_link($dir."/".$object))
                    removeDir($dir."/".$object);
                else
                    if(!unlink($dir."/".$object)){return error_get_last();}
            }
        }
        if(!rmdir($dir)){return error_get_last();}
    }
    return true;
}

function clear_archive(){
    $src = './cop_archive/';
    $dir = opendir($src);
    $result = true;
    while(false !== ( $file = readdir($dir)) && $result == true) {
        if (( $file != '.' ) && ( $file != '..' )) {
             if (is_file($src . '/' . $file) && strpos($src . '/' . $file, date('Ymd')) == false) {
                $result = unlink($src . '/' . $file);
            }
        }
    }
    closedir($dir);

    return $result;
}
