<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once('../../../../param.php');
include_once(ROOT."/libs/phpexcel/vendor/autoload.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");


$fieldSelectionData = $_POST['fieldSelectionData'];
$dataType = $_POST['dataType'];
$startingRow = $_POST['startingRow'];
$addedit = $_POST['addedit'];
$overwrite = $_POST['overwrite'];

if(strcmp($startingRow,'')==0 || $startingRow < 0){$startingRow = 0;}
if(strcmp($overwrite,'yes')==0){$overwrite = true;} else {$overwrite = false;}


foreach ($fieldSelectionData as $row) {
    $cell = $row['Excel Cell'];
    $tableField = $row['Coprime Field'];
    $cellNo = toNumber($cell);

    if (strcmp($tableField, '') != 0) {
        $import[$cell] = $tableField;
    }
}

$file_path = ROOT . "backend/modules/support/controllers/importDirectory/excelUpload.xlsx";
XLSInput($file_path,$import,$dataType,$startingRow,$cell,$addedit,$overwrite);


function toNumber($dest)
{
    if ($dest){return ord(strtolower($dest)) - 96;}
    else {return 0;}
}

function XLSInput($inputFileDirectory,$import,$dataType,$startingRow = 0,$cell='A',$addedit='add',$overwrite=false,$getSheet = 0)
{
    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
    $objReader->setReadDataOnly(true);

    $objPHPExcel = $objReader->load($inputFileDirectory);
    $sheet = $objPHPExcel->getSheet($getSheet);
    $highestRow = $sheet->getHighestRow();
//    $highestColumn = $sheet->getHighestColumn();
    $highestColumn = $cell;
    $highestColumn++;
    $endingRow = $highestRow;
    $startingRow++;


    for ($row = $startingRow; $row <= $endingRow; $row++) {

        for($column='A';$column != $highestColumn;$column++) {
            $cell = $sheet->getCell($column.$row);
            if($cell->isFormula()){
                $rowData = $cell->getOldCalculatedValue();

            } else {
                $rowData = $cell->getValue();
            }

            $dbTemplateField = $import[$column];

            if(strcmp($dbTemplateField,'')!=0){
                $parserValues[$dbTemplateField] = "$rowData";

            }

        }
        if($parserValues){
            sendToDB($dataType,$parserValues,$addedit,$overwrite);
        }

    }





}

function sendToDB($dataType,$parserValues,$addedit,$overwrite){


    if(strpos($addedit, 'add') !== false){$add = true;}else{$add = false;}
    if(strpos($addedit, 'edit') !== false){$edit = true;}else{$edit = false;}

    switch ($dataType){
        case 'Items':
            insertItems($parserValues,$add,$edit,$overwrite);
            break;
        case 'Item_Supplier':
            insertSupplierItems($parserValues,$add,$edit,$overwrite);
            break;
        case 'Customers':
            insertCustomers($parserValues,$add,$edit,$overwrite);
            break;
        case 'Suppliers':
            insertSuppliers($parserValues,$add,$edit,$overwrite);
            break;
        case 'PriceTypes':
            insertPriceTypes($parserValues,$add,$edit,$overwrite);
            break;
        case 'Prices':
            insertPrices($parserValues,$add,$edit,$overwrite);
            break;
        case 'Warehouses':
            insertWarehouses($parserValues,$add,$edit,$overwrite);
            break;
        case 'Categories':
            insertCategories($parserValues,$add,$edit,$overwrite);
            break;
        default:
            $result = false;
    }

    return $result;
}

//-----------------------------------Insert Items----------------------------------------------

function insertCategories($parserValues,$add,$edit,$overwrite){
    $categoriesTable = array('category_code'=>'','name'=>'', 'creation_date'=>'','allow_subcategories'=>'','allow_items'=>'', 'level'=>'','custom_order'=>'', 'timestamp'=>'NOW()');

    $categoriesTable = fillTableValues($parserValues,$categoriesTable);

    if(strcmp(trim($categoriesTable['category_code']),'')!=0) {


        $categoryID = getIDByFilter('Categories', 'category_id', 'category_code', $categoriesTable['category_code']);

        if($add && strcmp($categoryID,'0')==0) {$isNewID = true;} else {$isNewID = false;}

        if($isNewID){
            $categoryID = getNextKey('Categories', 'category_id');
            $categoriesTable['creation_date'] = 'NOW()';
        }

        if($isNewID && strcmp($categoriesTable['name'],'')==0){$categoriesTable['name'] = $categoriesTable['category_code'];}
        if($isNewID && strcmp($categoriesTable['level'],'')==0){$categoriesTable['level'] ='1';}

        $categoriesTable['category_id']  = $categoryID;

        $categoriesQueryResult = buildAndRunQuery($categoriesTable, 'Categories', 'category_id', 'category_code','category_code', $isNewID, $add, $edit,$overwrite);

        if($categoriesQueryResult){echo "$categoriesQueryResult <br>";}

    } else {

        echo "No Category Code Found<br>";

    }


}

function insertItems($parserValues,$add,$edit,$overwrite){

    $itemsTable        = array('item_id'=>'', 'item_code'=>'', 'item_sku'=>'', 'company_id'=>'', 'vat_id'=>'', 'subunits'=>'', 'sales_units'=>'', 'manufacturer_id'=>'', 'name'=>'', 'short_description'=>'', 'long_description'=>'', 'thumbnail_url'=>'', 'reorder_level'=>'', 'target_qty'=>'', 'bundled'=>'', 'max_stock'=>'', 'min_stock'=>'', 'packing'=>'', 'stock_control'=>'yes', 'sellable'=>'yes', 'weight'=>'', 'cbm'=>'', 'status'=>'', 'timestamp'=>'NOW()');
    $barcodeTable      = array('item_id'=>'', 'barcode'=>'', 'multiplier'=>'1', 'default_barcode'=>'yes', 'timestamp'=>'NOW()' );
    $categoryItemTable = array('category_id'=>'', 'item_id'=>'', 'position'=>'0', 'timestamp'=>'NOW()' );
    $stockTable        = array('warehouse_id'=>'', 'item_id'=>'', 'batch_number'=>'0', 'available'=>'', 'reserved'=>'', 'delivered'=>'', 'on_order'=>'', 'requested'=>'', 'sold'=>'', 'expiry_date'=>'', 'timestamp'=>'NOW()' );
    $pricesTable       = array('item_id'=>'', 'pricetype_id'=>'', 'price'=>'', 'allow_discount'=>'', 'inc_vat'=>'', 'timestamp'=>'NOW()' );

    $itemsTable        = fillTableValues($parserValues,$itemsTable);
    $barcodeTable      = fillTableValues($parserValues,$barcodeTable);
    $categoryItemTable = fillTableValues($parserValues,$categoryItemTable);
    $stockTable        = fillTableValues($parserValues,$stockTable);
    $pricesTable       = fillTableValues($parserValues,$pricesTable);

    if(strcmp($itemsTable['status'],'')!=0){if(strcmp($itemsTable['status'],'no')!=0) {$itemsTable['status'] = "yes";} else {$itemsTable['status'] = "inactive";}}
    if(strcmp($itemsTable['vat_id'],'')!=0) {$itemsTable['vat_id'] = getIDByFilter('Vats', 'vat_id', 'vat_code', $itemsTable['vat_id']);}
    if(strcmp($itemsTable['subunits'],'')==0 || $itemsTable['subunits'] <= 1) {$itemsTable['subunits'] = "1";}

    if(strcmp($itemsTable['item_code'],'')!=0) {

        $itemID      = getIDByFilter('Items', 'item_id', 'item_code', $itemsTable['item_code']);
        $categoryID  = getIDByFilter('Categories', 'category_id', 'category_code', $parserValues['category_code']);
        $warehouseID = getIDByFilter('Warehouses', 'warehouse_id', 'warehouse_code', $parserValues['warehouse_code']);
        $priceTypeID = getIDByFilter('PriceTypes', 'pricetype_id', 'price_code', $parserValues['price_code']);

        if($add && $itemID == 0) {$isNewID = true;} else {$isNewID = false;}
        if($isNewID){$itemID = getNextKey('Items', 'item_id');}

        $itemsTable['item_id']    = $itemID;
        $barcodeTable['item_id']  = $itemID;

        $stockTable['item_id']      = $itemID;
        $stockTable['warehouse_id'] = $warehouseID;

        $categoryItemTable['item_id']     = $itemID;
        $categoryItemTable['category_id'] = $categoryID;

        $pricesTable['item_id']     = $itemID;
        $pricesTable['pricetype_id'] = $priceTypeID;

        $itemsQueryResult = buildAndRunQuery($itemsTable, 'Items', 'item_id', 'item_code','item_code', $isNewID, $add, $edit,$overwrite);

        if(strcmp($barcodeTable['barcode'],'')!=0 && $itemID > 0){

            $oldBarcode = getIDByFilter('Item_Barcode', 'barcode', 'item_id', $itemID);

            if($add && strcmp($oldBarcode,'0')==0) {$isNewBarcode = true;} else {$isNewBarcode = false;}

            $barcodesQueryResult = buildAndRunQuery($barcodeTable, 'Item_Barcode', 'item_id', 'barcode','barcode', $isNewBarcode, $add, $edit,$overwrite);
        }

        if(strcmp($categoryItemTable['category_id'],'0')!=0 && $itemID > 0){

            $oldCategory = getIDByFilter('Category_Item', 'category_id', 'item_id', $itemID);

            if($add && strcmp($oldCategory,'0')==0) {$isNewCategory = true;} else {$isNewCategory = false;}

            $categoriesQueryResult = buildAndRunQuery($categoryItemTable, 'Category_Item', 'item_id', 'category_id','', $isNewCategory, $add, $edit,$overwrite);
        }

        if(strcmp($stockTable['warehouse_id'],'0')!=0 && $itemID > 0){

            $oldCategory = getIDByFilter('Stock', 'warehouse_id', 'item_id', $itemID);

            if($add && strcmp($oldCategory,'0')==0) {$isNewStock = true;} else {$isNewStock = false;}

            if(strcmp($stockTable['available'],'')!=0) {
                $stockQueryResult = buildAndRunQuery($stockTable, 'Stock', 'item_id', 'warehouse_id','available', $isNewStock, $add, $edit, $overwrite);
            }
        }

        if(strcmp($pricesTable['pricetype_id'],'0')!=0 && $itemID > 0){

            $oldPrice = getIDByFilter('Prices', 'pricetype_id', 'item_id', $itemID);

            if($add && strcmp($oldPrice,'0')==0) {$isNewPrice = true;} else {$isNewPrice = false;}

            if(strcmp($pricesTable['price'],'')!=0) {
                $priceQueryResult = buildAndRunQuery($pricesTable, 'Prices', 'item_id', 'pricetype_id','price', $isNewPrice, $add, $edit, $overwrite);
            }
        }

        if($itemsQueryResult){echo "$itemsQueryResult $categoriesQueryResult $barcodesQueryResult $stockQueryResult $priceQueryResult<br>";}

    } else {

        echo "No Item Code Found<br>";

    }
}

function insertCustomers($parserValues,$add,$edit,$overwrite){
    $customersTable = array('customer_id'=>'','customer_code'=>'', 'customer_company_name'=>'','customer_report_name'=>'', 'logo'=>'', 'registration_code'=>'', 'mobile'=>'', 'website'=>'', 'email'=>'', 'description'=>'', 'type_of_business'=>'', 'tic_code'=>'', 'vat_code'=>'', 'credit_limit'=>'', 'address_code_eurosoft'=>'', 'customer_type'=>'', 'balance'=>'',   'timestamp'=>'NOW()');
    $addressesTable = array('customer_address_id'=>'','address_code'=>'', 'customer_id'=>'','country'=>'', 'city'=>'', 'address_line_1'=>'', 'address_line_2'=>'', 'postcode'=>'', 'region'=>'', 'lat'=>'', 'lng'=>'', 'pobox'=>'', 'landline'=>'', 'fax'=>'', 'primary_address'=>'', 'timestamp'=>'NOW()');
    $chartOfAccounts = array('account_id'=>'','account_code'=>'', 'type_id'=>'0','local_currency_id'=>'0','timestamp'=>'NOW()');
    $customerGroup = array('group_id'=>'','customer_id'=>'', 'added_date'=>'NOW()','salesperson_id'=>'0','timestamp'=>'NOW()');

    $customersTable = fillTableValues($parserValues,$customersTable);
    $addressesTable = fillTableValues($parserValues,$addressesTable);

    $groupID  = getIDByFilter('CustomerGroups', 'group_id', 'group_code', $parserValues['group_code']);

    $customerGroup['group_id'] = $groupID;

    if(strcmp(trim($customersTable['customer_code']),'')!=0) {


        if(strcmp($addressesTable['address_code'],'')==0){$addressesTable['address_code'] = $customersTable['customer_code'];}
        if(strcmp($customersTable['type_of_business'],'')!=0){if(strcmp($customersTable['type_of_business'],'no')!=0) {$customersTable['type_of_business'] = "Credit";} else {$customersTable['type_of_business'] = "Inactive";}}

        $customerID = getIDByFilter('Customers', 'customer_id', 'customer_code', $customersTable['customer_code']);
        $addressID  = getIDByFilter('CustomerAddress', 'customer_address_id', 'address_code', $addressesTable['address_code']);

        if($add && strcmp($addressID,'0')==0) {$isNewAddress = true;} else {$isNewAddress = false;}
        if($add && strcmp($customerID,'0')==0) {$isNewID = true;} else {$isNewID = false;}

        if($isNewID){$customerID = getNextKey('Customers', 'customer_id');}
        if($isNewAddress){$addressID  = getNextKey('CustomerAddress', 'customer_address_id');}

        if($isNewID && strcmp($customersTable['balance'],'')==0){$customersTable['balance'] = "0";}

        $customersTable['customer_id']         = $customerID;
        $addressesTable['customer_id']         = $customerID;
        $chartOfAccounts['account_id']         = $customerID;
        $customerGroup['customer_id']          = $customerID;
        $addressesTable['customer_address_id'] = $addressID;

        $chartOfAccounts['account_code']       = $customersTable['customer_code'];
        $chartOfAccounts['account_name']       = $customersTable['customer_company_name'];


        $customersQueryResult  = buildAndRunQuery($customersTable, 'Customers', 'customer_id', 'customer_code','customer_code', $isNewID, $add, $edit,$overwrite);
        $addressesQueryResult  = buildAndRunQuery($addressesTable, 'CustomerAddress', 'customer_address_id', 'address_code','address_code', $isNewAddress, $add, $edit,$overwrite);
        $chartOfAccountsResult = buildAndRunQuery($chartOfAccounts, 'ChartOfAccounts', 'account_id', 'account_code','account_code', $isNewID, $add, $edit,$overwrite);

        $customerGroupQueryResult = '';

        if(strcmp($customerGroup['group_id'],'0')!=0 && $customerID > 0){

            $oldGroup = getIDByFilter('Customer_CustomersGroup', 'group_id', 'customer_id', $customerID);

            if($add && strcmp($oldGroup,'0')==0) {$isNewGroup = true;} else {$isNewGroup = false;}

            $customerGroupQueryResult = buildAndRunQuery($customerGroup, 'Customer_CustomersGroup', 'customer_id', 'group_id','', $isNewGroup, $add, $edit,$overwrite);
        }

        if($customersQueryResult){echo "$customersQueryResult $addressesQueryResult $customerGroupQueryResult<br>";}

    } else {

        echo "No Customer Code Found<br>";

    }
}

function insertSuppliers($parserValues,$add,$edit,$overwrite){
    $suppliersTable = array('customer_id'=>'','customer_code'=>'', 'customer_company_name'=>'','customer_report_name'=>'', 'logo'=>'', 'registration_code'=>'', 'mobile'=>'', 'website'=>'', 'email'=>'', 'description'=>'', 'type_of_business'=>'', 'tic_code'=>'', 'vat_code'=>'', 'credit_limit'=>'', 'address_code_eurosoft'=>'', 'customer_type'=>'', 'balance'=>'',   'timestamp'=>'NOW()');
    $addressesTable = array('supplier_address_id'=>'','address_code'=>'', 'supplier_id'=>'','country'=>'', 'city'=>'', 'address_line_1'=>'', 'address_line_2'=>'', 'postcode'=>'', 'region'=>'', 'lat'=>'', 'lng'=>'', 'pobox'=>'', 'landline'=>'', 'fax'=>'', 'primary_address'=>'', 'timestamp'=>'NOW()');

    $suppliersTable = fillTableValues($parserValues,$suppliersTable);
    $addressesTable = fillTableValues($parserValues,$addressesTable);



    if(strcmp(trim($suppliersTable['customer_code']),'')!=0) {


        if(strcmp($addressesTable['address_code'],'')==0){$addressesTable['address_code'] = $suppliersTable['customer_code'];}
        if(strcmp($suppliersTable['type_of_business'],'')!=0){if(strcmp($suppliersTable['type_of_business'],'no')!=0) {$suppliersTable['type_of_business'] = "Credit";} else {$suppliersTable['type_of_business'] = "Inactive";}}

        $supplierID = getIDByFilter('Suppliers', 'customer_id', 'customer_code', $suppliersTable['customer_code']);
        $addressID  = getIDByFilter('SupplierAddress', 'supplier_address_id', 'address_code', $addressesTable['address_code']);

        if($add && strcmp($addressID,'0')==0) {$isNewAddress = true;} else {$isNewAddress = false;}
        if($add && strcmp($supplierID,'0')==0) {$isNewID = true;} else {$isNewID = false;}

        if($isNewID){$supplierID = getNextKey('Suppliers', 'customer_id');}
        if($isNewAddress){$addressID  = getNextKey('SupplierAddress', 'supplier_address_id');}

        if($isNewID && strcmp($suppliersTable['balance'],'')==0){$suppliersTable['balance'] = "0";}

        $suppliersTable['customer_id']         = $supplierID;
        $addressesTable['supplier_id']         = $supplierID;
        $addressesTable['supplier_address_id'] = $addressID;

        $customersQueryResult  = buildAndRunQuery($suppliersTable, 'Suppliers', 'customer_id', 'customer_code','customer_code', $isNewID, $add, $edit,$overwrite);
        $addressesQueryResult  = buildAndRunQuery($addressesTable, 'SupplierAddress', 'supplier_address_id', 'address_code','address_code', $isNewAddress, $add, $edit,$overwrite);

        if($customersQueryResult || $addressesQueryResult){echo "$customersQueryResult $addressesQueryResult <br>";}

    } else {

        echo "No Customer Code Found<br>";

    }
}

function insertPriceTypes($parserValues,$add,$edit,$overwrite){
    $priceTypesTable = array('pricetype_id'=>'','price_code'=>'', 'name'=>'','allow_discount'=>'', 'default_type'=>'', 'timestamp'=>'NOW()');

    $priceTypesTable = fillTableValues($parserValues,$priceTypesTable);

    if(strcmp(trim($priceTypesTable['price_code']),'')!=0) {


        $priceTypeID = getIDByFilter('PriceTypes', 'pricetype_id', 'price_code', $priceTypesTable['price_code']);

        if($add && strcmp($priceTypeID,'0')==0) {$isNewID = true;} else {$isNewID = false;}

        if($isNewID){$priceTypeID = getNextKey('PriceTypes', 'pricetype_id');}


        if($isNewID && strcmp($priceTypesTable['name'],'')==0){$priceTypesTable['name'] = $priceTypesTable['price_code'];}

        $priceTypesTable['pricetype_id']         = $priceTypeID;

        $PriceTypesQueryResult = buildAndRunQuery($priceTypesTable, 'PriceTypes', 'pricetype_id', 'price_code','price_code', $isNewID, $add, $edit,$overwrite);

        if($PriceTypesQueryResult){echo "$PriceTypesQueryResult <br>";}

    } else {

        echo "No Price Type Code Found<br>";

    }
}

function insertSupplierItems($parserValues,$add,$edit,$overwrite){
    $supplierItemsTable = array('supplier_code'=>'','item_code'=>'', 'price'=>'','lead_time'=>'', 'timestamp'=>'NOW()');

    $supplierItemsTable = fillTableValues($parserValues,$supplierItemsTable);

    if(strcmp(trim($supplierItemsTable['supplier_code']),'')!=0) {
        $supplierItemsTable['supplier_id'] = getIDByFilter('Suppliers', 'customer_id', 'customer_code', $supplierItemsTable['supplier_code']);
    }
    if(strcmp(trim($supplierItemsTable['item_code']),'')!=0) {
        $supplierItemsTable['item_id'] = getIDByFilter('Items', 'item_id', 'item_code', $supplierItemsTable['item_code']);
    }

    if((int)$supplierItemsTable['item_id'] > 0 && (int)$supplierItemsTable['supplier_id'] > 0) {
        $displayField = $supplierItemsTable['supplier_code']." - ".$supplierItemsTable['item_code']." - ".$supplierItemsTable['price'];
        unset($supplierItemsTable['supplier_code']);
        unset($supplierItemsTable['item_code']);


        if($overwrite) {
            if (strcmp($supplierItemsTable['lead_time'], '') == 0) {$supplierItemsTable['lead_time'] = '';}
        }

        $supplierItemsQueryResult = buildAndRunLinkedTableQuery($supplierItemsTable,'Item_Supplier',array('item_id','supplier_id'),$displayField,$add,$edit,$overwrite);

        if($supplierItemsQueryResult){echo "$supplierItemsQueryResult <br>";}

    } else {
        if((int)$supplierItemsTable['item_id'] == 0 && (int)$supplierItemsTable['supplier_id'] > 0) {
            echo "Item ".$supplierItemsTable['item_code']." Not Found<br>";
        }

        if((int)$supplierItemsTable['supplier_id'] == 0 && (int)$supplierItemsTable['item_id'] > 0) {
            echo "Supplier ".$supplierItemsTable['supplier_code']." Not Found<br>";
        }


    }
}

function insertPrices($parserValues,$add,$edit,$overwrite){
    $pricesTable = array('item_code'=>'','price_code'=>'', 'price'=>'','allow_discount'=>'', 'inc_vat'=>'', 'timestamp'=>'NOW()');

    $pricesTable = fillTableValues($parserValues,$pricesTable);

    if(strcmp(trim($pricesTable['item_code']),'')!=0) {
        $pricesTable['item_id'] = getIDByFilter('Items', 'item_id', 'item_code', $pricesTable['item_code']);
    }
    if(strcmp(trim($pricesTable['price_code']),'')!=0) {
        $pricesTable['pricetype_id'] =getIDByFilter('PriceTypes', 'pricetype_id', 'price_code', $pricesTable['price_code']);
    }

    if((int)$pricesTable['item_id'] > 0 && (int)$pricesTable['pricetype_id'] > 0) {
        $displayField = $pricesTable['item_code']." - ".$pricesTable['price_code']." - ".$pricesTable['price'];
        unset($pricesTable['price_code']);
        unset($pricesTable['item_code']);


        if($overwrite) {
            if (strcmp($pricesTable['allow_discount'], '') == 0) {$pricesTable['allow_discount'] = '';}
            if (strcmp($pricesTable['inc_vat'], '') == 0) {$pricesTable['inc_vat'] = 'no';}
        }

        $PricesQueryResult = buildAndRunLinkedTableQuery($pricesTable,'Prices',array('item_id','pricetype_id'),$displayField,$add,$edit,$overwrite);

        if($PricesQueryResult){echo "$PricesQueryResult <br>";}

    } else {
        if((int)$pricesTable['item_id'] == 0 && (int)$pricesTable['pricetype_id'] > 0) {
            echo "Item ".$pricesTable['item_code']." Not Found<br>";
        }

        if((int)$pricesTable['pricetype_id'] == 0 && (int)$pricesTable['item_id'] > 0) {
            echo "Price List ".$pricesTable['price_code']." Not Found<br>";
        }


    }
}

function insertWarehouses($parserValues,$add,$edit,$overwrite){
    $warehousesTable = array('warehouse_id'=>'','warehouse_code'=>'', 'company_id'=>'0','name'=>'', 'type'=>'','landline'=>'','fax'=>'','email'=>'','country'=>'','city'=>'','address_line_1'=>'','address_line_2'=>'','postcode'=>'','region'=>'','lat'=>'','lng'=>'','pobox'=>'','salesperson_id'=>'', 'timestamp'=>'NOW()');

    $warehousesTable = fillTableValues($parserValues,$warehousesTable);

    if(strcmp(trim($warehousesTable['warehouse_code']),'')!=0) {


        $warehouseID = getIDByFilter('Warehouses', 'warehouse_id', 'warehouse_code', $warehousesTable['warehouse_code']);

        if($add && strcmp($warehouseID,'0')==0) {$isNewID = true;} else {$isNewID = false;}

        if($isNewID){$warehouseID = getNextKey('Warehouses', 'warehouse_id');}

        if($isNewID && strcmp($warehousesTable['name'],'')==0){$warehousesTable['name'] = $warehousesTable['warehouse_code'];}

        $warehousesTable['warehouse_id']  = $warehouseID;

        $warehousesQueryResult = buildAndRunQuery($warehousesTable, 'Warehouses', 'warehouse_id', 'warehouse_code','warehouse_code', $isNewID, $add, $edit,$overwrite);

        if($warehousesQueryResult){echo "$warehousesQueryResult <br>";}

    } else {

        echo "No Warehouse Code Found<br>";

    }
}

function getIDByFilter($table,$idField,$filterField,$filterValue){



    global $username, $password, $database;
    $ID=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT $idField FROM $table WHERE $filterField LIKE '$filterValue' ORDER BY $idField DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($res);
    while ($stm1->fetch()) {if(strcmp($res,'')!=0){$ID=$res;}}
    $stm1->close();

    return $ID;
}

function buildAndRunQuery($table,$tableName,$tableIDField,$tableCodeField,$displayField,$isNewID,$add,$edit,$overwrite=false){

    $insertFields = '';
    $insertValues = '';
    $updateFieldValues = '';
    $updateFilterValue = '';
    $displayName = str_replace('_',' ', rtrim($tableName,'s'));
    if(strcmp($displayName,"CustomerAddre")==0){$displayName="Address";}
    if(strcmp($displayName,"Customer CustomersGroup")==0){$displayName="Customer Group";}
    $tableIDValue = $table[$tableIDField];

    foreach ($table as $field => $val){

        $val = str_replace('"',"'", $val);
        $insertFields .= "$field,";

        if(strcmp($val,'NOW()')==0){

            $insertValues .= "$val,";
            $updateFieldValues .= "$field=$val,";

        } else if(strcmp($field,$tableIDField)==0){
            $insertValues .= "\"$val\",";
            $updateFilterValue .= "$field=\"$val\"";

        } else {

            $insertValues .= "\"$val\",";
            if($overwrite || strcmp($val,'')!=0) {
                $updateFieldValues .= "$field=\"$val\",";
            }

        }

    }

    $insertFields      = trim($insertFields,',');
    $insertValues      = trim($insertValues,',');
    $updateFieldValues = trim($updateFieldValues,',');
    $updateFilterValue = trim($updateFilterValue,',');


    if($tableIDValue > 0 && $isNewID && $add) {
        $query = "INSERT IGNORE INTO $tableName ($insertFields) VALUES ($insertValues)";
        $result =  "INSERT $displayName ";

    } else if($tableIDValue > 0 && !$isNewID && $edit){
        $query = "UPDATE IGNORE $tableName SET $updateFieldValues WHERE $updateFilterValue";
        $result = "UPDATE $displayName ";
    }


    if(strcmp($query,'')!=0) {

        $error = "OK";

        global $username, $password, $database;
        $db = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db->set_charset("utf8");
        $stmt = $db->prepare($query);
        $stmt->execute();
        if(strcmp($stmt->error,'')!=0){$error = " ERROR: $stmt->error ";}
        $stmt->close();

        $fieldDisplay = '';
        if(strcmp($displayField,'')!=0){
            $fieldDisplay = $table[$displayField];
        }
        return "$result $fieldDisplay - $error";
    } else {
        return false;
    }
}

function buildAndRunLinkedTableQuery($table,$tableName,$tableIDFields,$displayField,$add,$edit,$overwrite=false){

    $insertFields = '';
    $insertValues = '';
    $updateFieldValues = '';
    $updateFilterValue = '';
    $displayName = str_replace('_',' ', rtrim($tableName,'s'));
    if(strcmp($displayName,"CustomerAddre")==0){$displayName="Address";}


    foreach ($table as $field => $val){

        $val = str_replace('"',"'", $val);
        $insertFields .= "$field,";

        if(strcmp($val,'NOW()')==0){

            $insertValues .= "$val,";
            $updateFieldValues .= "$field=$val,";

        } else if(in_array($field, $tableIDFields)){

            $insertValues .= "\"$val\",";
            if(strcmp($updateFilterValue,'')!=0){$updateFilterValue .= " AND ";}
            $updateFilterValue .= "$field=\"$val\"";

        } else {

            $insertValues .= "\"$val\",";
            if($overwrite || strcmp($val,'')!=0) {
                $updateFieldValues .= "$field=\"$val\",";
            }

        }

    }

    $insertFields      = trim($insertFields,',');
    $insertValues      = trim($insertValues,',');
    $updateFieldValues = trim($updateFieldValues,',');
    $updateFilterValue = trim($updateFilterValue,',');


    if($edit && $add){
        $query = "INSERT INTO $tableName ($insertFields) VALUES ($insertValues) ON DUPLICATE KEY UPDATE $updateFieldValues";
        $result =  "INSERT/UPDATE $displayName ";
    } else if($edit){
        $query = "UPDATE IGNORE $tableName SET $updateFieldValues WHERE $updateFilterValue";
        $result = "UPDATE $displayName ";
    } else if($add) {
        $query = "INSERT IGNORE INTO $tableName ($insertFields) VALUES ($insertValues)";
        $result =  "INSERT $displayName ";

    }


    if(strcmp($query,'')!=0) {

        $error = "OK";

        global $username, $password, $database;
        $db = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

//        echo $query;

        $db->set_charset("utf8");
        $stmt = $db->prepare($query);
        $stmt->execute();
        if(strcmp($stmt->error,'')!=0){$error = " ERROR: $stmt->error ";}
        $stmt->close();

        $fieldDisplay = '';
        if(strcmp($displayField,'')!=0){
            $fieldDisplay = $displayField;
        }
        return "$result $fieldDisplay - $error";
    } else {
        return false;
    }
}

function fillTableValues($parserValues,$table){

    foreach ($parserValues as $tableField => $value){

        if (array_key_exists($tableField,$table)){

            $table[$tableField] = "$value";
        }
    }

    return $table;
}

?>