<?php
include_once('../../../../param.php');


if(!isset($_SESSION['adminID'])){
    http_response_code(401);
    exit;
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Html;
require_once (ROOT . "libs/phpSpreadsheet/vendor/autoload.php");


//$fieldSelectionData = $_POST['fieldSelectionData'];
$fieldSelectionData = json_decode($_POST['fieldSelectionData'], true);

$dataType = $_POST['dataType'];
$startingRow = intval($_POST['startingRow']) + 1; //excel rows start from 1 not 0

if(!empty($_POST['exportFileName'])){
    $exportFileName = $_POST['exportFileName'];
}
else{
    $exportFileName =  'Export_' . $dataType;
}

$exportFileName .=".xlsx";
$exportFields = [];

foreach ($fieldSelectionData as $row) {
    $excelColumn = $row['Excel Cell'];
    $dbField = $row['Coprime Field'];
    $fieldText = $row['Header Text'];
    if (!empty($dbField)) {
        $exportFields[$dbField] = [
            'excelColumn' => $excelColumn,
            'headerText' => $fieldText
        ];
    }
}

if (empty($exportFields)) {
    exit();
}

$data = retrieveData($dataType, array_keys($exportFields));

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// write headers
foreach ($exportFields as $dbField => $fieldData) {
    $columnLetter = $fieldData['excelColumn'];
    $headerText = $fieldData['headerText'];
    $sheet->setCellValue($columnLetter . $startingRow, $headerText);
    $sheet->getStyle($columnLetter . $startingRow)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);
    $sheet->getStyle($columnLetter . $startingRow)->getFont()->setBold(true);
    $sheet->getStyle($columnLetter . $startingRow)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('CADBF7');
}

// write data
$rowNumber = $startingRow + 1; //skip header
foreach ($data as $row) {
    foreach ($exportFields as $dbField => $fieldData) {
        $columnLetter = $fieldData['excelColumn'];
        $value = $row[$dbField] ;
        $sheet->setCellValue($columnLetter . $rowNumber, $value);
        $sheet->getStyle($columnLetter . $rowNumber)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);

    }
    $rowNumber++;
}

exportExcel($spreadsheet, $exportFileName);

function exportExcel($spreadsheet, $fileName) {
    $writer = new Xlsx($spreadsheet);
    ob_end_clean();
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $fileName . '"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
    exit();
}

function getItemJoins($fieldList){
    $joins = [];

    if (str_contains($fieldList, 'vat_code')) {
        $joins[] = "LEFT JOIN Vats ON Items.vat_id = Vats.vat_id";
    }
    if (str_contains($fieldList, 'barcode') || str_contains($fieldList, 'default_barcode')) {
        $joins[] = "LEFT JOIN Item_Barcode ON Items.item_id = Item_Barcode.item_id";
    }
    if ( str_contains($fieldList, 'price_code') || str_contains($fieldList, 'prices') ) {
        $joins[] = "LEFT JOIN Prices ON Items.item_id = Prices.item_id LEFT JOIN PriceTypes ON PriceTypes.pricetype_id = Prices.pricetype_id";
    }
    if (str_contains($fieldList, 'category_code')) {
        $joins[] = "LEFT JOIN Category_Item ON Items.item_id = Category_Item.item_id LEFT JOIN Categories ON Category_Item.category_id = Categories.category_id"; ;
    }
    if (str_contains($fieldList, 'warehouse_code') || str_contains($fieldList, 'available')) {
        $joins[] = "LEFT JOIN Stock ON Items.item_id = Stock.item_id LEFT JOIN  Warehouses ON Stock.warehouse_id = Warehouses.warehouse_id";
    }


    return $joins;

}

function getCustomerJoins($fieldList){
    $joins = [];
    $addressFields = ['address_code', 'country', 'city', 'region', 'address_line_1', 'address_line_2', 'postcode', 'pobox', 'lat', 'lng', 'primary_address','landline'];

    foreach ($addressFields as $field) {
        if (str_contains($fieldList, $field)) {
            $joins[] = "LEFT JOIN CustomerAddress ON Customers.customer_id = CustomerAddress.customer_id";
            break;
        }
    }
    if (str_contains($fieldList, 'group_code') ) {
        $joins[] = "LEFT JOIN Customer_CustomersGroup ON Customers.customer_id = Customer_CustomersGroup.customer_id
                    LEFT JOIN CustomerGroups ON CustomerGroups.group_id = Customer_CustomersGroup.group_id";
    }

    return $joins;

}
function retrieveData($dataType, $fields) {
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $fieldList = implode(',', $fields);
    $query = "";

    switch ($dataType) {
        case 'Items':
            $joins = getItemJoins($fieldList);
            $fieldList = str_replace('name', 'Items.name', $fieldList);
            $query = "SELECT $fieldList FROM Items " . implode(" ", $joins);
            break;
        case 'Customers':
            $joins = getCustomerJoins($fieldList);
            $fieldList = str_replace('description', 'Customers.description', $fieldList);
            $query = "SELECT $fieldList FROM Customers " . implode(" ", $joins);
            break;
        case 'PriceTypes':
            $query = "SELECT $fieldList FROM PriceTypes";
            break;
        case 'Prices':
            $fieldList = str_replace('allow_discount', 'Prices.allow_discount', $fieldList);
            $query = "SELECT $fieldList FROM Prices 
                     LEFT JOIN Items ON Prices.item_id = Items.item_id 
                     LEFT JOIN PriceTypes ON Prices.pricetype_id = PriceTypes.pricetype_id";
            break;
        case 'Warehouses':
            $query = "SELECT $fieldList FROM Warehouses";
            break;
        case 'Categories':
            $query = "SELECT $fieldList FROM Categories";
            break;
        default:
            return [];
    }


    $result = $db->query($query);
    $data = [];

    while ($row = $result->fetch_assoc()) {
        if (isset($row['default_barcode']) && (empty(trim($row['default_barcode'])) || $row['default_barcode']==null)) {
            $row['default_barcode'] = 'no';
        }
        if (isset($row['status']) && (empty($row['status']) || strcmp($row['status'],"inactive")==0 )) {
            $row['default_barcode'] = 'no';
        }
        if (isset($row['allow_items']) && (empty(trim($row['allow_items'])) || $row['allow_items']==null)) {
            $row['allow_items'] = 'no';
        }
        if (isset($row['allow_subcategories']) && (empty(trim($row['allow_subcategories'])) || $row['allow_subcategories']==null)) {
            $row['allow_subcategories'] = 'no';
        }
        $data[] = $row;
    }
    return $data;
}
?>