<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/modules/sapServiceLayerReader/model/SAPClient.php");
require_once(ROOT . "/backend/core/model/CopJsonHandler.php");

$sapTable = 'view.svc/ctrx_ScraptReasons_B1SLQuery';
$hideColumns = array('id__','Code','Name','U_PU1','U_PU2','U_PU3','U_PU4','U_PU5','U_SPIN-ON','U_CABIN','U_ELEMENTS','U_PARTS-10T','U_PARTS-BMV');
$filterQuery = '';
$filterNext = '';
$title = trim($_POST['title']);
$prodLine = trim($_POST['prodLine']);

if (($key = array_search('U_'.$prodLine, $hideColumns)) !== false) {
    unset($hideColumns[$key]);
}



global $username,$password,$database;
$db= new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT erp_host,erp_port,erp_username,erp_identifier,erp_database,erp_error_mail,erp_name FROM ERP_Connection LIMIT 1");
$stm->execute();
$stm->bind_result($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB,$errorMail,$erpName);
while ($stm->fetch()) {}
$stm->close();

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$erpErrors = $client->getErrors();

$result = $client->requestDataRecursive($sapTable.$filterQuery,'',false);
$arr = $result[0];
$keys = array_keys($arr[0]);

$columnNumber = 0;
$scrapCodes = array();

$str  = '<table style="width: 100%" class="table table-bordered"><tr>';
foreach ($arr as $d)
{
    foreach ($keys as $k)
    {
        $scrapCode=$d['Code'];

        if(!in_array($k,$hideColumns)) {
            if (!is_array($d[$k]) && strcmp($d[$k],'')!=0) {
                $columnNumber++;
                array_push($scrapCodes,$scrapCode);
                $str .= "<td style='padding: 1px;border: 1px solid white;'><label class='pull-right' style='vertical-align: center; padding: 6px;'><b>$d[$k]</b></label></td><td style='border: 1px solid white;'><input type='hidden' class='form-control text-center scrapCode' id='c$scrapCode' name='c$scrapCode' value='$scrapCode'><input type='hidden' class='form-control text-center scrapName' id='n$scrapCode' name='n$scrapCode' value='$d[$k]'><input type='number' class='form-control text-center scrapQty' id='q$scrapCode' name='q$scrapCode' style='width: 50%;'></td>";

                if($columnNumber % 3 == 0) {
                    $str .= "</tr><tr>";
                }
            }
        }
    }
}
$str .= "</tr></table>";
$scrapCodes = array_unique($scrapCodes);
$scrapCodesVar = implode("','",$scrapCodes);
$str  .= '<button type="button" class="btn btn-primary pull-left" id="closeProductionConfirmButton" onclick="closeProduction([\''.$scrapCodesVar.'\'])"><b> Close Production Order</button><button type="button" class="btn btn-danger pull-right" id="closeProductionCancelButton" style="width: 100px;" onclick="$(\'#closeProductionModal\').modal(\'toggle\');"><b> Cancel</button><br><br>';
echo $str;

