<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'ZE_Rebates';

// Table's primary key
$primaryKey = "rebate_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`rebate_id`', 'dt' => 'logo', 'formatter' => function( $d, $row ) {
        return '<img class="img-rounded center-canvas" src="//' . HTML_PATH . '/cop/backend/modules/rebates/model/rebateicon.png"  style="width: 35px !important;"></td>';},
        'field' => 'rebate_id' ),

    array( 'db' => '`c`.`customer_code`', 'dt' =>  'cus_code', 'field' =>'customer_code' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'cus_company_name', 'field' => 'customer_company_name' ),
    array( 'db' => '`c`.`customer_report_name`', 'dt' => 'cus_report_name', 'field' => 'customer_report_name' ),
    array( 'db' => '`r`.`type_id`', 'dt' => 'type', 'field' => 'type' ),
    array( 'db' => '`r`.`type_id`', 'dt' => 'type' ,'formatter' => function( $d, $row ) {
        if (strcmp($d,1)==0){
            return "One Time";
        }else{
            return "Monthly";
        }
    }, 'field' => 'type_id' ),
//    array( 'db' => '`r`.`status`', 'dt' => 'status', 'field' => 'status' ),
    array( 'db' => '`r`.`status`', 'dt' => 'status' ,'formatter' => function( $d, $row ) {
        $GLOBALS["status"] = "$d";
        return "$d";
        }, 'field' => 'status' ),

    array( 'db' => '`r`.`inserted_date`', 'dt' => 'validFrom' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'inserted_date' ),




    array( 'db' => '`r`.`category_id`', 'dt' => 'category',
        'formatter' => function( $d, $row ) {
            global $username,$password,$database;
            $db1 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            if ($d>0){
                $db1->set_charset("utf8");
                $stm1 = $db1->prepare("SELECT name FROM Categories WHERE category_id='$d' LIMIT 1");
                $stm1-> execute();
                $stm1-> bind_result($categoryName);
                while ($stm1->fetch()) {}
                $stm1->close();
                return "$categoryName";
            }else{
                return "ALL";
            }
        },
        'field' => 'category_id' ),
    array( 'db' => '`r`.`qty`', 'dt' => 'qty', 'field' => 'qty' ),
    array( 'db' => '`r`.`value`', 'dt' => 'value', 'field' => 'value' ),

    array( 'db' => '`r`.`qty_awarded`', 'dt' => 'awardQty', 'field' => 'qty_awarded' ),
    array( 'db' => '`r`.`value_awarded`', 'dt' => 'awardValue', 'field' => 'value_awarded' ),
    array( 'db' => '`r`.`discount_percent_awarded`', 'dt' => 'awardPercentage', 'field' => 'discount_percent_awarded' ),


    array( 'db' => '`r`.`valid_from`', 'dt' => 'from' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'valid_from'),
    array( 'db' => '`r`.`valid_until`', 'dt' => 'to' ,'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));}, 'field' => 'valid_until'),
    array( 'db' => '`r`.`max_qty_awared`', 'dt' => 'rem_ammount', 'field' => 'max_qty_awared' ),
    array( 'db' => '`r`.`max_value_awarded`', 'dt' => 'rem_qty', 'field' => 'max_value_awarded' ),

    array( 'db' => '`r`.`rebate_id`', 'dt' => 'action', 'formatter' => function( $d, $row ) {
            $status = $GLOBALS["status"];
            $GLOBALS["status"] = '';
            if (strcmp($status,'no')==0){
                return '
                    <button   id="'.$d.'" class="btn btn-success" onclick="updateRebateStatus('.$d.',0);" >Active</button>
                ';
            }else{
                return '
                    <button   id="'.$d.'" class="btn btn-danger" onclick="updateRebateStatus('.$d.',1);" >Inactive</button>
                ';
            }

        },
        'field' => 'rebate_id' ),



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

$where = '';
$joinQuery = "FROM `ZE_Rebates` AS `r`   LEFT JOIN `Customers` AS `c` ON (`r`.`customer_id` = `c`.`customer_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>