<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



$db2 = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");
//QUERY GET ALL ACTIVE CRs from devices
$currentDate=date("Y-m-d");
// $salespersonID=1000113;
$activeSalespersons=getActiveSalespersons($db);
$currentDate=date("Y-m-d");

function getAllDates($startingDate, $endingDate)
{
    $datesArray = [];

    $startingDate = strtotime($startingDate);
    $endingDate = strtotime($endingDate);

    for ($currentDate = $startingDate; $currentDate <= $endingDate; $currentDate += (86400)) {
        $date = date('Y-m-d', $currentDate);
        $datesArray[] = $date;
    }

    return $datesArray;
}

$dates = getAllDates('2024-05-01', '2024-06-04');

// foreach($dates as $currentDate)
//{
foreach($activeSalespersons as $salespersonID)
{
    $KPIValue=new stdClass();
    $KPIValue->salesperson=getSalespersonInfo($db,$salespersonID);
    $KPIValue->date=$currentDate;
    $KPIValue->day= date('N', strtotime($currentDate));
    $KPIValue->month=date('m', strtotime($currentDate));
    $KPIValue->year=date('Y', strtotime($currentDate));
    $KPIValue->schedule=getScheduleInfo($db,$KPIValue->salesperson->username,$KPIValue->day,$currentDate,$salespersonID);


    $planedVisited=0;
    $strikeVisited=0;
    $totalStrike=0;
    $unplanVisited=0;
    $scheduleCustomers=array();
    foreach($KPIValue->schedule->customers as $customer)
    {
        if(visitExists($db,$salespersonID,$customer->customerID,$currentDate))
        {
            $planedVisited++;
            $customer->visited='yes';
            if($KPIValue->salesperson->ps)
            {
                if(orderExists($db,$salespersonID,$customer->customerID,$currentDate))
                {
                    $strikeVisited++;
                }
            }
            else if($KPIValue->salesperson->exvan)
            {
                if(invoiceExists($db,$salespersonID,$customer->customerID,$currentDate))
                {
                    $strikeVisited++;
                }
            }
        }
        array_push($scheduleCustomers,$customer->customerID);
    }

    $visisedCustomerArray=getDayVisitsCustomers($db,$salespersonID,$currentDate);
    foreach($visisedCustomerArray as $visitedCustomerID)
    {
        if(!in_array($visitedCustomerID, $scheduleCustomers))
        {
            $unplanVisited++;
            if($KPIValue->salesperson->ps)
            {
                if(orderExists($db,$salespersonID,$visitedCustomerID,$currentDate))
                {
                    $strikeVisited++;
                }
            }
            else if($KPIValue->salesperson->exvan)
            {
                if(invoiceExists($db,$salespersonID,$visitedCustomerID,$currentDate))
                {
                    $strikeVisited++;
                }
            }
        }
    }



    if($KPIValue->salesperson->ps)
    {
        $orders=getOrderIDs($db,$salespersonID,$currentDate);
        $totals = getOrderTotalValue($db,$salespersonID,$orders->orderIDs,$db2);
        $totalAmount=$orders->total;
        $numberOFDocuments=$orders->numberOfOrders;
        $totalStrike=getDistnctOrderCustomer($db,$salespersonID,$currentDate);
    }
    else if($KPIValue->salesperson->exvan)
    {
        $invoices=getInvoiceIDs($db,$salespersonID,$currentDate);
        $totals = getInvoiceTotalValue($db,$salespersonID,$invoices->invoiceIDs,$db2);
        $totalAmount=$invoices->total;
        $numberOFDocuments=$orders->numberOfInvoices;
        $totalStrike=getDistnctInvoiceCustomer($db,$salespersonID,$currentDate);
    }

    $receipts=getReceiptTotals($db,$salespersonID,$currentDate);

    $KPIValue->plannedVisited=$planedVisited;
    $KPIValue->unplanVisited=$unplanVisited;
    $KPIValue->strikeVisited=$strikeVisited;
    $KPIValue->totalStrike=$totalStrike;
    $KPIValue->totalCSD=$totals->totalCSD;
    $KPIValue->totalAqf=$totals->totalAQF;
    $KPIValue->totalCases=$totals->totalCases;
    $KPIValue->totalInvoice=$totalAmount;
    $KPIValue->numberOFDocuments=$numberOFDocuments;
    $KPIValue->receipts=$receipts;

    $KPIValue->visisedCustomerArray=$visisedCustomerArray;
    $KPIValue->scheduleCustomers=$scheduleCustomers;


    insertIntoKPISalesperson($db,$KPIValue->salesperson->salespersonID,$KPIValue->salespersonCode,$currentDate,$KPIValue->schedule->plan,
        $KPIValue->plannedVisited,$KPIValue->unplanVisited, $KPIValue->strikeVisited,$KPIValue->totalStrike,$KPIValue->totalCases,$KPIValue->numberOFDocuments, $KPIValue->receipts->numOFReceipts,
        $KPIValue->receipts->receiptAmount,$KPIValue->totalCSD);



}
//}


function getSalespersonInfo($db,$salespersonID)
{
    $salesperson = new stdClass();


    $stm = $db->prepare("SELECT salesperson_code,first_name,last_name,anonymous_group_id,allow_orders,allow_invoices,username FROM SalesPersons WHERE salesperson_id='$salespersonID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($salespersonCode,$firstName,$lastName,$groupID,$allowOrders,$allowInvoices,$username);
    while ($stm->fetch()) {
        $salesperson->salespersonID=$salespersonID;
        $salesperson->salespersonCode=$salespersonCode;
        $salesperson->firstName=$firstName;
        $salesperson->lastName=$lastName;
        $salesperson->username=$username;
        $salesperson->ps=false;
        $salesperson->exvan=false;
        if(strcmp($allowOrders,'yes')==0)
        {
            $salesperson->ps=true;
            $salesperson->exvan=false;
        }

        if(strcmp($allowInvoices,'yes')==0)
        {
            $salesperson->ps=false;
            $salesperson->exvan=true;
        }

        if (isset($salesperson->route->routeID)){
            $salesperson->route->routeID=$groupID;
        }



    }
    $stm-> close();


    $stm = $db->prepare("SELECT group_code,name FROM CustomerGroups WHERE group_id='$groupID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($routeCode,$routeName);
    while ($stm->fetch()) {
        if (isset($salesperson->route->routeID)){
            $salesperson->route->routeID=$groupID;
            $salesperson->route->routeCode=$routeCode;
            $salesperson->route->routeName=$routeName;
        }
    }
    $stm-> close();
    return $salesperson;
}


function getScheduleInfo($db,$routeCode,$day,$currentDate,$salespersonID)
{
    $schedule= new stdClass();
    $schedule->plan=0;
    $schedule->customers=array();
    $stm = $db->prepare("SELECT Schedules.schedule_id,name,customer_id FROM Schedules,Schedule_Customer WHERE Schedules.schedule_id=Schedule_Customer.schedule_id AND ( (type='Single Date' AND date ='$currentDate' ) OR ( (type='Repeat' AND DATEDIFF('$currentDate', date) % repeat_period = 0) ) OR ((type='Custom' AND (day =DAYOFWEEK('$currentDate')-1 OR day='0') AND (month = MONTH('$currentDate') OR month='0') AND (week =FLOOR((DayOfMonth('$currentDate')-1)/7)+1 OR week ='0'))) ) AND Schedules.schedule_id IN(SELECT schedule_id AS schedule_id FROM Schedule_Salesperson WHERE salesperson_id ='$salespersonID') GROUP BY customer_id;");
    $stm-> execute();
    $stm-> bind_result($scheduleID,$scheduleName,$customerID);
    while ($stm->fetch()) {
        $schedule->scheduleID=$scheduleID;
        $schedule->scheduleName=$scheduleName;
        $customer= new stdClass();
        $customer->customerID=$customerID;
        $customer->visited="no";
        array_push($schedule->customers,$customer);
        $schedule->plan++;
    }
    $stm-> close();

    return $schedule;
}

function getBudgetInfo($db,$routeCode,$month,$year)
{
    $budgets=array();
    $stm = $db->prepare("SELECT Budget_Type,amount,working_days FROM  Z_Z_CUSTOM_BUDGET_ROUTE WHERE route = '$routeCode' AND month='$month' AND year='$year'");
    $stm-> execute();
    $stm-> bind_result($budgetType,$amount,$workingDays);
    while ($stm->fetch()) {
        $budget= new stdClass();
        $budget->budgetType=$budgetType;
        $budget->amount=$amount;
        $budget->workingDays=$workingDays;
        $budget->dailyBudget=round($amount/$workingDays);
        array_push($budgets,$budget);

    }
    $stm-> close();


    return $budgets;

}


function visitExists($db,$salespersonID,$customerID,$currentDate)
{
    $result=false;
    $stm = $db->prepare("SELECT COUNT(*) FROM  Visits WHERE salesperson_id = '$salespersonID' AND customer_id='$customerID' AND DATE(visit_date)='$currentDate' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter>0)
        {
            $result=true;
        }

    }
    $stm-> close();
    return $result;

}

function getOrderIDs($db,$salespersonID,$currentDate)
{
    $orders=new stdClass();
    $orders->total=0;
    $orders->orderIDs='0';
    $orders->numberOfOrders=0;
    $stm = $db->prepare("SELECT order_id,grand_total FROM Orders WHERE salesperson_id='$salespersonID' AND order_date='$currentDate' AND NOT status='Canceled'");
    $stm-> execute();
    $stm-> bind_result($orderID,$grandTotal);
    while ($stm->fetch()) {
        $orders->orderIDs.=",$orderID";
        $orders->total+=$grandTotal;
        $orders->numberOfOrders++;
    }
    $stm-> close();
    return $orders;

}

function getInvoiceIDs($db,$salespersonID,$currentDate)
{
    $invoices=new stdClass();
    $invoices->total=0;
    $invoices->invoiceIDs='0';
    $invoices->numberOfInvoices=0;
    $stm = $db->prepare("SELECT invoice_id,grand_total FROM Invoices WHERE salesperson_id='$salespersonID' AND invoice_date='$currentDate' AND NOT status='Canceled'");
    $stm-> execute();
    $stm-> bind_result($invoiceID,$grandTotal);
    while ($stm->fetch()) {
        $invoices->invoiceIDs.=",$invoiceID";
        $invoices->total+=$grandTotal;
        $invoices->numberOfInvoices++;
    }
    $stm-> close();
    return $invoices;

}

function getReceiptTotals($db,$salespersonID,$currentDate)
{
    $receipts=new stdClass();
    $stm = $db->prepare("SELECT COUNT(receipt_id),SUM(amount) FROM Receipts WHERE salesperson_id='$salespersonID' AND receipt_date='$currentDate' AND NOT status='Canceled'");
    $stm-> execute();
    $stm-> bind_result($numOFReceipts,$receiptAmount);
    while ($stm->fetch()) {
        $receipts->numOFReceipts=$numOFReceipts;
        $receipts->receiptAmount=$receiptAmount;

    }
    $stm-> close();
    return $receipts;
}

function getOrderTotalValue($db,$salespersonID,$orderIDs,$db2)
{
    $totals=new stdClass();
    $totals->totalCSD=0;
    $totals->totalAQF=0;
    $totals->totalCases=0;
    $stm = $db->prepare("SELECT item_id,SUM(qty) FROM Order_Item WHERE order_id IN($orderIDs) GROUP BY item_id");
    $stm-> execute();
    $stm-> bind_result($itemID,$qty);
    while ($stm->fetch()) {




        $totals->totalCSD+=$qty;

        $totals->totalAQF+=$qty;

        $totals->totalCases+=$qty;



    }
    $stm-> close();
    return $totals;
}

function getInvoiceTotalValue($db,$salespersonID,$invoiceIDs,$db2)
{
    $totals=new stdClass();
    $totals->totalCSD=0;
    $totals->totalAQF=0;
    $totals->totalCases=0;

    $stm = $db->prepare("SELECT item_id,SUM(qty) FROM Invoice_Item WHERE invoice_id IN($invoiceIDs) GROUP BY item_id");
    $stm-> execute();
    $stm-> bind_result($itemID,$qty);
    while ($stm->fetch()) {




        $totals->totalCSD+=$qty;



        $totals->totalCases+=$qty;


    }
    $stm-> close();
    return $totals;
}



function getRoutCreditStats($db,$routeCode)
{
    $routeCreditStats=new stdClass();
    $stm = $db->prepare("SELECT credit_limit,balance FROM  Z_Z_CUSTOM_STATISTICS_ROUTE_LIMIT WHERE route_code = '$routeCode' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($creditLimit,$balance);
    while ($stm->fetch()) {

        $routeCreditStats->creditLimit=$creditLimit;
        $routeCreditStats->balance=$balance;


    }
    $stm-> close();


    return $routeCreditStats;

}


function orderExists($db,$salespersonID,$customerID,$currentDate)
{
    $result=false;
    $stm = $db->prepare("SELECT COUNT(*) FROM  Orders WHERE salesperson_id = '$salespersonID' AND customer_id='$customerID' AND DATE(order_date)='$currentDate' AND NOT status='Canceled' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter>0)
        {
            $result=true;
        }

    }
    $stm-> close();
    return $result;

}

function invoiceExists($db,$salespersonID,$customerID,$currentDate)
{
    $result=false;
    $stm = $db->prepare("SELECT COUNT(*) FROM  Invoices WHERE salesperson_id = '$salespersonID' AND customer_id='$customerID' AND DATE(invoice_date)='$currentDate' AND NOT status='Canceled' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter>0)
        {
            $result=true;
        }

    }
    $stm-> close();
    return $result;

}


function getDistnctOrderCustomer($db,$salespersonID,$currentDate)
{

    $counter=0;
    $stm = $db->prepare("SELECT COUNT(DISTINCT customer_id) FROM Orders WHERE salesperson_id='$salespersonID' AND order_date='$currentDate' AND NOT status='Canceled'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
    }
    $stm-> close();
    return $counter;

}

function getDistnctInvoiceCustomer($db,$salespersonID,$currentDate)
{

    $counter=0;
    $stm = $db->prepare("SELECT COUNT(DISTINCT customer_id) FROM Invoices WHERE salesperson_id='$salespersonID' AND invoice_date='$currentDate' AND NOT status='Canceled'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
    }
    $stm-> close();
    return $counter;

}

function getDayVisitsCustomers($db,$salespersonID,$currentDate)
{
    $visitedCustomers=array();
    $stm = $db->prepare("SELECT DISTINCT(customer_id) FROM  Visits WHERE salesperson_id = '$salespersonID' AND DATE(visit_date)='$currentDate'");
    $stm-> execute();
    $stm-> bind_result($customerID);
    while ($stm->fetch()) {

        array_push($visitedCustomers,$customerID);

    }
    $stm-> close();
    return $visitedCustomers;

}
function   insertIntoKPISalesperson($db,$salespersonID,$salespersonCode,$currentDate,$plan,
                                    $plannedVisited,$unplanVisited, $strikeVisited,$totalStrike,$totalCases,$numberOFDocuments, $numOFReceipts,
                                    $receiptAmount,$totalCSD)
{

    $stmt = $db->prepare("INSERT INTO Z_Z_KPIS_VISITS(salesperson_id , salesperson_code, date, planned, planned_visited, unplanned_visited, strike_visited, strike_all, total_qty, number_of_sales_documents, number_of_receipts, total_receipts, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('ssssssssssss', $salespersonID,$salespersonCode,$currentDate,$plan,
        $plannedVisited,$unplanVisited, $strikeVisited,$totalStrike,$totalCases,$numberOFDocuments, $numOFReceipts,
        $receiptAmount);
    $stmt->execute();
    echo $stmt->error;
    $stmt->close();





}


function getActiveSalespersons($db)
{
    $activeSalespersons=array();
    $stm = $db->prepare("SELECT salesperson_id  FROM SalesPersons");
    $stm-> execute();
    $stm-> bind_result($salespersonID);
    while ($stm->fetch()) {

        array_push($activeSalespersons,$salespersonID);

    }
    $stm-> close();
    return $activeSalespersons;

}
?>
