<?php
include_once("../../../../param.php");
include_once(ROOT . "backend/modules/jinius/model/CopJsonHandler.php");
$companyID = $_SESSION['companyID'];

if(isset($_POST['date']) && strcmp($_POST['date'],'')!=0){
    $dateVar = $_POST['date'];
    $where = " WHERE DATE(timestamp) >= DATE('$dateVar') ";
} else {
    $dateVar = date('Y-m-d');
    $where = " WHERE DATE(timestamp) >= DATE('$dateVar') ";
}

if(isset($_POST['date2']) && strcmp($_POST['date2'],'')!=0){
    $dateVar2 = $_POST['date2'];
    $where .= " AND DATE(timestamp) <= DATE('$dateVar2') ";
} else {
    $dateVar2 = date('Y-m-d');
    $where .= " AND DATE(timestamp) <= DATE('$dateVar2') ";
}
if(strcmp($dateVar,$dateVar2)!=0){
    $displayDate = "Range: ".date_format( date_create_from_format('Y-m-d', $dateVar), 'd-m-Y')." - ".date_format( date_create_from_format('Y-m-d', $dateVar2), 'd-m-Y');
} else {
    $displayDate = "Date: ".date_format( date_create_from_format('Y-m-d', $dateVar), 'd-m-Y');

}


if(isset($_POST['errors']) && strcmp($_POST['errors'],'')!=0){
    if(strcmp($_POST['errors'],'yes')==0){
        $showingErrors = true;
        $errorVar = 'no';
        $where = " WHERE status NOT IN ('AlreadyExists','OK') ";
        $errorFilterClass = 'primary';
        $errorFilterLabel = 'Show All (By Date)';
        $displayDate = "DOCUMENT ERRORS";
    } else {
        $showingErrors = false;
        $errorVar = 'yes';
        $errorFilterClass = 'danger';
        $errorFilterLabel = 'Filter Errors';
    }
} else {
    $showingErrors = false;
    $errorVar = 'yes';
    $errorFilterClass = 'danger';
    $errorFilterLabel = 'Filter Errors';
}




?>
<div id="main" role="main">
    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="yearly">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>

        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage Jinius Documents</li>
        </ol>
        <!-- end breadcrumb -->

    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
                    <img style="display:inline;" class="custom-rounded-image yearly" src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/invoiceicon.png" width="30" height="30">&nbsp;
                    Jinius Documents
                </h3>
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-4">
                <form method="post" action="//<?php echo HTML_PATH; ?>/cop/backend/modules/jinius/views/manage_jinius_document_statuses.php" style="<?php if($showingErrors){echo "display:none";}else{echo "display:block;";}?>">
                    <input type="date" name="date" class="form-control" style="width: 34%;display: inline;text-align: center;" value="<?php echo $dateVar;?>">
                    <input type="date" name="date2" class="form-control" style="width: 34%;display: inline;text-align: center;" value="<?php echo $dateVar2;?>">
                    <input type="hidden" name="errors" class="form-control" style="display: inline;text-align: center;" value="no">
                    <input type="submit" class="btn btn-waybill pull-right" value="Select Dates" style="width: 29%;display: inline;margin-top: 0px;" />
                </form>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2"></div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
                <form method="post" action="//<?php echo HTML_PATH; ?>/cop/backend/modules/jinius/views/manage_jinius_document_statuses.php">
                    <input type="hidden" name="errors" class="form-control" style="display: inline;text-align: center;" value="<?php echo $errorVar;?>">
                    <input type="submit" class="btn btn-<?php echo $errorFilterClass; ?> btn-block pull-right" value="<?php echo $errorFilterLabel; ?>" style="display: inline;margin-top: 2px;" />
                </form>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-3" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Send to Jinius </h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">
                                <center>
                                    <br>

                                    <table style="width: 100%;margin: 20px;">
                                        <tr>
                                            <td colspan="2">
                                                <label class="label-bold pull-left"><h4 style="margin-bottom: 0;padding-bottom: 0;font-weight: bold;">Invoices:</h4></label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:80%">
                                                <select class="form-control " id="invoicesToSend" style="width: 100%;" multiple="multiple">
                                                    <?php
                                                    global $username,$password,$database;
                                                    $db = new mysqli('localhost',$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT invoice_id,invoice_code,invoice_date FROM Invoices WHERE invoice_id NOT IN (SELECT id FROM Documents_Jinius WHERE type = 5) AND invoice_date >= '2022-11-01' ORDER BY invoice_date DESC,invoice_code DESC");
                                                    $stm->execute();
                                                    $stm->bind_result($invoiceToSendID, $invoiceToSendCode,$invoiceToSendDate);
                                                    while ($stm->fetch()) {
                                                        $displayInvoiceDate  = date_format( date_create_from_format('Y-m-d', $invoiceToSendDate), 'd-m-Y');

                                                        echo "<option value='$invoiceToSendID'>$invoiceToSendCode - $displayInvoiceDate</option>";
                                                    }
                                                    $stm->close();
                                                    ?>
                                                </select>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-invoice pull-left" onclick="sendInvoicesToJinius()" id="sendInvoicesToJiniusButton">Send To Jinius <i class="fa fa-arrow-right"></i></button>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"><br></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <label class="label-bold pull-left"><h4 style="margin-bottom: 0;padding-bottom: 0;font-weight: bold;">Returns:</h4></label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:80%">
                                                <select class="form-control " id="returnsToSend" style="width: 100%;" multiple="multiple">
                                                    <?php
                                                    global $username,$password,$database;
                                                    $db = new mysqli('localhost',$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT return_id,return_code,return_date FROM Returns WHERE return_id NOT IN (SELECT id FROM Documents_Jinius WHERE type = 4) AND return_date >= '2022-11-01' ORDER BY return_date DESC,return_code DESC");
                                                    $stm->execute();
                                                    $stm->bind_result($returnToSendID, $returnToSendCode,$returnToSendDate);
                                                    while ($stm->fetch()) {
                                                        $displayReturnDate  = date_format( date_create_from_format('Y-m-d', $returnToSendDate), 'd-m-Y');

                                                        echo "<option value='$returnToSendID'>$returnToSendCode - $displayReturnDate</option>";
                                                    }
                                                    $stm->close();
                                                    ?>
                                                </select>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-return pull-left" onclick="sendReturnsToJinius()" id="sendReturnsToJiniusButton">Send To Jinius <i class="fa fa-arrow-right"></i></button>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"><br></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <label class="label-bold pull-left"><h4 style="margin-bottom: 0;padding-bottom: 0;font-weight: bold;">Receipts:</h4></label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:80%">
                                                <select class="form-control " id="receiptsToSend" style="width: 100%;" multiple="multiple">
                                                    <?php
                                                    global $username,$password,$database;
                                                    $db = new mysqli('localhost',$username,$password,$database);
                                                    if (mysqli_connect_errno()) {
                                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                                        exit();
                                                    }
                                                    $db->set_charset("utf8");
                                                    $stm = $db->prepare("SELECT Receipts.receipt_id,receipt_code,receipt_date,Invoices.invoice_id,invoice_code,invoice_date FROM Receipts,Invoice_Receipt,Invoices WHERE Receipts.receipt_id=Invoice_Receipt.receipt_id AND Invoice_Receipt.invoice_id=Invoices.invoice_id AND Invoice_Receipt.invoice_id IN (SELECT id FROM Documents_Jinius WHERE type = 5) AND  Receipts.receipt_id NOT IN (SELECT id FROM Documents_Jinius WHERE type = 6) AND receipt_date >= '2022-11-01' ORDER BY receipt_date DESC,receipt_code DESC");
                                                    $stm->execute();
                                                    $stm->bind_result($receiptToSendID, $receiptToSendCode,$receiptToSendDate,$invoiceForReceiptID,$invoiceForReceiptCode,$invoiceForReceiptDate);
                                                    while ($stm->fetch()) {
                                                        $displayReceiptDate  = date_format( date_create_from_format('Y-m-d', $receiptToSendDate), 'd-m-Y');

                                                        echo "<option value='$receiptToSendID|$invoiceForReceiptID'>$receiptToSendCode - $receiptToSendDate (For Invoice $invoiceForReceiptCode)</option>";
                                                    }
                                                    $stm->close();
                                                    ?>
                                                </select>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-orange pull-left" onclick="sendInvoicePaymentsToJinius()" id="sendReturnsToJiniusButton">Send To Jinius <i class="fa fa-arrow-right"></i></button>
                                            </td>
                                        </tr>
                                    </table>
                                    <br>
                                    <br>
                                    <div id="tesultTestBox"></div>

                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->

                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Documents Table </h2>
                        </header>

                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table " width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:6%"></th>
                                        <th class="hasinput" style="width:15%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Type" />
                                        </th>
                                        <th class="hasinput" style="width:14%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Code" value="" />
                                        </th>
                                        <th class="hasinput" style="width:14%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Amount" value="" />
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Status" />
                                        </th>
                                        <th class="hasinput" style="width:20%">
                                            <input type="text" class="form-control text-center" placeholder="Filter Reason" />
                                        </th>

                                        <th class="hasinput " style="width:10%">
                                            <input id="dateselect_filter" type="text" placeholder="Date" class="form-control datepicker text-center" data-dateformat="dd-mm-yy">
                                        </th>

                                        <th class="hasinput" style="width:40%">
                                            <center><label><b><?php echo $displayDate; ?></b></label></center>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'></th>
                                        <th class='text-center'>Type</th>
                                        <th class='text-center'>Code</th>
                                        <th class='text-center'>Amount</th>
                                        <th class='text-center'>Status</th>
                                        <th class='text-center'>Response</th>
                                        <th class='text-center' data-hide="phone">Date</th>
                                        <th class='text-center' data-hide="phone,tablet">Actions</th>
                                    </tr>
                                    </thead>
                                    <?php
                                    $docTypes = array('1'=>'Tender','2'=>'Order','3'=>'Waybill','4'=>'Return','5'=>'Invoice','6'=>'Receipt','7'=>'Transfer');

                                    global $username,$password,$database;
                                    $db = new mysqli('localhost',$username,$password,$database);
                                    if (mysqli_connect_errno()) {
                                        printf("Connect failed: %s\n", mysqli_connect_error());
                                        exit();
                                    }
                                    $db->set_charset("utf8");
                                    $stm = $db->prepare("SELECT id,type,status,reason,timestamp,export_code,export_id FROM Documents_Jinius $where ORDER BY timestamp DESC");
                                    $stm->execute();
                                    $stm->bind_result($docID,$docType, $docStatus, $statusReason, $recTimestamp,$jiniusStatus,$exportID);
                                    while ($stm->fetch()) {

                                        if(strcmp($docStatus,'OK')!=0 && strcmp($docStatus,'Created')!=0){
                                            $color="style='background-color:firebrick;color:white;'";
                                        } else {
                                            $color="style='background-color:green;color:white;'";
                                        }

                                        if(strcmp($docStatus,'AlreadyExists')==0){
                                            $color="style='background-color:goldenrod;color:white;'";
                                        }

                                        $recTimestampSort = $recTimestamp;
                                        $recTimestamp = date_format( date_create_from_format('Y-m-d H:i:s', $recTimestamp), 'd-m-Y H:i');

                                        if(strcmp($docTypes[$docType],'Transfer')==0){
                                            $class = "invoice";
                                            $table = "Warehouse_Transactions";
                                            $fileView = "warehouse_transaction";
                                            $fileEdit = "warehouse_transfer";
                                            $codeColumn = "warehouse_transaction_code";
                                            $idColumn = 'warehouse_transaction_id';
                                        } else if(strcmp($docTypes[$docType],'Return')==0){
                                            $class = strtolower($docTypes[$docType]);
                                            $table = $docTypes[$docType]."s";
                                            $codeColumn = strtolower($docTypes[$docType])."_code";
                                            $idColumn = strtolower($docTypes[$docType]).'_id';
                                            $amountColumn = 'grand_total';
                                            $fileEdit = $fileView = $class;
                                            $onclickEventInsert = "sendSingle".$docTypes[$docType]."ToJinius($docID)";
                                            $onclickEventCheckStatus = "update".$docTypes[$docType]."StatusJinius($docID,'checkCreditNoteStatus')";
                                        } else if(strcmp($docTypes[$docType],'Receipt')==0) {
                                            $class = strtolower($docTypes[$docType]);
                                            $table = $docTypes[$docType]."s";
                                            $codeColumn = strtolower($docTypes[$docType])."_code";
                                            $idColumn = strtolower($docTypes[$docType]).'_id';
                                            $amountColumn = '(amount + cash_discount) as total';
                                            $fileEdit = $fileView = $class;
                                            $onclickEventInsert = "sendSingle".$docTypes[$docType]."ToJinius($docID)";
                                            $onclickEventCheckStatus = "update".$docTypes[$docType]."StatusJinius($docID,'check".$docTypes[$docType]."Status')";
                                            $onclickEventVoid = "update".$docTypes[$docType]."StatusJinius($docID,'void".$docTypes[$docType]."')";
                                            $onclickEventSetAsPaid = "update".$docTypes[$docType]."StatusJinius($docID,'setAsPaid".$docTypes[$docType]."')";
                                        } else {
                                            $class = strtolower($docTypes[$docType]);
                                            $table = $docTypes[$docType]."s";
                                            $codeColumn = strtolower($docTypes[$docType])."_code";
                                            $idColumn = strtolower($docTypes[$docType]).'_id';
                                            $amountColumn = 'grand_total';
                                            $fileEdit = $fileView = $class;
                                            $onclickEventInsert = "sendSingle".$docTypes[$docType]."ToJinius($docID)";
                                            $onclickEventCheckStatus = "update".$docTypes[$docType]."StatusJinius($docID,'check".$docTypes[$docType]."Status')";
                                            $onclickEventVoid = "update".$docTypes[$docType]."StatusJinius($docID,'void".$docTypes[$docType]."')";
                                            $onclickEventSetAsPaid = "update".$docTypes[$docType]."StatusJinius($docID,'setAsPaid".$docTypes[$docType]."')";
                                        }


                                        $db2 = new mysqli(localhost,$username,$password,$database);
                                        if (mysqli_connect_errno())
                                        {
                                            printf("Connect failed: %s\n", mysqli_connect_error());
                                            exit();
                                        }
                                        $db2->set_charset("utf8");
                                        $stm2 = $db2->prepare("SELECT $codeColumn,$amountColumn FROM $table WHERE $idColumn = $docID ");
                                        $stm2->execute();
                                        $stm2->bind_result($docCode,$docAmount);
                                        while ($stm2->fetch()) {}
                                        $stm2->close();

                                        $jsonToTable = new CopJsonHandler();

                                        $statusReasonTable = $jsonToTable->jsonToTable("$docID-$docType",$statusReason);

                                        $buttonView = '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_'.$fileView.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">	           			                   
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-return yearly" value="View" >
                                                    </form>';

                                        $buttonEdit = '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/create_'.$fileEdit.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-primary" value="Edit" >
                                                    </form>';

                                        $buttonsJinius = '';



                                        if(strcmp($exportID,'')!=0){

                                            if(strcmp($docStatus,'OK')==0 || strcmp($docStatus,'')==0) {
                                                if(strcmp($docTypes[$docType],'Receipt')==0
                                                && strcmp(trim($jiniusStatus),'PendingApproval')!=0
                                                && strcmp(trim($jiniusStatus),'Declined')!=0)
                                                {
                                                    $docStatus = 'Completed';
                                                } else {
                                                    $docStatus = $jiniusStatus;
                                                }

                                            }

                                            if(strcmp(trim($jiniusStatus),'')!=0 || strcmp($exportID,'')!=0) {

                                                if (strcmp($docTypes[$docType], 'Invoice') == 0) {
                                                    $buttonsJinius .= '<button type="button" class="btn btn-warning" id="deleteButton' . $docID . '" onclick="' . $onclickEventCheckStatus . '" style="display: inline-block; margin: 2px;">Check Status</button>';
                                                    if(strcmp($jiniusStatus,'InReview')!=0){
                                                        $buttonsJinius .= '<button type="button" class="btn btn-danger" id="deleteButton' . $docID . '" onclick="' . $onclickEventVoid . '" style="display: inline-block; margin: 2px;">Void ' . $docTypes[$docType] . '</button>';
//                                                      $buttonsJinius .= '<button type="button" class="btn btn-success" id="deleteButton' . $docID . '" onclick="' . $onclickEventSetAsPaid . '" style="display: inline-block; margin: 2px;">Mark As Paid</button>';

                                                    }
                                                }
                                                if (strcmp($docTypes[$docType], 'Receipt') == 0 && strcmp(trim($jiniusStatus),'PendingApproval')==0) {
                                                    $jiniusInvoiceID = json_decode($statusReason,true)['id'];
                                                    $invoiceToResendID = 0;
                                                    $db2->set_charset("utf8");
                                                    $stm2 = $db2->prepare("SELECT id FROM Documents_Jinius WHERE type='5' AND  export_id='$jiniusInvoiceID' AND NOT export_id='' LIMIT 1");
                                                    $stm2->execute();
                                                    $stm2->bind_result($invoiceToPayID);
                                                    while ($stm2->fetch()) {}
                                                    $stm2->close();
                                                    if(strcmp($jiniusInvoiceID,'')!=0 && $invoiceToPayID > 0) {
                                                        $buttonsJinius .= '<button type="button" class="btn btn-success" id="deleteButton' . $docID . '" onclick="acceptDeclineInvoicePaymentFromJinius(' . $invoiceToPayID . ',' . $docID . ',\'acceptInvoicePayment\')" style="display: inline-block; margin: 2px;">Accept Payment</button>';
                                                        $buttonsJinius .= '<button type="button" class="btn btn-danger " id="deleteButton' . $docID . '" onclick="acceptDeclineInvoicePaymentFromJinius(' . $invoiceToPayID . ',' . $docID . ',\'declineInvoicePayment\')" style="display: inline-block; margin: 2px;">Decline Payment</button>';
                                                    }
                                                }

                                            } else {
                                                $docStatus = 'Failed';
                                                $buttonsJinius = '<button type="button" class="btn btn-primary" id="deleteButton'.$docID.'" onclick="'.$onclickEventInsert.'" style="display: inline-block; margin: 2px;">Send to Jinius</button>';
                                            }

                                        } else if(strcmp($docTypes[$docType],'Return')==0 || strcmp($docStatus,'AlreadyExists')==0){
                                            if(strcmp($exportID,'')==0){
                                                $docStatus = 'Failed';
                                                $buttonsJinius = '<button type="button" class="btn btn-primary" id="deleteButton'.$docID.'" onclick="'.$onclickEventInsert.'" style="display: inline-block; margin: 2px;">Send to Jinius</button>';
                                            }

                                        } else if(strcmp($docTypes[$docType],'Receipt')==0){

                                            $invoiceToResendID = 0;
                                            $db2->set_charset("utf8");
                                            $stm2 = $db2->prepare("SELECT invoice_id FROM Invoice_Receipt WHERE Invoice_Receipt.invoice_id IN (SELECT id FROM Documents_Jinius WHERE type = 5) AND  Invoice_Receipt.receipt_id IN (SELECT id FROM Documents_Jinius WHERE type = 6)  AND Invoice_Receipt.receipt_id='$docID' LIMIT 1");
                                            $stm2->execute();
                                            $stm2->bind_result($invoiceToResendID);
                                            while ($stm2->fetch()) {}
                                            $stm2->close();

                                            if($invoiceToResendID > 0) {
                                                $buttonsJinius = '<button type="button" class="btn btn-orange" id="deleteButton' . $docID . '" onclick="sendSingleInvoicePaymentToJinius(\'' . $docID . '|' . $invoiceToResendID . '\')" style="display: inline-block; margin: 2px;">Send to Jinius</button>';
                                            }

                                        } else {
                                            $buttonsJinius = '<button type="button" class="btn btn-primary" id="deleteButton'.$docID.'" onclick="'.$onclickEventInsert.'" style="display: inline-block; margin: 2px;">Send to Jinius</button>';

                                        }

                                        if(is_numeric($jiniusStatus)){
                                            $docStatus = $jiniusStatus;
                                        }

                                        $docStatus = implode(' ',preg_split('/(?=[A-Z])/',$docStatus));
                                        if(strcmp($docStatus,'O K')==0){$docStatus = 'OK';}

                                        if(is_numeric($docStatus)){
                                            $color="style='background-color:firebrick;color:white;'";
                                        } else if(strcmp(strtolower(trim($docStatus)),'voided')==0 || strcmp(trim($jiniusStatus),'Declined')==0){
                                            $color="style='background-color:gray;color:white;'";
                                            $buttonsJinius = '';
                                        } else if(strcmp($docTypes[$docType],'Receipt')==0 && strcmp(trim($jiniusStatus),'PendingApproval')==0){
                                            $color="style='background-color:#a8c2fc;color:black;'";
                                        } else if(strcmp(strtolower(trim($docStatus)),'paid')==0){
                                            $buttonsJinius = '';
                                        }

                                        echo "<tr $color>";
                                        echo "<td><img class='custom-rounded-image ".$class." center-canvas' onclick='actionHistory($docID,\"$table\")' src='//".HTML_PATH."/cop/backend/themes/".THEME_NAME."/img/".strtolower($docTypes[$docType])."icon.png' width='30' height='30'></td>";
                                        echo "<td>$docTypes[$docType]</td>";
                                        echo "<td>$docCode</td>";
                                        echo "<td>$docAmount</td>";
                                        echo "<td>$docStatus</td>";
                                        echo "<td>$statusReasonTable</td>";
                                        echo "<td data-sort='$recTimestampSort'>$recTimestamp</td>";
                                        echo "<td><center>
                                                <table>
                                                    <tr>
                                                        <td style='width: 50%;'>$buttonView</td><td>$buttonEdit</td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan='2'>$buttonsJinius</td>
                                                    </tr>
                                                 </table>
                                               </td>";
                                        echo "</tr>";
                                    }
                                    $stm->close();

                                    ?>
                                </table>
                            </div>
                            <!-- end widget content -->
                        </div>
                        <!-- end widget div -->
                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>

       <!-- Modal -->
        <div class="modal fade" id="moreInfoElementModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog" style="width:100%">
                <div class="modal-content" style="overflow-x:scroll;">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;color: black;">Last Jinius Response</strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;font-size: 14px;" id="morInfoElementModalBody">

                    </div>
                    <footer class="modal-footer" >
                        <button onclick="$('#moreInfoElementModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">Close</button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->


        <!--Modal-->
        <div class="modal fade" id="trackModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <!--                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->
                        <center>
                            <h4 class="modal-title"style="margin-left:10px;"><i class="fafa-gears"></i><strong style="padding-left:5px;">&nbsp;Action Tracking<span id="trackModalHeader"></span></strong></h4>
                        </center>
                    </div>

                    <div class="modal-body" id="trackModalBody" style="margin-top:5px;padding-top:5px;"></div>

                    <footer class="modal-footer">
                        <button onclick="$('#trackModal').modal('toggle');" class="btnbtn-default" ype="button" style="margin-right:10px;">Close</button>
                    </footer>
                </div><!--/.modal-content-->
            </div><!--/.modal-dialog-->
        </div><!--/.modal-->



    </div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function actionHistory(actionID,actionType)
    {

        $.ajax({
            type:"POST",
            url:'//<?php echo HTML_PATH?>/cop/backend/modules/jinius/controllers/getJiniusHistoryDrillDown.php',
            data:{
                'actionID':actionID,
                'actionType':actionType,
            },
            success:function(result){
                $('#trackModalBody').html(result);
                $('#trackModal').modal('toggle');

            }
        });

    }

    function showMoreInfoElement(moreInfoElement){

        $('#morInfoElementModalBody').html($('#'+moreInfoElement).html());
        $('#moreInfoElementModal').modal('toggle');
    }

    function sendSingleInvoiceToJinius(invoice){
        var type = 'sendInvoice';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendInvoice.php',
            data: {'invoices' : invoice,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoices Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();

            }

        });
    }

    function sendInvoicesToJinius(){

        var invoices = $('#invoicesToSend option:selected').toArray().map(item => item.value).join();
        var type = 'sendInvoice';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendInvoice.php',
            data: {'invoices' : invoices,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoices Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function updateInvoiceStatusJinius(invoices,type){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendInvoice.php',
            data: {'invoices' : invoices,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoice Status Updated",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function sendSingleReturnToJinius(returns){
        var type = 'sendCreditNote';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendReturn.php',
            data: {'returns' : returns,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Returns Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();

            }

        });
    }

    function sendReturnsToJinius(){

        var returns = $('#returnsToSend option:selected').toArray().map(item => item.value).join();
        var type = 'sendCreditNote';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendReturn.php',
            data: {'returns' : returns,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Returns Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function updateReturnStatusJinius(returns,type){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendReturn.php',
            data: {'returns' : returns,'type':type},
            success: function (result) {

                $.smallBox({
                    title: "Success!",
                    content: "Return Status Updated",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function sendInvoicePaymentsToJinius(){
        var receipts = $('#receiptsToSend option:selected').toArray().map(item => item.value).join();
        var type = 'sendInvoicePayment';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendPayment.php',
            data: {'receipts' : receipts,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoice Status Updated",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function sendSingleInvoicePaymentToJinius(receiptInvoice){
        var type = 'sendInvoicePayment';
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendPayment.php',
            data: {'receipts' : receiptInvoice,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoice Status Updated",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();
            }

        });
    }

    function acceptDeclineInvoicePaymentFromJinius(invoice,payment,type){
        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/jinius/controllers/sendInvoice.php',
            data: {'invoices' : invoice,'payment':payment,'type':type},
            success: function (result) {
                // $('#tesultTestBox').html(result);
                $.smallBox({
                    title: "Success!",
                    content: "Invoices Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
                window.location.reload();

            }

        });
    }

    $(document).ready(function() {
        pageSetUp();
        $('#invoicesToSend').select2();
        $('#returnsToSend').select2();
        $('#receiptsToSend').select2();

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        ///* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
               "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                   "t"+
                   "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
               "autoWidth" : true,"order": [[ 6, "desc" ]],});


        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {

           otable
               .column( $(this).parent().index()+':visible' )
               .search( this.value )
               .draw();

        } ).keyup();
        /* END COLUMN FILTER */
    })

</script>