<?php
class CopJsonHandler{

    public static function jsonToTable($elementID,$jsonText = '',$hide=array())
    {
        $arr = json_decode($jsonText, true);
        $html = "<span id='$elementID-moreInfoElement' style='display: none;'>";
        if ($arr && is_array($arr)) {
            $html .= self::_arrayToHtmlTableRecursive($arr,$hide);
            $html .= "</span>";
            $html .= "<button class='btn btn-success' id='$elementID-moreInfoButton' onclick='showMoreInfoElement(\"$elementID-moreInfoElement\");'>View Response</button>";
        } else {
            $html = "$jsonText";
        }
        return $html;
    }

    public static function jsonToDataTable($jsonText = '',$hide=array(),$hideFilter=array(),$httpRedirect = '',$buttonURL='',$buttonFilterKey='',$disableApplyfilterButton=false,$datatableID='1',$highlightRow2=array(),$coprimePaging=true,$duplicateColumns=array(),$cellFunctionToCall=array())
    {
        $arr = json_decode($jsonText, true);
        $html = "";
        if ($arr && is_array($arr)) {
            $html .= self::_arrayToDataTableRecursive($arr,$hide,$hideFilter,$httpRedirect,$buttonURL,$buttonFilterKey,$disableApplyfilterButton,$datatableID,$highlightRow2,$coprimePaging,$duplicateColumns,$cellFunctionToCall);
        }
        return $html;
    }

    public static function jsonToView($jsonText = '',$hide=array(),$rowsPerColumn=3,$title='',$httpRedirect = '',$buttonURL='',$buttonFilterKey='')
    {
        $arr = json_decode($jsonText, true);
        $html = "";
        if ($arr && is_array($arr)) {
            $html .= self::_arrayToView($arr,$hide,$httpRedirect,$buttonURL,$buttonFilterKey,$rowsPerColumn,$title);
        }
        return $html;
    }

    public static function jsonToInput($jsonText = '',$hide=array(),$disable=array())
    {
        $arr = json_decode($jsonText, true);
        $html = "";
        if ($arr && is_array($arr)) {
            $html .= self::_arrayToInputTableRecursive($arr,1,1,$hide,$disable);
        }
        return $html;
    }

    public static function jsonToSelect($jsonText = '',$selectID='', $selectColumn=array())
    {
        $arr = json_decode($jsonText, true);
        $html = "";
        if ($arr && is_array($arr)) {
            $html .= self::_arrayToSelection($arr,$selectID,$selectColumn);
        }
        return $html;
    }

    private static function _arrayToHtmlTableRecursive($arr,$hide) {

        $str  = '<table style="border-collapse: collapse;width:100%;">';

        foreach ($arr as $k => $d)
        {
            if(!in_array($k,$hide)) {
                $str .= "<tr style=''>";
                $title = ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $k));
                $title = str_replace('I D','ID',$title);
                $str .= "<td style='background-color: lightblue;font-weight: bolder;border: 1px solid black;padding: 5px;'> $title </td>";
                $str .= "<td style='border: 1px solid black;padding: 2px;' class='$k'>";
                if (is_array($d)) {
                    if (!empty($d)) {
                        $str .= self::_arrayToHtmlTableRecursive($d, $hide);
                    }
                } else {
                    $str .= "<center>" . $d . "</center>";
                }
                $str .= "</td>";
                $str .= "</tr>";
            }
        }



        $str .= "</table>";

        return $str;
    }

    private static function _arrayToInputTableRecursive($arr,$line,$table,$hide,$disable) {
        $keys = array_keys($arr[0]);
        $str  = '<table style="border-collapse: collapse;width:100%;">';
        $str .= "<tr style='background-color: lightblue;font-weight: bolder;'>";
        foreach ($keys as $k)
        {
            if(!in_array($k,$hide)){
                $title = ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $k));
                $title = str_replace('I D','ID',$title);
                $str .=  "<th style='border: 1px solid black;padding: 5px;'> $title </th>";
            }
        }
        $str .= "</tr>";
        foreach ($arr as $d)
        {
            $str .= "<tr>";
            $colNumber = 1;
            foreach ($keys as $k)
            {
                if(!in_array($k,$hide)) {
                    $str .= "<td style='border: 1px solid black;padding: 2px;' class='$k'>";
                    if (is_array($d[$k])) {
                        if (!empty($d[$k])) {

                            $str .= self::_arrayToInputTableRecursive($d[$k], $line, $table + 1,$hide,$disable);

                        }
                    } else {
                        if(!in_array($k,$disable)) {
                            $str .= "<input type='text' style='width: 100%;padding: 5px;' name='$table-$line-$colNumber-$k' id='$table-$line-$colNumber-$k' value='" . $d[$k] . "'/>";
                        } else {
                            $str .= "<center>".$d[$k]."</center>";
                        }
                    }
                    $str .= "</td>";
                    $colNumber++;
                }
            }
            $str .= "</tr>";
            $line++;
        }

        $str .= "</table>";

        return $str;


//        $keys = array_keys($arr[0]);
//        $str = "<table style='border-collapse: collapse;'><tbody>";
//        $str .= "<tr>";
//        foreach ($keys as $k) {
//            {
//                $str .= "<th> $k </th>";
//            }
//        }
//        $str .= "</tr>";
//
//        foreach ($keys as $key => $val) {
//            $str .= "<tr>";
//
//            $str .= "<td style='border: 1px solid black;'>";
//            if (is_array($val)) {
//                if (!empty($val)) {
//                    $str .= self::_arrayToHtmlTableRecursive($val);
//                }
//            } else {
//                $str .= "<strong>$val</strong>";
//            }
//            $str .= "</td></tr>";
//        }
//        $str .= "</tbody></table>";
//
//        return $str;
    }

    private static function _arrayToSelection($arr,$selectID,$selectColumn) {
        $keys = array_keys($arr[0]);
        $str  = '<select name="'.$selectID.'" id="'.$selectID.'" class="form-control">';

        $title = ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $selectColumn));
        $title = str_replace('I D','ID',$title);

        $str .= "<option value=''>Select $title</option>";

        foreach ($arr as $d)
        {
            foreach ($keys as $k)
            {
                if(in_array($k,$selectColumn)) {
                    if (!is_array($d[$k])) {

                        if(in_array($k,$selectColumn)) {
                            $str .= "<option value='".$d[$k]."'>".$d[$k]."</option>";
                        }
                    }

                }
            }

        }

        $str .= "</select>";

        return $str;


    }

    private static function _arrayToDataTableRecursive($arr,$hide,$hideFilter,$httpRedirect,$buttonURL,$buttonFilterKey,$disableApplyfilterButton,$datatableID,$highlightRow2,$coprimePaging,$duplicateColumns,$cellFunctionToCall,$level=1) {
        $nextLevel = $level+1;
        $keys = array_keys($arr[0]);
        $str2 = '';
        $str  = '<table id="datatable_fixed_column_'.$datatableID.'_'.$level.'" class="table table-striped table-hover dataTable" width="100%">';
        $str .= "<thead><tr >";
        if(!$disableApplyfilterButton) {
        foreach ($keys as $k)
        {
            if(!in_array($k,$hide)) {
                $str .= "<th class='hasinput' >";
                if(array_key_exists($k,$duplicateColumns)){
                    $str2 .= "<th class='hasinput' >";
                }
                if (!in_array($k, $hideFilter)) {
                    $title = ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $k));
                    $title = str_replace('I D', 'ID', $title);
                    $str .= "<input type='text' class='form-control text-center' id='$k' placeholder='Filter $title' data-key='$k'/>";
                    if(array_key_exists($k,$duplicateColumns)){
                        $str2 .= "<input type='text' class='form-control text-center' id='$k' placeholder='Filter $title' data-key='$k'/>";
                    }
                }
                $str .= "</th>";
                if(array_key_exists($k,$duplicateColumns)){
                    $str2 .= "</th>";
                }
            }
        }

            $str .= "<th class='hasinput' ><button class='btn btn-primary btn-block' id='filterButton$level'>Apply Filter</button></th>";
        }
        $str .= "</tr>";
        $str .= "<tr >";
        foreach ($keys as $k)
        {
            if(!in_array($k,$hide)) {
                $title = ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $k));
                $title = str_replace('I D','ID',$title);
                $str .= "<th class='text-center'>$title</th>";
                if(array_key_exists($k,$duplicateColumns)){

                    $duplicateColumnsClassCss = explode('|',$duplicateColumns[$k]);
                    $duplicateColumnsClass = $duplicateColumnsClassCss[0];
                    $duplicateColumnsCss= $duplicateColumnsClassCss[1];

                    $str2 .= "<th class='text-center' style='$duplicateColumnsCss'>$duplicateColumnsClass</th>";
                }
            }
        }
        $str .= $str2;
        $str .= "<th class='text-center'></th>";

        $str .= "</tr></thead><tbody>";
        foreach ($arr as $d)
        {
            $str2 = '';
            $str .= "<tr>";
            $buttonFilter = '';
            foreach ($keys as $k)
            {

                if(!in_array($k,$hide)) {
                    $cssStyle = '';

                    foreach ($highlightRow2 as $row=>$color){
                        $rowValue = explode('|',$row);
                        $column = $rowValue[0];
                        $value = $rowValue[1];
                        if(strcmp($d[$column],$value)==0){$cssStyle = "style='background-color:$color;font-weight:bolder'";}
                    }

                    $checkVar = $d[$k];
                    if($checkVar < 0){$cssStyle = "style='background-color:salmon;font-weight:bolder'";}

                    $str .= "<td class='$k' $cssStyle>";
                    if(array_key_exists($k,$duplicateColumns)){

                        $duplicateColumnsClassCss = explode('|',$duplicateColumns[$k]);
                        $duplicateColumnsClass = $duplicateColumnsClassCss[0];
                        $duplicateColumnsCss= $duplicateColumnsClassCss[1];
                        if(strcmp($duplicateColumnsCss,'')!=0){
                            $str2 .= "<td class='$duplicateColumnsClass' style='$duplicateColumnsCss'>";
                        } else {
                            $str2 .= "<td class='$duplicateColumnsClass' $cssStyle>";
                        }
                    }
                    if (is_array($d[$k])) {
                        if (!empty($d[$k])) {
                            $nextLevel++;
                            $str .= self::_arrayToDataTableRecursive($d[$k],$hide,$hideFilter,$httpRedirect,$buttonURL,$buttonFilterKey,$disableApplyfilterButton,$datatableID,$highlightRow2,$coprimePaging,$duplicateColumns,$cellFunctionToCall,$nextLevel);
                            if(array_key_exists($k,$duplicateColumns)){
                                $str2 .= self::_arrayToDataTableRecursive($d[$k],$hide,$hideFilter,$httpRedirect,$buttonURL,$buttonFilterKey,$disableApplyfilterButton,$datatableID,$highlightRow2,$coprimePaging,$duplicateColumns,$cellFunctionToCall,$nextLevel);
                            }
                        }
                    } else {
                        if(strcmp($buttonFilterKey,$k)==0){$buttonFilter=$d[$k];}
                        if (strpos(strtolower($k), 'date') !== false) {
                            if(array_key_exists($k,$cellFunctionToCall)){
                                $str .= "<span onclick='$cellFunctionToCall[$k]'>";
                            }
                            $str .= "<center>" . date_format( date_create_from_format('Y-m-d', $d[$k]), 'd-m-Y') . "</center>";
                            if(array_key_exists($k,$duplicateColumns)){
                                $str2 .= "<center>" . date_format( date_create_from_format('Y-m-d', $d[$k]), 'd-m-Y') . "</center>";
                            }
                            if(array_key_exists($k,$cellFunctionToCall)){
                                $str .= "</span>";
                            }
                        } else {

                            if(array_key_exists($k,$cellFunctionToCall)){
                                $str .= "<span onclick='$cellFunctionToCall[$k]'>";
                            }
                            $str .= "<center>" . $d[$k] . "</center>";
                            if(array_key_exists($k,$duplicateColumns)){
                                $str2 .= "<center>" . $d[$k] . "</center>";
                            }
                            if(array_key_exists($k,$cellFunctionToCall)){
                                $str .= "</span>";
                            }
                        }
                    }
                    $str .= "</td>";
                    if(array_key_exists($k,$duplicateColumns)){
                        $str2 .= "</td>";
                    }
                }
            }
            if(strcmp($buttonURL,'')!=0 && strcmp($buttonFilter,'')!=0){$button = "<a href=\"$buttonURL?$buttonFilterKey=$buttonFilter\" target='_blank' class='btn btn-primary btn-block'>View</a>";}
            $str .= $str2;
            $str .= "<td $cssStyle>$button</td>";
            $str .= "</tr>";
        }

        $str .= "</tbody></table>";

        if($coprimePaging){
            $datatablePaging = 'var otable'.$level.' = $("#datatable_fixed_column_'.$datatableID.'_'.$level.'").DataTable({
                       "sDom": "<\'dt-toolbar\'<\'col-xs-6 col-sm-6\'f><\'col-sm-6 col-xs-6 hidden-xs\' B C l>r>"+
						"t"+
						"<\'dt-toolbar-footer\'<\'col-sm-6 col-xs-12 hidden-xs\'i><\'col-sm-6 col-xs-12\'p>>",
                       "autoWidth" : true,"order": [[ 0, "asc" ]],"pageLength":100,});';
        } else {
            $datatablePaging = 'var otable'.$level.' = $("#datatable_fixed_column_'.$datatableID.'_'.$level.'").DataTable({
                       "sDom": "<\'dt-toolbar\'<\'col-xs-6 col-sm-6\' ><\'col-sm-6 col-xs-6 hidden-xs\'   >r>"+
                "t"+
                "<\'dt-toolbar-footer\'<\'col-sm-6 col-xs-12 hidden-xs\'><\'col-sm-6 col-xs-12\'>>",
                       "autoWidth" : true,"order": [[ 0, "asc" ]],"pageLength":-1,});';
        }


        $str .= '
        <script type="text/javascript">
            $(document).ready(function() {
    
    
                var responsiveHelper_datatable_fixed_column = undefined;
        
                var breakpointDefinition = {
                    tablet : 1024,
                    phone : 480
                };
        
                ///* COLUMN FILTER  */
                '.$datatablePaging.'
        
                
                $("#filterButton'.$level.'").click(function() {
                    var fullFilter = "";
                    $("#datatable_fixed_column_'.$datatableID.'_'.$level.' thead th input[type=text]").each(function() {
                        var key = $(this).data("key");
                        var filter = $(this).val();
                        if(filter.localeCompare("")!==0){
                            if(!Number.isNaN(filter)){
                                var filterQuery = "contains("+key+",\'"+filter+"\')";
                            } else {
                                var filterQuery = "contains("+key+",\'"+filter+"\')";
                            }
                            
                            if(fullFilter.localeCompare("")===0){ 
                                fullFilter +="?$filter=";
                            } else {
                                fullFilter += "%20and%20";
                            }
                            
                            fullFilter += filterQuery;
                            
                        }
                    });
                    
                    
                    window.location.href = "'.$httpRedirect.'"+fullFilter;

                
                });
                    /* END COLUMN FILTER */
            });
        </script>
        ';

        return $str;
    }

    private static function _arrayToView($arr,$hide,$httpRedirect,$buttonURL,$buttonFilterKey,$rowsPerColumn,$title,$level=1) {
        $rowCounter = 0;
        $nextLevel = $level+1;
        $keys = array_keys($arr[0]);

        $colspanTitle = $rowsPerColumn*2 / $rowsPerColumn;


        foreach ($arr as $d)
        {
            $str  .= '<table style="width: 100%" class="table table-bordered">';
            $str .= "<tr >";
            $str .= "<td colspan='$colspanTitle' >$title</td>";
            $str .= "</tr><tr><td style='vertical-align: top !important;'><table style='width: 100%'>";

            foreach ($keys as $k)
            {
                if($rowCounter % $rowsPerColumn == 0 && $rowCounter > 0){

                    $str .= "</table></td><td style='vertical-align: top !important;'><table style='width: 100%'>";
                }

                if(!in_array($k,$hide)) {
                    if (is_array($d[$k])) {
                        if (!empty($d[$k])) {
                            $nextLevel++;
                            $str .= self::_arrayToView($d[$k],$hide,$httpRedirect,$buttonURL,$buttonFilterKey,$rowsPerColumn,$title,$nextLevel);
                        }
                    } else {
                        $str .= "<tr><td style='padding: 1px;'><label class='pull-left' style='vertical-align: center'><b>$k</b></label></td><td><textarea class='form-control text-center' id='$k' disabled readonly>".$d[$k]."</textarea></td></tr>";
                    }
                }

                $rowCounter++;
            }

            $str .= "</table></td></tr>";
            $str .= "</table>";
        }



//            $buttonFilter = '';
//            if(strcmp($buttonURL,'')!=0 && strcmp($buttonFilter,'')!=0){$button = "<a href=\"$buttonURL?$buttonFilterKey=$buttonFilter\" class='btn btn-primary btn-block'>View</a>";}
//            $str .= "$button";

        $str .= '
        <script type="text/javascript">
            $(document).ready(function() {});
    
    
               
        </script>
        ';

        return $str;
    }
}





?>